/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.AddGenome;
import base.BasePlayer.AminoTable;
import base.BasePlayer.BedTable;
import base.BasePlayer.ClusterTable;
import base.BasePlayer.Control;
import base.BasePlayer.ControlFile;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Gene;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.OwnVCFCodec;
import base.BasePlayer.QualEntry;
import base.BasePlayer.RangeSlider;
import base.BasePlayer.Sample;
import base.BasePlayer.SampleNode;
import base.BasePlayer.Settings;
import base.BasePlayer.StatsTable;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantCaller;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class VariantHandler
extends JPanel
implements ChangeListener,
ActionListener,
MouseListener,
KeyListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    static RangeSlider commonSlider = new RangeSlider(1, 1);
    static RangeSlider callSlider = new RangeSlider(0, 100);
    static RangeSlider callSliderIndel = new RangeSlider(0, 100);
    static JSlider qualitySlider = new JSlider(0, 60);
    static JSlider gqSlider = new JSlider(0, 60);
    static JSlider coverageSlider = new JSlider(1, 40);
    static JSlider maxCoverageSlider = new JSlider(1, 2000);
    static JSlider geneSlider = new JSlider(1, 1);
    static JLabel geneLabel = new JLabel("At least 1/1 samples share a mutated gene");
    static JLabel aminoCount = new JLabel("");
    static JLabel callsLabel = new JLabel();
    static JLabel coverageLabel = new JLabel();
    static JLabel maxCoverageLabel = new JLabel();
    static JLabel qualityLabel = new JLabel();
    static JLabel gqLabel = new JLabel();
    static JLabel comparison = new JLabel("Sample comparison");
    static JLabel callsLabelIndel = new JLabel();
    static JLabel coverageLabelIndel = new JLabel();
    static JLabel maxCoverageLabelIndel = new JLabel();
    static JLabel qualityLabelIndel = new JLabel();
    static JLabel gqLabelIndel = new JLabel();
    static JLabel slideLabel = new JLabel("Shared variants in 1/1 samples");
    static JLabel clusterLabel = new JLabel("Window size for variant clusters");
    static JSlider qualitySliderIndel = new JSlider(0, 60);
    static JSlider gqSliderIndel = new JSlider(0, 60);
    static JSlider coverageSliderIndel = new JSlider(1, 40);
    static JSlider maxCoverageSliderIndel = new JSlider(1, 2000);
    static JMenu filters;
    static JMenuBar aminobar;
    static JMenu aminomenu;
    static JMenu outputmenu;
    static JMenuItem write;
    static JTextField clusterBox;
    static ButtonGroup outputgroup;
    static JRadioButton tsv;
    static JRadioButton geneTsv;
    static JRadioButton compactTsv;
    static JRadioButton vcf;
    static JRadioButton oncodrive;
    static JCheckBox hidenoncoding;
    static JCheckBox freeze;
    static JCheckBox rscode;
    static JCheckBox allChroms;
    static JCheckBox allChromsfrom;
    static JCheckBox onlyAutosomes;
    static JCheckBox hideSNVs;
    static JCheckBox hideHomos;
    static JCheckBox onlyStats;
    static JCheckBox outputContexts;
    static JCheckBox hideIndels;
    static JCheckBox synonymous;
    static JCheckBox nonsense;
    static JCheckBox windowcalc;
    static JCheckBox intronic;
    static JCheckBox intergenic;
    static JCheckBox utr;
    static JCheckBox onlyselected;
    static JCheckBox writetofile;
    static JCheckBox indelFilters;
    static JLabel SNVFilters;
    static JFrame frame;
    static JLabel totalVars;
    static JLabel totalVars2;
    static JLabel totalVarsIndel;
    static JLabel empty;
    static JButton varcalc;
    static JButton statcalc;
    static ArrayList<ControlFile> controlarray;
    String userDir;
    static HashMap<String, Integer> variantSettings;
    static int lastWrittenPos;
    static ArrayList<String> outputStrings;
    static MouseWheelListener sliderWheelListener;
    static JTabbedPane tabs;
    static JScrollPane tableScroll;
    static JSeparator separator;
    static AminoTable table;
    static StatsTable stattable;
    static JScrollPane statsScroll;
    static ClusterTable clusterTable;
    static JScrollPane clusterScroll;
    static ArrayList<JScrollPane> tablescrolls;
    static ArrayList<BedTable> tables;
    static NodeSorter nodesorter;
    static JPopupMenu menu;
    static JPopupMenu menuIndel;
    static JScrollPane menuScroll;
    static JScrollPane menuScrollIndel;
    static JPanel menuPanel;
    static JPanel menuPanelIndel;
    static JButton applyQualities;
    static JButton applyQualitiesIndel;
    static JButton advQualities;
    static JButton advQualitiesIndel;
    static OwnVCFCodec vcfCodec;
    static String format;
    static JRadioButton none;
    static JRadioButton recessiveHomo;
    static JRadioButton dominant;
    static JRadioButton denovo;
    static JRadioButton xLinked;
    static JRadioButton compound;
    static JRadioButton recessive;
    ButtonGroup inheritgroup = new ButtonGroup();
    int moveX = 0;
    int moveY = 0;
    int pressX = 0;
    int pressY = 0;
    static JLabel adder;
    static JLabel adder2;
    static JLabel adder3;
    static JLabel adder4;
    static JLabel adder5;
    int buttonHeight = 11;
    int buttonWidth = 72;
    static float maxSlideValue;
    Dimension buttondimension = new Dimension(this.buttonWidth, this.buttonHeight);
    static Color backColor;
    static Color frameColor;
    static int clusterSize;
    static JTabbedPane filterPanes;
    static JPanel filterpanel;
    static JPanel filterpanelIndel;
    static JPanel hidepanel;
    static JPanel inheritpanel;
    static JPanel comparepanel;
    static JPanel aminopanel;

    static {
        controlarray = new ArrayList();
        lastWrittenPos = 0;
        outputStrings = new ArrayList();
        tableScroll = new JScrollPane();
        statsScroll = new JScrollPane();
        clusterScroll = new JScrollPane();
        tablescrolls = new ArrayList();
        tables = new ArrayList();
        nodesorter = new NodeSorter();
        vcfCodec = new OwnVCFCodec();
        format = "GT:DP:AD:GQ";
        none = new JRadioButton("None");
        recessiveHomo = new JRadioButton("Homozygous Recessive");
        dominant = new JRadioButton("Autosomal Dominant");
        denovo = new JRadioButton("De Novo");
        xLinked = new JRadioButton("X-Linked Recessive");
        compound = new JRadioButton("Compound Heterozygous");
        recessive = new JRadioButton("Recessive");
        maxSlideValue = 0.0f;
        backColor = new Color(228, 228, 218, 255);
        frameColor = new Color(188, 188, 178, 255);
        clusterSize = 0;
        filterPanes = new JTabbedPane();
    }

    public VariantHandler() {
        super(new GridBagLayout());
        sliderWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                JSlider slider = (JSlider)e.getSource();
                if (notches < 0) {
                    slider.setValue(slider.getValue() + 1);
                } else if (notches > 0) {
                    slider.setValue(slider.getValue() - 1);
                }
            }
        };
        this.createButtons();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        this.userDir = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent().replace("%20", " ");
        this.setOpaque(false);
        if (Main.screenSize == null) {
            Main.screenSize = new Dimension(1000, 1000);
        }
        stattable = new StatsTable(Main.screenSize.width, Main.screenSize.height, statsScroll);
        stattable.setEnabled(true);
        table = new AminoTable(Main.screenSize.width, Main.screenSize.height, tableScroll);
        table.setEnabled(true);
        clusterTable = new ClusterTable(Main.screenSize.width, Main.screenSize.height, clusterScroll);
        clusterTable.setEnabled(true);
        tabs.setTabLayoutPolicy(1);
        filterPanes.setTabLayoutPolicy(1);
        aminopanel.setLayout(new GridLayout(1, 3));
        tableScroll.getViewport().add(table);
        tableScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                table.repaint();
            }
        });
        tableScroll.getVerticalScrollBar().setUnitIncrement(16);
        statsScroll.setPreferredSize(new Dimension(500, 400));
        statsScroll.getViewport().add(stattable);
        statsScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                stattable.repaint();
            }
        });
        clusterScroll.getVerticalScrollBar().setUnitIncrement(16);
        clusterScroll.setName("Clusters");
        clusterScroll.getVerticalScrollBar().setUnitIncrement(16);
        clusterScroll.setPreferredSize(new Dimension(500, 400));
        clusterScroll.getViewport().add(clusterTable);
        clusterScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent event) {
                clusterTable.repaint();
            }
        });
        clusterScroll.getVerticalScrollBar().setUnitIncrement(16);
        filterPanes.addKeyListener(this);
        c.gridy = 1;
        filterPanes.add("SNVs", filterpanel);
        filterPanes.add("Indels", filterpanelIndel);
        filterPanes.add("Hide", hidepanel);
        filterPanes.add("Compare", comparepanel);
        filterPanes.add("Inheritance", inheritpanel);
        this.add((Component)filterPanes, c);
        c.gridy = 2;
        c.fill = 2;
        this.add((Component)aminopanel, c);
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.8;
        tabs.addMouseListener(this);
        tabs.setBackground(backColor);
        tabs.add("Genes", tableScroll);
        tabs.add("Stats", statsScroll);
        c.fill = 1;
        this.add((Component)tabs, c);
        if (Main.menuFont == null) {
            Main.menuFont = new Font("SansSerif", 0, 12);
        }
        menuPanel.add(new JLabel("Hard filters"));
        menuPanelIndel.add(new JLabel("Hard filters"));
        VariantHandler.setFonts(Main.menuFont);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(frameColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    void createButtons() {
        freeze = new JCheckBox("Freeze filters");
        freeze.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (freeze.isSelected()) {
                    VariantHandler.this.freezeFilters(true);
                } else {
                    VariantHandler.this.freezeFilters(false);
                }
            }
        });
        commonSlider = new RangeSlider(1, 1);
        callSlider = new RangeSlider(0, 100);
        callSliderIndel = new RangeSlider(0, 100);
        qualitySlider = new JSlider(0, 60);
        gqSlider = new JSlider(0, 60);
        coverageSlider = new JSlider(1, 40);
        maxCoverageSlider = new JSlider(1, 2000);
        geneSlider = new JSlider(1, 1);
        geneLabel = new JLabel("At least 1/1 samples share a mutated gene");
        aminoCount = new JLabel("");
        callsLabel = new JLabel();
        coverageLabel = new JLabel();
        maxCoverageLabel = new JLabel();
        qualityLabel = new JLabel();
        gqLabel = new JLabel();
        comparison = new JLabel("Sample comparison");
        callsLabelIndel = new JLabel();
        coverageLabelIndel = new JLabel();
        maxCoverageLabelIndel = new JLabel();
        qualityLabelIndel = new JLabel();
        gqLabelIndel = new JLabel();
        slideLabel = new JLabel("Shared variants in 1/1 samples");
        clusterLabel = new JLabel("Window size for variant clusters");
        qualitySliderIndel = new JSlider(0, 60);
        gqSliderIndel = new JSlider(0, 60);
        coverageSliderIndel = new JSlider(1, 40);
        filters = new JMenu("Variant Filters");
        aminobar = new JMenuBar();
        aminomenu = new JMenu("Options");
        outputmenu = new JMenu("Variant output");
        write = new JMenuItem("Save");
        clusterBox = new JTextField("0");
        outputgroup = new ButtonGroup();
        tsv = new JRadioButton("TSV");
        compactTsv = new JRadioButton("Compact TSV");
        geneTsv = new JRadioButton("Gene TSV");
        vcf = new JRadioButton("VCF");
        oncodrive = new JRadioButton("Oncodrive");
        hidenoncoding = new JCheckBox("Hide non-coding variants");
        rscode = new JCheckBox("Hide rs-coded variants");
        allChroms = new JCheckBox("All chromosomes");
        allChromsfrom = new JCheckBox("From this chr?");
        onlyAutosomes = new JCheckBox("Only autosomes?");
        hideSNVs = new JCheckBox("Hide SNVs");
        hideHomos = new JCheckBox("Hide homozygotes");
        onlyStats = new JCheckBox("Only stats");
        outputContexts = new JCheckBox("Output contexts");
        hideIndels = new JCheckBox("Hide indels");
        synonymous = new JCheckBox("Only non-synonymous");
        nonsense = new JCheckBox("Only truncs");
        windowcalc = new JCheckBox("Window calculation");
        intronic = new JCheckBox("Show intronic");
        intergenic = new JCheckBox("Show intergenic");
        utr = new JCheckBox("Show UTR");
        onlyselected = new JCheckBox("Only selected sample");
        writetofile = new JCheckBox("Write directly to a file");
        indelFilters = new JCheckBox("Use indel specific filters");
        SNVFilters = new JLabel("SNV & indel filters");
        SNVFilters.setName("header");
        indelFilters.setName("header");
        comparison.setName("header");
        totalVars = new JLabel("Variant count on screen: 0");
        totalVars2 = new JLabel("Variant count on screen: 0");
        totalVarsIndel = new JLabel("Variant count on screen: 0");
        empty = new JLabel("");
        varcalc = new JButton("Annotate");
        statcalc = new JButton("Stats");
        tabs = new JTabbedPane();
        separator = new JSeparator();
        menu = new JPopupMenu("Advanced quality control");
        menuIndel = new JPopupMenu("Advanced quality control");
        menuPanel = new JPanel(new GridBagLayout());
        menuPanelIndel = new JPanel(new GridBagLayout());
        applyQualities = new JButton("Apply");
        applyQualitiesIndel = new JButton("Apply");
        advQualities = new JButton("Hard filters");
        advQualitiesIndel = new JButton("Hard filters");
        filterPanes = new JTabbedPane();
        filterpanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        filterpanelIndel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        hidepanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        inheritpanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        comparepanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        aminopanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(backColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        geneSlider.setValue(1);
        geneSlider.setSnapToTicks(true);
        geneSlider.setMajorTickSpacing(1);
        geneSlider.setMinorTickSpacing(1);
        geneSlider.setOpaque(false);
        geneSlider.addChangeListener(this);
        geneSlider.addMouseWheelListener(sliderWheelListener);
        commonSlider.addMouseWheelListener(sliderWheelListener);
        commonSlider.setValue(1);
        commonSlider.setUpperValue(1);
        commonSlider.addChangeListener(this);
        commonSlider.addMouseListener(this);
        commonSlider.setOpaque(false);
        qualitySlider.addMouseWheelListener(sliderWheelListener);
        qualitySlider.addChangeListener(this);
        qualitySlider.addMouseListener(this);
        qualitySlider.setValue(0);
        qualitySlider.setOpaque(false);
        qualitySliderIndel.addMouseWheelListener(sliderWheelListener);
        qualitySliderIndel.addChangeListener(this);
        qualitySliderIndel.addMouseListener(this);
        qualitySliderIndel.setValue(0);
        qualitySliderIndel.setOpaque(false);
        gqSlider.addMouseWheelListener(sliderWheelListener);
        gqSlider.addChangeListener(this);
        gqSlider.addMouseListener(this);
        gqSlider.setValue(0);
        gqSlider.setOpaque(false);
        gqSliderIndel.addMouseWheelListener(sliderWheelListener);
        gqSliderIndel.addChangeListener(this);
        gqSliderIndel.addMouseListener(this);
        gqSliderIndel.setValue(0);
        gqSliderIndel.setOpaque(false);
        coverageSlider.addMouseWheelListener(sliderWheelListener);
        coverageSlider.addChangeListener(this);
        coverageSlider.addMouseListener(this);
        coverageSlider.setOpaque(false);
        coverageSlider.setValue(4);
        coverageSliderIndel.addMouseWheelListener(sliderWheelListener);
        coverageSliderIndel.addChangeListener(this);
        coverageSliderIndel.addMouseListener(this);
        coverageSliderIndel.setOpaque(false);
        coverageSliderIndel.setValue(4);
        maxCoverageSlider.addMouseWheelListener(sliderWheelListener);
        maxCoverageSlider.addChangeListener(this);
        maxCoverageSlider.addMouseListener(this);
        maxCoverageSlider.setOpaque(false);
        maxCoverageSlider.setValue(1500);
        maxCoverageSliderIndel.addMouseWheelListener(sliderWheelListener);
        maxCoverageSliderIndel.addChangeListener(this);
        maxCoverageSliderIndel.addMouseListener(this);
        maxCoverageSliderIndel.setOpaque(false);
        maxCoverageSliderIndel.setValue(1500);
        callSlider.addMouseWheelListener(sliderWheelListener);
        callSlider.addChangeListener(this);
        callSlider.addMouseListener(this);
        callSlider.setValue(10);
        callSlider.setUpperValue(100);
        callSlider.setOpaque(false);
        callSliderIndel.addMouseWheelListener(sliderWheelListener);
        callSliderIndel.addChangeListener(this);
        callSliderIndel.addMouseListener(this);
        callSliderIndel.setValue(10);
        callSliderIndel.setUpperValue(100);
        callSliderIndel.setOpaque(false);
        indelFilters.setOpaque(false);
        indelFilters.addActionListener(this);
        hideSNVs.setOpaque(false);
        hideSNVs.addActionListener(this);
        hideIndels.setOpaque(false);
        hideIndels.addActionListener(this);
        hideHomos.setOpaque(false);
        hideHomos.addActionListener(this);
        rscode.addActionListener(this);
        rscode.setOpaque(false);
        hidenoncoding.addActionListener(this);
        hidenoncoding.setOpaque(false);
        frame.getContentPane().setBackground(Color.white);
        frame.setBackground(Color.white);
        frame.addComponentListener(this);
        menuScroll = new JScrollPane(menuPanel);
        menuPanel.setBackground(Color.white);
        menu.addKeyListener(this);
        menuScroll.addKeyListener(this);
        menu.add(menuScroll);
        menu.add(applyQualities);
        menuScrollIndel = new JScrollPane(menuPanelIndel);
        menuPanelIndel.setBackground(Color.white);
        menuIndel.add(menuScrollIndel);
        menuIndel.addKeyListener(this);
        menuScrollIndel.addKeyListener(this);
        menuIndel.add(applyQualitiesIndel);
        applyQualitiesIndel.addActionListener(this);
        applyQualities.addActionListener(this);
        advQualities.addActionListener(this);
        advQualitiesIndel.addActionListener(this);
        qualityLabel.setToolTipText("Variants below quality threshold will be hidden");
        gqLabel.setToolTipText("Variants below quality threshold will be hidden");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 4, 0, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        filterpanel.add((Component)SNVFilters, c);
        qualityLabel.setToolTipText("Click for hard filters (advanced)");
        qualityLabel.addMouseListener(this);
        c.gridx = 1;
        adder2 = new JLabel("__________________________________");
        adder2.setForeground(Draw.sidecolor);
        filterpanel.add((Component)adder2, c);
        filterpanel.add((Component)totalVars, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanel.add((Component)qualityLabel, c);
        c.gridx = 1;
        filterpanel.add((Component)qualitySlider, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanel.add((Component)gqLabel, c);
        c.gridx = 1;
        filterpanel.add((Component)gqSlider, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanel.add((Component)coverageLabel, c);
        c.gridx = 1;
        filterpanel.add((Component)coverageSlider, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanel.add((Component)maxCoverageLabel, c);
        c.gridx = 1;
        filterpanel.add((Component)maxCoverageSlider, c);
        ++c.gridy;
        c.gridx = 0;
        adder = new JLabel("_______________________________________");
        adder.setForeground(Draw.sidecolor);
        filterpanel.add((Component)adder, c);
        filterpanel.add((Component)callsLabel, c);
        c.gridx = 1;
        filterpanel.add((Component)callSlider, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        filterpanel.add((Component)new JLabel(), c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        filterpanelIndel.add((Component)indelFilters, c);
        qualityLabelIndel.setToolTipText("Click for hard filters (advanced)");
        qualityLabelIndel.addMouseListener(this);
        c.insets = new Insets(2, 4, 0, 4);
        c.gridx = 1;
        adder4 = new JLabel("__________________________________");
        adder4.setForeground(Draw.sidecolor);
        filterpanelIndel.add((Component)adder4, c);
        filterpanelIndel.add((Component)totalVarsIndel, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanelIndel.add((Component)qualityLabelIndel, c);
        c.gridx = 1;
        filterpanelIndel.add((Component)qualitySliderIndel, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanelIndel.add((Component)gqLabelIndel, c);
        c.gridx = 1;
        filterpanelIndel.add((Component)gqSliderIndel, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanelIndel.add((Component)coverageLabelIndel, c);
        c.gridx = 1;
        filterpanelIndel.add((Component)coverageSliderIndel, c);
        ++c.gridy;
        c.gridx = 0;
        filterpanelIndel.add((Component)maxCoverageLabelIndel, c);
        c.gridx = 1;
        filterpanelIndel.add((Component)maxCoverageSliderIndel, c);
        ++c.gridy;
        c.gridx = 0;
        adder3 = new JLabel("__________________________________");
        adder3.setForeground(Draw.sidecolor);
        filterpanelIndel.add((Component)adder3, c);
        filterpanelIndel.add((Component)callsLabelIndel, c);
        c.gridx = 1;
        filterpanelIndel.add((Component)callSliderIndel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        filterpanelIndel.add((Component)new JLabel(), c);
        c.insets = new Insets(0, 4, 0, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        hidepanel.add((Component)hidenoncoding, c);
        ++c.gridy;
        hidepanel.add((Component)rscode, c);
        ++c.gridy;
        hidepanel.add((Component)hideSNVs, c);
        ++c.gridy;
        hidepanel.add((Component)hideIndels, c);
        ++c.gridy;
        hidepanel.add((Component)hideHomos, c);
        ++c.gridy;
        freeze.setBackground(new Color(170, 220, 255));
        hidepanel.add((Component)freeze, c);
        VariantHandler.freezeIndels(true);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        hidepanel.add((Component)new JLabel(), c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        none.setSelected(true);
        this.inheritgroup.add(none);
        this.inheritgroup.add(recessiveHomo);
        this.inheritgroup.add(dominant);
        this.inheritgroup.add(denovo);
        this.inheritgroup.add(xLinked);
        this.inheritgroup.add(recessive);
        this.inheritgroup.add(compound);
        none.setOpaque(false);
        recessiveHomo.setOpaque(false);
        dominant.setOpaque(false);
        denovo.setOpaque(false);
        xLinked.setOpaque(false);
        recessive.setOpaque(false);
        compound.setOpaque(false);
        inheritpanel.add((Component)none, c);
        ++c.gridy;
        inheritpanel.add((Component)dominant, c);
        ++c.gridy;
        inheritpanel.add((Component)recessive, c);
        ++c.gridy;
        inheritpanel.add((Component)recessiveHomo, c);
        ++c.gridy;
        inheritpanel.add((Component)compound, c);
        c.gridy = 0;
        c.gridx = 1;
        inheritpanel.add((Component)xLinked, c);
        ++c.gridy;
        inheritpanel.add((Component)denovo, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 4, 0, 4);
        c.weightx = 0.0;
        c.weighty = 0.0;
        comparepanel.add((Component)comparison, c);
        c.gridx = 1;
        comparepanel.add((Component)totalVars2, c);
        ++c.gridy;
        c.gridx = 0;
        comparepanel.add((Component)geneLabel, c);
        c.gridx = 1;
        comparepanel.add((Component)geneSlider, c);
        c.gridx = 0;
        ++c.gridy;
        comparepanel.add((Component)slideLabel, c);
        c.gridx = 1;
        comparepanel.add((Component)commonSlider, c);
        c.gridx = 0;
        ++c.gridy;
        comparepanel.add((Component)clusterLabel, c);
        c.gridx = 1;
        clusterBox.addKeyListener(this);
        comparepanel.add((Component)clusterBox, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        comparepanel.add((Component)new JLabel(), c);
        varcalc.addActionListener(this);
        allChroms.addActionListener(this);
        write.addActionListener(this);
        aminomenu.add(synonymous);
        aminomenu.add(nonsense);
        aminomenu.add(intronic);
        aminomenu.add(intergenic);
        aminomenu.add(utr);
        aminomenu.add(allChroms);
        aminomenu.add(onlyselected);
        onlyStats.addActionListener(this);
        aminomenu.add(onlyStats);
        aminomenu.add(windowcalc);
        aminomenu.add(writetofile);
        if (Main.settingsIcon == null) {
            URL imgUrl = this.getClass().getResource("icons/settings.png");
            Main.settingsIcon = new ImageIcon(imgUrl);
            imgUrl = this.getClass().getResource("icons/save.gif");
            Main.save = new ImageIcon(imgUrl);
        }
        aminomenu.setIcon(Main.settingsIcon);
        writetofile.addActionListener(this);
        writetofile.setIcon(Main.save);
        outputmenu.setIcon(Main.save);
        aminopanel.add(aminobar);
        aminopanel.add(aminoCount);
        aminobar.add(varcalc);
        aminobar.add(aminomenu);
        tsv.setSelected(true);
        outputgroup.add(tsv);
        outputgroup.add(compactTsv);
        outputgroup.add(geneTsv);
        outputgroup.add(vcf);
        outputgroup.add(oncodrive);
        outputmenu.add(tsv);
        outputmenu.add(compactTsv);
        outputmenu.add(vcf);
        outputmenu.add(geneTsv);
        outputmenu.add(oncodrive);
        write.setIcon(Main.save);
        outputmenu.add(write);
        aminobar.add(outputmenu);
        VariantHandler.setValues();
    }

    static void setValues() {
        if (variantSettings == null) {
            variantSettings = new HashMap();
            variantSettings.put("SNVquality", 0);
            variantSettings.put("SNVgq", 0);
            variantSettings.put("mincoverage", 4);
            variantSettings.put("maxcoverage", 1500);
            variantSettings.put("fraction", 10);
            variantSettings.put("upperFraction", 100);
            variantSettings.put("Indelquality", 0);
            variantSettings.put("Indelgq", 0);
            variantSettings.put("Indelmincoverage", 4);
            variantSettings.put("Indelmaxcoverage", 1500);
            variantSettings.put("Indelfraction", 10);
            variantSettings.put("IndelUpperFraction", 100);
            variantSettings.put("IndelFilters", 0);
            variantSettings.put("geneSlider", 1);
            variantSettings.put("commonSliderMin", 1);
            variantSettings.put("commonSliderMax", 1);
            variantSettings.put("clusterSize", 0);
            variantSettings.put("hideNoncoding", 0);
            variantSettings.put("hideRscoded", 0);
            variantSettings.put("hideSNVs", 0);
            variantSettings.put("hideIndels", 0);
            variantSettings.put("hideHomozygotes", 0);
            variantSettings.put("freeze", 0);
            variantSettings.put("nonSyn", 0);
            variantSettings.put("truncs", 0);
            variantSettings.put("intronic", 0);
            variantSettings.put("intergenic", 0);
            variantSettings.put("utr", 0);
            variantSettings.put("allChroms", 0);
            variantSettings.put("onlySel", 0);
            variantSettings.put("onlyStats", 0);
            variantSettings.put("contexts", 0);
            variantSettings.put("writeFile", 0);
            variantSettings.put("tsv", 1);
            variantSettings.put("compact", 0);
            variantSettings.put("vcf", 0);
            variantSettings.put("windowcalc", 0);
            variantSettings.put("oncodrive", 0);
        }
        qualitySlider.setValue(variantSettings.get("SNVquality"));
        gqSlider.setValue(variantSettings.get("SNVgq"));
        coverageSlider.setValue(variantSettings.get("mincoverage"));
        maxCoverageSlider.setValue(variantSettings.get("maxcoverage"));
        callSlider.setValue(variantSettings.get("fraction"));
        callSlider.setUpperValue(variantSettings.get("upperFraction"));
        qualitySliderIndel.setValue(variantSettings.get("Indelquality"));
        gqSliderIndel.setValue(variantSettings.get("Indelgq"));
        coverageSliderIndel.setValue(variantSettings.get("Indelmincoverage"));
        maxCoverageSliderIndel.setValue(variantSettings.get("Indelmaxcoverage"));
        callSliderIndel.setValue(variantSettings.get("Indelfraction"));
        callSliderIndel.setUpperValue(variantSettings.get("IndelUpperFraction"));
        indelFilters.setSelected(variantSettings.get("IndelFilters") == 1);
        VariantHandler.checkIndelFilters();
        maxSlideValue = maxCoverageSlider.getValue();
        if (Main.varsamples > 1) {
            commonSlider.setMinimum(1);
            commonSlider.setMaximum(Main.varsamples);
            geneSlider.setMinimum(1);
            geneSlider.setMaximum(Main.varsamples);
        } else {
            commonSlider.setMinimum(1);
            commonSlider.setMaximum(1);
            geneSlider.setMinimum(1);
            geneSlider.setMaximum(1);
        }
        geneSlider.setValue(variantSettings.get("geneSlider"));
        commonSlider.setValue(variantSettings.get("commonSliderMin"));
        commonSlider.setUpperValue(variantSettings.get("commonSliderMax"));
        clusterSize = variantSettings.get("clusterSize");
        clusterBox.setText("" + clusterSize);
        hidenoncoding.setSelected(variantSettings.get("hideNoncoding") == 1);
        rscode.setSelected(variantSettings.get("hideRscoded") == 1);
        hideSNVs.setSelected(variantSettings.get("hideSNVs") == 1);
        hideIndels.setSelected(variantSettings.get("hideIndels") == 1);
        hideHomos.setSelected(variantSettings.get("hideHomozygotes") == 1);
        freeze.setSelected(variantSettings.get("freeze") == 1);
        synonymous.setSelected(variantSettings.get("nonSyn") == 1);
        nonsense.setSelected(variantSettings.get("truncs") == 1);
        if (variantSettings.get("windowcalc") != null) {
            windowcalc.setSelected(variantSettings.get("windowcalc") == 1);
        }
        intronic.setSelected(variantSettings.get("intronic") == 1);
        intergenic.setSelected(variantSettings.get("intergenic") == 1);
        utr.setSelected(variantSettings.get("utr") == 1);
        allChroms.setSelected(variantSettings.get("allChroms") == 1);
        onlyselected.setSelected(variantSettings.get("onlySel") == 1);
        onlyStats.setSelected(variantSettings.get("onlyStats") == 1);
        if (variantSettings.get("contexts") != null) {
            outputContexts.setSelected(variantSettings.get("contexts") == 1);
        }
        writetofile.setSelected(variantSettings.get("writeFile") == 1);
        VariantHandler.checkWriteFiles();
        tsv.setSelected(variantSettings.get("tsv") == 1);
        compactTsv.setSelected(variantSettings.get("compact") == 1);
        vcf.setSelected(variantSettings.get("vcf") == 1);
        if (variantSettings.get("genetsv") != null) {
            geneTsv.setSelected(variantSettings.get("genetsv") == 1);
        }
        oncodrive.setSelected(variantSettings.get("oncodrive") == 1);
    }

    static void saveValues() {
        variantSettings.put("SNVquality", qualitySlider.getValue());
        variantSettings.put("SNVgq", gqSlider.getValue());
        variantSettings.put("mincoverage", coverageSlider.getValue());
        variantSettings.put("maxcoverage", maxCoverageSlider.getValue());
        variantSettings.put("fraction", callSlider.getValue());
        variantSettings.put("upperFraction", callSlider.getUpperValue());
        variantSettings.put("Indelquality", qualitySliderIndel.getValue());
        variantSettings.put("Indelgq", gqSliderIndel.getValue());
        variantSettings.put("Indelmincoverage", coverageSliderIndel.getValue());
        variantSettings.put("Indelmaxcoverage", maxCoverageSliderIndel.getValue());
        variantSettings.put("Indelfraction", callSliderIndel.getValue());
        variantSettings.put("IndelUpperFraction", callSliderIndel.getUpperValue());
        variantSettings.put("IndelFilters", indelFilters.isSelected() ? 1 : 0);
        variantSettings.put("geneSlider", geneSlider.getValue());
        variantSettings.put("commonSliderMin", commonSlider.getValue());
        variantSettings.put("commonSliderMax", commonSlider.getUpperValue());
        variantSettings.put("clusterSize", clusterSize);
        variantSettings.put("hideNoncoding", hidenoncoding.isSelected() ? 1 : 0);
        variantSettings.put("hideRscoded", rscode.isSelected() ? 1 : 0);
        variantSettings.put("hideSNVs", hideSNVs.isSelected() ? 1 : 0);
        variantSettings.put("hideIndels", hideIndels.isSelected() ? 1 : 0);
        variantSettings.put("hideHomozygotes", hideHomos.isSelected() ? 1 : 0);
        variantSettings.put("freeze", freeze.isSelected() ? 1 : 0);
        variantSettings.put("nonSyn", synonymous.isSelected() ? 1 : 0);
        variantSettings.put("truncs", nonsense.isSelected() ? 1 : 0);
        variantSettings.put("windowcalc", windowcalc.isSelected() ? 1 : 0);
        variantSettings.put("intronic", intronic.isSelected() ? 1 : 0);
        variantSettings.put("intergenic", intergenic.isSelected() ? 1 : 0);
        variantSettings.put("utr", utr.isSelected() ? 1 : 0);
        variantSettings.put("allChroms", allChroms.isSelected() ? 1 : 0);
        variantSettings.put("onlySel", onlyselected.isSelected() ? 1 : 0);
        variantSettings.put("onlyStats", onlyStats.isSelected() ? 1 : 0);
        variantSettings.put("contexts", outputContexts.isSelected() ? 1 : 0);
        variantSettings.put("writeFile", writetofile.isSelected() ? 1 : 0);
        variantSettings.put("tsv", tsv.isSelected() ? 1 : 0);
        variantSettings.put("compact", compactTsv.isSelected() ? 1 : 0);
        variantSettings.put("genetsv", geneTsv.isSelected() ? 1 : 0);
        variantSettings.put("vcf", vcf.isSelected() ? 1 : 0);
        variantSettings.put("oncodrive", oncodrive.isSelected() ? 1 : 0);
    }

    private static void createAndShowGUI() {
        try {
            frame = new JFrame("Variant Manager");
            frame.setResizable(true);
            VariantHandler newContentPane = new VariantHandler();
            newContentPane.setOpaque(true);
            frame.setContentPane(newContentPane);
            frame.pack();
            filterPanes.setMinimumSize(filterPanes.getSize());
            table.setPreferredSize(new Dimension(tableScroll.getViewport().getWidth(), tableScroll.getViewport().getHeight()));
            table.setMinimumSize(new Dimension(tableScroll.getViewport().getWidth(), tableScroll.getViewport().getHeight()));
            table.resizeTable(tableScroll.getViewport().getWidth());
            aminobar.setMinimumSize(new Dimension((int)aminobar.getSize().getWidth(), (int)aminobar.getSize().getHeight()));
            filters.setMinimumSize(new Dimension((int)filters.getSize().getWidth(), (int)filters.getSize().getHeight()));
            clusterTable.resizeTable(tableScroll.getViewport().getWidth());
            if (Main.chromDraw == null) {
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
                String add = "##INFO=<ID=ABHom,Number=1,Type=Float,Description=\"Allele Balance for homs (A/(A+O))\">";
                VariantHandler.addMenuComponents(add);
                add = "##INFO=<ID=AC,Number=A,Type=Integer,Description=\"Allele count in genotypes, for each ALT allele, in the same order as listed\">";
                VariantHandler.addMenuComponents(add);
            } else {
                frame.setDefaultCloseOperation(1);
                frame.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("sun.java2d.d3d", "false");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariantHandler.createAndShowGUI();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (Main.drawCanvas != null && Main.drawCanvas.varCalc < 1000000) {
            Draw.calculateVars = true;
            Draw.updatevars = true;
        }
        if (event.getSource() == commonSlider) {
            slideLabel.setText("Shared variants in " + commonSlider.getValue() + "/" + commonSlider.getUpperValue() + " samples");
            if (!(commonSlider.getValue() <= 1 && commonSlider.getUpperValue() >= Main.varsamples || clusterBox.getText().equals("0") || clusterBox.getText().equals(""))) {
                clusterSize = Integer.parseInt(clusterBox.getText());
                Main.drawCanvas.calcClusters(FileRead.head, 1);
                if (tabs.indexOfComponent(clusterScroll) == -1) {
                    tabs.add((Component)clusterScroll, tabs.indexOfComponent(statsScroll));
                }
            } else if (clusterSize != 0) {
                if (clusterBox.getText().equals("0") || clusterBox.getText().equals("")) {
                    clusterSize = 0;
                }
                if (tabs.indexOfComponent(clusterScroll) != -1) {
                    tabs.remove(clusterScroll);
                }
            } else if (clusterSize == 0 && tabs.indexOfComponent(clusterScroll) != -1) {
                tabs.remove(clusterScroll);
            }
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            }
            return;
        }
        if (event.getSource() == geneSlider) {
            geneLabel.setText("At least " + geneSlider.getValue() + "/" + geneSlider.getMaximum() + " samples share a mutated gene");
        } else {
            if (event.getSource() == qualitySlider) {
                qualityLabel.setText("Min. quality score: " + qualitySlider.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == gqSlider) {
                gqLabel.setText("Min. genotype quality score: " + gqSlider.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == coverageSlider) {
                coverageLabel.setText("Min. coverage: " + coverageSlider.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == callSlider) {
                callsLabel.setText("Min/max allelic fraction: " + callSlider.getValue() + "% - " + callSlider.getUpperValue() + "%");
                if (Settings.selectedVarDraw == 1) {
                    maxSlideValue = (float)callSlider.getUpperValue() / 100.0f;
                }
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == maxCoverageSlider) {
                maxCoverageLabel.setText("Max. coverage: " + maxCoverageSlider.getValue());
                if (Settings.selectedVarDraw == 0) {
                    maxSlideValue = maxCoverageSlider.getValue();
                }
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == qualitySliderIndel) {
                qualityLabelIndel.setText("Min. quality score: " + qualitySliderIndel.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == gqSliderIndel) {
                gqLabelIndel.setText("Min. genotype quality score: " + gqSliderIndel.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == coverageSliderIndel) {
                coverageLabelIndel.setText("Min. coverage: " + coverageSliderIndel.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == callSliderIndel) {
                callsLabelIndel.setText("Min/max allelic fraction: " + callSliderIndel.getValue() + "% - " + callSliderIndel.getUpperValue() + "%");
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
            if (event.getSource() == maxCoverageSliderIndel) {
                maxCoverageLabelIndel.setText("Max. coverage: " + maxCoverageSliderIndel.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                        Main.chromDraw.updateExons = true;
                        Main.chromDraw.repaint();
                    }
                }
                return;
            }
        }
    }

    static void checkIndelFilters() {
        if (indelFilters.isSelected()) {
            VariantHandler.freezeIndels(false);
            SNVFilters.setText("SNV filters");
        } else {
            VariantHandler.freezeIndels(true);
            SNVFilters.setText("SNV & indel filters");
        }
        if (Main.drawCanvas != null) {
            Draw.updatevars = true;
            Main.drawCanvas.repaint();
        }
    }

    static void checkWriteFiles() {
        if (writetofile.isSelected()) {
            writetofile.setBackground(Color.white);
            aminomenu.add((Component)tsv, aminomenu.getItemCount() - 1);
            aminomenu.add((Component)compactTsv, aminomenu.getItemCount() - 1);
            aminomenu.add((Component)vcf, aminomenu.getItemCount() - 1);
            aminomenu.add((Component)geneTsv, aminomenu.getItemCount() - 1);
            aminomenu.add((Component)oncodrive, aminomenu.getItemCount() - 1);
            aminomenu.getPopupMenu().pack();
            aminomenu.revalidate();
            aminomenu.repaint();
            tabs.revalidate();
        } else {
            writetofile.setBackground(Color.lightGray);
            outputmenu.add((Component)oncodrive, 0);
            outputmenu.add((Component)geneTsv, 0);
            outputmenu.add((Component)vcf, 0);
            outputmenu.add((Component)compactTsv, 0);
            outputmenu.add((Component)tsv, 0);
            outputmenu.revalidate();
            aminomenu.getPopupMenu().pack();
            tabs.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block140: {
            if (event.getSource() == writetofile) {
                VariantHandler.checkWriteFiles();
            } else if (event.getSource() == hidenoncoding) {
                Draw.calculateVars = true;
                if (commonSlider.getValue() > 1) {
                    Main.drawCanvas.calcClusters(FileRead.head, 1);
                }
                Draw.updatevars = true;
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            } else if (event.getSource() == indelFilters) {
                VariantHandler.checkIndelFilters();
            } else if (event.getSource() == varcalc) {
                if (onlyStats.isSelected()) {
                    if (outputContexts.isSelected()) {
                        try {
                            FileDialog fs = new FileDialog((Frame)frame, "Save output as...", 1);
                            fs.setDirectory(Main.savedir);
                            fs.setFile("*.tsv");
                            fs.setVisible(true);
                            String filename = fs.getFile();
                            if (filename != null) {
                                File outfname = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                                BufferedWriter output = null;
                                BufferedWriter sigOutput = null;
                                Main.savedir = fs.getDirectory();
                                Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
                                lastWrittenPos = 0;
                                if (tsv.isSelected() || compactTsv.isSelected() || oncodrive.isSelected() || geneTsv.isSelected()) {
                                    File outfile;
                                    if (!outfname.getName().contains(".tsv")) {
                                        outfile = new File(String.valueOf(outfname.getCanonicalPath()) + ".tsv");
                                        FileRead.outputName = String.valueOf(outfname.getCanonicalPath()) + ".tsv";
                                        output = new BufferedWriter(new FileWriter(outfile));
                                    } else {
                                        outfile = outfname;
                                        FileRead.outputName = outfname.getCanonicalPath();
                                        output = new BufferedWriter(new FileWriter(outfile));
                                    }
                                    if (output != null) {
                                        sigOutput = new BufferedWriter(new FileWriter(String.valueOf(outfname.getCanonicalPath()) + "_signatures.tsv"));
                                        String header = this.createTSVHeader();
                                        output.write(header);
                                        FileRead.output = output;
                                        FileRead.sigOutput = sigOutput;
                                    }
                                }
                                table.clear();
                                VariantHandler.table.headerHover = 2;
                                VariantHandler.table.sorter.ascending = true;
                                table.createPolygon();
                                table.repaint();
                                FileRead calculator = new FileRead();
                                calculator.varcalc = true;
                                calculator.execute();
                            }
                            return;
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(Main.chromDraw, e.getMessage(), "Error", 0);
                            e.printStackTrace();
                        }
                    }
                    table.clear();
                    VariantHandler.table.headerHover = 2;
                    VariantHandler.table.sorter.ascending = true;
                    table.createPolygon();
                    table.repaint();
                    FileRead calculator = new FileRead();
                    calculator.varcalc = true;
                    calculator.execute();
                } else if (writetofile.isSelected()) {
                    try {
                        FileDialog fs = new FileDialog((Frame)frame, "Save output file to...", 1);
                        fs.setDirectory(Main.savedir);
                        fs.setFile("*.tsv");
                        fs.setVisible(true);
                        String outfname = "";
                        String filename = fs.getFile();
                        if (filename == null) break block140;
                        outfname = String.valueOf(fs.getDirectory()) + "/" + filename;
                        BufferedWriter output = null;
                        Main.savedir = fs.getDirectory();
                        Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
                        lastWrittenPos = 0;
                        if (tsv.isSelected() || compactTsv.isSelected() || oncodrive.isSelected() || geneTsv.isSelected()) {
                            File outfile;
                            if (!outfname.contains(".tsv")) {
                                outfile = new File(String.valueOf(outfname) + ".tsv");
                                FileRead.outputName = String.valueOf(outfname) + ".tsv";
                                output = new BufferedWriter(new FileWriter(outfile));
                            } else {
                                outfile = new File(outfname);
                                FileRead.outputName = outfname;
                                output = new BufferedWriter(new FileWriter(outfile));
                            }
                            if (output != null) {
                                String header = this.createTSVHeader();
                                output.write(header);
                                table.clear();
                                VariantHandler.table.headerHover = 2;
                                VariantHandler.table.sorter.ascending = true;
                                table.createPolygon();
                                table.repaint();
                                FileRead.output = output;
                                FileRead calculator = new FileRead();
                                calculator.varcalc = true;
                                calculator.execute();
                            }
                        } else if (vcf.isSelected()) {
                            SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
                            FileRead.indexCreator = new TabixIndexCreator(dict, TabixFormat.VCF);
                            FileRead.filepointer = 0L;
                            if (!outfname.contains(".vcf")) {
                                outfname = String.valueOf(outfname) + ".vcf";
                            } else {
                                FileRead.outputName = outfname;
                            }
                            if (!outfname.endsWith(".gz")) {
                                outfname = String.valueOf(outfname) + ".gz";
                            }
                            FileRead.lastpos = 0;
                            FileRead.outputgz = new BlockCompressedOutputStream(outfname);
                            FileRead.outFile = new File(outfname);
                            String header = this.createVCFHeader();
                            VCFHeader vcfheader = new VCFHeader();
                            VCFHeaderLine headerline = new VCFHeaderLine("format", "##fileformat=VCFv4.1");
                            vcfheader.addMetaDataLine(headerline);
                            vcfCodec.setVCFHeader(vcfheader, VCFHeaderVersion.VCF4_1);
                            FileRead.outputgz.write(header.getBytes());
                            table.clear();
                            VariantHandler.table.headerHover = 2;
                            VariantHandler.table.sorter.ascending = true;
                            table.createPolygon();
                            table.repaint();
                            FileRead calculator = new FileRead();
                            calculator.varcalc = true;
                            calculator.execute();
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(Main.chromDraw, e.getMessage(), "Error", 0);
                        e.printStackTrace();
                    }
                } else {
                    FileRead.outputgz = null;
                    table.clear();
                    VariantHandler.table.headerHover = 2;
                    VariantHandler.table.sorter.ascending = true;
                    table.createPolygon();
                    table.repaint();
                    FileRead calculator = new FileRead();
                    calculator.varcalc = true;
                    calculator.execute();
                }
            } else if (event.getSource() == hideSNVs) {
                Draw.calculateVars = true;
                if (commonSlider.getValue() > 1) {
                    Main.drawCanvas.calcClusters(FileRead.head, 1);
                }
                Draw.updatevars = true;
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            } else if (event.getSource() == hideIndels) {
                Draw.calculateVars = true;
                Draw.updatevars = true;
                if (commonSlider.getValue() > 1) {
                    Main.drawCanvas.calcClusters(FileRead.head, 1);
                }
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            } else if (event.getSource() == hideHomos) {
                Draw.calculateVars = true;
                if (commonSlider.getValue() > 1) {
                    Main.drawCanvas.calcClusters(FileRead.head, 1);
                }
                Draw.updatevars = true;
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            } else if (event.getSource() == rscode) {
                Draw.calculateVars = true;
                Draw.updatevars = true;
                if (commonSlider.getValue() > 1) {
                    Main.drawCanvas.calcClusters(FileRead.head, 1);
                }
                Main.drawCanvas.repaint();
                if (Main.drawCanvas.splits.get((int)0).viewLength <= 1000000.0) {
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                }
            } else if (event.getSource() == allChroms) {
                if (allChroms.isSelected()) {
                    varcalc.setEnabled(true);
                    aminomenu.add((Component)allChromsfrom, 6);
                    aminomenu.add((Component)onlyAutosomes, 7);
                    aminomenu.getPopupMenu().pack();
                } else {
                    aminomenu.remove(allChromsfrom);
                    aminomenu.remove(onlyAutosomes);
                    aminomenu.getPopupMenu().pack();
                }
            } else if (event.getSource() == onlyStats) {
                if (onlyStats.isSelected()) {
                    aminomenu.add((Component)outputContexts, aminomenu.getPopupMenu().getComponentIndex(onlyStats) + 1);
                    aminomenu.getPopupMenu().pack();
                } else {
                    outputContexts.setSelected(false);
                    aminomenu.remove(outputContexts);
                    aminomenu.getPopupMenu().pack();
                }
            } else if (event.getSource() == write) {
                try {
                    FileDialog fs = new FileDialog((Frame)frame, "Save output file to...", 1);
                    fs.setDirectory(Main.savedir);
                    fs.setFile("*.tsv");
                    fs.setVisible(true);
                    String outfname = "";
                    String filename = fs.getFile();
                    if (filename == null) break block140;
                    outfname = String.valueOf(fs.getDirectory()) + "/" + filename;
                    BufferedWriter output = null;
                    Main.savedir = fs.getDirectory();
                    Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
                    try {
                        File outfile = null;
                        if (tsv.isSelected() || compactTsv.isSelected() || oncodrive.isSelected() || geneTsv.isSelected()) {
                            if (!outfname.contains(".tsv")) {
                                outfile = new File(String.valueOf(outfname) + ".tsv");
                                output = new BufferedWriter(new FileWriter(outfile));
                            } else {
                                outfile = new File(outfname);
                                output = new BufferedWriter(new FileWriter(outfile));
                            }
                            if (output != null) {
                                OutputRunner runner2 = new OutputRunner(output, null, null);
                                runner2.execute();
                            }
                        } else if (vcf.isSelected()) {
                            BlockCompressedOutputStream outputgz;
                            if (!outfname.contains(".vcf")) {
                                outfile = new File(String.valueOf(outfname) + ".vcf.gz");
                                outputgz = new BlockCompressedOutputStream(outfile);
                            } else if (!outfname.endsWith(".gz")) {
                                outfile = new File(String.valueOf(outfname) + ".gz");
                                outputgz = new BlockCompressedOutputStream(outfile);
                            } else {
                                outfile = new File(outfname);
                                outputgz = new BlockCompressedOutputStream(outfile);
                            }
                            if (outputgz != null) {
                                OutputRunner runner3 = new OutputRunner(output, outputgz, outfile);
                                runner3.execute();
                            }
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(frame, ex.getMessage());
                    }
                }
                catch (Exception e) {
                    ErrorLog.addError(e.getStackTrace());
                    e.printStackTrace();
                }
            } else if (event.getSource() == advQualities) {
                menu.show(this, 100, 100);
            } else if (event.getSource() == advQualitiesIndel) {
                menuIndel.show(this, 100, 100);
            } else if (event.getSource() == applyQualities) {
                Main.drawCanvas.drawVariables.advQDraw = null;
                if (indelFilters.isSelected()) {
                    int i = 0;
                    while (i < menuPanel.getComponentCount()) {
                        if (menuPanel.getComponent(i) instanceof JLabel) {
                            JComponent field;
                            JLabel label = (JLabel)menuPanel.getComponent(i);
                            if (menuPanel.getComponent(i + 1) instanceof JTextField) {
                                field = (JTextField)menuPanel.getComponent(i + 1);
                                String format = "<";
                                try {
                                    Float number = null;
                                    field.setForeground(Color.black);
                                    if (((JTextComponent)field).getText().length() > 0) {
                                        if (((JTextComponent)field).getText().trim().startsWith("<")) {
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith("<=")) {
                                            format = String.valueOf(format) + "=";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith(">=")) {
                                            format = ">=";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith(">")) {
                                            format = ">";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                        } else {
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().trim()));
                                        }
                                        if (Main.drawCanvas.drawVariables.advQDraw == null) {
                                            Main.drawCanvas.drawVariables.advQDraw = new ArrayList();
                                        }
                                        Main.drawCanvas.drawVariables.advQDraw.add(new QualEntry(label.getText(), number, format));
                                    }
                                }
                                catch (Exception e) {
                                    field.setForeground(Color.red);
                                }
                            } else {
                                field = (JCheckBox)menuPanel.getComponent(i + 1);
                                if (((AbstractButton)field).isSelected()) {
                                    if (Main.drawCanvas.drawVariables.advQDraw == null) {
                                        Main.drawCanvas.drawVariables.advQDraw = new ArrayList();
                                    }
                                    Main.drawCanvas.drawVariables.advQDraw.add(new QualEntry(((AbstractButton)field).getText(), Float.valueOf(1.0f), ""));
                                }
                            }
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < menuPanel.getComponentCount()) {
                        if (menuPanel.getComponent(i) instanceof JLabel) {
                            JComponent field;
                            JLabel label = (JLabel)menuPanel.getComponent(i);
                            if (menuPanel.getComponent(i + 1) instanceof JTextField) {
                                field = (JTextField)menuPanel.getComponent(i + 1);
                                String format = "<";
                                try {
                                    Float number = null;
                                    field.setForeground(Color.black);
                                    if (((JTextComponent)field).getText().length() > 0) {
                                        if (((JTextComponent)field).getText().trim().startsWith("<")) {
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith("<=")) {
                                            format = String.valueOf(format) + "=";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith(">=")) {
                                            format = ">=";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                        } else if (((JTextComponent)field).getText().trim().startsWith(">")) {
                                            format = ">";
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                        } else {
                                            number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().trim()));
                                        }
                                        if (Main.drawCanvas.drawVariables.advQDraw == null) {
                                            Main.drawCanvas.drawVariables.advQDraw = new ArrayList();
                                        }
                                        Main.drawCanvas.drawVariables.advQDraw.add(new QualEntry(label.getText(), number, format));
                                        JTextField indelfield = (JTextField)menuPanelIndel.getComponent(i + 1);
                                        indelfield.setText(String.valueOf(format) + number);
                                    }
                                }
                                catch (Exception e) {
                                    field.setForeground(Color.red);
                                }
                            } else if (menuPanel.getComponent(i + 1) instanceof JCheckBox) {
                                field = (JCheckBox)menuPanel.getComponent(i + 1);
                                if (Main.drawCanvas.drawVariables.advQDraw == null) {
                                    Main.drawCanvas.drawVariables.advQDraw = new ArrayList();
                                }
                                if (((AbstractButton)field).isSelected()) {
                                    Main.drawCanvas.drawVariables.advQDraw.add(new QualEntry(((AbstractButton)field).getText(), Float.valueOf(1.0f), ""));
                                    JCheckBox fieldIndel = (JCheckBox)menuPanelIndel.getComponent(i + 1);
                                    fieldIndel.setSelected(true);
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (FileRead.head.getNext() != null) {
                    FileRead.search = true;
                    Main.drawCanvas.forcereload = true;
                    Main.drawCanvas.gotoPos(Main.drawCanvas.splits.get((int)0).chrom, Main.drawCanvas.splits.get((int)0).start, Main.drawCanvas.splits.get((int)0).end);
                    Main.drawCanvas.forcereload = false;
                }
            } else if (event.getSource() == applyQualitiesIndel) {
                Main.drawCanvas.drawVariables.advQDrawIndel = null;
                int i = 0;
                while (i < menuPanelIndel.getComponentCount()) {
                    if (menuPanelIndel.getComponent(i) instanceof JLabel) {
                        JComponent field;
                        JLabel label = (JLabel)menuPanelIndel.getComponent(i);
                        if (menuPanel.getComponent(i + 1) instanceof JTextField) {
                            field = (JTextField)menuPanelIndel.getComponent(i + 1);
                            String format = "<";
                            try {
                                Float number = null;
                                field.setForeground(Color.black);
                                if (((JTextComponent)field).getText().length() > 0) {
                                    if (((JTextComponent)field).getText().trim().startsWith("<")) {
                                        number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                    } else if (((JTextComponent)field).getText().trim().startsWith("<=")) {
                                        format = String.valueOf(format) + "=";
                                        number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                    } else if (((JTextComponent)field).getText().trim().startsWith(">=")) {
                                        format = ">=";
                                        number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(2).trim()));
                                    } else if (((JTextComponent)field).getText().trim().startsWith(">")) {
                                        format = ">";
                                        number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().substring(1).trim()));
                                    } else {
                                        number = Float.valueOf(Float.parseFloat(((JTextComponent)field).getText().trim()));
                                    }
                                    if (Main.drawCanvas.drawVariables.advQDrawIndel == null) {
                                        Main.drawCanvas.drawVariables.advQDrawIndel = new ArrayList();
                                    }
                                    Main.drawCanvas.drawVariables.advQDrawIndel.add(new QualEntry(label.getText(), number, format));
                                }
                            }
                            catch (Exception e) {
                                field.setForeground(Color.red);
                            }
                        } else {
                            field = (JCheckBox)menuPanelIndel.getComponent(i + 1);
                            if (Main.drawCanvas.drawVariables.advQDrawIndel == null) {
                                Main.drawCanvas.drawVariables.advQDrawIndel = new ArrayList();
                            }
                            if (((AbstractButton)field).isSelected()) {
                                Main.drawCanvas.drawVariables.advQDrawIndel.add(new QualEntry(((AbstractButton)field).getText(), Float.valueOf(1.0f), ""));
                            }
                        }
                    }
                    ++i;
                }
                if (FileRead.head.getNext() != null) {
                    FileRead.search = true;
                    Main.drawCanvas.forcereload = true;
                    Main.drawCanvas.gotoPos(Main.drawCanvas.splits.get((int)0).chrom, Main.drawCanvas.splits.get((int)0).start, Main.drawCanvas.splits.get((int)0).end);
                    Main.drawCanvas.forcereload = false;
                }
            }
        }
    }

    static void removeMenuComponents() {
        menuPanel.removeAll();
        menuPanelIndel.removeAll();
        menuPanel.add(new JLabel("Hard filters"));
        menuPanelIndel.add(new JLabel("Hard filters"));
    }

    static void addMenuComponents(String line) {
        String key;
        if (line.startsWith("##FILTER")) {
            key = line.substring(line.indexOf("<ID=") + 4, line.indexOf(","));
            if (Main.drawCanvas != null && Main.drawCanvas.advQualities == null) {
                Main.drawCanvas.advQualities = new HashMap();
                Main.drawCanvas.advQualitiesIndel = new HashMap();
            }
            if (Main.drawCanvas != null && !Main.drawCanvas.advQualities.containsKey(key)) {
                Main.drawCanvas.advQualities.put(key, Float.valueOf(0.0f));
                String description = line.substring(line.indexOf("ion=\"") + 5);
                description = description.substring(0, description.indexOf("\""));
                JCheckBox addCheck = new JCheckBox(key);
                JCheckBox addCheckIndel = new JCheckBox(key);
                addCheck.setToolTipText(description);
                GridBagConstraints constr = new GridBagConstraints();
                constr.fill = 2;
                constr.anchor = 18;
                constr.gridx = 0;
                addCheck.setOpaque(false);
                constr.gridy = menuPanel.getComponentCount() / 2;
                menuPanel.add((Component)new JLabel(), constr);
                menuPanelIndel.add((Component)new JLabel(), constr);
                constr.gridx = 1;
                menuPanel.add((Component)addCheck, constr);
                menuPanelIndel.add((Component)addCheckIndel, constr);
                if (Main.drawCanvas.drawVariables.advQDrawIndel != null && Main.drawCanvas.drawVariables.advQDrawIndel.size() > 0) {
                    int i;
                    if (Main.drawCanvas.drawVariables.advQDraw != null && Main.drawCanvas.drawVariables.advQDraw.size() > 0) {
                        i = 0;
                        while (i < Main.drawCanvas.drawVariables.advQDraw.size()) {
                            if (Main.drawCanvas.drawVariables.advQDraw.get((int)i).key.equals(key)) {
                                addCheck.setSelected(Main.drawCanvas.drawVariables.advQDraw.get((int)i).value == 1.0f);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (Main.drawCanvas.drawVariables.advQDrawIndel != null && Main.drawCanvas.drawVariables.advQDrawIndel.size() > 0) {
                        i = 0;
                        while (i < Main.drawCanvas.drawVariables.advQDrawIndel.size()) {
                            if (Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).key.equals(key)) {
                                addCheckIndel.setSelected(Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).value == 1.0f);
                                break;
                            }
                            ++i;
                        }
                    }
                } else if (Main.drawCanvas.drawVariables.advQDraw != null && Main.drawCanvas.drawVariables.advQDraw.size() > 0) {
                    int i = 0;
                    while (i < Main.drawCanvas.drawVariables.advQDraw.size()) {
                        if (Main.drawCanvas.drawVariables.advQDraw.get((int)i).key.equals(key)) {
                            addCheck.setSelected(Main.drawCanvas.drawVariables.advQDraw.get((int)i).value == 1.0f);
                            addCheckIndel.setSelected(Main.drawCanvas.drawVariables.advQDraw.get((int)i).value == 1.0f);
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else {
            if (line.indexOf("Number=1") < 0) {
                return;
            }
            key = line.substring(line.indexOf("<ID=") + 4, line.indexOf(","));
            if (Main.drawCanvas != null) {
                if (Main.drawCanvas.advQualities == null) {
                    Main.drawCanvas.advQualities = new HashMap();
                    Main.drawCanvas.advQualitiesIndel = new HashMap();
                }
                if (!Main.drawCanvas.advQualities.containsKey(key)) {
                    int i;
                    GridBagConstraints constr = new GridBagConstraints();
                    constr.fill = 2;
                    constr.anchor = 18;
                    constr.gridx = 0;
                    constr.gridy = menuPanel.getComponentCount() / 2;
                    String[] split = line.substring(line.indexOf("<") + 1).replace(">", "").split(",");
                    StringBuffer tooltip = new StringBuffer("<html>");
                    int i2 = 0;
                    while (i2 < split.length) {
                        tooltip.append(String.valueOf(split[i2]) + "<br>");
                        ++i2;
                    }
                    tooltip.append("</html>");
                    Main.drawCanvas.advQualities.put(key, Float.valueOf(0.0f));
                    JLabel addLabel = new JLabel(key);
                    JLabel addLabelIndel = new JLabel(key);
                    addLabel.setToolTipText(tooltip.toString());
                    menuPanel.add((Component)addLabel, constr);
                    menuPanelIndel.add((Component)addLabelIndel, constr);
                    JTextField field = new JTextField("<");
                    JTextField fieldIndel = new JTextField("<");
                    if (Main.drawCanvas.drawVariables.advQDrawIndel != null && Main.drawCanvas.drawVariables.advQDrawIndel.size() > 0) {
                        if (Main.drawCanvas.drawVariables.advQDraw != null && Main.drawCanvas.drawVariables.advQDraw.size() > 0) {
                            i = 0;
                            while (i < Main.drawCanvas.drawVariables.advQDraw.size()) {
                                if (Main.drawCanvas.drawVariables.advQDraw.get((int)i).key.equals(key)) {
                                    field.setText(String.valueOf(Main.drawCanvas.drawVariables.advQDraw.get((int)i).format) + " " + Main.drawCanvas.drawVariables.advQDraw.get((int)i).value);
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (Main.drawCanvas.drawVariables.advQDrawIndel != null && Main.drawCanvas.drawVariables.advQDrawIndel.size() > 0) {
                            i = 0;
                            while (i < Main.drawCanvas.drawVariables.advQDrawIndel.size()) {
                                if (Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).key.equals(key)) {
                                    fieldIndel.setText(String.valueOf(Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).format) + " " + Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).value);
                                    break;
                                }
                                ++i;
                            }
                        }
                    } else if (Main.drawCanvas.drawVariables.advQDraw != null && Main.drawCanvas.drawVariables.advQDraw.size() > 0) {
                        i = 0;
                        while (i < Main.drawCanvas.drawVariables.advQDraw.size()) {
                            if (Main.drawCanvas.drawVariables.advQDraw.get((int)i).key.equals(key)) {
                                field.setText(String.valueOf(Main.drawCanvas.drawVariables.advQDraw.get((int)i).format) + " " + Main.drawCanvas.drawVariables.advQDraw.get((int)i).value);
                                fieldIndel.setText(String.valueOf(Main.drawCanvas.drawVariables.advQDraw.get((int)i).format) + " " + Main.drawCanvas.drawVariables.advQDraw.get((int)i).value);
                                break;
                            }
                            ++i;
                        }
                    }
                    field.setPreferredSize(new Dimension(100, Main.defaultFontSize * 2));
                    field.setToolTipText(tooltip.toString());
                    fieldIndel.setPreferredSize(new Dimension(100, Main.defaultFontSize * 2));
                    fieldIndel.setToolTipText(tooltip.toString());
                    constr.gridx = 1;
                    menuPanel.add((Component)field, constr);
                    menuPanelIndel.add((Component)fieldIndel, constr);
                }
            }
        }
        int i = 0;
        while (i < menuPanel.getComponentCount()) {
            menuPanel.getComponent(i).setFont(Main.menuFont);
            if (menuPanel.getComponent(i) instanceof JTextField) {
                menuPanel.getComponent(i).setPreferredSize(new Dimension(Main.defaultFontSize * 6, Main.defaultFontSize * 2));
            }
            ++i;
        }
        i = 0;
        while (i < menuPanelIndel.getComponentCount()) {
            menuPanelIndel.getComponent(i).setFont(Main.menuFont);
            if (menuPanelIndel.getComponent(i) instanceof JTextField) {
                menuPanelIndel.getComponent(i).setPreferredSize(new Dimension(Main.defaultFontSize * 6, Main.defaultFontSize * 2));
            }
            ++i;
        }
        menu.pack();
        menuIndel.pack();
    }

    String createVCFHeader() {
        StringBuffer headerstring = new StringBuffer("##fileformat=VCFv4.1" + Main.lineseparator + "##BasePlayer=<Version: " + Main.version + " output " + new SimpleDateFormat("dd.MM.yyyy HH:mm").format(Calendar.getInstance().getTime()) + ">" + Main.lineseparator + "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">" + Main.lineseparator + "##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Approximate read depth\">" + Main.lineseparator + "##FORMAT=<ID=AD,Number=.,Type=Integer,Description=\"Allelic depths for the ref and alt alleles in the order listed\">" + Main.lineseparator + "##FORMAT=<ID=GQ,Number=1,Type=Integer,Description=\"Genotype Quality\">" + Main.lineseparator + "##reference=" + Main.ref.getName() + Main.lineseparator);
        if (onlyselected.isSelected()) {
            headerstring.append("##sample=" + Main.drawCanvas.selectedSample.getName() + Main.lineseparator);
            headerstring.append("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\t" + Main.drawCanvas.selectedSample.getName() + Main.lineseparator);
        } else {
            StringBuffer headersamples = new StringBuffer("");
            headerstring.append("##files=");
            int i = 0;
            while (i < Main.drawCanvas.sampleList.size()) {
                if (Main.drawCanvas.sampleList.get(i).getTabixFile() != null || Main.drawCanvas.sampleList.get((int)i).calledvariants || VariantCaller.inanno.isSelected() && Main.drawCanvas.sampleList.get((int)i).samFile != null) {
                    headerstring.append(String.valueOf(Main.drawCanvas.sampleList.get(i).getName()) + ",");
                }
                if (VariantCaller.inanno.isSelected() && Main.drawCanvas.sampleList.get((int)i).samFile != null || Main.drawCanvas.sampleList.get((int)i).calledvariants || !Main.drawCanvas.sampleList.get((int)i).multiVCF && (Main.drawCanvas.sampleList.get(i).getTabixFile() != null || Main.drawCanvas.sampleList.get((int)i).multipart) && !Main.drawCanvas.sampleList.get((int)i).removed) {
                    headersamples.append("\t" + Main.drawCanvas.sampleList.get(i).getName());
                }
                ++i;
            }
            headerstring.deleteCharAt(headerstring.length() - 1);
            headerstring.append(Main.lineseparator);
            headerstring.append("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");
            headerstring.append(headersamples + Main.lineseparator);
            StringBuffer stringBuffer = new StringBuffer();
        }
        return headerstring.toString();
    }

    String createTSVHeader() {
        int i;
        StringBuffer headerstring = new StringBuffer("");
        headerstring.append("##BasePlayer version: " + Main.version + " output " + new SimpleDateFormat("dd.MM.yyyy HH:mm").format(Calendar.getInstance().getTime()) + Main.lineseparator);
        headerstring.append("##Files: ");
        if (onlyselected.isSelected()) {
            headerstring.append(Main.drawCanvas.selectedSample.getName());
        } else {
            i = 0;
            while (i < Main.samples) {
                if (Main.drawCanvas.sampleList.get((int)i).calledvariants || (Main.drawCanvas.sampleList.get(i).getTabixFile() != null || Main.drawCanvas.sampleList.get((int)i).multipart) && !Main.drawCanvas.sampleList.get((int)i).removed) {
                    headerstring.append(String.valueOf(Main.drawCanvas.sampleList.get(i).getName()) + ",");
                }
                ++i;
            }
            headerstring.deleteCharAt(headerstring.length() - 1);
        }
        headerstring.append(Main.lineseparator);
        headerstring.append("##Genome:" + Main.ref.getName() + ",Annotation:" + Main.annotationfile + Main.lineseparator);
        headerstring.append("##" + synonymous.getText() + ":" + synonymous.isSelected() + "," + utr.getText() + ":" + utr.isSelected() + "," + intronic.getText() + ":" + intronic.isSelected() + "," + nonsense.getText() + ":" + nonsense.isSelected() + "," + intergenic.getText() + ":" + intergenic.isSelected() + Main.lineseparator);
        if (Control.controlData.fileArray.size() > 0 && Control.controlData.controlsOn) {
            headerstring.append("##Controls:");
            i = 0;
            while (i < Control.controlData.fileArray.size()) {
                if (Control.controlData.fileArray.get((int)i).controlOn) {
                    headerstring.append(String.valueOf(Control.controlData.fileArray.get(i).getName()) + ":" + Control.controlData.fileArray.get((int)i).alleleFreq);
                    if (Control.controlData.fileArray.get((int)i).remOverlaps.isSelected()) {
                        headerstring.append(",Overlap_indels");
                    }
                    headerstring.append(",");
                }
                ++i;
            }
            headerstring.deleteCharAt(headerstring.length() - 1);
            headerstring.append(Main.lineseparator);
        } else {
            headerstring.append("##No controls applied" + Main.lineseparator);
        }
        if (Main.bedCanvas.bedOn) {
            headerstring.append("##Tracks:");
            i = 0;
            while (i < Main.bedCanvas.bedTrack.size()) {
                if (Main.bedCanvas.bedTrack.get((int)i).intersect) {
                    if (Main.bedCanvas.bedTrack.get((int)i).limitValue > Double.MIN_VALUE) {
                        headerstring.append(String.valueOf(Main.bedCanvas.bedTrack.get((int)i).file.getName()) + ">=" + Main.bedCanvas.bedTrack.get((int)i).limitValue + ",");
                    } else {
                        headerstring.append(String.valueOf(Main.bedCanvas.bedTrack.get((int)i).file.getName()) + ",");
                    }
                }
                ++i;
            }
            headerstring.deleteCharAt(headerstring.length() - 1);
            headerstring.append(Main.lineseparator);
        }
        if (commonSlider.getValue() > 1) {
            if (clusterSize > 0) {
                headerstring.append("##Variant clusters in " + commonSlider.getValue() + "/" + Main.varsamples + " samples within " + clusterSize + "bp" + Main.lineseparator);
            } else {
                headerstring.append("##Shared variants in " + commonSlider.getValue() + "/" + Main.varsamples + " samples" + Main.lineseparator);
            }
        }
        if (geneSlider.getValue() > 1) {
            headerstring.append("##At least " + geneSlider.getValue() + "/" + Main.varsamples + " samples share a mutated gene" + Main.lineseparator);
        }
        headerstring.append("##Variant filters:" + Main.lineseparator);
        headerstring.append("##Hide rs-coded variants: " + rscode.isSelected() + Main.lineseparator);
        headerstring.append("##Hide SNVs: " + hideSNVs.isSelected() + Main.lineseparator);
        headerstring.append("##Hide indels: " + hideIndels.isSelected() + Main.lineseparator);
        if (indelFilters.isSelected()) {
            headerstring.append("##Min. coverage SNVs: " + coverageSlider.getValue() + ", Indels:  " + coverageSliderIndel.getValue() + Main.lineseparator);
            headerstring.append("##Min. allelic/fraction SNVs: " + callSlider.getValue() + "%, Indels:  " + callSliderIndel.getValue() + "%" + Main.lineseparator);
            headerstring.append("##Min. quality score SNVs: " + qualitySlider.getValue() + ", Indels:  " + qualitySliderIndel.getValue() + Main.lineseparator);
            headerstring.append("##Min. genotype quality score SNVs: " + gqSlider.getValue() + ", Indels:  " + gqSliderIndel.getValue() + Main.lineseparator);
            headerstring.append("##Max. coverage SNVs: " + maxCoverageSlider.getValue() + ", Indels:  " + maxCoverageSliderIndel.getValue() + Main.lineseparator);
        } else {
            headerstring.append("##Min. coverage: " + coverageSlider.getValue() + Main.lineseparator);
            headerstring.append("##Min. allelic/fraction: " + callSlider.getValue() + "%" + Main.lineseparator);
            headerstring.append("##Min. quality score: " + qualitySlider.getValue() + Main.lineseparator);
            headerstring.append("##Min. genotype quality score: " + gqSlider.getValue() + Main.lineseparator);
            headerstring.append("##Max. coverage: " + maxCoverageSlider.getValue() + Main.lineseparator);
        }
        if (Main.drawCanvas.drawVariables.advQDraw != null) {
            i = 0;
            while (i < Main.drawCanvas.drawVariables.advQDraw.size()) {
                headerstring.append("##" + Main.drawCanvas.drawVariables.advQDraw.get((int)i).key + ": " + Main.drawCanvas.drawVariables.advQDraw.get((int)i).format + Main.drawCanvas.drawVariables.advQDraw.get((int)i).value + Main.lineseparator);
                ++i;
            }
        }
        if (Main.drawCanvas.drawVariables.advQDrawIndel != null) {
            i = 0;
            while (i < Main.drawCanvas.drawVariables.advQDrawIndel.size()) {
                headerstring.append("##Indel: " + Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).key + ": " + Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).format + Main.drawCanvas.drawVariables.advQDrawIndel.get((int)i).value + Main.lineseparator);
                ++i;
            }
        }
        StringBuffer controls = new StringBuffer("");
        if (Control.controlData.controlsOn) {
            controlarray.clear();
            int i2 = 0;
            while (i2 < Control.controlData.fileArray.size()) {
                if (Control.controlData.fileArray.get((int)i2).controlOn) {
                    controls.append("AF: " + Control.controlData.fileArray.get(i2).getName() + "\tOR\t");
                    controlarray.add(Control.controlData.fileArray.get(i2));
                }
                ++i2;
            }
        }
        StringBuffer tracks = new StringBuffer("");
        if (Main.bedCanvas.bedOn) {
            int i3 = 0;
            while (i3 < Main.bedCanvas.bedTrack.size()) {
                if (Main.bedCanvas.bedTrack.get((int)i3).intersect) {
                    tracks.append(String.valueOf(Main.bedCanvas.bedTrack.get((int)i3).file.getName()) + "\t");
                }
                ++i3;
            }
        }
        String clusters = "";
        if (commonSlider.getValue() > 1 && clusterSize > 0) {
            clusters = "ClusterID\tClusterMutCount\tClusterWidth\tClusterMutFreq\t";
        }
        if (!tabs.getSelectedComponent().equals(statsScroll) && !onlyStats.isSelected()) {
            if (oncodrive.isSelected()) {
                headerstring.append("#CHROM\tPOS\tREF\tALT\tSAMPLE" + Main.lineseparator);
            } else if (geneTsv.isSelected()) {
                headerstring.append("Gene\tMutationCount\tSampleCount\t");
                if (onlyselected.isSelected()) {
                    headerstring.append(Main.drawCanvas.selectedSample.getName());
                } else {
                    int i4 = 0;
                    while (i4 < Main.samples) {
                        if (Main.drawCanvas.sampleList.get((int)i4).calledvariants || (Main.drawCanvas.sampleList.get(i4).getTabixFile() != null || Main.drawCanvas.sampleList.get((int)i4).multipart) && !Main.drawCanvas.sampleList.get((int)i4).removed) {
                            headerstring.append(String.valueOf(Main.drawCanvas.sampleList.get(i4).getName()) + "\t");
                        }
                        ++i4;
                    }
                    headerstring.deleteCharAt(headerstring.length() - 1);
                }
                headerstring.append(Main.lineseparator);
            } else {
                headerstring.append("#Sample\tGene\tMutationCount\tSampleCount\tENSG\tENST\tBioType\tPosition\tStrand\tRegion\tEffect\tBaseChange\tGenotype(calls/coverage)\tQuality\tGQ\trs-code\t" + clusters + controls + tracks + "Description" + Main.lineseparator);
            }
        } else {
            headerstring.append("#Sample\tVariants\tSNVs\tDELs\tINSs\tCoding\tHetero/homo-rate\tTS/TV-rate\tT>A\tT>C\tT>G\tC>A\tC>G\tC>T\tAvg.call/cov\tSynonymous\tNonsynonymous\tMissense\tSplice-site\tNonsense\tFrameShift\tInframe" + Main.lineseparator);
        }
        return headerstring.toString();
    }

    void writeOutput(BufferedWriter output, BlockCompressedOutputStream outputgz, File outFile) {
        frame.getGlassPane().setVisible(true);
        table.setEnabled(false);
        frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (tabs.getSelectedComponent().equals(statsScroll)) {
                String header = this.createTSVHeader();
                output.write(header);
                int i = 0;
                while (i < VariantHandler.stattable.sampleArray.size()) {
                    Sample sample = (Sample)VariantHandler.stattable.sampleArray.get(i)[0];
                    output.write(sample.getName());
                    int j = 1;
                    while (j < VariantHandler.stattable.headerlengths.length) {
                        output.write("\t" + VariantHandler.stattable.sampleArray.get(i)[j]);
                        ++j;
                    }
                    output.write("\t" + sample.syn + "\t" + sample.nonsyn + "\t" + sample.missense + "\t" + sample.splice + "\t" + sample.nonsense + "\t" + sample.fshift + "\t" + sample.inframe);
                    output.write(Main.lineseparator);
                    ++i;
                }
                output.close();
            } else if (vcf.isSelected()) {
                String header = this.createVCFHeader();
                if (outputgz != null) {
                    SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
                    FileRead.indexCreator = new TabixIndexCreator(dict, TabixFormat.VCF);
                    FileRead.filepointer = 0L;
                    VCFHeader vcfheader = new VCFHeader();
                    VCFHeaderLine headerline = new VCFHeaderLine("format", "##fileformat=VCFv4.1");
                    vcfheader.addMetaDataLine(headerline);
                    vcfCodec.setVCFHeader(vcfheader, VCFHeaderVersion.VCF4_1);
                    outputgz.write(header.getBytes());
                } else {
                    output.write(this.createVCFHeader());
                }
                this.writeGeneListToVCF(VariantHandler.table.genearray, output, outputgz);
                if (outputgz != null) {
                    int i = 0;
                    while (i < outputStrings.size()) {
                        outputgz.write(outputStrings.get(i).getBytes());
                        VariantContext vcf = vcfCodec.decode(outputStrings.get(i));
                        FileRead.indexCreator.addFeature(vcf, FileRead.filepointer);
                        FileRead.filepointer = outputgz.getFilePointer();
                        ++i;
                    }
                    outputStrings.clear();
                    outputgz.flush();
                    Index index = FileRead.indexCreator.finalizeIndex(outputgz.getFilePointer());
                    index.writeBasedOnFeatureFile(outFile);
                    outputgz.close();
                }
            } else {
                output.write(this.createTSVHeader());
                int gene = 0;
                while (gene < VariantHandler.table.genearray.size()) {
                    Main.drawCanvas.loadbarAll = (int)((double)gene / (double)VariantHandler.table.genearray.size() * 100.0);
                    Main.drawCanvas.loadBarSample = (int)((double)gene / (double)VariantHandler.table.genearray.size() * 100.0);
                    VariantHandler.writeTranscriptToFile(VariantHandler.table.genearray.get(gene), output);
                    ++gene;
                }
                output.close();
            }
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            table.setEnabled(true);
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.chromDraw, e.getMessage(), "Error", 0);
        }
        frame.getGlassPane().setVisible(false);
        frame.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        controlarray.clear();
        table.setEnabled(true);
    }

    static void writeNodeToFile(VarNode node, String chrom, BufferedWriter output, BlockCompressedOutputStream outputgz) {
        block45: {
            try {
                if (vcf.isSelected()) {
                    StringBuffer info = new StringBuffer("");
                    StringBuffer alts = new StringBuffer("");
                    StringBuffer refs = new StringBuffer("");
                    StringBuffer ADs = new StringBuffer("");
                    StringBuffer sampleinfos = new StringBuffer("");
                    double avgquality = 0.0;
                    int samplecount = 0;
                    String rscode = ".";
                    String ref = Main.getBase.get(node.getRefBase());
                    int AN = Main.varsamples * 2;
                    int AC = 0;
                    int allelenro = 1;
                    StringBuffer ACs = new StringBuffer("");
                    StringBuffer AFs = new StringBuffer("");
                    double AF = 0.0;
                    String sampleinfo = null;
                    int[] coverages = null;
                    HashMap<Short, String> samplehash = new HashMap<Short, String>();
                    boolean set = false;
                    boolean found = false;
                    int var = 0;
                    while (var < node.vars.size()) {
                        Map.Entry<String, ArrayList<SampleNode>> entry = node.vars.get(var);
                        if (!Main.drawCanvas.hideNodeVar(node, entry)) {
                            AF = 0.0;
                            AC = 0;
                            avgquality = 0.0;
                            if (node.vars.size() == 1) {
                                if (node.indel && entry.getKey().length() > 1) {
                                    String[] result = MethodLibrary.makeIndelColumns(chrom, node.getPosition(), ref, entry.getKey());
                                    ref = result[0];
                                    alts.append(String.valueOf(result[1]) + ",");
                                } else {
                                    alts.append(String.valueOf(entry.getKey()) + ",");
                                }
                            } else if (node.indel) {
                                if (!set) {
                                    String[] result = MethodLibrary.makeMultiAlt(chrom, node.getPosition(), ref, node);
                                    set = true;
                                    ref = result[0];
                                    alts.append(result[1]);
                                }
                                allelenro = var + 1;
                            } else {
                                if (refs.length() == 0) {
                                    refs.append(String.valueOf(ref) + ",");
                                }
                                if (alts.length() > 0) {
                                    ++allelenro;
                                }
                                alts.append(String.valueOf(entry.getKey()) + ",");
                            }
                            coverages = new int[node.vars.size() + 1];
                            int i = 0;
                            while (i < coverages.length) {
                                coverages[i] = 0;
                                ++i;
                            }
                            int sample = 0;
                            while (sample < entry.getValue().size()) {
                                ADs = new StringBuffer("");
                                if (!Main.drawCanvas.hideVar(entry.getValue().get(sample), entry.getKey().length() > 1)) {
                                    int i2;
                                    found = true;
                                    if (samplehash.containsKey(entry.getValue().get(sample).getSample().getMultiIndex())) {
                                        ++AC;
                                        coverages[0] = 0;
                                        coverages[Integer.parseInt((String)new StringBuilder().append((char)((String)samplehash.get((Object)Short.valueOf((short)entry.getValue().get((int)sample).getSample().getMultiIndex()))).charAt((int)2)).toString())] = entry.getValue().get(sample).getCoverage() - entry.getValue().get(sample).getCalls();
                                        coverages[allelenro] = entry.getValue().get(sample).getCalls();
                                        ADs.append(coverages[0]);
                                        i2 = 1;
                                        while (i2 < coverages.length) {
                                            ADs.append("," + coverages[i2]);
                                            ++i2;
                                        }
                                        sampleinfo = String.valueOf(((String)samplehash.get(entry.getValue().get(sample).getSample().getMultiIndex())).charAt(2)) + "/" + allelenro + ":" + entry.getValue().get(sample).getCoverage() + ":" + ADs + ":" + entry.getValue().get(sample).getGQString();
                                        samplehash.put(entry.getValue().get(sample).getSample().getMultiIndex(), sampleinfo);
                                    } else if (entry.getValue().get(sample).isHomozygous()) {
                                        AC += 2;
                                        coverages[0] = entry.getValue().get(sample).getCoverage() - entry.getValue().get(sample).getCalls();
                                        coverages[allelenro] = entry.getValue().get(sample).getCalls();
                                        ADs.append(coverages[0]);
                                        i2 = 1;
                                        while (i2 < coverages.length) {
                                            ADs.append("," + coverages[i2]);
                                            ++i2;
                                        }
                                        sampleinfo = String.valueOf(allelenro) + "/" + allelenro + ":" + entry.getValue().get(sample).getCoverage() + ":" + ADs + ":" + entry.getValue().get(sample).getGQString();
                                        samplehash.put(entry.getValue().get(sample).getSample().getMultiIndex(), sampleinfo);
                                    } else {
                                        ++AC;
                                        coverages[0] = entry.getValue().get(sample).getCoverage() - entry.getValue().get(sample).getCalls();
                                        coverages[allelenro] = entry.getValue().get(sample).getCalls();
                                        ADs.append(coverages[0]);
                                        i2 = 1;
                                        while (i2 < coverages.length) {
                                            ADs.append("," + coverages[i2]);
                                            ++i2;
                                        }
                                        sampleinfo = "0/" + allelenro + ":" + entry.getValue().get(sample).getCoverage() + ":" + ADs.toString() + ":" + entry.getValue().get(sample).getGQString();
                                        samplehash.put(entry.getValue().get(sample).getSample().getMultiIndex(), sampleinfo);
                                    }
                                    ++samplecount;
                                    if (entry.getValue().get(sample).getQuality() != null) {
                                        avgquality += (double)entry.getValue().get(sample).getQuality().floatValue();
                                    }
                                }
                                ++sample;
                            }
                            AF = MethodLibrary.round((double)AC / (double)AN, 5);
                            ACs.append(String.valueOf(AC) + ",");
                            AFs.append(String.valueOf(AF) + ",");
                        }
                        ++var;
                    }
                    if (!found) {
                        return;
                    }
                    if (node.rscode != null) {
                        rscode = node.rscode;
                    }
                    Short i = 0;
                    while (i < Main.varsamples) {
                        if (samplehash.containsKey(i)) {
                            sampleinfos.append("\t" + (String)samplehash.get(i));
                        } else {
                            sampleinfos.append("\t0/0");
                        }
                        i = (short)(i + 1);
                    }
                    alts.deleteCharAt(alts.length() - 1);
                    AFs.deleteCharAt(AFs.length() - 1);
                    ACs.deleteCharAt(ACs.length() - 1);
                    info.append("AN=" + AN + ";AC=" + ACs + ";AF=" + AFs);
                    if (outputgz != null) {
                        String writeline = String.valueOf(chrom) + "\t" + (node.getPosition() + 1) + "\t" + rscode + "\t" + ref + "\t" + alts + "\t" + MethodLibrary.round(avgquality / (double)samplecount, 2) + "\tPASS\t" + info + "\t" + format + sampleinfos + Main.lineseparator;
                        outputgz.write(writeline.getBytes());
                        VariantContext vcf = vcfCodec.decode(writeline);
                        FileRead.indexCreator.addFeature(vcf, FileRead.filepointer);
                        FileRead.filepointer = outputgz.getFilePointer();
                    } else if (output != null) {
                        output.write(String.valueOf(chrom) + "\t" + (node.getPosition() + 1) + "\t" + rscode + "\t" + ref + "\t" + alts + "\t" + MethodLibrary.round(avgquality / (double)samplecount, 2) + "\t.\t" + info + "\t" + format + sampleinfos + Main.lineseparator);
                    }
                    break block45;
                }
                if (!oncodrive.isSelected()) break block45;
                String[] result = null;
                int var = 0;
                while (var < node.vars.size()) {
                    Map.Entry<String, ArrayList<SampleNode>> entry = node.vars.get(var);
                    if (!Main.drawCanvas.hideNodeVar(node, entry)) {
                        if (node.indel && entry.getKey().length() > 1) {
                            result = MethodLibrary.makeIndelColumns(node.getChrom(), node.getPosition(), Main.getBase.get(node.getRefBase()), entry.getKey());
                        }
                        int i = 0;
                        while (i < entry.getValue().size()) {
                            if (!Main.drawCanvas.hideVar(entry.getValue().get(i), entry.getKey().length() > 1)) {
                                try {
                                    if (output != null) {
                                        if (node.indel && entry.getKey().length() > 1) {
                                            if (result[0].length() > 1) {
                                                output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 2) + "\t" + result[0].substring(1) + "\t-\t" + entry.getValue().get(i).getSample().getName() + Main.lineseparator);
                                            } else {
                                                output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 2) + "\t-\t" + result[1].substring(1) + "\t" + entry.getValue().get(i).getSample().getName() + Main.lineseparator);
                                            }
                                        } else {
                                            output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 1) + "\t" + Main.getBase.get(node.getRefBase()) + "\t" + entry.getKey() + "\t" + entry.getValue().get(i).getSample().getName() + Main.lineseparator);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    ErrorLog.addError(ex.getStackTrace());
                                }
                            }
                            ++i;
                        }
                    }
                    ++var;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void writeTranscriptToFile(Gene gene, BufferedWriter output) {
        try {
            SampleNode varnode;
            VarNode node = null;
            StringBuffer strand = new StringBuffer("");
            int casefreq = 0;
            String genotype = "";
            String biotype = ".";
            String geneID = "";
            String description = "";
            StringBuffer controls = new StringBuffer("");
            StringBuffer tracks = new StringBuffer("");
            String clusters = "";
            HashMap<ControlFile, SampleNode> temphash = new HashMap<ControlFile, SampleNode>();
            table.getAminos(gene);
            StringBuffer samples = new StringBuffer("");
            StringBuffer genotypes = new StringBuffer("");
            StringBuffer qualities = new StringBuffer("");
            StringBuffer GQualities = new StringBuffer("");
            int s = 0;
            while (s < VariantHandler.table.aminoarray.size()) {
                String[] row = VariantHandler.table.aminoarray.get(s).getRow();
                node = VariantHandler.table.aminoarray.get(s).getNode();
                strand = new StringBuffer("");
                String rscode = node.isRscode() != null ? node.isRscode() : "N/A";
                String exons = row[8].contains("troni") ? "Intronic" : (row[8].contains("geni") ? "Intergenic" : (row[8].length() == 1 ? "Exon " + row[8] : (row[8].length() > 1 ? "Exons " + row[8] : "")));
                if (gene.intergenic) {
                    if (node.getTranscripts().size() == 2) {
                        geneID = String.valueOf(gene.getID()) + ";" + node.getTranscripts().get(1).getGene().getID();
                        description = String.valueOf(gene.getDescription()) + ";" + node.getTranscripts().get(1).getGene().getDescription();
                        strand.append(gene.getStrand() ? "+;" : "-;");
                        strand.append(node.getTranscripts().get(1).getGene().getStrand() ? "+" : "-");
                    } else {
                        geneID = gene.getID();
                        description = gene.getDescription();
                    }
                } else {
                    if (!gene.getStrand()) {
                        strand.append("-");
                    } else {
                        strand.append("+");
                    }
                    geneID = gene.getID();
                    description = gene.getDescription();
                }
                String transcripts = row[6];
                biotype = row[7];
                clusters = "";
                if (commonSlider.getValue() > 1 && clusterSize > 0 && node.clusterNode != null) {
                    clusters = String.valueOf(node.clusterNode.ID) + "\t" + node.clusterNode.nodecount + "\t" + node.clusterNode.width + "\t" + MethodLibrary.round((double)node.clusterNode.nodecount / (double)node.clusterNode.width, 2) + "\t";
                }
                int var = 0;
                while (var < node.vars.size()) {
                    Map.Entry<String, ArrayList<SampleNode>> entry = node.vars.get(var);
                    if (!Main.drawCanvas.hideNodeVar(node, entry) && entry.getKey().equals(row[5])) {
                        int i;
                        String aminochange = exons.length() > 0 ? row[3] : "N/A";
                        if (Main.bedCanvas.bedOn) {
                            tracks = new StringBuffer("");
                            StringBuffer[] bedarray = MethodLibrary.makeTrackArray(node, entry.getKey());
                            if (bedarray != null) {
                                int b = 0;
                                while (b < bedarray.length) {
                                    if (Main.bedCanvas.bedTrack.get((int)b).intersect) {
                                        if (bedarray[b] != null) {
                                            tracks.append(String.valueOf(bedarray[b].toString()) + "\t");
                                        } else {
                                            tracks.append("-\t");
                                        }
                                    }
                                    ++b;
                                }
                            } else {
                                int i2 = 0;
                                while (i2 < Main.bedCanvas.bedTrack.size()) {
                                    if (Main.bedCanvas.bedTrack.get((int)i2).intersect) {
                                        tracks.append("\t");
                                    }
                                    ++i2;
                                }
                            }
                        }
                        if (Control.controlData.controlsOn && entry.getValue().size() > 0) {
                            casefreq = 0;
                            controls = new StringBuffer("");
                            temphash.clear();
                            int e = entry.getValue().size() - 1;
                            while (e > -1) {
                                if (entry.getValue().get((int)e).alleles == null) {
                                    casefreq = entry.getValue().get(e).isHomozygous() ? (casefreq += 2) : ++casefreq;
                                } else if (entry.getValue().get((int)e).getControlSample().controlOn) {
                                    temphash.put(entry.getValue().get(e).getControlSample(), entry.getValue().get(e));
                                }
                                --e;
                            }
                            i = 0;
                            while (i < controlarray.size()) {
                                if (temphash.containsKey(controlarray.get(i))) {
                                    controls.append(String.valueOf(MethodLibrary.round((double)((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).alleles.intValue() / (double)((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).allelenumber.intValue(), 5)) + "\t");
                                    controls.append(String.valueOf(MethodLibrary.round((double)casefreq / (double)(Main.varsamples * 2 - casefreq) / ((double)((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).alleles.intValue() / (double)(((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).allelenumber - ((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).alleles)), 5)) + " (p=" + MethodLibrary.round(VariantHandler.table.fe.getRightTailedP(casefreq, Main.varsamples * 2 - casefreq, ((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).alleles, ((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).allelenumber - ((SampleNode)temphash.get((Object)VariantHandler.controlarray.get((int)i))).alleles), 12) + ")\t");
                                } else {
                                    controls.append("N/A\tN/A\t");
                                }
                                ++i;
                            }
                        }
                        if (compactTsv.isSelected()) {
                            samples = new StringBuffer("");
                            genotypes = new StringBuffer("");
                            qualities = new StringBuffer("");
                            GQualities = new StringBuffer("");
                            i = 0;
                            while (i < entry.getValue().size()) {
                                if (!Main.drawCanvas.hideVar(entry.getValue().get(i), entry.getKey().length() > 1)) {
                                    varnode = entry.getValue().get(i);
                                    if (varnode.isHomozygous()) {
                                        genotypes.append("Hom(" + varnode.getCalls() + "/" + varnode.getCoverage() + ");");
                                    } else {
                                        genotypes.append("Het(" + varnode.getCalls() + "/" + varnode.getCoverage() + ");");
                                    }
                                    samples.append(String.valueOf(varnode.getSample().getName()) + ";");
                                    qualities.append(varnode.getQuality() + ";");
                                    GQualities.append(String.valueOf(varnode.getGQString()) + ";");
                                }
                                ++i;
                            }
                            genotypes.deleteCharAt(genotypes.length() - 1);
                            qualities.deleteCharAt(qualities.length() - 1);
                            samples.deleteCharAt(samples.length() - 1);
                            GQualities.deleteCharAt(GQualities.length() - 1);
                            if (output != null) {
                                if (exons.length() > 0) {
                                    if (!aminochange.equals("N/A")) {
                                        output.write(samples + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + exons + "\t" + aminochange + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotypes + "\t" + qualities + "\t" + GQualities + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                    } else {
                                        output.write(samples + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "UTR" + "\t" + aminochange + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotypes + "\t" + qualities + "\t" + GQualities + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                    }
                                } else if (node.getTranscripts() != null && node.isInGene()) {
                                    output.write(samples + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "Intronic" + "\t" + "N/A" + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotypes + "\t" + qualities + "\t" + GQualities + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                } else {
                                    output.write(samples + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "Intergenic" + "\t" + "N/A" + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotypes + "\t" + qualities + "\t" + GQualities + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                }
                            }
                        } else if (tsv.isSelected()) {
                            i = 0;
                            while (i < entry.getValue().size()) {
                                if (!Main.drawCanvas.hideVar(entry.getValue().get(i), entry.getKey().length() > 1)) {
                                    varnode = entry.getValue().get(i);
                                    genotype = varnode.isHomozygous() ? "Hom(" + varnode.getCalls() + "/" + varnode.getCoverage() + ")" : "Het(" + varnode.getCalls() + "/" + varnode.getCoverage() + ")";
                                    try {
                                        if (output != null) {
                                            if (exons.length() > 0) {
                                                if (!aminochange.equals("N/A")) {
                                                    output.write(String.valueOf(varnode.getSample().getName()) + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + exons + "\t" + aminochange + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotype + "\t" + varnode.getQuality() + "\t" + varnode.getGQString() + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                                } else {
                                                    output.write(String.valueOf(varnode.getSample().getName()) + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "UTR" + "\t" + aminochange + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotype + "\t" + varnode.getQuality() + "\t" + varnode.getGQString() + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                                }
                                            } else if (node.getTranscripts() != null && node.isInGene()) {
                                                output.write(String.valueOf(varnode.getSample().getName()) + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "Intronic" + "\t" + "N/A" + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotype + "\t" + varnode.getQuality() + "\t" + varnode.getGQString() + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                            } else {
                                                output.write(String.valueOf(varnode.getSample().getName()) + "\t" + row[0] + "\t" + row[1] + "\t" + gene.samples.size() + "\t" + geneID + "\t" + transcripts + "\t" + biotype + "\t" + row[2] + "\t" + strand + "\t" + "Intergenic" + "\t" + "N/A" + "\t" + Main.getBase.get(node.getRefBase()) + "->" + entry.getKey() + "\t" + genotype + "\t" + varnode.getQuality() + "\t" + varnode.getGQString() + "\t" + rscode + "\t" + clusters + controls + tracks + description + Main.lineseparator);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        ErrorLog.addError(ex.getStackTrace());
                                    }
                                }
                                ++i;
                            }
                        } else if (oncodrive.isSelected()) {
                            String[] result = null;
                            int v = 0;
                            while (v < node.vars.size()) {
                                entry = node.vars.get(v);
                                if (!Main.drawCanvas.hideNodeVar(node, entry)) {
                                    if (node.indel && entry.getKey().length() > 1) {
                                        result = MethodLibrary.makeIndelColumns(node.getChrom(), node.getPosition(), Main.getBase.get(node.getRefBase()), entry.getKey());
                                    }
                                    int i3 = 0;
                                    while (i3 < entry.getValue().size()) {
                                        if (!Main.drawCanvas.hideVar(entry.getValue().get(i3), entry.getKey().length() > 1)) {
                                            try {
                                                if (output != null) {
                                                    if (node.indel && entry.getKey().length() > 1) {
                                                        if (result[0].length() > 1) {
                                                            output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 1) + "\t" + result[0].substring(1) + "\t-\t" + entry.getValue().get(i3).getSample().getName() + Main.lineseparator);
                                                        } else {
                                                            output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 1) + "\t-\t" + result[1].substring(1) + "\t" + entry.getValue().get(i3).getSample().getName() + Main.lineseparator);
                                                        }
                                                    } else {
                                                        output.write(String.valueOf(node.getChrom()) + "\t" + (node.getPosition() + 1) + "\t" + Main.getBase.get(node.getRefBase()) + "\t" + entry.getKey() + "\t" + entry.getValue().get(i3).getSample().getName() + Main.lineseparator);
                                                    }
                                                }
                                            }
                                            catch (Exception ex) {
                                                ex.printStackTrace();
                                                ErrorLog.addError(ex.getStackTrace());
                                            }
                                        }
                                        ++i3;
                                    }
                                }
                                ++v;
                            }
                        } else if (geneTsv.isSelected()) {
                            output.write(String.valueOf(gene.getName()) + "\t" + gene.mutations + "\t" + gene.samples.size() + "\t");
                            i = 0;
                            while (i < Main.drawCanvas.sampleList.size()) {
                                if (Main.drawCanvas.sampleList.get((int)i).calledvariants || (Main.drawCanvas.sampleList.get(i).getTabixFile() != null || Main.drawCanvas.sampleList.get((int)i).multipart) && !Main.drawCanvas.sampleList.get((int)i).removed) {
                                    if (gene.samples.contains(Main.drawCanvas.sampleList.get(i))) {
                                        output.write("1\t");
                                    } else {
                                        output.write("0\t");
                                    }
                                }
                                ++i;
                            }
                            output.write(Main.lineseparator);
                        }
                    }
                    ++var;
                }
                ++s;
            }
            Main.drawCanvas.loadBarSample = (int)((double)gene.getStart() / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
            varnode = null;
            Object var3_2 = null;
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(Main.chromDraw, String.valueOf(exc.getMessage()) + " - there were problem writing variants for " + gene.getName(), "Error", 0);
            exc.printStackTrace();
            ErrorLog.addError(exc.getStackTrace());
        }
    }

    void writeGeneListToVCF(ArrayList<Gene> genelist, BufferedWriter output, BlockCompressedOutputStream outputgz) {
        boolean found = false;
        VarNode node = null;
        if (VariantHandler.table.genearray.size() > 0 && VariantHandler.table.genearray.get((int)0).varnodes != null && VariantHandler.table.genearray.get((int)0).varnodes.size() > 0) {
            node = VariantHandler.table.genearray.get((int)0).varnodes.get(0);
        }
        while (node != null) {
            if (geneSlider.getValue() > 1) {
                found = false;
                if (node.isInGene()) {
                    int i;
                    if (node.getExons() != null) {
                        i = 0;
                        while (i < node.getExons().size()) {
                            if (node.getExons().get((int)i).getTranscript().getGene().samples.size() >= geneSlider.getValue()) {
                                found = true;
                            } else {
                                node.getExons().remove(i);
                                --i;
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < node.getTranscripts().size()) {
                            if (node.getTranscripts().get((int)i).getGene().samples.size() >= geneSlider.getValue()) {
                                found = true;
                            } else {
                                node.getTranscripts().remove(i);
                                --i;
                            }
                            ++i;
                        }
                    }
                }
                if (found) {
                    VariantHandler.writeNodeToFile(node, node.getChrom(), null, outputgz);
                }
            } else {
                VariantHandler.writeNodeToFile(node, node.getChrom(), null, outputgz);
            }
            node = node.getNext();
        }
        node = null;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getSource() == qualityLabel) {
            menu.show(this, 100, 100);
        } else if (event.getSource() == qualityLabelIndel) {
            menuIndel.show(this, 100, 100);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event.getSource() == qualityLabel) {
            qualityLabel.setForeground(Color.white);
        } else if (event.getSource() == qualityLabelIndel) {
            qualityLabelIndel.setForeground(Color.white);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (event.getSource() == qualityLabel) {
            qualityLabel.setForeground(Color.black);
        } else if (event.getSource() == qualityLabelIndel) {
            qualityLabelIndel.setForeground(Color.black);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getSource() == tabs) {
            if (tabs.getSelectedIndex() == 0) {
                aminoCount.setText(String.valueOf(VariantHandler.table.variants) + " variants");
                outputmenu.setText("Variant output");
                vcf.setVisible(true);
                compactTsv.setVisible(true);
                oncodrive.setVisible(true);
                outputmenu.revalidate();
            } else if (tabs.getSelectedIndex() == tabs.indexOfComponent(statsScroll)) {
                if (VariantHandler.stattable.bufImage.getWidth() == 1) {
                    VariantHandler.stattable.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(Main.screenSize.width, Main.screenSize.height, 2));
                    VariantHandler.stattable.buf = (Graphics2D)VariantHandler.stattable.bufImage.getGraphics();
                }
                aminoCount.setText(String.valueOf(VariantHandler.stattable.variants) + " variants");
                outputmenu.setText("Stats output");
                outputmenu.revalidate();
                vcf.setVisible(false);
                compactTsv.setVisible(false);
                oncodrive.setVisible(false);
            } else if (tabs.getSelectedIndex() == tabs.indexOfComponent(clusterScroll)) {
                if (VariantHandler.clusterTable.bufImage.getWidth() == 1) {
                    VariantHandler.clusterTable.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(Main.screenSize.width, Main.screenSize.height, 2));
                    VariantHandler.clusterTable.buf = (Graphics2D)VariantHandler.clusterTable.bufImage.getGraphics();
                }
                aminoCount.setText(String.valueOf(VariantHandler.clusterTable.variants) + " variants");
                outputmenu.setText("Variant output");
                vcf.setVisible(true);
                compactTsv.setVisible(true);
                oncodrive.setVisible(true);
                outputmenu.revalidate();
            } else {
                aminoCount.setText(String.valueOf(VariantHandler.tables.get((int)(VariantHandler.tabs.getSelectedIndex() - (VariantHandler.tabs.indexOfComponent((Component)VariantHandler.statsScroll) + 1))).variants) + " variants");
                outputmenu.setText("Variant output");
                vcf.setVisible(true);
                compactTsv.setVisible(true);
                oncodrive.setVisible(true);
                outputmenu.revalidate();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.getSource() == tableScroll.getVerticalScrollBar()) {
            table.repaint();
            return;
        }
        if (event.getSource() == coverageSlider) {
            if (coverageSlider.getValue() == coverageSlider.getMaximum()) {
                coverageSlider.setMaximum(coverageSlider.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == qualitySlider) {
            if (qualitySlider.getValue() == qualitySlider.getMaximum()) {
                qualitySlider.setMaximum(qualitySlider.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == gqSlider) {
            if (gqSlider.getValue() == gqSlider.getMaximum()) {
                gqSlider.setMaximum(gqSlider.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == maxCoverageSlider) {
            if (maxCoverageSlider.getValue() == maxCoverageSlider.getMaximum()) {
                maxCoverageSlider.setMaximum(maxCoverageSlider.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == callSlider) {
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == coverageSliderIndel) {
            if (coverageSliderIndel.getValue() == coverageSliderIndel.getMaximum()) {
                coverageSliderIndel.setMaximum(coverageSliderIndel.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == qualitySliderIndel) {
            if (qualitySliderIndel.getValue() == qualitySliderIndel.getMaximum()) {
                qualitySliderIndel.setMaximum(qualitySliderIndel.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == gqSliderIndel) {
            if (gqSliderIndel.getValue() == gqSliderIndel.getMaximum()) {
                gqSliderIndel.setMaximum(gqSliderIndel.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == maxCoverageSliderIndel) {
            if (maxCoverageSliderIndel.getValue() == maxCoverageSliderIndel.getMaximum()) {
                maxCoverageSliderIndel.setMaximum(maxCoverageSliderIndel.getMaximum() * 2);
            }
            if (commonSlider.getValue() > 1) {
                Main.drawCanvas.calcClusters(FileRead.head, 1);
            }
        } else if (event.getSource() == callSliderIndel && commonSlider.getValue() > 1) {
            Main.drawCanvas.calcClusters(FileRead.head, 1);
        }
        Draw.updatevars = true;
        Draw.calculateVars = true;
        Main.drawCanvas.repaint();
    }

    void freezeFilters(boolean value) {
        block11: {
            block10: {
                JLabel label;
                if (!value) break block10;
                int i = 2;
                while (i < filterpanel.getComponentCount()) {
                    if (filterpanel.getComponent(i).equals(freeze)) {
                        if (filterpanelIndel.getComponent(i) instanceof JLabel && (label = (JLabel)filterpanelIndel.getComponent(i)).getText().contains("___")) {
                            // empty if block
                        }
                    } else {
                        filterpanel.getComponent(i).setEnabled(false);
                        filterpanel.getComponent(i).revalidate();
                    }
                    ++i;
                }
                i = 2;
                while (i < filterpanelIndel.getComponentCount()) {
                    if (filterpanelIndel.getComponent(i).equals(freeze)) {
                        if (filterpanelIndel.getComponent(i) instanceof JLabel && (label = (JLabel)filterpanelIndel.getComponent(i)).getText().contains("___")) {
                            // empty if block
                        }
                    } else {
                        filterpanelIndel.getComponent(i).setEnabled(false);
                        filterpanelIndel.getComponent(i).revalidate();
                    }
                    ++i;
                }
                break block11;
            }
            int i = 0;
            while (i < filterpanel.getComponentCount()) {
                filterpanel.getComponent(i).setEnabled(true);
                filterpanel.getComponent(i).revalidate();
                ++i;
            }
            if (!indelFilters.isSelected()) break block11;
            i = 0;
            while (i < filterpanelIndel.getComponentCount()) {
                filterpanelIndel.getComponent(i).setEnabled(true);
                filterpanelIndel.getComponent(i).revalidate();
                ++i;
            }
        }
    }

    static void setFonts(Font menuFont) {
        try {
            int i = 0;
            while (i < filterpanel.getComponentCount()) {
                if (filterpanel.getComponent(i).getName() != null) {
                    filterpanel.getComponent(i).setFont(Main.menuFontBold);
                } else {
                    filterpanel.getComponent(i).setFont(menuFont);
                }
                ++i;
            }
            i = 0;
            while (i < filterpanelIndel.getComponentCount()) {
                if (filterpanelIndel.getComponent(i).getName() != null) {
                    filterpanelIndel.getComponent(i).setFont(Main.menuFontBold);
                } else {
                    filterpanelIndel.getComponent(i).setFont(menuFont);
                }
                ++i;
            }
            i = 0;
            while (i < comparepanel.getComponentCount()) {
                if (comparepanel.getComponent(i).getName() != null) {
                    comparepanel.getComponent(i).setFont(Main.menuFontBold);
                } else {
                    comparepanel.getComponent(i).setFont(menuFont);
                }
                ++i;
            }
            i = 0;
            while (i < aminopanel.getComponentCount()) {
                aminopanel.getComponent(i).setFont(menuFont);
                ++i;
            }
            i = 0;
            while (i < hidepanel.getComponentCount()) {
                hidepanel.getComponent(i).setFont(menuFont);
                ++i;
            }
            i = 0;
            while (i < inheritpanel.getComponentCount()) {
                inheritpanel.getComponent(i).setFont(menuFont);
                ++i;
            }
            filterPanes.setFont(menuFont);
            filters.setFont(menuFont);
            i = 0;
            while (i < filters.getPopupMenu().getComponentCount()) {
                filters.getPopupMenu().getComponent(i).setFont(menuFont);
                ++i;
            }
            aminomenu.setFont(menuFont);
            outputmenu.setFont(menuFont);
            i = 0;
            while (i < aminomenu.getPopupMenu().getComponentCount()) {
                aminomenu.getPopupMenu().getComponent(i).setFont(menuFont);
                ++i;
            }
            i = 0;
            while (i < outputmenu.getPopupMenu().getComponentCount()) {
                outputmenu.getPopupMenu().getComponent(i).setFont(menuFont);
                ++i;
            }
            varcalc.setFont(menuFont);
            allChromsfrom.setFont(menuFont.deriveFont(2));
            onlyAutosomes.setFont(menuFont.deriveFont(2));
            tabs.setFont(menuFont);
            tabs.revalidate();
            if (table != null) {
                VariantHandler.table.buf.setFont(menuFont);
                VariantHandler.table.rowHeight = menuFont.getSize() + 5;
                VariantHandler.table.fm = VariantHandler.table.buf.getFontMetrics();
                VariantHandler.stattable.buf.setFont(menuFont);
                VariantHandler.stattable.rowHeight = menuFont.getSize() + 5;
                VariantHandler.clusterTable.buf.setFont(menuFont);
                VariantHandler.clusterTable.rowHeight = menuFont.getSize() + 5;
                i = 0;
                while (i < tables.size()) {
                    VariantHandler.tables.get((int)i).buf.setFont(menuFont);
                    VariantHandler.tables.get((int)i).rowHeight = menuFont.getSize() + 5;
                    ++i;
                }
            }
            i = 0;
            while (i < menuPanel.getComponentCount()) {
                menuPanel.getComponent(i).setFont(Main.menuFont);
                if (menuPanel.getComponent(i) instanceof JTextField) {
                    menuPanel.getComponent(i).setPreferredSize(new Dimension(Main.defaultFontSize * 6, (int)((double)Main.defaultFontSize * 1.5)));
                }
                ++i;
            }
            i = 0;
            while (i < menuPanelIndel.getComponentCount()) {
                menuPanelIndel.getComponent(i).setFont(Main.menuFont);
                if (menuPanelIndel.getComponent(i) instanceof JTextField) {
                    menuPanelIndel.getComponent(i).setPreferredSize(new Dimension(Main.defaultFontSize * 6, (int)((double)Main.defaultFontSize * 1.5)));
                }
                ++i;
            }
            menu.setFont(menuFont);
            menuIndel.setFont(menuFont);
            i = 0;
            while (i < menu.getComponentCount()) {
                menu.getComponent(i).setFont(Main.menuFont);
                ++i;
            }
            i = 0;
            while (i < menuIndel.getComponentCount()) {
                menuIndel.getComponent(i).setFont(Main.menuFont);
                ++i;
            }
            menu.pack();
            menuIndel.pack();
            frame.pack();
            aminobar.setMinimumSize(new Dimension((int)aminobar.getSize().getWidth(), (int)aminobar.getSize().getHeight()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void freezeIndels(boolean value) {
        if (value) {
            int i = 2;
            while (i < filterpanelIndel.getComponentCount()) {
                if (filterpanelIndel.getComponent(i).equals(freeze)) {
                    JLabel label;
                    if (filterpanelIndel.getComponent(i) instanceof JLabel && (label = (JLabel)filterpanelIndel.getComponent(i)).getText().contains("___")) {
                        // empty if block
                    }
                } else {
                    filterpanelIndel.getComponent(i).setEnabled(false);
                    filterpanelIndel.getComponent(i).revalidate();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < filterpanelIndel.getComponentCount()) {
                filterpanelIndel.getComponent(i).setEnabled(true);
                filterpanelIndel.getComponent(i).revalidate();
                ++i;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.getSource() == clusterBox) {
            if (commonSlider.getValue() > 1) {
                clusterSize = Integer.parseInt(clusterBox.getText());
                Main.drawCanvas.calcClusters(FileRead.head, 1);
                if (tabs.indexOfComponent(clusterScroll) == -1) {
                    tabs.add((Component)clusterScroll, tabs.indexOfComponent(statsScroll));
                }
            }
            if (clusterSize == 0 && tabs.indexOfComponent(clusterScroll) != -1) {
                tabs.remove(clusterScroll);
            }
        }
        e.getKeyCode();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        table.resizeTable();
        int i = 0;
        while (i < tables.size()) {
            tables.get(i).resizeTable();
            ++i;
        }
        stattable.resizeTable();
        clusterTable.resizeTable();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static class NodeSorter
    implements Comparator<VarNode> {
        @Override
        public int compare(VarNode o1, VarNode o2) {
            if (o1.getPosition() <= o2.getPosition()) {
                return -1;
            }
            return 1;
        }
    }

    public class OutputRunner
    extends SwingWorker<String, Object> {
        BufferedWriter output;
        BlockCompressedOutputStream outputgz;
        File outFile;

        public OutputRunner(BufferedWriter output, BlockCompressedOutputStream outputgz, File outFile) {
            this.output = output;
            this.outputgz = outputgz;
            this.outFile = outFile;
        }

        @Override
        protected String doInBackground() {
            Main.drawCanvas.loading("Writing output...");
            VariantHandler.this.writeOutput(this.output, this.outputgz, this.outFile);
            Main.drawCanvas.ready("Writing output...");
            return "";
        }
    }
}

