/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.Draw;
import base.BasePlayer.Gene;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.ReferenceSeq;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;

public class SplitClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    int chromEnd = 0;
    int offset;
    int chromOffset;
    public double pixel = 0.0;
    public double start = 1.0;
    public double end = 0.0;
    public double viewLength = 0.0;
    String chrom;
    private transient ArrayList<Gene> genes = new ArrayList();
    boolean updateReads = false;
    boolean removed = false;
    boolean clearedReads = true;
    boolean clearedCoverages = true;
    private transient ReferenceSeq drawReference;
    private transient ReferenceSeq readReference;
    private transient Double divider = 4.0;
    public boolean splitRead = false;
    private transient SplitDraw splitDraw;
    private transient ArrayList<String[]> chromBands = new ArrayList();
    int transStart = 0;

    public SplitClass() {
        this.splitDraw = new SplitDraw();
    }

    void resetSplits() {
        this.splitDraw = new SplitDraw();
    }

    public void clearGenes() {
        this.genes.clear();
    }

    public void setChromBands(ArrayList<String[]> bands) {
        this.chromBands = bands;
    }

    public ArrayList<String[]> getChromBands() {
        return this.chromBands;
    }

    ReferenceSeq getReference() {
        return this.drawReference;
    }

    void setReference(ReferenceSeq ref) {
        this.drawReference = ref;
    }

    ReferenceSeq getReadReference() {
        return this.readReference;
    }

    void setReadReference(ReferenceSeq ref) {
        this.readReference = ref;
    }

    void nullRef() {
        this.readReference = null;
        this.drawReference = null;
    }

    ArrayList<Gene> getGenes() {
        return this.genes;
    }

    void setGenes(ArrayList<Gene> genes) {
        this.genes = genes;
    }

    void setDivider(Double divider) {
        this.divider = divider;
    }

    SplitDraw getSplitDraw() {
        return this.splitDraw;
    }

    Double getDivider() {
        return this.divider;
    }

    Graphics2D getExonImageBuffer() {
        return this.splitDraw.exonImageBuffer;
    }

    Graphics2D getReadBuffer() {
        return this.splitDraw.readBuffer;
    }

    Graphics2D getSelectbuf() {
        return this.splitDraw.selectbuf;
    }

    BufferedImage getExonImage() {
        if (this.splitDraw == null) {
            return null;
        }
        return this.splitDraw.exonImage;
    }

    BufferedImage getReadImage() {
        if (this.splitDraw == null) {
            return null;
        }
        return this.splitDraw.readImage;
    }

    BufferedImage getSelectbuffer() {
        return this.splitDraw.selectbuffer;
    }

    Composite getBackupe() {
        return this.splitDraw.backupe;
    }

    Composite getBackupr() {
        return this.splitDraw.backupr;
    }

    Composite getBackups() {
        return this.splitDraw.backups;
    }

    BufferedImage getCytoImage() {
        return this.splitDraw.cytoImage;
    }

    void setCytoImage(BufferedImage image) {
        this.splitDraw.cytoImage = image;
    }

    void removeSplitDraw() {
        this.splitDraw = null;
    }

    public class SplitDraw {
        Graphics2D exonImageBuffer;
        BufferedImage exonImage;
        Graphics2D readBuffer;
        BufferedImage readImage;
        Graphics2D selectbuf;
        BufferedImage selectbuffer;
        Composite backupe;
        Composite backupr;
        Composite backups;
        BufferedImage cytoImage;

        public SplitDraw() {
            this.resizeImages((int)Main.screenSize.getWidth());
            this.selectbuf.setStroke(Draw.strongStroke);
        }

        public void resizeImages(int width) {
            this.exonImage = MethodLibrary.toCompatibleImage(new BufferedImage(width, (int)Main.screenSize.getHeight(), 2));
            this.exonImageBuffer = (Graphics2D)this.exonImage.getGraphics();
            this.readImage = MethodLibrary.toCompatibleImage(new BufferedImage(width, (int)Main.screenSize.getHeight(), 2));
            this.readBuffer = (Graphics2D)this.readImage.getGraphics();
            this.backupr = this.readBuffer.getComposite();
            this.backupe = this.exonImageBuffer.getComposite();
            this.selectbuffer = MethodLibrary.toCompatibleImage(new BufferedImage(width, (int)Main.screenSize.getHeight(), 2));
            this.selectbuf = (Graphics2D)this.selectbuffer.getGraphics();
            this.backups = this.selectbuf.getComposite();
        }
    }
}

