/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ControlFile;
import base.BasePlayer.Sample;
import base.BasePlayer.Settings;
import base.BasePlayer.VariantHandler;
import java.util.HashMap;

public class SampleNode {
    private final Integer coverage;
    private final Integer calls;
    private final Float quality;
    private final Float gq;
    float heightValue = 0.0f;
    private final Sample sample;
    private final ControlFile controlSample;
    private final boolean genotype;
    Integer alleles;
    Integer allelenumber;
    boolean common = false;
    boolean inheritance = false;

    public SampleNode(int alleles, int allelenumber, ControlFile sample) {
        this.alleles = alleles;
        this.allelenumber = allelenumber;
        this.sample = null;
        this.controlSample = sample;
        this.quality = null;
        this.gq = null;
        this.coverage = null;
        this.calls = null;
        this.genotype = false;
    }

    public SampleNode(int coverage, int calls, boolean genotype, Float quality, Float gq, HashMap<String, Float> advquals, Sample sample) {
        this.sample = sample;
        this.controlSample = null;
        this.coverage = coverage;
        this.calls = calls;
        this.gq = gq;
        this.quality = quality;
        this.genotype = genotype;
        switch (Settings.selectedVarDraw) {
            case 0: {
                if (sample.getMaxCoverage() < (float)coverage) {
                    sample.setMaxCoverage(coverage);
                }
                this.heightValue = coverage;
                break;
            }
            case 1: {
                if (sample.getMaxCoverage() < (float)calls / (float)coverage) {
                    sample.setMaxCoverage((float)calls / (float)coverage);
                }
                this.heightValue = (float)calls / (float)coverage;
                break;
            }
            case 2: {
                if (quality == null) break;
                if (sample.getMaxCoverage() < quality.floatValue()) {
                    sample.setMaxCoverage(quality.floatValue());
                    if (VariantHandler.maxSlideValue < quality.floatValue()) {
                        VariantHandler.maxSlideValue = quality.floatValue();
                    }
                }
                this.heightValue = quality.floatValue();
                break;
            }
            case 3: {
                if (gq == null) break;
                if (sample.getMaxCoverage() < gq.floatValue()) {
                    sample.setMaxCoverage(gq.floatValue());
                    if (VariantHandler.maxSlideValue < gq.floatValue()) {
                        VariantHandler.maxSlideValue = gq.floatValue();
                    }
                }
                this.heightValue = gq.floatValue();
                break;
            }
            case 4: {
                if (sample.getMaxCoverage() < (float)calls) {
                    sample.setMaxCoverage(calls);
                }
                this.heightValue = calls;
            }
        }
    }

    public void addAlleles(int add) {
        this.alleles = this.alleles + add;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public int getCalls() {
        return this.calls;
    }

    public Float getQuality() {
        return this.quality;
    }

    public Float getGQ() {
        return this.gq;
    }

    public String getGQString() {
        if (this.gq == null) {
            return ".";
        }
        return "" + this.gq;
    }

    public Sample getSample() {
        return this.sample;
    }

    public ControlFile getControlSample() {
        return this.controlSample;
    }

    public Double getAlleleFraction() {
        return (double)this.calls.intValue() / (double)this.coverage.intValue();
    }

    public boolean isHomozygous() {
        return this.genotype;
    }
}

