/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.Main;
import java.io.RandomAccessFile;

public class ReferenceSeq {
    byte[] seq;
    int startpos = 0;
    int endpos = 0;
    String chrom;
    RandomAccessFile ref;
    static boolean wait = false;

    public ReferenceSeq(String chrom, int start, int end, RandomAccessFile file) {
        wait = true;
        this.startpos = start;
        this.endpos = end;
        this.seq = this.getSeq(chrom, start, end, file);
        this.ref = file;
        this.chrom = chrom;
        wait = false;
    }

    public ReferenceSeq() {
    }

    public byte[] getSeq() {
        return this.seq;
    }

    public int getStartPos() {
        return this.startpos;
    }

    public int getEndPos() {
        return this.endpos;
    }

    void appendToStart(int pos) {
        try {
            while (wait) {
                Thread.sleep(100L);
            }
            Thread.sleep(0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (pos >= this.startpos) {
            return;
        }
        wait = true;
        byte[] first = this.getSeq(this.chrom, pos, this.startpos, this.ref);
        byte[] combined = new byte[first.length + this.seq.length];
        System.arraycopy(first, 0, combined, 0, first.length);
        System.arraycopy(this.seq, 0, combined, first.length, this.seq.length);
        this.seq = combined;
        this.startpos = pos;
        wait = false;
    }

    public void append(int pos) {
        try {
            while (wait) {
                Thread.sleep(100L);
            }
            Thread.sleep(0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (pos <= this.endpos) {
            return;
        }
        wait = true;
        byte[] second = this.getSeq(this.chrom, this.endpos, pos, this.ref);
        byte[] combined = new byte[second.length + this.seq.length];
        System.arraycopy(this.seq, 0, combined, 0, this.seq.length);
        System.arraycopy(second, 0, combined, this.seq.length, second.length);
        this.seq = combined;
        this.endpos = pos;
        wait = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getSeq(String chrom, int start, int end, RandomAccessFile seqchrom) {
        try {
            if (chrom == null) {
                return null;
            }
            if (!Main.chromIndex.containsKey(String.valueOf(Main.refchrom) + chrom)) {
                if (!Main.chromIndex.containsKey(chrom.replace("chr", ""))) {
                    return null;
                }
                chrom = chrom.replace("chr", "");
            }
            if (start < 0) {
                start = 0;
                this.startpos = 0;
            }
            byte[] seqresult = null;
            try {
                seqresult = new byte[end - start + 1 + (end - start) / (Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue() - 1)];
            }
            catch (Exception e) {
                System.out.println(String.valueOf(end - start) + " " + Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue());
                e.printStackTrace();
                seqresult = new byte[end - start + 1 + (end - start) / 40];
            }
            byte[] temp = new byte[end - start];
            seqchrom.seek(Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[0] + (long)start + (long)(start / Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue()));
            if (seqchrom.getFilePointer() + (long)seqresult.length > seqchrom.length()) {
                seqresult = new byte[(int)(seqchrom.length() - seqchrom.getFilePointer())];
            }
            seqchrom.readFully(seqresult);
            if (seqresult.length == 0) {
                return new byte[1];
            }
            if (seqresult[0] == 10) {
                seqchrom.seek(Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[0] + (long)(start + 1) + (long)(start / Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue()));
                if (seqchrom.getFilePointer() + (long)seqresult.length > seqchrom.length() - 1L) {
                    seqresult = new byte[(int)(seqchrom.length() - seqchrom.getFilePointer())];
                }
                seqchrom.readFully(seqresult);
            }
            int pointer = 0;
            int i = 0;
            while (i < seqresult.length && pointer <= temp.length - 1) {
                if (seqresult[i] != 10) {
                    temp[pointer] = seqresult[i];
                    ++pointer;
                }
                ++i;
            }
            seqresult = null;
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

