/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ControlData;
import base.BasePlayer.ControlFile;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Launcher;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import htsjdk.samtools.FileTruncatedException;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class Control {
    static String path = Launcher.ctrldir;
    static String offsetString = "";
    static boolean hold = false;
    static int row = 1;
    static int runIndex = -1;
    static boolean isCancel;
    private static TabixReader tabixreader;
    static ControlData controlData;
    private static int index;
    private static int refindex;
    private static int allelenumber;
    private static String[] infosplit;
    private static String[] coverages;

    static {
        controlData = new ControlData();
    }

    static void applyControl() {
        try {
            String teststring = null;
            int c = 0;
            while (c < Control.controlData.fileArray.size()) {
                if (!Main.drawCanvas.loading) break;
                if (Control.controlData.fileArray.get((int)c).controlOn && !Control.controlData.fileArray.get((int)c).controlled) {
                    VarNode current;
                    TabixReader.Iterator iterator;
                    block22: {
                        Main.drawCanvas.loadbarAll = (int)((double)c / (double)Control.controlData.fileArray.size() * 100.0);
                        try {
                            tabixreader = new TabixReader(Control.controlData.fileArray.get(c).getTabixFile());
                        }
                        catch (Exception tab) {
                            Main.showError("Could not find " + Control.controlData.fileArray.get(c).getTabixFile(), "Note");
                        }
                        Main.drawCanvas.loadingtext = "Applying control " + Control.controlData.fileArray.get(c).getName();
                        iterator = null;
                        current = FileRead.head.getNext();
                        if (current == null) {
                            return;
                        }
                        try {
                            iterator = tabixreader.query(String.valueOf(Main.chromosomeDropdown.getSelectedItem().toString()) + ":" + (current.getPosition() - 1));
                            teststring = iterator.next();
                            if (teststring != null || (teststring = (iterator = tabixreader.query("chr" + Main.chromosomeDropdown.getSelectedItem().toString() + ":" + (current.getPosition() - 1))).next()) != null) break block22;
                            try {
                                if (Main.chromosomeDropdown.getSelectedItem().toString().equals("X")) {
                                    iterator = tabixreader.query("23:" + (current.getPosition() - 1));
                                } else if (Main.chromosomeDropdown.getSelectedItem().toString().equals("Y")) {
                                    iterator = tabixreader.query("24:" + (current.getPosition() - 1));
                                } else if (Main.chromosomeDropdown.getSelectedItem().toString().contains("M")) {
                                    iterator = tabixreader.query("25:" + (current.getPosition() - 1));
                                }
                                teststring = iterator.next();
                                if (teststring == null) {
                                    ErrorLog.addError("Chromosome " + Main.chromosomeDropdown.getSelectedItem().toString() + " not found in " + Control.controlData.fileArray.get(c).getName());
                                }
                            }
                            catch (Exception exc) {
                                ErrorLog.addError("Chromosome " + Main.chromosomeDropdown.getSelectedItem().toString() + " not found in " + Control.controlData.fileArray.get(c).getName());
                            }
                        }
                        catch (Exception e) {
                            ErrorLog.addError(e.getStackTrace());
                        }
                    }
                    if (iterator != null && teststring != null) {
                        if (Control.controlData.fileArray.get(c).getTabixFile().endsWith(".vcf.gz")) {
                            if (!Control.controlData.fileArray.get((int)c).remOverlaps.isSelected()) {
                                Control.useVCFstrict(iterator, current, c, teststring);
                            } else {
                                Control.useVCFoverlap(iterator, current, c, teststring);
                            }
                        } else {
                            Control.useCTRL(iterator, current, c);
                        }
                        current = null;
                        Control.controlData.fileArray.get((int)c).controlled = true;
                    }
                }
                ++c;
            }
            Draw.calculateVars = true;
            Draw.updatevars = true;
            Main.drawCanvas.repaint();
            VariantHandler.table.repaint();
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    static void useCTRL(TabixReader.Iterator iterator, VarNode current, int c) {
        try {
            String line;
            int count = 0;
            ArrayList<SampleNode> samplelist = null;
            while ((line = iterator.next()) != null) {
                String controlvar;
                int position;
                String[] split = line.split("\t");
                if (split[2].length() > 1 && !split[2].contains(",")) {
                    position = Integer.parseInt(split[1]) - 1;
                    controlvar = split[2].startsWith("-") ? (split[2].substring(1).length() == 2 ? "del" + split[2].substring(2) : "del" + (split[2].length() - 2)) : (split[2].substring(1).length() == 1 ? "ins" + split[2].substring(1) : "ins" + (split[2].length() - 1));
                } else {
                    position = Integer.parseInt(split[1]) - 1;
                    controlvar = split[2];
                }
                while (current != null && current.getPosition() < position) {
                    current = current.getNext();
                }
                if (current == null) break;
                if (position < current.getPosition()) continue;
                if (current.getPosition() == position) {
                    current.controlled = true;
                    int i = 0;
                    while (i < current.vars.size()) {
                        if (split[2].contains(",")) {
                            samplelist = current.vars.get(i).getValue();
                            samplelist.add(new SampleNode(Integer.parseInt(split[3]) * (Integer.parseInt(split[4]) + 1), Control.controlData.fileArray.get((int)c).varcount, Control.controlData.fileArray.get(c)));
                        } else if (current.vars.get(i).getKey().equals(controlvar)) {
                            samplelist = current.vars.get(i).getValue();
                            if (samplelist.get(samplelist.size() - 1).getControlSample() != null && samplelist.get(samplelist.size() - 1).getControlSample().equals(Control.controlData.fileArray.get(c))) {
                                samplelist.get((int)(samplelist.size() - 1)).alleles = samplelist.get((int)(samplelist.size() - 1)).alleles + Integer.parseInt(split[3]) * (Integer.parseInt(split[4]) + 1);
                            } else {
                                samplelist.add(new SampleNode(Integer.parseInt(split[3]) * (Integer.parseInt(split[4]) + 1), Control.controlData.fileArray.get((int)c).varcount, Control.controlData.fileArray.get(c)));
                            }
                        }
                        ++i;
                    }
                }
                if (count % 1000 == 0) {
                    Main.drawCanvas.loadBarSample = (int)((double)current.getPosition() / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
                    Draw.updatevars = true;
                    Main.drawCanvas.repaint();
                }
                ++count;
            }
            if (samplelist != null) {
                samplelist = null;
            }
            current = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void useVCFoverlap(TabixReader.Iterator iterator, VarNode current, int c, String firstline) {
        try {
            String line = firstline;
            String controlvar = "";
            String[] templist = null;
            int count = 0;
            int ref = 0;
            int alt = 0;
            int endindex = -1;
            int acendindex = -1;
            ArrayList<SampleNode> samplelist = null;
            int alleles = 0;
            int baselength = 0;
            while (line != null) {
                if (!Main.drawCanvas.loading) break;
                String[] split = line.split("\t");
                baselength = MethodLibrary.getControlBaseLength(split[3], split[4], 0);
                int position = Integer.parseInt(split[1]) - 1;
                while (current != null && current.getPosition() < position) {
                    current = current.getNext();
                }
                if (current == null) break;
                if (position + baselength < current.getPosition()) {
                    line = iterator.next();
                    continue;
                }
                if (current.getPosition() >= position && current.getPosition() <= position + baselength) {
                    int i;
                    if (!split[4].contains(",")) {
                        controlvar = FileRead.getVariant(split[3], split[4]);
                    } else {
                        templist = split[4].split(",");
                        i = 0;
                        while (i < templist.length) {
                            templist[i] = FileRead.getVariant(split[3], templist[i]);
                            ++i;
                        }
                    }
                    current.controlled = true;
                    index = split[7].indexOf(";AC=") + 4;
                    if (index < 0) {
                        index = split[7].indexOf("AC=") + 3;
                    }
                    if ((acendindex = split[7].indexOf(";", index)) == -1) {
                        acendindex = split[7].length();
                    }
                    if ((endindex = split[7].indexOf(";", refindex = split[7].indexOf(";AN=") + 4)) == -1) {
                        endindex = split[7].length();
                    }
                    i = 0;
                    while (i < current.vars.size()) {
                        ++count;
                        if (split[4].contains(",")) {
                            int t = 0;
                            while (t < templist.length) {
                                if (current.vars.get(i).getKey().equals(templist[t]) || baselength > 1) {
                                    if (Control.controlData.fileArray.get((int)c).varcount > 2) {
                                        alleles = Integer.parseInt(split[7].substring(index, acendindex).split(",")[t]);
                                        try {
                                            allelenumber = Integer.parseInt(split[7].substring(refindex, endindex));
                                        }
                                        catch (Exception e) {
                                            System.out.println(line);
                                            Main.showError("Controlling error in line:\n" + line, "Error");
                                        }
                                    } else {
                                        infosplit = split[split.length - 1].split(":");
                                        coverages = infosplit[split[8].indexOf("AD") / 3].split(",");
                                        ref = Integer.parseInt(coverages[0]);
                                        alleles = alt = Integer.parseInt(coverages[1]);
                                        allelenumber = ref + alt;
                                    }
                                    if (alleles > 0) {
                                        samplelist = current.vars.get(i).getValue();
                                        samplelist.add(new SampleNode(alleles, allelenumber, Control.controlData.fileArray.get(c)));
                                    }
                                }
                                ++t;
                            }
                        } else if (current.vars.get(i).getKey().equals(controlvar) || baselength > 1) {
                            if (Control.controlData.fileArray.get((int)c).varcount > 2) {
                                allelenumber = Integer.parseInt(split[7].substring(refindex, endindex));
                                alleles = Integer.parseInt(split[7].substring(index, acendindex));
                            } else {
                                infosplit = split[split.length - 1].split(":");
                                alleles = infosplit[0].length() > 2 ? (infosplit[0].charAt(0) != infosplit[0].charAt(2) ? 1 : 2) : 0;
                                allelenumber = 2;
                            }
                            if (alleles > 0) {
                                samplelist = current.vars.get(i).getValue();
                                samplelist.add(new SampleNode(alleles, allelenumber, Control.controlData.fileArray.get(c)));
                            }
                        }
                        ++i;
                    }
                }
                if (count % 10 == 0) {
                    Main.drawCanvas.loadBarSample = (int)((double)current.getPosition() / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
                    Draw.updatevars = true;
                    Main.drawCanvas.repaint();
                }
                try {
                    line = iterator.next();
                }
                catch (FileTruncatedException fileTruncatedException) {
                    // empty catch block
                }
            }
            if (samplelist != null) {
                samplelist = null;
            }
            current = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void useVCFstrict(TabixReader.Iterator iterator, VarNode current, int c, String firstline) {
        try {
            String line = firstline;
            String controlvar = "";
            String[] templist = null;
            int count = 0;
            int endindex = -1;
            int acendindex = -1;
            ArrayList<SampleNode> samplelist = null;
            int alleles = 0;
            while (line != null) {
                if (!Main.drawCanvas.loading) break;
                String[] split = line.split("\t");
                int position = Integer.parseInt(split[1]) - 1;
                while (current != null && current.getPosition() < position) {
                    current = current.getNext();
                }
                if (current == null) break;
                if (position < current.getPosition()) {
                    line = iterator.next();
                    continue;
                }
                if (current.getPosition() == position) {
                    int i;
                    if (!split[4].contains(",")) {
                        controlvar = FileRead.getVariant(split[3], split[4]);
                    } else {
                        templist = split[4].split(",");
                        i = 0;
                        while (i < templist.length) {
                            templist[i] = FileRead.getVariant(split[3], templist[i]);
                            ++i;
                        }
                    }
                    current.controlled = true;
                    index = split[7].indexOf(";AC=") + 4;
                    if (index < 0) {
                        index = split[7].indexOf("AC=") + 3;
                    }
                    if ((acendindex = split[7].indexOf(";", index)) == -1) {
                        acendindex = split[7].length();
                    }
                    if ((endindex = split[7].indexOf(";", refindex = split[7].indexOf(";AN=") + 4)) == -1) {
                        endindex = split[7].length();
                    }
                    i = 0;
                    while (i < current.vars.size()) {
                        ++count;
                        if (split[4].contains(",")) {
                            int t = 0;
                            while (t < templist.length) {
                                if (current.vars.get(i).getKey().equals(templist[t])) {
                                    if (Control.controlData.fileArray.get((int)c).varcount > 2) {
                                        alleles = Integer.parseInt(split[7].substring(index, acendindex).split(",")[t]);
                                        try {
                                            allelenumber = Integer.parseInt(split[7].substring(refindex, endindex));
                                        }
                                        catch (Exception e) {
                                            System.out.println(line);
                                            Main.showError("Controlling error in line:\n" + line, "Error");
                                        }
                                    } else {
                                        if (infosplit[0].length() > 2) {
                                            alleles = infosplit[0].charAt(0) != infosplit[0].charAt(2) ? 1 : 2;
                                        } else {
                                            System.out.println(line);
                                            alleles = 0;
                                        }
                                        allelenumber = 2;
                                    }
                                    if (alleles > 0) {
                                        samplelist = current.vars.get(i).getValue();
                                        samplelist.add(new SampleNode(alleles, allelenumber, Control.controlData.fileArray.get(c)));
                                    }
                                }
                                ++t;
                            }
                        } else if (current.vars.get(i).getKey().equals(controlvar)) {
                            if (Control.controlData.fileArray.get((int)c).varcount > 2) {
                                allelenumber = Integer.parseInt(split[7].substring(refindex, endindex));
                                alleles = Integer.parseInt(split[7].substring(index, acendindex));
                            } else {
                                infosplit = split[split.length - 1].split(":");
                                alleles = infosplit[0].length() > 2 ? (infosplit[0].charAt(0) != infosplit[0].charAt(2) ? 1 : 2) : 0;
                                allelenumber = 2;
                            }
                            if (alleles > 0) {
                                samplelist = current.vars.get(i).getValue();
                                samplelist.add(new SampleNode(alleles, allelenumber, Control.controlData.fileArray.get(c)));
                            }
                        }
                        ++i;
                    }
                }
                if (count % 10 == 0) {
                    Main.drawCanvas.loadBarSample = (int)((double)current.getPosition() / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
                    Draw.updatevars = true;
                    Main.drawCanvas.repaint();
                }
                try {
                    line = iterator.next();
                }
                catch (FileTruncatedException fileTruncatedException) {
                    // empty catch block
                }
            }
            if (samplelist != null) {
                samplelist = null;
            }
            current = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void addFiles(File[] filestemp) {
        try {
            int samplecount = 0;
            int i = 0;
            while (i < filestemp.length) {
                if (filestemp[i].isDirectory()) {
                    int j = 0;
                    while (j < filestemp[i].listFiles().length) {
                        if (filestemp[i].listFiles()[j].length() != 0L && (filestemp[i].listFiles()[j].getAbsolutePath().matches(".*.vcf") || filestemp[i].listFiles()[j].getAbsolutePath().matches(".*.ctrl"))) {
                            ControlFile addSample = new ControlFile(filestemp[i].listFiles()[j].getName(), (short)j, filestemp[i].listFiles()[j].getCanonicalPath());
                            Control.controlData.fileArray.add(addSample);
                            if (filestemp[i].listFiles()[j].getName().contains(".ctrl")) {
                                Object[] addi = new Object[]{row, filestemp[i].listFiles()[j].getName(), new Boolean(true)};
                                Main.controlDraw.trackDivider.add(0.0);
                                try {
                                    samplecount = 0;
                                    BufferedReader reader = new BufferedReader(new FileReader(filestemp[i].listFiles()[j]));
                                    String line = reader.readLine();
                                    while (line.startsWith("#")) {
                                        if (line.startsWith("##Chr")) break;
                                        if (line.contains("#SampleCount")) {
                                            samplecount = Integer.parseInt(line.split("=")[1]);
                                            Control.controlData.total += samplecount;
                                        } else {
                                            ++samplecount;
                                            ++Control.controlData.total;
                                        }
                                        ++row;
                                        line = reader.readLine();
                                    }
                                    reader.close();
                                    addi[1] = samplecount + "_" + addi[1];
                                }
                                catch (Exception e) {
                                    ErrorLog.addError(e.getStackTrace());
                                    e.printStackTrace();
                                }
                            } else {
                                ++row;
                                ++samplecount;
                                ++Control.controlData.total;
                            }
                        }
                        ++j;
                    }
                } else if (filestemp[i].getName().endsWith(".vcf.gz")) {
                    ControlFile addSample = new ControlFile(filestemp[i].getName(), (short)Control.controlData.fileArray.size(), filestemp[i].getCanonicalPath());
                    Control.controlData.fileArray.add(addSample);
                    MethodLibrary.addHeaderColumns(addSample);
                    Main.controlDraw.trackDivider.add(0.0);
                    try {
                        samplecount = 0;
                        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(filestemp[i]));
                        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
                        String line = reader.readLine();
                        String population = "";
                        int idindex = 0;
                        int dotindex = 0;
                        while (line.startsWith("#")) {
                            if (line.contains("##INFO")) {
                                if (line.contains("ID=")) {
                                    idindex = line.indexOf("ID=");
                                    dotindex = line.indexOf(",");
                                    if (idindex > 0 && dotindex > 0 && line.substring(idindex, dotindex).contains("AC") && (population = line.substring(idindex + 3, dotindex).replace("AC", "").replace("_", "")).length() == 0) {
                                        population = "ALL";
                                    }
                                }
                            } else if (line.startsWith("#CHROM")) {
                                samplecount = line.split("\t").length - 9 < 0 ? 0 : line.split("\t").length - 9;
                                Control.controlData.total += samplecount * 2;
                            }
                            line = reader.readLine();
                        }
                        addSample.varcount = samplecount * 2;
                        if (samplecount == 0) {
                            int count = 0;
                            int maxnumber = 0;
                            int endindex = -1;
                            String[] split = line.split("\t");
                            if (line.contains("AN=")) {
                                while (count < 1000) {
                                    refindex = split[7].indexOf(";AN=") + 4;
                                    if (refindex == -1) {
                                        refindex = split[7].indexOf("AN=") + 3;
                                    }
                                    if ((endindex = split[7].indexOf(";", refindex)) == -1) {
                                        endindex = split[7].length();
                                    }
                                    if ((allelenumber = Integer.parseInt(split[7].substring(refindex, endindex))) > maxnumber) {
                                        maxnumber = allelenumber;
                                    }
                                    ++count;
                                    line = reader.readLine();
                                    if (line == null) break;
                                    split = line.split("\t");
                                }
                            }
                            addSample.varcount = maxnumber;
                            samplecount = maxnumber / 2;
                        } else if (samplecount == 1) {
                            addSample.varcount = 2;
                            samplecount = 1;
                        }
                        reader.close();
                        gzip.close();
                        Control.controlData.sampleCount += samplecount;
                    }
                    catch (Exception e) {
                        ErrorLog.addError(e.getStackTrace());
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (Control.controlData.fileArray.size() > 0 && samplecount > 0) {
                if (Main.trackPane.isVisible() && Control.controlData.fileArray.size() == 0) {
                    Main.trackPane.setDividerLocation(Main.varpane.getDividerLocation());
                }
                i = 0;
                while (i < Main.controlDraw.trackDivider.size()) {
                    Main.controlDraw.trackDivider.set(i, (double)(i + 1) * ((double)Main.varpane.getDividerLocation() / (double)Main.controlDraw.trackDivider.size()));
                    ++i;
                }
                if (!Main.trackPane.isVisible()) {
                    Main.trackPane.setVisible(true);
                    Main.varpane.setDividerSize(2);
                    Main.varpane.setDividerLocation(Control.controlData.fileArray.size() * 80);
                } else {
                    Main.varpane.setDividerLocation(Main.varpane.getDividerLocation() + 80);
                    if (Main.bedScroll.isVisible()) {
                        Main.trackPane.setDividerSize(2);
                    }
                }
                Main.controlScroll.setVisible(true);
                Main.controlDraw.setVisible(true);
                hold = false;
            }
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    static void clearControls() {
        Map.Entry<String, ArrayList<SampleNode>> entry;
        VarNode current = FileRead.head.getNext();
        while (current != null) {
            if (current.controlled) {
                int v = 0;
                while (v < current.vars.size()) {
                    entry = current.vars.get(v);
                    int i = entry.getValue().size() - 1;
                    while (i > -1) {
                        if (entry.getValue().get((int)i).alleles == null) break;
                        entry.getValue().remove(i);
                        --i;
                    }
                    ++v;
                }
                current.controlled = false;
            }
            current = current.getNext();
        }
        Control.controlData.fileArray.clear();
        Control.controlData.total = 0;
        Control.controlData.sampleCount = 0;
        entry = null;
        current = null;
    }

    static void dismissControls(VarNode head) {
        Map.Entry<String, ArrayList<SampleNode>> entry;
        VarNode current = head;
        while (current != null) {
            if (current.controlled) {
                int v = 0;
                while (v < current.vars.size()) {
                    entry = current.vars.get(v);
                    int i = entry.getValue().size() - 1;
                    while (i > -1) {
                        if (entry.getValue().get((int)i).alleles == null) break;
                        entry.getValue().remove(i);
                        --i;
                    }
                    ++v;
                }
                current.controlled = false;
            }
            current = current.getNext();
        }
        int i = 0;
        while (i < Control.controlData.fileArray.size()) {
            Control.controlData.fileArray.get((int)i).controlled = false;
            ++i;
        }
        entry = null;
        current = null;
        head = null;
    }

    static void dismissControl(VarNode head, ControlFile sample) {
        Map.Entry<String, ArrayList<SampleNode>> entry;
        VarNode current = head;
        sample.controlOn = false;
        Main.controlDraw.repaint();
        sample.controlled = false;
        while (current != null) {
            if (current.controlled) {
                int v = 0;
                while (v < current.vars.size()) {
                    entry = current.vars.get(v);
                    int i = entry.getValue().size() - 1;
                    while (i > -1) {
                        if (entry.getValue().get((int)i).alleles == null) break;
                        if (entry.getValue().get(i).getControlSample().equals(sample)) {
                            entry.getValue().remove(i);
                        }
                        --i;
                    }
                    ++v;
                }
            }
            current = current.getNext();
        }
        int i = 0;
        while (i < Control.controlData.fileArray.size()) {
            Control.controlData.fileArray.get((int)i).controlled = false;
            ++i;
        }
        Control.applyControl();
        entry = null;
        current = null;
        head = null;
    }

    static void control(VarNode head) {
        try {
            runner runner2 = new runner();
            runner2.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLog.addError(ex.getStackTrace());
        }
    }

    static class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.getName().matches(".*.ctrl.gz")) {
                return true;
            }
            return file.getName().matches(".*.vcf.gz");
        }

        @Override
        public String getDescription() {
            return "*.ctrl.gz, *.vcf.gz";
        }
    }

    public static class runner
    extends SwingWorker<String, Object> {
        @Override
        protected String doInBackground() {
            Main.drawCanvas.loading("Controlling");
            Control.applyControl();
            Main.drawCanvas.ready("Controlling");
            return "";
        }
    }
}

