/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.AminoEntry;
import base.BasePlayer.BedNode;
import base.BasePlayer.BedTrack;
import base.BasePlayer.Control;
import base.BasePlayer.ControlFile;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.io.FilenameUtils;

public class BedTable
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    BufferedImage bufImage;
    ListSorter sorter = new ListSorter();
    int rowHeight = 15;
    int geneheaderlength = 0;
    Graphics2D buf;
    StringBuffer mutcountbuffer = new StringBuffer("");
    int width;
    int height;
    ArrayList<AminoEntry> aminoarray = new ArrayList();
    ArrayList<BedNode> bedarray = new ArrayList();
    int mouseY = 0;
    int mouseX = 0;
    int pressX = 0;
    int pressY = 0;
    final JScrollPane tablescroll;
    public BedNode hoverNode;
    public BedNode selectedNode;
    String[] posSplit;
    String[] hoverString;
    int samplecount = 0;
    int variants = 0;
    Enumeration<String> e;
    String base;
    final BedTrack bedtrack;
    ArrayList<Object[]> geneheader = new ArrayList();
    String[] header = new String[]{"Event", "Mut. count", "Event position", "Event length (bp)", "Mutation freq. (%)", "Flanking genes"};
    int[][] headerlengths = new int[this.header.length][2];
    private int genemutcount;
    VarNode hoverVar;
    private VarNode selectedVar;
    private int listAdd;
    private String[] selectedString;
    private int pointer;
    int headerHover;
    boolean dot = false;
    Polygon sortTriangle = new Polygon();
    private int hoverSample = -1;
    private int mutcount;
    ArrayList<SampleNode> vararray = new ArrayList();
    SampleNode[] controlarray;
    private Color textcolor;
    private double casefreq;
    Map.Entry<String, ArrayList<SampleNode>> entry;
    MethodLibrary.controlsorter ctrlsort = new MethodLibrary.controlsorter();
    private int geneHeaderHover;
    private boolean mouseDrag;
    private int resizeColumn;
    private int cases;
    private int dragX;
    private int firstrow = 0;
    private int firstvisible;

    BedTable(int width, int height, JScrollPane tablescroll, BedTrack bedtrack) {
        this.width = width;
        this.height = height;
        this.tablescroll = tablescroll;
        Object[] obj = new Object[]{"Sample", 10, (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Mut. count", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Position", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Base change", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Genotype", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Quality", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"rs-code", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        this.geneheaderlength = this.geneheader.size();
        this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(width, height, 2));
        this.buf = (Graphics2D)this.bufImage.getGraphics();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.controlarray = VariantHandler.table.controlarray;
        this.bedtrack = bedtrack;
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = (int)(0.15 * (double)width);
        this.headerlengths[1][0] = this.headerlengths[0][1] + this.headerlengths[0][0];
        this.headerlengths[1][1] = (int)(0.15 * (double)width);
        this.headerlengths[2][0] = this.headerlengths[1][1] + this.headerlengths[1][0];
        this.headerlengths[2][1] = (int)(0.2 * (double)width);
        this.headerlengths[3][0] = this.headerlengths[2][1] + this.headerlengths[2][0];
        this.headerlengths[3][1] = (int)(0.5 * (double)width);
        this.addMouseWheelListener(this);
    }

    void resizeTable() {
        if (this.bufImage.getWidth() < this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
            this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
            this.buf = (Graphics2D)this.bufImage.getGraphics();
        }
    }

    void resizeTable(int width) {
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = (int)((double)width / (double)this.headerlengths.length);
        int i = 1;
        while (i < this.headerlengths.length) {
            this.headerlengths[i][0] = this.headerlengths[i - 1][1] + this.headerlengths[i - 1][0];
            this.headerlengths[i][1] = (int)((double)width / (double)this.headerlengths.length);
            ++i;
        }
        this.geneheader.get((int)0)[2] = (width - 10) / this.geneheader.size();
        i = 1;
        while (i < this.geneheader.size()) {
            this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i - 1)[1] + (Integer)this.geneheader.get(i - 1)[2];
            this.geneheader.get((int)i)[2] = (width - 10) / this.geneheader.size();
            ++i;
        }
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    void addRowGeneheader(Object column) {
        Object[] obj = new Object[]{column, (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], 100};
        this.geneheader.add(obj);
        if ((Integer)obj[1] + (Integer)obj[2] > this.getWidth()) {
            if (this.bufImage == null) {
                this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width, this.height, 2));
                this.buf = (Graphics2D)this.bufImage.getGraphics();
            }
            if (this.bufImage.getWidth() < (Integer)obj[1] + (Integer)obj[2]) {
                this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                this.buf = (Graphics2D)this.bufImage.getGraphics();
            }
            this.setPreferredSize(new Dimension((Integer)obj[1] + (Integer)obj[2], this.getHeight()));
            this.revalidate();
        }
    }

    void drawScreen(Graphics g) {
        try {
            this.buf.setColor(Color.black);
            this.buf.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.width != this.getWidth()) {
                this.width = this.getWidth();
                this.createPolygon();
                this.resizeTable();
            }
            this.genemutcount = 0;
            if (!this.bedtrack.intersect) {
                this.buf.setColor(Color.white);
                this.buf.drawString("Press play on bed track to annotate variants", 5, 40);
            } else if (this.getTableSize() > 0) {
                this.hoverVar = null;
                this.hoverSample = -1;
                this.headerHover = -1;
                this.geneHeaderHover = -1;
                if (!this.mouseDrag) {
                    this.resizeColumn = -1;
                }
                if (this.aminoarray == null) {
                    this.aminoarray = new ArrayList();
                }
                this.firstrow = this.tablescroll.getVerticalScrollBar().getValue() / this.rowHeight - this.samplecount - this.listAdd - this.aminoarray.size();
                if (this.firstrow < 0) {
                    this.firstrow = 0;
                }
                int i = this.firstrow;
                while (i < this.bedarray.size()) {
                    block105: {
                        this.dot = false;
                        if ((i + 1 + this.samplecount + this.listAdd + this.aminoarray.size()) * this.rowHeight >= this.tablescroll.getVerticalScrollBar().getValue()) {
                            if (i * this.rowHeight > this.tablescroll.getVerticalScrollBar().getValue() + this.tablescroll.getViewport().getHeight()) break;
                            if (this.mouseY >= this.rowHeight * (i + this.genemutcount + 1) && this.mouseY < this.rowHeight * (i + this.genemutcount + 2)) {
                                this.hoverNode = this.bedarray.get(i);
                            }
                            try {
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawLine(4, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                if (this.bedarray.get((int)i).getTrack().hasvalues) {
                                    this.buf.drawString(String.valueOf(i + 1) + ".  " + MethodLibrary.shortString(this.bedarray.get((int)i).name, 10) + "=" + MethodLibrary.round(this.bedarray.get((int)i).value, 3), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                } else {
                                    this.buf.drawString(String.valueOf(i + 1) + ".  " + MethodLibrary.shortString(this.bedarray.get((int)i).name, 10), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                }
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[1][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.headerlengths[1][1], this.rowHeight - 1);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.mutcountbuffer = new StringBuffer(this.bedarray.get((int)i).mutations + " ");
                                this.buf.drawString(this.mutcountbuffer.toString(), this.headerlengths[1][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[2][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.buf.drawString(String.valueOf(this.bedarray.get(i).getChrom()) + ":" + MethodLibrary.formatNumber(this.bedarray.get(i).getPosition() + 1) + "-" + MethodLibrary.formatNumber(this.bedarray.get(i).getPosition() + 1 + this.bedarray.get(i).getLength()), this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[3][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.buf.drawString(MethodLibrary.formatNumber(this.bedarray.get(i).getLength()), this.headerlengths[3][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[4][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.buf.drawString("" + MethodLibrary.round((double)this.bedarray.get((int)i).mutations / (double)this.bedarray.get(i).getLength() * 100.0, 4), this.headerlengths[4][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[5][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                if (this.bedarray.get(i).equals(this.hoverNode) || this.bedarray.get(i).equals(this.selectedNode)) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.firstvisible = 0;
                                if (this.bedarray.get((int)i).varnodes != null) {
                                    int f = 0;
                                    while (f < this.bedarray.get((int)i).varnodes.size()) {
                                        if (!Main.drawCanvas.hideNode(this.bedarray.get((int)i).varnodes.get(f))) {
                                            this.firstvisible = f;
                                            break;
                                        }
                                        ++f;
                                    }
                                    if (this.bedarray.get((int)i).varnodes.get(this.firstvisible).getExons() != null) {
                                        if (this.bedarray.get((int)i).varnodes.get((int)this.firstvisible).coding) {
                                            this.buf.setColor(Color.red);
                                            this.buf.drawString(String.valueOf(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getExons().get(0).getTranscript().getGenename()) + " (Coding)", this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        } else {
                                            this.buf.setColor(Color.lightGray);
                                            this.buf.drawString(String.valueOf(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getExons().get(0).getTranscript().getGenename()) + " (UTR)", this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        }
                                    } else if (this.bedarray.get((int)i).varnodes.get(this.firstvisible).isInGene()) {
                                        this.buf.setColor(Color.lightGray);
                                        this.buf.drawString(String.valueOf(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).getGenename()) + " (Intronic)", this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else {
                                        this.buf.setColor(Color.gray);
                                        if (!this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).equals(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(1))) {
                                            this.buf.drawString(String.valueOf(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).getGenename()) + " ... " + this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(1).getGenename(), this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        } else if (this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).getEnd() > this.bedarray.get((int)i).varnodes.get(this.firstvisible).getPosition()) {
                                            this.buf.drawString(" ... " + this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).getGenename(), this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        } else {
                                            this.buf.drawString(String.valueOf(this.bedarray.get((int)i).varnodes.get(this.firstvisible).getTranscripts().get(0).getGenename()) + " ... ", this.headerlengths[5][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        }
                                    }
                                }
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawLine(3, this.rowHeight + 3, 3, this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                int r = 0;
                                while (r < this.headerlengths.length) {
                                    this.buf.drawLine(this.headerlengths[r][0], this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.headerlengths[r][0], this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    ++r;
                                }
                                if (this.selectedNode == null || !this.selectedNode.equals(this.bedarray.get(i))) break block105;
                                this.hoverSample = -1;
                                this.genemutcount = this.aminoarray.size() + 1;
                                this.listAdd = 1;
                                this.buf.drawLine(20, this.rowHeight * (i + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                this.drawGeneheader(this.rowHeight * (i + this.listAdd + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                int s = 0;
                                while (s < this.aminoarray.size()) {
                                    int v;
                                    this.buf.setColor(Color.darkGray);
                                    this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    if (this.mouseY >= this.rowHeight * (i + s + this.listAdd + 2) && this.mouseY < this.rowHeight * (i + s + this.listAdd + 3)) {
                                        this.hoverNode = null;
                                        this.hoverVar = this.aminoarray.get(s).getNode();
                                        this.hoverString = this.aminoarray.get(s).getRow();
                                        this.buf.setColor(Color.white);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getIndex();
                                                break;
                                            }
                                            ++v;
                                        }
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("nonsense")) {
                                        this.buf.setColor(Color.red);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("missense")) {
                                        this.buf.setColor(Color.yellow);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("synonymous")) {
                                        this.buf.setColor(Color.green);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("UTR")) {
                                        this.buf.setColor(Color.lightGray);
                                    } else {
                                        this.buf.setColor(Color.gray);
                                    }
                                    if (!this.aminoarray.get(s).getRow()[1].equals("1")) {
                                        this.buf.drawString("Multiple", 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else {
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getName(), 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                break;
                                            }
                                            ++v;
                                        }
                                    }
                                    this.textcolor = this.hoverVar != null && this.hoverString.equals(this.aminoarray.get(s).getRow()) ? Color.white : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("nonsense") ? Color.red : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("missense") ? Color.yellow : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("synonymous") ? Color.green : (this.aminoarray.get(s).getRow()[3].contains("UTR") ? Color.lightGray : Color.gray))));
                                    int h = 1;
                                    while (h < 4) {
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.geneheader.get(h)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(h)[2], this.rowHeight - 1);
                                        this.buf.setColor(this.textcolor);
                                        this.buf.drawString(this.aminoarray.get(s).getRow()[h], (Integer)this.geneheader.get(h)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        ++h;
                                    }
                                    if (this.aminoarray.get(s).getRow()[1].equals("1")) {
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.geneheader.get(4)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                        this.buf.setColor(this.textcolor);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).isHomozygous()) {
                                                    this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    if (Control.controlData.controlsOn) {
                                                        this.cases = 2;
                                                        this.casefreq = 2.0 / (double)(Main.varsamples * 2);
                                                    }
                                                } else {
                                                    this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    if (Control.controlData.controlsOn) {
                                                        this.cases = 1;
                                                        this.casefreq = 1.0 / (double)(Main.varsamples * 2);
                                                    }
                                                }
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 1, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(this.textcolor);
                                                this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getQuality(), (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++v;
                                        }
                                    }
                                    if (Control.controlData.controlsOn) {
                                        this.cases = 0;
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.cases = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).isHomozygous() ? (this.cases += Integer.parseInt(this.aminoarray.get(s).getRow()[1]) * 2) : (this.cases += Integer.parseInt(this.aminoarray.get(s).getRow()[1]));
                                            }
                                            ++v;
                                        }
                                        this.casefreq = (double)this.cases / (double)(Main.varsamples * 2);
                                    }
                                    this.buf.setColor(this.textcolor);
                                    this.buf.drawString(this.aminoarray.get(s).getRow()[4], (Integer)this.geneheader.get(6)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    if (Control.controlData.controlsOn) {
                                        this.buf.setColor(this.textcolor);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                int e;
                                                this.vararray = this.aminoarray.get((int)s).getNode().vars.get(v).getValue();
                                                this.controlarray = new SampleNode[Control.controlData.fileArray.size()];
                                                if (this.vararray.get((int)(this.vararray.size() - 1)).alleles != null) {
                                                    e = this.vararray.size() - 1;
                                                    while (e > 0) {
                                                        if (this.vararray.get((int)e).alleles == null) break;
                                                        this.controlarray[this.vararray.get((int)e).getControlSample().getIndex()] = this.vararray.get(e);
                                                        --e;
                                                    }
                                                }
                                                e = 0;
                                                while (e < this.controlarray.length) {
                                                    if (Control.controlData.fileArray.get((int)e).controlOn) {
                                                        if (this.controlarray[e] == null) {
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("0", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        } else {
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("" + MethodLibrary.round((double)this.controlarray[e].alleles.intValue() / (double)this.controlarray[e].allelenumber.intValue(), 2), (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString(MethodLibrary.round(this.casefreq / ((double)this.controlarray[e].alleles.intValue() / (double)this.controlarray[e].allelenumber.intValue()), 2) + " (p=" + MethodLibrary.round(VariantHandler.table.fe.getRightTailedP(this.cases, Main.varsamples * 2 - this.cases, this.controlarray[e].alleles, this.controlarray[e].allelenumber - this.controlarray[e].alleles), 2) + ")", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        }
                                                    } else {
                                                        this.buf.setColor(Color.black);
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                        this.buf.setColor(Color.darkGray);
                                                        this.buf.drawString("Apply controls", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        this.buf.setColor(Color.black);
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                        this.buf.setColor(Color.darkGray);
                                                        this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    }
                                                    ++e;
                                                }
                                            }
                                            ++v;
                                        }
                                    } else {
                                        this.buf.setColor(Color.darkGray);
                                        int e = this.geneheaderlength;
                                        while (e < this.geneheader.size()) {
                                            if (this.geneheader.get(e)[0] instanceof ControlFile) {
                                                this.buf.drawString("Apply controls", (Integer)this.geneheader.get(e)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++e;
                                        }
                                        this.buf.setColor(Color.lightGray);
                                    }
                                    this.vararray = null;
                                    if (Main.bedCanvas.bedOn) {
                                        int a = 0;
                                        while (a < this.aminoarray.size()) {
                                            StringBuffer[] bedarraytemp = MethodLibrary.makeTrackArray(this.aminoarray.get(a).getNode(), this.aminoarray.get(a).getRow()[5]);
                                            if (bedarraytemp != null) {
                                                int h2 = 0;
                                                int b = 0;
                                                while (b < bedarraytemp.length) {
                                                    if (b != this.bedtrack.trackIndex) {
                                                        this.buf.setColor(Color.black);
                                                        if (b == bedarraytemp.length - 1) {
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + h2)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth() - (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + h2)[1], this.rowHeight - 1);
                                                        } else {
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + h2)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + h2)[2], this.rowHeight - 1);
                                                        }
                                                        this.buf.setColor(Color.white);
                                                        if (bedarraytemp[b] != null) {
                                                            this.buf.drawString(bedarraytemp[b].toString(), (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + h2)[1] + 14, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        }
                                                        ++h2;
                                                    }
                                                    ++b;
                                                }
                                            }
                                            ++a;
                                        }
                                    }
                                    this.buf.setColor(Color.darkGray);
                                    int j = 0;
                                    while (j < this.geneheader.size()) {
                                        this.buf.drawLine((Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                        ++j;
                                    }
                                    if (this.selectedVar != null && this.selectedString.equals(this.aminoarray.get(s).getRow()) && Integer.parseInt(this.selectedString[1]) > 1) {
                                        this.pointer = 0;
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.selectedString[5])) {
                                                int l = 0;
                                                while (l < this.aminoarray.get((int)s).getNode().vars.get(v).getValue().size()) {
                                                    if (this.aminoarray.get((int)s).getNode().vars.get((int)v).getValue().get((int)l).alleles != null) break;
                                                    if (this.mouseY > this.rowHeight * (i + s + this.pointer + 4) && this.mouseY < this.rowHeight * (i + s + this.pointer + 5)) {
                                                        this.textcolor = Color.white;
                                                        this.hoverVar = this.aminoarray.get(s).getNode();
                                                        this.hoverString = this.aminoarray.get(s).getRow();
                                                        this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getIndex();
                                                    } else {
                                                        this.textcolor = Color.lightGray;
                                                    }
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getName(), 30, this.rowHeight * (i + s + this.pointer + 4) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    ++this.pointer;
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(4)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).isHomozygous()) {
                                                        this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    } else {
                                                        this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    }
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getQuality(), (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    this.buf.setColor(Color.darkGray);
                                                    int j2 = 4;
                                                    while (j2 < 7) {
                                                        this.buf.drawLine((Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue(), (Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight + 2);
                                                        ++j2;
                                                    }
                                                    ++l;
                                                }
                                            }
                                            ++v;
                                        }
                                        this.listAdd = Integer.parseInt(this.selectedString[1]) + 1;
                                        this.genemutcount = this.aminoarray.size() + this.listAdd;
                                        this.buf.setColor(Color.darkGray);
                                        this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    }
                                    ++s;
                                }
                            }
                            catch (Exception e) {
                                ErrorLog.addError(e.getStackTrace());
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                }
                this.buf.setColor(Color.darkGray);
                this.buf.drawLine(4, this.rowHeight * (this.bedarray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (this.bedarray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
            }
            this.drawHeader();
            if (this.headerHover == -1 && this.geneHeaderHover == -1) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.resizeColumn == -1) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
            g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void drawHeader() {
        int i = 0;
        while (i < this.header.length) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect(this.headerlengths[i][0], 0, this.headerlengths[i][1] + 1, this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= this.rowHeight) {
                if (this.mouseX >= this.headerlengths[i][0] && this.mouseX <= this.headerlengths[i][0] + this.headerlengths[i][1]) {
                    this.headerHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
                    this.headerHover = this.headerlengths.length;
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.headerHover > -1 && i > 0 && i < this.header.length && this.mouseX > this.headerlengths[i][0] - 5 && this.mouseX < this.headerlengths[i][0] + 5) {
                this.resizeColumn = i;
            }
            this.buf.drawString(this.header[i], this.headerlengths[i][0] + 4, this.rowHeight - 2);
            this.buf.setColor(Color.black);
            this.buf.drawLine(this.headerlengths[i][0], 0, this.headerlengths[i][0], this.rowHeight);
            if (this.sorter.index > -1) {
                if (this.sorter.ascending) {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                } else {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                }
            }
            ++i;
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect(this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 2, 0, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine(this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 1, 0, this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 1, this.rowHeight);
        if (!this.mouseDrag && this.headerHover > -1 && this.resizeColumn == -1 && this.mouseX > this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] - 5 && this.mouseX < this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 5) {
            this.resizeColumn = this.header.length;
        }
    }

    void drawGeneheader(int y) {
        int i = 0;
        while (i < this.geneheader.size()) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[2], this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= y + this.rowHeight && this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() >= y) {
                if (this.mouseX >= (Integer)this.geneheader.get(i)[1] + 10 && this.mouseX <= (Integer)this.geneheader.get(i)[1] + (Integer)this.geneheader.get(i)[2] + 10) {
                    this.geneHeaderHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10) {
                    this.geneHeaderHover = this.geneheader.size();
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.geneHeaderHover > -1 && i > 0 && i < this.geneheader.size() && this.mouseX > (Integer)this.geneheader.get(i)[1] + 5 && this.mouseX < (Integer)this.geneheader.get(i)[1] + 15 && this.resizeColumn != i) {
                this.resizeColumn = i;
            }
            if (this.geneheader.get(i)[0] instanceof String) {
                this.buf.drawString((String)this.geneheader.get(i)[0], (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
            } else if (this.geneheader.get(i)[0] instanceof ControlFile) {
                ControlFile ctrlfile = (ControlFile)this.geneheader.get(i)[0];
                this.buf.drawString("AF: " + ctrlfile.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                ctrlfile = null;
            } else {
                BedTrack track = (BedTrack)this.geneheader.get(i)[0];
                if (track.file != null) {
                    this.buf.drawString(track.file.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                } else {
                    this.buf.drawString(FilenameUtils.getName(track.url.getFile()), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                }
                Object var3_3 = null;
            }
            this.buf.setColor(Color.black);
            this.buf.drawLine((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[1] + 10, y + this.rowHeight);
            ++i;
        }
        if (!this.mouseDrag && this.geneHeaderHover > -1 && this.resizeColumn == -1 && this.mouseX > (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] - 5 && this.mouseX < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 15) {
            this.resizeColumn = this.geneheader.size();
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 11, y, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y, (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y + this.rowHeight);
    }

    void drawScreen2(Graphics g) {
        int i;
        this.buf.setColor(Color.black);
        this.buf.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.aminoarray.size() > 0) {
            this.samplecount = 0;
            this.genemutcount = 0;
            i = 0;
            while (i < this.aminoarray.size()) {
                if ((i + 1) * this.rowHeight >= this.tablescroll.getVerticalScrollBar().getValue()) {
                    if (i * this.rowHeight > this.tablescroll.getVerticalScrollBar().getValue() + this.getHeight()) break;
                    int j = 0;
                    while (j < this.aminoarray.get(i).getRow().length) {
                        try {
                            if (this.selectedNode != null && this.selectedNode.equals(this.aminoarray.get(i).getNode())) {
                                this.buf.setColor(Color.yellow);
                                if (j < 2) {
                                    this.buf.drawString(this.aminoarray.get(i).getRow()[j], 10 + this.getWidth() / this.header.length * j, this.rowHeight * (i + 1) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                } else {
                                    this.buf.setColor(Color.yellow);
                                    int s = 0;
                                    while (s < this.samplecount) {
                                        if (j == 2) {
                                            this.buf.setColor(Color.yellow);
                                        }
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect(this.getWidth() / this.header.length * j, this.rowHeight * (i + s + 2) + 2 - this.tablescroll.getVerticalScrollBar().getValue(), this.getWidth() / this.header.length + 1, this.rowHeight);
                                        this.buf.setColor(Color.yellow);
                                        this.buf.drawString(this.aminoarray.get(i).getRow()[j], 10 + this.getWidth() / this.header.length * j, this.rowHeight * (i + s + 2) + 2 - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        ++s;
                                    }
                                }
                            } else {
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.getWidth() / this.header.length * j, this.rowHeight * (i + 1 + this.samplecount) + 2 - this.tablescroll.getVerticalScrollBar().getValue(), this.getWidth() / this.header.length, this.rowHeight);
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawRect(this.getWidth() / this.header.length * j, this.rowHeight * (i + 1 + this.samplecount) + 2 - this.tablescroll.getVerticalScrollBar().getValue(), this.getWidth() / this.header.length, this.rowHeight);
                                if (this.hoverNode != null && this.hoverNode.equals(this.aminoarray.get(i).getNode())) {
                                    this.buf.setColor(Color.yellow);
                                } else {
                                    this.buf.setColor(Color.white);
                                }
                                this.buf.drawString(this.aminoarray.get(i).getRow()[j], 10 + this.getWidth() / this.header.length * j, this.rowHeight * (i + 1 + this.samplecount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ErrorLog.addError(e.getStackTrace());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.header.length) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect(i * this.getWidth() / this.header.length, 0, this.getWidth() / this.header.length + 1, this.rowHeight);
            this.buf.setColor(Color.white);
            this.buf.drawString(this.header[i], i * this.getWidth() / this.header.length + 4, this.rowHeight - 2);
            this.buf.setColor(Color.black);
            this.buf.drawLine(i * this.getWidth() / this.header.length, 0, i * this.getWidth() / this.header.length, this.rowHeight);
            ++i;
        }
        g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
    }

    void addEntry(BedNode entry) {
        this.bedarray.add(entry);
    }

    void clear() {
        this.bedarray.clear();
        this.aminoarray.clear();
        this.hoverNode = null;
        this.selectedNode = null;
        this.entry = null;
        this.vararray.clear();
        this.hoverVar = null;
        this.selectedVar = null;
    }

    int getTableSize() {
        if (this.bedarray == null) {
            return 0;
        }
        return this.bedarray.size();
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.drawScreen(g);
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled() || this.headerHover != -1) break;
                if (event.getClickCount() == 2) {
                    FileRead.novars = true;
                    if (this.hoverSample > -1) {
                        Main.drawCanvas.drawVariables.visiblestart = (short)this.hoverSample;
                        Main.drawCanvas.drawVariables.visiblesamples = 1;
                        Main.drawCanvas.resizeCanvas(Main.drawScroll.getViewport().getWidth(), (int)((double)Main.samples * Main.drawCanvas.drawVariables.sampleHeight));
                        Draw.setScrollbar((int)((double)this.hoverSample * Main.drawCanvas.drawVariables.sampleHeight));
                    }
                    FileRead.search = true;
                    if (this.hoverVar != null) {
                        VarNode searchHead = this.hoverVar;
                        while (searchHead.getPrev() != null) {
                            if (searchHead.getPrev().getPosition() == 0) {
                                searchHead.getPrev().putNext(searchHead);
                            }
                            searchHead = searchHead.getPrev();
                        }
                        FileRead.head = searchHead;
                        searchHead = null;
                        Main.drawCanvas.current = this.hoverVar;
                        if (this.hoverVar.getExons() != null) {
                            Main.drawCanvas.gotoPos(this.hoverVar.getExons().get(0).getTranscript().getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                            break;
                        }
                        if (this.hoverVar.getTranscripts() == null) break;
                        Main.drawCanvas.gotoPos(this.hoverVar.getTranscripts().get(0).getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                        break;
                    }
                    if (this.hoverNode == null) break;
                    VarNode searchHead = this.hoverNode.varnodes.get(0);
                    while (searchHead.getPrev() != null) {
                        if (searchHead.getPrev().getPosition() == 0) {
                            searchHead.getPrev().putNext(searchHead);
                        }
                        searchHead = searchHead.getPrev();
                    }
                    FileRead.head = searchHead;
                    searchHead = null;
                    Main.drawCanvas.current = this.hoverNode.varnodes.get(0);
                    Main.drawCanvas.gotoPos(this.hoverNode.getChrom().replace("chr", ""), this.hoverNode.getPosition(), this.hoverNode.getPosition() + this.hoverNode.getLength());
                    break;
                }
                if (event.getClickCount() != 1) break;
                if (!(this.hoverVar == null || this.selectedVar != null && this.selectedVar.equals(this.hoverVar))) {
                    this.selectedVar = this.hoverVar;
                    this.selectedString = this.hoverString;
                    if (this.selectedVar.isRscode() != null) {
                        this.hoverString[4] = this.selectedVar.rscode;
                    }
                    this.repaint();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount + Integer.parseInt(this.selectedString[1])) * this.rowHeight));
                    this.revalidate();
                    break;
                }
                if (this.hoverVar != null && this.selectedVar.equals(this.hoverVar)) {
                    if (this.hoverSample != -1) break;
                    this.selectedVar = null;
                    this.repaint();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                    this.revalidate();
                    break;
                }
                if (this.hoverVar != null && this.selectedNode != null && this.hoverNode.equals(this.selectedNode)) {
                    this.selectedString = this.hoverString;
                    this.samplecount = 0;
                    this.repaint();
                    break;
                }
                if (this.hoverSample != -1 || this.hoverNode == null) break;
                if (this.selectedNode != null && this.selectedNode.equals(this.hoverNode)) {
                    this.selectedString = null;
                    this.selectedNode = null;
                    this.hoverVar = null;
                    this.selectedVar = null;
                    this.aminoarray = null;
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2) * this.rowHeight));
                    this.revalidate();
                    this.repaint();
                    break;
                }
                this.selectedNode = this.hoverNode;
                this.selectedString = this.hoverString;
                this.samplecount = this.selectedNode.varnodes.size();
                if (VariantHandler.tabs.getSelectedIndex() == 0) {
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                    this.revalidate();
                    this.getAminos(this.selectedNode);
                    this.repaint();
                    break;
                }
                this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                this.revalidate();
                this.getAminos(this.selectedNode);
                this.repaint();
                break;
            }
            case 4: {
                this.selectedNode = null;
                this.selectedVar = null;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    void createPolygon() {
        if (this.sorter.ascending) {
            int[] x = new int[]{this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 15, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 10, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 5};
            int[] y = new int[]{12, 4, 12};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        } else {
            int[] x = new int[]{this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 15, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 10, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 5};
            int[] y = new int[]{4, 12, 4};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled()) break;
                this.dragX = event.getX();
                if (this.headerHover > -1 && this.resizeColumn == -1) {
                    this.sorter.ascending = !this.sorter.ascending;
                    this.sorter.index = this.headerHover;
                    Collections.sort(this.bedarray, this.sorter);
                    this.createPolygon();
                    this.repaint();
                }
                if (this.hoverNode == null && this.hoverVar == null) break;
                Main.chromDraw.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mouseDrag = false;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mouseDrag = true;
        if (this.resizeColumn > 0) {
            this.resizeTable(this.resizeColumn, event.getX() - this.dragX);
            this.dragX = event.getX();
        }
    }

    void resizeTable(int column, int amount) {
        if (this.headerHover != -1) {
            if (this.headerlengths[column - 1][1] + amount > 20) {
                int[] nArray = this.headerlengths[column - 1];
                nArray[1] = nArray[1] + amount;
                int i = column;
                while (i < this.headerlengths.length) {
                    int[] nArray2 = this.headerlengths[i];
                    nArray2[0] = nArray2[0] + amount;
                    ++i;
                }
            }
            if (this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1] > this.getWidth()) {
                if (this.bufImage.getWidth() < this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                }
                this.setPreferredSize(new Dimension(this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1], this.getHeight()));
                this.revalidate();
            }
        } else {
            if ((Integer)this.geneheader.get(column - 1)[2] + amount > 20) {
                this.geneheader.get((int)(column - 1))[2] = (Integer)this.geneheader.get(column - 1)[2] + amount;
                int i = column;
                while (i < this.geneheader.size()) {
                    this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i)[1] + amount;
                    ++i;
                }
            }
            if ((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] > this.getWidth()) {
                if (this.bufImage.getWidth() < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                }
                this.setPreferredSize(new Dimension((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], this.getHeight()));
                this.revalidate();
            }
        }
        this.createPolygon();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.mouseY = event.getY();
        this.mouseX = event.getX();
        this.repaint();
    }

    void getAminos(BedNode transcript) {
        try {
            this.aminoarray = null;
            VarNode varnode = null;
            int t = 0;
            while (t < transcript.varnodes.size()) {
                if (!Main.drawCanvas.hideNode(transcript.varnodes.get(t))) {
                    varnode = transcript.varnodes.get(t);
                    int v = 0;
                    while (v < varnode.vars.size()) {
                        this.entry = varnode.vars.get(v);
                        this.mutcount = 0;
                        if (!Main.drawCanvas.hideNodeVar(varnode, this.entry)) {
                            int m = 0;
                            while (m < this.entry.getValue().size()) {
                                if (this.entry.getValue().get((int)m).alleles != null) break;
                                if (!Main.drawCanvas.hideVar(this.entry.getValue().get(m), this.entry.getKey().length() > 1)) {
                                    ++this.mutcount;
                                } else {
                                    this.entry.getValue().remove(m);
                                    --m;
                                }
                                ++m;
                            }
                            if (this.mutcount != 0) {
                                this.base = this.entry.getKey();
                                String[] addrow = new String[]{transcript.name, "" + this.mutcount, String.valueOf(transcript.getChrom()) + ":" + MethodLibrary.formatNumber(varnode.getPosition() + 1), this.base.length() == 1 ? Main.getBase.get(varnode.getRefBase()) + ">" + this.base : this.base, varnode.isRscode() != null ? varnode.rscode : "N/A", this.base};
                                AminoEntry aminoentry = new AminoEntry(addrow, varnode);
                                if (this.aminoarray == null) {
                                    this.aminoarray = new ArrayList();
                                }
                                this.aminoarray.add(aminoentry);
                            }
                        }
                        ++v;
                    }
                }
                ++t;
            }
            varnode = null;
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() - 16);
        } else {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() + 16);
        }
        this.repaint();
    }

    public static class ListSorter
    implements Comparator<BedNode> {
        public int index;
        boolean ascending = true;

        @Override
        public int compare(BedNode o1, BedNode o2) {
            if (this.index == 0) {
                String f1 = o1.name;
                String f2 = o2.name;
                if (f1.compareTo(f2) < 0) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1.compareTo(f2) > 0) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 1) {
                int f1 = o1.mutations;
                int f2 = o2.mutations;
                if (f1 < f2) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 2) {
                if (Main.chromIndex.get(o1.getChrom())[0] + (long)o1.getPosition() < Main.chromIndex.get(o2.getChrom())[0] + (long)o2.getPosition()) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (Main.chromIndex.get(o1.getChrom())[0] + (long)o1.getPosition() > Main.chromIndex.get(o2.getChrom())[0] + (long)o2.getPosition()) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 3) {
                int f2;
                int f1 = o1.getLength();
                if (f1 < (f2 = o2.getLength())) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 4) {
                double f2;
                double f1 = (double)o1.mutations / (double)o1.getLength();
                if (f1 < (f2 = (double)o2.mutations / (double)o2.getLength())) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }
}

