/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Reads;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.tribble.readers.TabixReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class Average
extends JPanel
implements TableCellRenderer,
MouseListener {
    private static final long serialVersionUID = 1L;
    static JFrame frame;
    static List<int[]> mergeVector;
    static JButton openbutton;
    static JButton output;
    static int startpos;
    static int endpos;
    static int startchrom;
    static int endchrom;
    static JButton execute;
    JButton cancel = new JButton("Cancel");
    static JTextArea info;
    static List<List<String>> outVector;
    JLabel fileLabel = new JLabel("Open BED-file to calculate average coverage");
    static JPanel panel;
    static Object[] headers;
    static Object[][] data;
    static DefaultTableModel model;
    static JCheckBox smallregion;
    static JTable table;
    JScrollPane infoScroll = new JScrollPane(table, 20, 30);

    static {
        mergeVector = null;
        openbutton = new JButton("Open BED-file");
        output = new JButton("Write output");
        startpos = 0;
        endpos = 0;
        startchrom = 0;
        endchrom = 0;
        execute = new JButton("Execute");
        info = new JTextArea();
        outVector = Collections.synchronizedList(new ArrayList());
        panel = new JPanel(new GridBagLayout());
        headers = new Object[]{"Sample", "Average coverage", "Average mapping quality", "Soft clip rate", "Zero quality rate", "Covered (%) (Coverage : Percentage)", "Status"};
        data = new Object[0][];
        model = new DefaultTableModel(data, headers);
        smallregion = new JCheckBox("Small region?");
        table = new JTable(model);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Average.createAndShowGUI();
            }
        });
    }

    public static void setSamples() {
        outVector.clear();
        model.setRowCount(0);
        if (outVector.size() == 0) {
            int i = 0;
            while (i < Main.samples) {
                if (Main.drawCanvas.sampleList.get((int)i).samFile != null) {
                    List addVector = Collections.synchronizedList(new ArrayList());
                    outVector.add(addVector);
                    Object[] row = new Object[]{Main.drawCanvas.sampleList.get(i).getName()};
                    model.addRow(row);
                }
                ++i;
            }
        } else {
            outVector.clear();
            model.getDataVector().clear();
            int i = 0;
            while (i < Main.samples) {
                if (Main.drawCanvas.sampleList.get((int)i).samFile != null) {
                    List addVector = Collections.synchronizedList(new ArrayList());
                    outVector.add(addVector);
                    Object[] row = new Object[]{Main.drawCanvas.sampleList.get(i).getName()};
                    model.addRow(row);
                }
                ++i;
            }
        }
    }

    public Average() {
        super(new GridBagLayout());
        panel.setBackground(Draw.sidecolor);
        output.setEnabled(false);
        execute.setEnabled(false);
        this.cancel.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(5, 5, 2, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)openbutton, c);
        c.gridx = 1;
        panel.add((Component)execute, c);
        c.gridx = 2;
        panel.add((Component)this.cancel, c);
        c.gridx = 3;
        panel.add((Component)output, c);
        c.gridx = 4;
        panel.add((Component)smallregion, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 5;
        panel.add((Component)this.fileLabel, c);
        c = new GridBagConstraints(0, 2, 5, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
        table.setAutoResizeMode(4);
        this.infoScroll.getViewport().setBackground(Color.white);
        this.infoScroll.setPreferredSize(this.infoScroll.getPreferredSize());
        table.setAutoCreateRowSorter(true);
        panel.add((Component)this.infoScroll, c);
        this.add((Component)panel, c);
        openbutton.addMouseListener(this);
        output.addMouseListener(this);
        execute.addMouseListener(this);
        this.cancel.addMouseListener(this);
        Average.setFonts(Main.menuFont);
    }

    static void setFonts(Font menuFont) {
        int i = 0;
        while (i < panel.getComponentCount()) {
            panel.getComponent(i).setFont(menuFont);
            ++i;
        }
        table.getTableHeader().setFont(menuFont);
        table.setFont(menuFont);
        table.setRowHeight(menuFont.getSize() + 4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getValueAt(row, column).toString().contains("Running")) {
            comp.setForeground(Color.red);
        } else {
            comp.setForeground(Color.YELLOW);
        }
        return comp;
    }

    /*
     * Unable to fully structure code
     */
    static void calcAverageRegions() {
        block22: {
            try {
                mergeVector = Average.mergeVector;
                zeros = 0;
                start = 0;
                end = 0;
                stat = 0;
                status = "";
                percent = "";
                coverageWidth = new int[10];
                reader = new FileRead();
                coverageArray = new int[]{};
                s = 0;
                while (s < Main.drawCanvas.sampleList.size()) {
                    block23: {
                        if (Main.cancel) break block22;
                        if (Main.drawCanvas.sampleList.get((int)s).samFile == null) break block23;
                        result = 0L;
                        qualities = 0L;
                        cliplengths = 0L;
                        readlengths = 0L;
                        reads = 0L;
                        currentLength = 0;
                        readClass = Main.drawCanvas.sampleList.get(s).getreadHash().get(Main.drawCanvas.splits.get(0));
                        coverageWidth = new int[10];
                        i = 0;
                        while (i < 10) {
                            coverageWidth[i] = 0;
                            ++i;
                        }
                        first = true;
                        c = 0;
                        while (c < mergeVector.size()) {
                            iterator = reader.getBamIterator(readClass, (String)Main.chromosomeDropdown.getItemAt(mergeVector.get(c)[0]), mergeVector.get(c)[1], mergeVector.get(c)[2]);
                            samRecord = null;
                            coverageArray = new int[mergeVector.get(c)[2] - mergeVector.get(c)[1]];
                            i = 0;
                            while (i < coverageArray.length) {
                                coverageArray[i] = 0;
                                ++i;
                            }
                            currentLength += mergeVector.get(c)[2] - mergeVector.get(c)[1];
                            if (!Main.cancel) ** GOTO lbl71
                            break;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    samRecord = iterator.next();
                                }
                                catch (Exception ex) {
                                    continue;
                                }
                                if (Main.cancel) break;
                                if (samRecord == null || (end = samRecord.getAlignmentEnd()) == 0) continue;
                                start = samRecord.getAlignmentStart();
                                ++reads;
                                qualities += (long)samRecord.getMappingQuality();
                                cliplengths += (long)(samRecord.getUnclippedEnd() - samRecord.getUnclippedStart() - (end - start));
                                readlengths += (long)(samRecord.getUnclippedEnd() - samRecord.getUnclippedStart());
                                if (samRecord.getMappingQuality() == 0) {
                                    ++zeros;
                                    continue;
                                }
                                try {
                                    i = start;
                                    while (i < end) {
                                        if (i >= mergeVector.get(c)[1]) {
                                            if (i > mergeVector.get(c)[2] - 1) continue block10;
                                            v0 = i - mergeVector.get(c)[1];
                                            coverageArray[v0] = coverageArray[v0] + 1;
                                        }
                                        ++i;
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    ErrorLog.addError(e.getStackTrace());
                                    e.printStackTrace();
                                }
lbl71:
                                // 7 sources

                                ** while (iterator.hasNext())
                            }
lbl72:
                            // 2 sources

                            i = 0;
                            while (i < coverageArray.length) {
                                result += (long)coverageArray[i];
                                if (coverageArray[i] > 0) {
                                    if (coverageArray[i] >= 10) {
                                        j = 0;
                                        while (j < 10) {
                                            v1 = j++;
                                            coverageWidth[v1] = coverageWidth[v1] + 1;
                                        }
                                    } else {
                                        j = coverageArray[i] - 1;
                                        while (j >= 0) {
                                            v2 = j--;
                                            coverageWidth[v2] = coverageWidth[v2] + 1;
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (stat != (int)((double)c / (double)mergeVector.size() * 100.0)) {
                                if (currentLength != 0) {
                                    Average.model.setValueAt("" + MethodLibrary.round((double)result / (double)currentLength, 2), s, 1);
                                }
                                percent = "1 : " + (int)((double)coverageWidth[0] / (double)currentLength * 100.0) + " | 2 : " + (int)((double)coverageWidth[1] / (double)currentLength * 100.0) + " | 3 : " + (int)((double)coverageWidth[2] / (double)currentLength * 100.0) + " | 4 : " + (int)((double)coverageWidth[3] / (double)currentLength * 100.0) + " | 5 : " + (int)((double)coverageWidth[4] / (double)currentLength * 100.0) + " | 6 : " + (int)((double)coverageWidth[5] / (double)currentLength * 100.0) + " | 7 : " + (int)((double)coverageWidth[6] / (double)currentLength * 100.0) + " | 8 : " + (int)((double)coverageWidth[7] / (double)currentLength * 100.0) + " | 9 : " + (int)((double)coverageWidth[8] / (double)currentLength * 100.0) + " | 10+ : " + (int)((double)coverageWidth[9] / (double)currentLength * 100.0);
                                Average.model.setValueAt(MethodLibrary.round((double)qualities / (double)reads, 2), s, 2);
                                Average.model.setValueAt(MethodLibrary.round((double)cliplengths / (double)readlengths, 4), s, 3);
                                Average.model.setValueAt(MethodLibrary.round((double)zeros / (double)reads, 4), s, 4);
                                Average.model.setValueAt(String.valueOf(percent) + "%", s, 5);
                                stat = (int)((double)c / (double)mergeVector.size() * 100.0);
                                status = "" + (double)c / (double)mergeVector.size() * 100.0;
                                Average.model.setValueAt("Running " + status.substring(0, status.indexOf(".")) + "%", s, 6);
                            }
                            ++c;
                        }
                        Average.model.setValueAt("100%", s, 6);
                    }
                    ++s;
                }
            }
            catch (Exception ex) {
                ErrorLog.addError(ex.getStackTrace());
                ex.printStackTrace();
            }
        }
    }

    static void calcAverage() {
        try {
            List<int[]> mergeVector = Average.mergeVector;
            int zeros = 0;
            long result = 0L;
            long qualities = 0L;
            long cliplengths = 0L;
            long readlengths = 0L;
            long reads = 0L;
            int currentLength = 0;
            int start = 0;
            int end = 0;
            FileRead reader = new FileRead();
            int pointer = 0;
            int stat = 0;
            String status = "";
            String percent = "";
            int[] coverageWidth = new int[10];
            boolean first = true;
            SamReader inputSam = null;
            int[] coverageArray = new int[]{};
            int s = 0;
            while (s < Main.drawCanvas.sampleList.size()) {
                if (Main.cancel) break;
                if (Main.drawCanvas.sampleList.get((int)s).samFile != null) {
                    SAMRecordIterator iterator;
                    pointer = 0;
                    qualities = 0L;
                    Reads readClass = Main.drawCanvas.sampleList.get(s).getreadHash().get(Main.drawCanvas.splits.get(0));
                    currentLength = 0;
                    result = 0L;
                    zeros = 0;
                    reads = 0L;
                    cliplengths = 0L;
                    readlengths = 0L;
                    coverageWidth = new int[10];
                    HashMap<String, Integer> chrmap = null;
                    if (startchrom == endchrom) {
                        iterator = reader.getBamIterator(readClass, (String)Main.chromosomeDropdown.getItemAt(startchrom), startpos, endpos);
                    } else {
                        inputSam = SamReaderFactory.make().open(Main.drawCanvas.sampleList.get((int)s).samFile);
                        chrmap = MethodLibrary.mapChrnameToIndex(inputSam.getFileHeader());
                        iterator = inputSam.iterator();
                    }
                    SAMRecord samRecord = null;
                    int i = 0;
                    while (i < 10) {
                        coverageWidth[i] = 0;
                        ++i;
                    }
                    block10: while (iterator.hasNext()) {
                        try {
                            samRecord = (SAMRecord)iterator.next();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        if (Main.cancel) break;
                        if (samRecord == null || (end = samRecord.getAlignmentEnd()) == 0) continue;
                        if (pointer > mergeVector.size() - 1) break;
                        if (chrmap.get(samRecord.getReferenceName()) == null) continue;
                        if (chrmap.get(samRecord.getReferenceName()) != mergeVector.get(pointer)[0]) {
                            pointer = 0;
                            int chrtest = chrmap.get(samRecord.getReferenceName());
                            try {
                                while (chrtest != mergeVector.get(pointer)[0]) {
                                    ++pointer;
                                }
                            }
                            catch (Exception e) {
                                break;
                            }
                            first = true;
                        }
                        if (end < mergeVector.get(pointer)[1]) continue;
                        start = samRecord.getAlignmentStart();
                        if (start > mergeVector.get(pointer)[2]) {
                            if (!first) {
                                i = 0;
                                while (i < coverageArray.length) {
                                    result += (long)coverageArray[i];
                                    if (coverageArray[i] > 0) {
                                        int j;
                                        if (coverageArray[i] >= 10) {
                                            j = 0;
                                            while (j < 10) {
                                                int n = j++;
                                                coverageWidth[n] = coverageWidth[n] + 1;
                                            }
                                        } else {
                                            j = coverageArray[i] - 1;
                                            while (j >= 0) {
                                                int n = j--;
                                                coverageWidth[n] = coverageWidth[n] + 1;
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                if (stat != (int)((double)pointer / (double)mergeVector.size() * 100.0)) {
                                    if (currentLength != 0) {
                                        model.setValueAt("" + MethodLibrary.round((double)result / (double)currentLength, 2), s, 1);
                                    }
                                    percent = "1 : " + (int)((double)coverageWidth[0] / (double)currentLength * 100.0) + " | 2 : " + (int)((double)coverageWidth[1] / (double)currentLength * 100.0) + " | 3 : " + (int)((double)coverageWidth[2] / (double)currentLength * 100.0) + " | 4 : " + (int)((double)coverageWidth[3] / (double)currentLength * 100.0) + " | 5 : " + (int)((double)coverageWidth[4] / (double)currentLength * 100.0) + " | 6 : " + (int)((double)coverageWidth[5] / (double)currentLength * 100.0) + " | 7 : " + (int)((double)coverageWidth[6] / (double)currentLength * 100.0) + " | 8 : " + (int)((double)coverageWidth[7] / (double)currentLength * 100.0) + " | 9 : " + (int)((double)coverageWidth[8] / (double)currentLength * 100.0) + " | 10+ : " + (int)((double)coverageWidth[9] / (double)currentLength * 100.0);
                                    model.setValueAt(MethodLibrary.round((double)qualities / (double)reads, 2), s, 2);
                                    model.setValueAt(MethodLibrary.round((double)cliplengths / (double)readlengths, 4), s, 3);
                                    model.setValueAt(MethodLibrary.round((double)zeros / (double)reads, 4), s, 4);
                                    model.setValueAt(String.valueOf(percent) + "%", s, 5);
                                    stat = (int)((double)pointer / (double)mergeVector.size() * 100.0);
                                    status = "" + (double)pointer / (double)mergeVector.size() * 100.0;
                                    model.setValueAt("Running " + status.substring(0, status.indexOf(".")) + "%", s, 6);
                                }
                            }
                            if (++pointer > mergeVector.size() - 1) break;
                            first = true;
                        }
                        if (first) {
                            coverageArray = new int[mergeVector.get(pointer)[2] - mergeVector.get(pointer)[1]];
                            i = 0;
                            while (i < coverageArray.length) {
                                coverageArray[i] = 0;
                                ++i;
                            }
                            currentLength += mergeVector.get(pointer)[2] - mergeVector.get(pointer)[1];
                            first = false;
                        }
                        ++reads;
                        qualities += (long)samRecord.getMappingQuality();
                        cliplengths += (long)(samRecord.getUnclippedEnd() - samRecord.getUnclippedStart() - (end - start));
                        readlengths += (long)(samRecord.getUnclippedEnd() - samRecord.getUnclippedStart());
                        if (samRecord.getMappingQuality() == 0) {
                            ++zeros;
                            continue;
                        }
                        try {
                            i = start;
                            while (i < end) {
                                if (i >= mergeVector.get(pointer)[1]) {
                                    if (i > mergeVector.get(pointer)[2] - 1) continue block10;
                                    int n = i - mergeVector.get(pointer)[1];
                                    coverageArray[n] = coverageArray[n] + 1;
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            ErrorLog.addError(e.getStackTrace());
                            e.printStackTrace();
                        }
                    }
                    model.setValueAt("100%", s, 6);
                    inputSam.close();
                }
                ++s;
            }
        }
        catch (Exception ex) {
            ErrorLog.addError(ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    static void createAndShowGUI() {
        frame = new JFrame("Coverage calculator");
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame.setDefaultCloseOperation(1);
        frame.setResizable(true);
        Average newContentPane = new Average();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        block33: {
            if (e.getSource() != openbutton) break block33;
            try {
                List<String[]> tempVector;
                File bedfile;
                block31: {
                    output.setEnabled(false);
                    execute.setEnabled(false);
                    this.cancel.setEnabled(false);
                    TabixReader tabixReader = null;
                    BufferedReader bedfilereader = null;
                    FileDialog fc = new FileDialog((Frame)frame, "Choose region file", 0);
                    fc.setDirectory(Main.trackDir);
                    fc.setFile("*.bed");
                    fc.setFilenameFilter(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".bed") || name.endsWith(".bed.gz");
                        }
                    });
                    fc.setMultipleMode(false);
                    fc.setVisible(true);
                    String openfile = fc.getFile();
                    if (openfile == null) return;
                    bedfile = new File(String.valueOf(fc.getDirectory()) + "/" + openfile);
                    Boolean tabix = false;
                    if (bedfile.getAbsolutePath().endsWith(".tbi")) {
                        Main.showError("Oops, you opened the index file.", "Note");
                        return;
                    }
                    if (bedfile.getAbsolutePath().endsWith(".gz")) {
                        tabix = true;
                        tabixReader = new TabixReader(bedfile.getCanonicalPath());
                    } else {
                        bedfilereader = new BufferedReader(new FileReader(bedfile));
                    }
                    tempVector = Collections.synchronizedList(new ArrayList());
                    while (true) {
                        String[] split;
                        block36: {
                            block34: {
                                block37: {
                                    block35: {
                                        String line;
                                        if ((line = tabix != false ? tabixReader.readLine() : bedfilereader.readLine()) == null) {
                                            if (bedfilereader != null) {
                                                break;
                                            }
                                            break block31;
                                        }
                                        if (line.startsWith("#") || (split = line.split("\\t+")).length < 3 || split[0].equals("chr")) continue;
                                        if (split[0].matches("(chr)?\\d+")) break block34;
                                        if (!split[0].contains("X")) break block35;
                                        split[0] = "" + Main.chromModel.getIndexOf("X");
                                        break block36;
                                    }
                                    if (!split[0].contains("Y")) break block37;
                                    split[0] = "" + Main.chromModel.getIndexOf("Y");
                                    break block36;
                                }
                                if (!split[0].matches("(chr)?MT?")) continue;
                                if (Main.chromModel.getIndexOf("MT") > -1) {
                                    split[0] = "" + Main.chromModel.getIndexOf("MT");
                                    break block36;
                                } else if (Main.chromModel.getIndexOf("M") > -1) {
                                    split[0] = "" + Main.chromModel.getIndexOf("M");
                                }
                                break block36;
                            }
                            if (split[0].contains("hr")) {
                                split[0] = split[0].substring(3);
                            }
                        }
                        split[0] = "" + (Integer.parseInt(split[0]) - 1);
                        String[] add = new String[]{split[0], split[1], split[2]};
                        tempVector.add(add);
                    }
                    bedfilereader.close();
                }
                Collections.sort(tempVector, new MethodLibrary.BEDSorter());
                mergeVector = Collections.synchronizedList(new ArrayList());
                int[] adderi = new int[3];
                mergeVector.add(adderi);
                int start = 0;
                int end = 0;
                int chrom = 0;
                int size = 0;
                boolean first = true;
                int i = 0;
                while (true) {
                    int[] add;
                    int index;
                    block32: {
                        if (i >= tempVector.size()) {
                            endchrom = chrom;
                            endpos = end;
                            mergeVector.remove(0);
                            output.setEnabled(true);
                            execute.setEnabled(true);
                            this.cancel.setEnabled(true);
                            this.fileLabel.setText(bedfile.getName() + " | region size: " + size);
                            return;
                        }
                        chrom = Integer.parseInt(((String[])tempVector.get(i))[0]);
                        start = Integer.parseInt(((String[])tempVector.get(i))[1]);
                        if (first) {
                            startchrom = chrom;
                            startpos = start;
                            first = false;
                        }
                        end = Integer.parseInt(((String[])tempVector.get(i))[2]);
                        index = mergeVector.size() - 1;
                        if (start > mergeVector.get(index)[2]) {
                            add = new int[]{chrom, start, end};
                            mergeVector.add(add);
                            size += end - start;
                        } else {
                            while (true) {
                                if (start > mergeVector.get(index)[1] || chrom != mergeVector.get(index)[0]) {
                                    if (start >= mergeVector.get(index)[2]) break;
                                    if (end > mergeVector.get(index)[2]) {
                                        Average.mergeVector.get((int)index)[2] = end;
                                    }
                                    break block32;
                                }
                                if (start <= mergeVector.get(index)[1] && end >= mergeVector.get(index)[1]) {
                                    if (end > mergeVector.get(index)[2]) {
                                        mergeVector.remove(index);
                                    } else {
                                        end = mergeVector.get(index)[2];
                                        mergeVector.remove(index);
                                    }
                                }
                                --index;
                            }
                            add = new int[]{chrom, start, end};
                            mergeVector.add(index + 1, add);
                            size += end - start;
                        }
                    }
                    if (chrom != mergeVector.get(index)[0]) {
                        add = new int[]{chrom, start, end};
                        size += end - start;
                        mergeVector.add(index + 1, add);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (e.getSource() == execute) {
            execute.setEnabled(false);
            openbutton.setEnabled(false);
            output.setEnabled(false);
            Main.cancel = false;
            runner run = new runner();
            model.setValueAt("0%", 0, 3);
            run.execute();
            return;
        }
        if (e.getSource() == this.cancel) {
            Main.cancel = true;
            return;
        }
        if (e.getSource() != output) return;
        try {
            String outfilename = "";
            FileDialog fs = new FileDialog((Frame)frame, "Save output file to...", 1);
            fs.setDirectory(Main.savedir);
            fs.setFile("*.tsv");
            fs.setVisible(true);
            String filename = fs.getFile();
            if (filename == null) return;
            outfilename = String.valueOf(fs.getDirectory()) + "/" + filename;
            Main.savedir = fs.getDirectory();
            Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
            File outfile = new File(outfilename);
            BufferedWriter output = new BufferedWriter(new FileWriter(outfile));
            output.write("#" + this.fileLabel.getText() + "\n");
            System.out.println(this.fileLabel.getText());
            output.write("#Sample\tAverage coverage\tAverage mapping quality\tSoft clip rate\tZero quality rate\tCovered (%) (Coverage : Percentage)\n");
            int j = 0;
            while (true) {
                if (j >= model.getRowCount()) {
                    output.close();
                    return;
                }
                if (model.getValueAt(j, 1) != null) {
                    output.write(String.valueOf(model.getValueAt(j, 0).toString()) + "\t" + model.getValueAt(j, 1).toString() + "\t" + model.getValueAt(j, 2).toString() + "\t" + model.getValueAt(j, 3).toString() + "\t" + model.getValueAt(j, 4).toString() + "\t" + model.getValueAt(j, 5).toString() + "\n");
                }
                ++j;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().contains(".bed") && !file.getName().contains(".tbi");
        }

        @Override
        public String getDescription() {
            return "*.bed";
        }
    }

    public static class runner
    extends SwingWorker<String, Object> {
        @Override
        protected String doInBackground() {
            if (smallregion.isSelected()) {
                Average.calcAverageRegions();
            } else {
                Average.calcAverage();
            }
            execute.setEnabled(true);
            output.setEnabled(true);
            openbutton.setEnabled(true);
            return "";
        }
    }
}

