/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF3Parser
implements VCFLineParser {
    VCF3Parser() {
    }

    @Override
    public Map<String, String> parseLine(String valueLine, List<String> expectedTagOrder, List<String> recommendedTags) {
        if (!recommendedTags.isEmpty()) {
            throw new TribbleException.InternalCodecException("Recommended tags are not allowed in VCFv3.x");
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int tagIndex = 0;
        boolean inQuote = false;
        char[] cArray = valueLine.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    inQuote = !inQuote;
                    break;
                }
                case ',': {
                    if (!inQuote) {
                        ret.put(expectedTagOrder.get(tagIndex++), builder.toString());
                        builder = new StringBuilder();
                        break;
                    }
                }
                default: {
                    builder.append(c);
                }
            }
            ++index;
            ++n2;
        }
        ret.put(expectedTagOrder.get(tagIndex++), builder.toString());
        index = 0;
        if (tagIndex != expectedTagOrder.size()) {
            throw new IllegalArgumentException("Unexpected tag count " + tagIndex + ", we expected " + expectedTagOrder.size());
        }
        for (String str : ret.keySet()) {
            if (!expectedTagOrder.get(index).equals(str)) {
                throw new IllegalArgumentException("Unexpected tag " + str + " in string " + valueLine);
            }
            ++index;
        }
        return ret;
    }
}

