/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util.popgen;

public final class HardyWeinbergCalculation {
    private HardyWeinbergCalculation() {
    }

    public static double hwCalculate(int obsAA, int obsAB, int obsBB) {
        int diplotypes = obsAA + obsAB + obsBB;
        int rare = obsAA * 2 + obsAB;
        int hets = obsAB;
        if (rare > diplotypes) {
            rare = 2 * diplotypes - rare;
        }
        if (hets > rare) {
            return -1.0;
        }
        double[] tailProbs = new double[rare + 1];
        int z = 0;
        while (z < tailProbs.length) {
            tailProbs[z] = 0.0;
            ++z;
        }
        int mid = (int)((long)rare * (long)(2 * diplotypes - rare) / (long)(2 * diplotypes));
        if ((rare & 1 ^ mid & 1) != 0) {
            ++mid;
        }
        int het = mid;
        int hom_r = (rare - mid) / 2;
        int hom_c = diplotypes - het - hom_r;
        tailProbs[mid] = 1.0;
        double sum = tailProbs[mid];
        het = mid;
        while (het > 1) {
            tailProbs[het - 2] = tailProbs[het] * (double)het * ((double)het - 1.0) / (4.0 * ((double)hom_r + 1.0) * ((double)hom_c + 1.0));
            sum += tailProbs[het - 2];
            ++hom_r;
            ++hom_c;
            het -= 2;
        }
        het = mid;
        hom_r = (rare - mid) / 2;
        hom_c = diplotypes - het - hom_r;
        het = mid;
        while (het <= rare - 2) {
            tailProbs[het + 2] = tailProbs[het] * 4.0 * (double)hom_r * (double)hom_c / (((double)het + 2.0) * ((double)het + 1.0));
            sum += tailProbs[het + 2];
            --hom_r;
            --hom_c;
            het += 2;
        }
        int z2 = 0;
        while (z2 < tailProbs.length) {
            int n = z2++;
            tailProbs[n] = tailProbs[n] / sum;
        }
        double top = tailProbs[hets];
        int i = hets + 1;
        while (i <= rare) {
            top += tailProbs[i];
            ++i;
        }
        double otherSide = tailProbs[hets];
        int i2 = hets - 1;
        while (i2 >= 0) {
            otherSide += tailProbs[i2];
            --i2;
        }
        if (top > 0.5 && otherSide > 0.5) {
            return 1.0;
        }
        if (top < otherSide) {
            return top * 2.0;
        }
        return otherSide * 2.0;
    }
}

