/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.linear;

import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.linear.LinearIndex;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;

public class LinearIndexCreator
extends TribbleIndexCreator {
    public static final int DEFAULT_BIN_WIDTH = 8000;
    private int binWidth = 8000;
    private final Path inputFile;
    private final LinkedList<LinearIndex.ChrIndex> chrList = new LinkedList();
    private int longestFeature = 0;
    private final ArrayList<Block> blocks = new ArrayList();

    public LinearIndexCreator(Path inputPath, int binSize) {
        this.inputFile = inputPath;
        this.binWidth = binSize;
    }

    public LinearIndexCreator(File inputFile, int binSize) {
        this(IOUtil.toPath(inputFile), binSize);
    }

    public LinearIndexCreator(File inputFile) {
        this(IOUtil.toPath(inputFile));
    }

    public LinearIndexCreator(Path inputPath) {
        this(inputPath, 8000);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        if (this.chrList.isEmpty() || !this.chrList.getLast().getName().equals(feature.getContig())) {
            if (!this.chrList.isEmpty()) {
                int x = 0;
                while (x < this.blocks.size()) {
                    this.blocks.get(x).setEndPosition(x + 1 == this.blocks.size() ? filePosition : this.blocks.get(x + 1).getStartPosition());
                    this.chrList.getLast().addBlock(this.blocks.get(x));
                    ++x;
                }
            }
            this.chrList.add(new LinearIndex.ChrIndex(feature.getContig(), this.binWidth));
            this.blocks.clear();
            this.blocks.add(new Block(filePosition, 0L));
            this.longestFeature = 0;
        }
        while (feature.getStart() > this.blocks.size() * this.binWidth) {
            this.blocks.add(new Block(filePosition, 0L));
        }
        if (feature.getEnd() - feature.getStart() + 1 > this.longestFeature) {
            this.longestFeature = feature.getEnd() - feature.getStart() + 1;
            this.chrList.getLast().updateLongestFeature(this.longestFeature);
        }
        this.chrList.getLast().incrementFeatureCount();
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        if (finalFilePosition == 0L) {
            throw new IllegalArgumentException("finalFilePosition != 0, -> " + finalFilePosition);
        }
        int x = 0;
        while (x < this.blocks.size()) {
            this.blocks.get(x).setEndPosition(x + 1 == this.blocks.size() ? finalFilePosition : this.blocks.get(x + 1).getStartPosition());
            this.chrList.getLast().addBlock(this.blocks.get(x));
            ++x;
        }
        this.blocks.clear();
        LinearIndex index = new LinearIndex(this.chrList, this.inputFile);
        index.addProperties(this.properties);
        index.finalizeIndex();
        return index.optimize();
    }

    public int defaultBinSize() {
        return 8000;
    }

    public int getBinSize() {
        return this.binWidth;
    }
}

