/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.example;

import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;

public class ProfileIndexReading {
    public static void main(String[] args) {
        if (args.length < 2) {
            ProfileIndexReading.printUsage();
        }
        int iterations = Integer.parseInt(args[0]);
        int j = 1;
        while (j < args.length) {
            String indexFile = args[j];
            System.out.printf("Reading %s%n", indexFile);
            long startTime = System.currentTimeMillis();
            int i = 0;
            while (i < iterations) {
                System.out.printf("  iteration %d%n", i);
                Index index = IndexFactory.loadIndex(indexFile);
                ++i;
            }
            long stopTime = System.currentTimeMillis();
            System.out.printf("Runtime %s %.2f%n", indexFile, (double)(stopTime - startTime) / 1000.0);
            ++j;
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar ReadIndices.jar iterations index.file...");
        System.exit(1);
    }
}

