/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.readers.SynchronousLineReader;
import htsjdk.tribble.readers.TabixIteratorLineReader;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class TabixFeatureReader<T extends Feature, SOURCE>
extends AbstractFeatureReader<T, SOURCE> {
    TabixReader tabixReader;
    List<String> sequenceNames;

    public TabixFeatureReader(String featureFile, AsciiFeatureCodec codec) throws IOException {
        this(featureFile, null, codec, null, null);
    }

    public TabixFeatureReader(String featureFile, String indexFile, AsciiFeatureCodec codec) throws IOException {
        this(featureFile, indexFile, codec, null, null);
    }

    public TabixFeatureReader(String featureFile, String indexFile, AsciiFeatureCodec codec, Function<SeekableByteChannel, SeekableByteChannel> wrapper, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws IOException {
        super(featureFile, codec, wrapper, indexWrapper);
        this.tabixReader = new TabixReader(this.path, indexFile, wrapper, indexWrapper);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.getChromosomes());
        this.readHeader();
    }

    private void readHeader() throws IOException {
        Object source = null;
        try {
            try {
                source = this.codec.makeSourceFromStream(new PositionalBufferedStream(new BlockCompressedInputStream(SeekableStreamFactory.getInstance().getStreamFor(this.path, this.wrapper))));
                this.header = this.codec.readHeader(source);
            }
            catch (Exception e) {
                throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e.getMessage(), this.path, e);
            }
        }
        finally {
            if (source != null) {
                this.codec.close(source);
            }
        }
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        List<String> mp = this.getSequenceNames();
        if (mp == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find sequence named " + chr + " in the tabix index. ", this.path);
        }
        if (!mp.contains(chr)) {
            return new AbstractFeatureReader.EmptyIterator();
        }
        TabixIteratorLineReader lineReader = new TabixIteratorLineReader(this.tabixReader.query(this.tabixReader.chr2tid(chr), start - 1, end));
        return new FeatureIterator(lineReader, start - 1, end);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        BlockCompressedInputStream is = new BlockCompressedInputStream(SeekableStreamFactory.getInstance().getStreamFor(this.path, this.wrapper));
        PositionalBufferedStream stream = new PositionalBufferedStream(is);
        SynchronousLineReader reader = new SynchronousLineReader(stream);
        return new FeatureIterator(reader, 0, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.tabixReader.close();
    }

    class FeatureIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        private T currentRecord;
        private LineReader lineReader;
        private int start;
        private int end;

        public FeatureIterator(LineReader lineReader, int start, int end) throws IOException {
            this.lineReader = lineReader;
            this.start = start;
            this.end = end;
            this.readNextRecord();
        }

        protected void readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && (nextLine = this.lineReader.readLine()) != null) {
                try {
                    Object f = ((AsciiFeatureCodec)TabixFeatureReader.this.codec).decode(nextLine);
                    if (f == null) continue;
                    if (f.getStart() > this.end) {
                        return;
                    }
                    if (f.getEnd() <= this.start) continue;
                    this.currentRecord = f;
                }
                catch (TribbleException e) {
                    e.setSource(TabixFeatureReader.this.path);
                    throw e;
                }
                catch (NumberFormatException e) {
                    String error = "Error parsing line: " + nextLine;
                    throw new TribbleException.MalformedFeatureFile(error, TabixFeatureReader.this.path, e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e) {
                throw new RuntimeIOException("Unable to read the next record, the last record was at " + ret.getContig() + ":" + ret.getStart() + "-" + ret.getEnd(), e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.lineReader.close();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

