/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.ftp;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FTPClient {
    private Socket commandSocket = null;
    public static final int READ_TIMEOUT = 300000;
    private PrintStream commandStream = null;
    private BufferedReader responseReader = null;
    private InputStream dataStream;
    private String passiveHost;
    private int passivePort;
    long restPosition = -1L;
    String host;

    public FTPReply connect(String host) throws IOException {
        this.host = host;
        this.commandSocket = new Socket(host, 21);
        this.commandSocket.setSoTimeout(300000);
        this.commandStream = new PrintStream(this.commandSocket.getOutputStream());
        this.responseReader = new BufferedReader(new InputStreamReader(this.commandSocket.getInputStream()));
        FTPReply reply = new FTPReply(this.responseReader);
        if (!reply.isPositiveCompletion()) {
            this.disconnect();
        }
        return reply;
    }

    public FTPReply executeCommand(String command) throws IOException {
        this.commandStream.println(command);
        return new FTPReply(this.responseReader);
    }

    public FTPReply login(String username, String password) throws IOException {
        FTPReply response = this.executeCommand("user " + username);
        if (!response.isPositiveIntermediate()) {
            return response;
        }
        response = this.executeCommand("pass " + password);
        return response;
    }

    public FTPReply quit() throws IOException {
        return this.executeCommand("QUIT");
    }

    public FTPReply binary() throws IOException {
        return this.executeCommand("TYPE I");
    }

    public FTPReply pasv() throws IOException {
        FTPReply reply = this.executeCommand("PASV");
        if (reply.getCode() == 226 || reply.getCode() == 426) {
            reply = this.getReply();
        }
        String response = reply.getReplyString();
        int code = reply.getCode();
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                this.passiveHost = String.valueOf(tokenizer.nextToken()) + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                this.passivePort = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                throw new IOException("SimpleFTP received bad data link information: " + response);
            }
            catch (NoSuchElementException e) {
                throw new IOException("SimpleFTP received bad data link information: " + response);
            }
        }
        if (reply.isPositiveCompletion() && this.dataStream == null) {
            Socket dataSocket = new Socket(this.passiveHost, this.passivePort);
            dataSocket.setSoTimeout(300000);
            this.dataStream = new SocketInputStream(dataSocket, dataSocket.getInputStream());
        }
        return reply;
    }

    public void setRestPosition(long position) {
        this.restPosition = position;
    }

    public FTPReply retr(String file) throws IOException {
        FTPReply restReply;
        if (this.restPosition >= 0L && !(restReply = this.executeCommand("REST " + this.restPosition)).isSuccess()) {
            return restReply;
        }
        return this.executeCommand("RETR " + file);
    }

    public FTPReply getReply() throws IOException {
        return new FTPReply(this.responseReader);
    }

    public FTPReply size(String file) throws IOException {
        return this.executeCommand("SIZE " + file);
    }

    public InputStream getDataStream() throws IOException {
        return this.dataStream;
    }

    public void closeDataStream() throws IOException {
        if (this.dataStream != null) {
            this.dataStream.close();
            this.dataStream = null;
        }
    }

    public void disconnect() {
        try {
            if (this.commandStream != null) {
                this.commandStream.close();
                this.responseReader.close();
                this.commandSocket.close();
                if (this.dataStream != null) {
                    this.dataStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SAMException("Error disconnecting", e);
        }
        this.commandStream = null;
        this.responseReader = null;
        this.commandSocket = null;
    }

    class SocketInputStream
    extends FilterInputStream {
        Socket socket;

        SocketInputStream(Socket socket, InputStream inputStream) {
            super(inputStream);
            this.socket = socket;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.socket.close();
            FTPClient.this.dataStream = null;
        }
    }
}

