/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

public class SolexaQualityConverter {
    public static final int SOLEXA_ADDEND = 64;
    public static final int PHRED_ADDEND = 33;
    public static final int ILLUMINA_TO_PHRED_SUBTRAHEND = 31;
    private static SolexaQualityConverter singleton = null;
    private final byte[] phredScore = new byte[256];

    public static synchronized SolexaQualityConverter getSingleton() {
        if (singleton == null) {
            singleton = new SolexaQualityConverter();
        }
        return singleton;
    }

    private SolexaQualityConverter() {
        int i = 0;
        while (i < 64) {
            this.phredScore[i] = 0;
            ++i;
        }
        i = 64;
        while (i < this.phredScore.length) {
            this.phredScore[i] = this.convertSolexaQualityCharToPhredBinary(i);
            ++i;
        }
    }

    private byte convertSolexaQualityCharToPhredBinary(int solexaQuality) {
        return (byte)Math.round(10.0 * Math.log10(1.0 + Math.pow(10.0, (double)(solexaQuality - 64) / 10.0)));
    }

    public byte solexaCharToPhredBinary(byte solexaQuality) {
        return this.phredScore[solexaQuality];
    }

    public byte[] getSolexaToPhredConversionTable() {
        return this.phredScore;
    }

    public void convertSolexaQualityCharsToPhredBinary(byte[] solexaQuals) {
        int i = 0;
        while (i < solexaQuals.length) {
            solexaQuals[i] = this.phredScore[solexaQuals[i]];
            ++i;
        }
    }

    public void convertSolexaQualityCharsToPhredChars(byte[] solexaQuals) {
        int i = 0;
        while (i < solexaQuals.length) {
            solexaQuals[i] = (byte)(this.phredScore[solexaQuals[i]] + 33 & 0xFF);
            ++i;
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(byte[] solexaQuals) {
        int i = 0;
        while (i < solexaQuals.length) {
            int n = i++;
            solexaQuals[n] = (byte)(solexaQuals[n] - 64);
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(int offset, int length, byte[] solexaQuals) {
        int limit = offset + length;
        int i = offset;
        while (i < limit) {
            int n = i++;
            solexaQuals[n] = (byte)(solexaQuals[n] - 64);
        }
    }
}

