/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Log {
    private static LogLevel globalLogLevel = LogLevel.INFO;
    private static PrintStream out = System.err;
    private final Class<?> clazz;
    private final String className;

    private Log(Class<?> clazz) {
        this.clazz = clazz;
        this.className = clazz.getSimpleName();
    }

    public static Log getInstance(Class<?> clazz) {
        return new Log(clazz);
    }

    public static void setGlobalLogLevel(LogLevel logLevel) {
        globalLogLevel = logLevel;
    }

    public static LogLevel getGlobalLogLevel() {
        return globalLogLevel;
    }

    public static void setGlobalPrintStream(PrintStream stream) {
        out = stream;
    }

    public static PrintStream getGlobalPrintStream() {
        return out;
    }

    public static final boolean isEnabled(LogLevel level) {
        return level.ordinal() <= globalLogLevel.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(LogLevel level, Throwable throwable, Object ... parts) {
        if (Log.isEnabled(level)) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(level.name()).append('\t').append(this.getTimestamp()).append('\t').append(this.className).append('\t');
            Object[] objectArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                Object part = objectArray[n2];
                if (part != null && part.getClass().isArray()) {
                    Class<?> component = part.getClass().getComponentType();
                    if (component.equals(Boolean.TYPE)) {
                        tmp.append(Arrays.toString((boolean[])part));
                    } else if (component.equals(Byte.TYPE)) {
                        tmp.append(Arrays.toString((byte[])part));
                    } else if (component.equals(Character.TYPE)) {
                        tmp.append(Arrays.toString((char[])part));
                    } else if (component.equals(Double.TYPE)) {
                        tmp.append(Arrays.toString((double[])part));
                    } else if (component.equals(Float.TYPE)) {
                        tmp.append(Arrays.toString((float[])part));
                    } else if (component.equals(Integer.TYPE)) {
                        tmp.append(Arrays.toString((int[])part));
                    } else if (component.equals(Long.TYPE)) {
                        tmp.append(Arrays.toString((long[])part));
                    } else if (component.equals(Short.TYPE)) {
                        tmp.append(Arrays.toString((short[])part));
                    } else {
                        tmp.append(Arrays.toString((Object[])part));
                    }
                } else {
                    tmp.append(part);
                }
                ++n2;
            }
            if (throwable != null) {
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(tmp.toString());
                    throwable.printStackTrace(out);
                }
            } else {
                out.println(tmp.toString());
            }
        }
    }

    protected String getTimestamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fmt.format(new Date());
    }

    public final void error(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.ERROR, throwable, messageParts);
    }

    public final void warn(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.WARNING, throwable, messageParts);
    }

    public final void info(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.INFO, throwable, messageParts);
    }

    public final void debug(Throwable throwable, Object ... messageParts) {
        this.emit(LogLevel.DEBUG, throwable, messageParts);
    }

    public final void error(Object ... messageParts) {
        this.emit(LogLevel.ERROR, null, messageParts);
    }

    public final void warn(Object ... messageParts) {
        this.emit(LogLevel.WARNING, null, messageParts);
    }

    public final void info(Object ... messageParts) {
        this.emit(LogLevel.INFO, null, messageParts);
    }

    public final void debug(Object ... messageParts) {
        this.emit(LogLevel.DEBUG, null, messageParts);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

