/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.annotation.Strand;
import java.util.Collection;

public class Interval
implements Comparable<Interval>,
Cloneable,
Locatable {
    private final boolean negativeStrand;
    private final String name;
    private final String contig;
    private final int start;
    private final int end;

    public Interval(String sequence, int start, int end) {
        this(sequence, start, end, false, null);
    }

    public Interval(Locatable locatable) {
        this(locatable.getContig(), locatable.getStart(), locatable.getEnd());
    }

    public Interval(String sequence, int start, int end, boolean negative, String name) {
        this.contig = sequence;
        this.start = start;
        this.end = end;
        this.negativeStrand = negative;
        this.name = name;
    }

    @Deprecated
    public String getSequence() {
        return this.getContig();
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public boolean isPositiveStrand() {
        return !this.negativeStrand;
    }

    public Strand getStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.FORWARD;
    }

    public String getName() {
        return this.name;
    }

    public boolean intersects(Interval other) {
        return this.getContig().equals(other.getContig()) && CoordMath.overlaps(this.getStart(), this.getEnd(), other.getStart(), other.getEnd());
    }

    public int getIntersectionLength(Interval other) {
        if (this.intersects(other)) {
            return CoordMath.getOverlap(this.getStart(), this.getEnd(), other.getStart(), other.getEnd());
        }
        return 0;
    }

    public Interval intersect(Interval that) {
        if (!this.intersects(that)) {
            throw new IllegalArgumentException(that + " does not intersect " + this);
        }
        return new Interval(this.getContig(), Math.max(this.getStart(), that.getStart()), Math.min(this.getEnd(), that.getEnd()), this.negativeStrand, String.valueOf(this.name) + " intersection " + that.name);
    }

    public boolean abuts(Interval other) {
        return this.getContig().equals(other.getContig()) && (this.getStart() == other.getEnd() + 1 || other.getStart() == this.getEnd() + 1);
    }

    public int length() {
        return this.getEnd() - this.getStart() + 1;
    }

    public Interval pad(int left, int right) {
        return new Interval(this.getContig(), this.getStart() - left, this.getEnd() + right, this.negativeStrand, this.name);
    }

    public static long countBases(Collection<Interval> intervals) {
        long total = 0L;
        for (Interval i : intervals) {
            total += (long)i.length();
        }
        return total;
    }

    @Override
    public int compareTo(Interval that) {
        if (that == null) {
            return -1;
        }
        int result = this.getContig().compareTo(that.getContig());
        if (result == 0) {
            result = this.getStart() == that.getStart() ? this.getEnd() - that.getEnd() : this.getStart() - that.getStart();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Interval)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Interval that = (Interval)other;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.getContig().hashCode();
        result = 31 * result + this.getStart();
        result = 31 * result + this.getEnd();
        return result;
    }

    public String toString() {
        return String.valueOf(this.getContig()) + ":" + this.getStart() + "-" + this.getEnd() + "\t" + this.getStrand().encode() + "\t" + (this.name == null ? Character.valueOf('.') : this.name);
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new SAMException("That's unpossible", cnse);
        }
    }

    @Override
    public String getContig() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }
}

