/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.CloserUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class FastLineReader
implements Closeable {
    private InputStream in;
    private byte[] fileBuffer = new byte[512000];
    private int nextByte = 0;
    private int numBytes = 0;
    private boolean atEof;

    public FastLineReader(InputStream in) {
        this.in = in;
        this.ensureBufferNotEmpty();
    }

    public boolean eof() {
        return this.atEof;
    }

    public boolean atEoln() {
        return this.ensureBufferNotEmpty() && (this.fileBuffer[this.nextByte] == 10 || this.fileBuffer[this.nextByte] == 13);
    }

    public boolean skipNewlines() {
        boolean sawEoln = false;
        while (this.atEoln()) {
            sawEoln = true;
            ++this.nextByte;
        }
        return sawEoln;
    }

    @Override
    public void close() {
        CloserUtil.close(this.in);
        this.in = null;
        this.fileBuffer = null;
    }

    public byte getByte() {
        byte ret = this.peekByte();
        ++this.nextByte;
        this.ensureBufferNotEmpty();
        return ret;
    }

    public byte peekByte() {
        if (this.eof()) {
            throw new IllegalStateException("Cannot getByte() if EOF.");
        }
        return this.fileBuffer[this.nextByte];
    }

    public int readToEndOfOutputBufferOrEoln(byte[] outputBuffer, int startOutputIndex) {
        int totalGrabbed = 0;
        while (this.ensureBufferNotEmpty()) {
            int startInputIndex = this.nextByte;
            boolean sawNewline = this.advanceToEobOrEoln();
            int lengthOfChunk = this.nextByte - startInputIndex;
            if (lengthOfChunk > outputBuffer.length - (startOutputIndex + totalGrabbed)) {
                lengthOfChunk = outputBuffer.length - (startOutputIndex + totalGrabbed);
                this.nextByte = startInputIndex + lengthOfChunk;
            }
            System.arraycopy(this.fileBuffer, startInputIndex, outputBuffer, startOutputIndex + totalGrabbed, lengthOfChunk);
            if (!sawNewline && (totalGrabbed += lengthOfChunk) < outputBuffer.length - startOutputIndex) continue;
        }
        this.ensureBufferNotEmpty();
        return totalGrabbed;
    }

    private boolean advanceToEobOrEoln() {
        while (this.nextByte < this.numBytes) {
            if (this.atEoln()) {
                return true;
            }
            ++this.nextByte;
        }
        return false;
    }

    private boolean ensureBufferNotEmpty() {
        block3: {
            try {
                if (this.nextByte >= this.numBytes) break block3;
                return true;
            }
            catch (IOException e) {
                throw new SAMException("Exception reading InputStream", e);
            }
        }
        this.nextByte = 0;
        this.numBytes = this.in.read(this.fileBuffer);
        this.atEof = this.numBytes < 1;
        return !this.atEof;
    }
}

