/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.TempStreamFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.stream.Collectors;

public class DiskBackedQueue<E>
implements Queue<E> {
    private final int maxRecordsInRamQueue;
    private final Queue<E> ramRecords;
    private Path diskRecords = null;
    private final TempStreamFactory tempStreamFactory = new TempStreamFactory();
    private OutputStream outputStream = null;
    private InputStream inputStream = null;
    private boolean canAdd = true;
    private int numRecordsOnDisk = 0;
    private E headRecord = null;
    private final List<Path> tmpDirs;
    private final SortingCollection.Codec<E> codec;

    private DiskBackedQueue(SortingCollection.Codec<E> codec, int maxRecordsInRam, List<Path> tmpDirs) {
        if (maxRecordsInRam < 0) {
            throw new IllegalArgumentException("maxRecordsInRamQueue must be >= 0");
        }
        if (tmpDirs == null || tmpDirs.isEmpty()) {
            throw new IllegalArgumentException("At least one temp directory must be provided.");
        }
        for (Path tmpDir : tmpDirs) {
            IOUtil.assertDirectoryIsWritable(tmpDir);
        }
        this.tmpDirs = tmpDirs;
        this.codec = codec;
        this.maxRecordsInRamQueue = maxRecordsInRam == 0 ? 0 : maxRecordsInRam - 1;
        this.ramRecords = new ArrayDeque(this.maxRecordsInRamQueue);
    }

    public static <T> DiskBackedQueue<T> newInstance(SortingCollection.Codec<T> codec, int maxRecordsInRam, List<File> tmpDir) {
        return new DiskBackedQueue<T>(codec, maxRecordsInRam, tmpDir.stream().map(File::toPath).collect(Collectors.toList()));
    }

    public static <T> DiskBackedQueue<T> newInstanceFromPaths(SortingCollection.Codec<T> codec, int maxRecordsInRam, List<Path> tmpDir) {
        return new DiskBackedQueue<T>(codec, maxRecordsInRam, tmpDir);
    }

    public boolean canAdd() {
        return this.canAdd;
    }

    public int getNumRecordsOnDisk() {
        return this.numRecordsOnDisk;
    }

    public boolean headRecordIsFromDisk() {
        return !this.canAdd;
    }

    @Override
    public boolean add(E record) throws IllegalStateException {
        if (!this.canAdd) {
            throw new IllegalStateException("Cannot add to DiskBackedQueue whose canAdd() method returns false");
        }
        if (this.headRecord == null) {
            if (this.numRecordsOnDisk > 0) {
                throw new SAMException("Head record was null but we have records on disk. Bug!");
            }
            this.headRecord = record;
        } else if (this.ramRecords.size() == this.maxRecordsInRamQueue) {
            this.spillToDisk(record);
        } else {
            if (this.numRecordsOnDisk > 0) {
                throw new SAMException("Trying to add records to RAM but there were records on disk. Bug!");
            }
            this.ramRecords.add(record);
        }
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.canAdd && this.add(e);
    }

    @Override
    public E remove() {
        E element = this.poll();
        if (element == null) {
            throw new NoSuchElementException("Attempting to remove() from empty DiskBackedQueue");
        }
        return element;
    }

    @Override
    public E poll() {
        E outRecord = this.headRecord;
        if (outRecord != null) {
            this.updateQueueHead();
        }
        return outRecord;
    }

    @Override
    public E element() {
        if (this.headRecord != null) {
            return this.headRecord;
        }
        throw new NoSuchElementException("Attempting to element() from empty DiskBackedQueue");
    }

    @Override
    public E peek() {
        return this.headRecord;
    }

    @Override
    public int size() {
        return this.headRecord == null ? 0 : 1 + this.ramRecords.size() + this.numRecordsOnDisk;
    }

    @Override
    public boolean isEmpty() {
        return this.headRecord == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            for (E element : c) {
                this.add(element);
            }
            return true;
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Cannot add to DiskBackedQueue whose canAdd() method returns false", e);
        }
    }

    @Override
    public void clear() {
        this.headRecord = null;
        this.ramRecords.clear();
        this.closeIOResources();
        this.outputStream = null;
        this.inputStream = null;
        this.diskRecords = null;
        this.canAdd = true;
    }

    protected void finalize() throws Throwable {
        this.closeIOResources();
        super.finalize();
    }

    private void spillToDisk(E record) throws RuntimeIOException {
        try {
            if (this.diskRecords == null) {
                this.diskRecords = this.newTempFile();
                this.outputStream = this.tempStreamFactory.wrapTempOutputStream(Files.newOutputStream(this.diskRecords, new OpenOption[0]), Defaults.BUFFER_SIZE);
                this.codec.setOutputStream(this.outputStream);
            }
            this.codec.encode(record);
            this.outputStream.flush();
            ++this.numRecordsOnDisk;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Problem writing temporary file. Try setting TMP_DIR to a file system with lots of space.", e);
        }
    }

    private Path newTempFile() throws IOException {
        return IOUtil.newTempPath("diskbackedqueue.", ".tmp", this.tmpDirs.toArray(new Path[this.tmpDirs.size()]), 0x140000000L);
    }

    private void updateQueueHead() {
        if (!this.ramRecords.isEmpty()) {
            this.headRecord = this.ramRecords.poll();
            if (this.numRecordsOnDisk > 0) {
                this.canAdd = false;
            }
        } else if (this.diskRecords != null) {
            this.headRecord = this.readFileRecord(this.diskRecords);
            this.canAdd = false;
        } else {
            this.canAdd = true;
            this.headRecord = null;
        }
    }

    private E readFileRecord(Path file) {
        if (this.canAdd) {
            this.canAdd = false;
        }
        if (file == null) {
            throw new IllegalStateException("The file to read from was null");
        }
        try {
            E record;
            if (this.inputStream == null) {
                this.inputStream = Files.newInputStream(file, new OpenOption[0]);
                this.codec.setInputStream(this.tempStreamFactory.wrapTempInputStream(this.inputStream, Defaults.BUFFER_SIZE));
            }
            if ((record = this.codec.decode()) != null) {
                --this.numRecordsOnDisk;
            }
            return record;
        }
        catch (IOException e) {
            throw new RuntimeIOException("DiskBackedQueue encountered an error reading from a file", e);
        }
    }

    private void closeIOResources() {
        CloserUtil.close(this.outputStream);
        CloserUtil.close(this.inputStream);
        if (this.diskRecords != null) {
            IOUtil.deletePaths((Iterable<Path>)this.diskRecords);
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support remove(Object o)");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support removeAll(Collection<?> c)");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support retainAll(Collection<?> c)");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support contains(Object o)");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support containsAll(Collection<?> c)");
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("DiskBackedQueue does not support iterator()");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("DiskBackedQueue does not support toArray()");
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException("DiskBackedQueue does not support toArray(T1[] a)");
    }
}

