/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncBufferedIterator<T>
implements CloseableIterator<T> {
    private static final Log log = Log.getInstance(AsyncBufferedIterator.class);
    private static final AtomicInteger threadsCreated = new AtomicInteger(0);
    private final int bufferSize;
    private Thread backgroundThread;
    private final Iterator<T> underlyingIterator;
    private final BlockingQueue<IteratorBuffer<T>> buffers;
    private IteratorBuffer<T> currentBlock = new IteratorBuffer(Collections.emptyList());

    public AsyncBufferedIterator(Iterator<T> iterator, int bufferSize) {
        this(iterator, bufferSize, 1, null);
    }

    public AsyncBufferedIterator(Iterator<T> iterator, int bufferSize, int bufferCount) {
        this(iterator, bufferSize, bufferCount, null);
    }

    public AsyncBufferedIterator(Iterator<T> iterator, int bufferSize, int bufferCount, String threadName) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator cannot be null");
        }
        if (bufferCount <= 0) {
            throw new IllegalArgumentException("Must use at least 1 buffer.");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be at least 1 record.");
        }
        this.underlyingIterator = iterator;
        this.buffers = new ArrayBlockingQueue<IteratorBuffer<T>>(bufferCount);
        this.bufferSize = bufferSize;
        int threadNumber = threadsCreated.incrementAndGet();
        this.backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AsyncBufferedIterator.this.backgroundRun();
            }
        }, threadName != null ? threadName : String.valueOf(this.getThreadNamePrefix()) + threadNumber);
        this.backgroundThread.setDaemon(true);
        log.debug("Starting thread " + this.backgroundThread.getName());
        this.backgroundThread.start();
    }

    protected String getThreadNamePrefix() {
        return AsyncBufferedIterator.class.getSimpleName();
    }

    @Override
    public void close() {
        if (this.backgroundThread != null) {
            try {
                try {
                    this.backgroundThread.interrupt();
                    this.buffers.clear();
                    this.backgroundThread.join();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Interrupted waiting for background thread to complete", ie);
                }
            }
            finally {
                CloserUtil.close(this.underlyingIterator);
                this.backgroundThread = null;
                this.currentBlock = null;
            }
        }
    }

    private void ensureHasNext() {
        if (!this.currentBlock.hasNext()) {
            this.raiseBackgroundThreadException();
            if (!this.currentBlock.isEndOfStream()) {
                try {
                    this.currentBlock = this.buffers.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Error reading from background thread", e);
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.backgroundThread == null) {
            throw new IllegalStateException("iterator has been closed");
        }
        this.ensureHasNext();
        return this.currentBlock.hasNext();
    }

    private void raiseBackgroundThreadException() throws Error {
        Throwable t = this.currentBlock.getException();
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.currentBlock.next();
        }
        throw new NoSuchElementException("next");
    }

    private IteratorBuffer<T> readAhead() {
        ArrayList<T> readAhead = null;
        try {
            if (!this.underlyingIterator.hasNext()) {
                return new IteratorBuffer();
            }
            readAhead = new ArrayList<T>(this.bufferSize);
            int i = 0;
            while (i < this.bufferSize && this.underlyingIterator.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    return new IteratorBuffer(readAhead, new InterruptedException());
                }
                readAhead.add(this.underlyingIterator.next());
                ++i;
            }
            return new IteratorBuffer(readAhead);
        }
        catch (Throwable t) {
            return new IteratorBuffer(readAhead, t);
        }
    }

    private void backgroundRun() {
        try {
            IteratorBuffer<T> block;
            do {
                if ((block = this.readAhead()).getException() instanceof InterruptedException) {
                    return;
                }
                this.buffers.put(block);
            } while (!block.isEndOfStream());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class IteratorBuffer<U>
    implements Iterator<U> {
        private final Throwable exception;
        private final Iterator<U> it;

        public IteratorBuffer(Iterable<U> it) {
            this.it = it != null ? it.iterator() : null;
            this.exception = null;
        }

        public IteratorBuffer(Iterable<U> it, Throwable exception) {
            this.it = it != null ? it.iterator() : null;
            this.exception = exception;
        }

        public IteratorBuffer() {
            this.it = null;
            this.exception = null;
        }

        @Override
        public boolean hasNext() {
            return this.it != null && this.it.hasNext();
        }

        @Override
        public U next() {
            return this.it.next();
        }

        public boolean isEndOfStream() {
            return this.it == null;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

