/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFTPStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.util.function.Function;

public class SeekableStreamFactory {
    private static final ISeekableStreamFactory DEFAULT_FACTORY;
    private static ISeekableStreamFactory currentFactory;

    static {
        currentFactory = DEFAULT_FACTORY = new DefaultSeekableStreamFactory();
    }

    private SeekableStreamFactory() {
    }

    public static void setInstance(ISeekableStreamFactory factory) {
        currentFactory = factory;
    }

    public static ISeekableStreamFactory getInstance() {
        return currentFactory;
    }

    public static boolean isFilePath(String path) {
        return !path.startsWith("http:") && !path.startsWith("https:") && !path.startsWith("ftp:");
    }

    private static class DefaultSeekableStreamFactory
    implements ISeekableStreamFactory {
        private DefaultSeekableStreamFactory() {
        }

        @Override
        public SeekableStream getStreamFor(URL url) throws IOException {
            return this.getStreamFor(url.toExternalForm());
        }

        @Override
        public SeekableStream getStreamFor(String path) throws IOException {
            return this.getStreamFor(path, null);
        }

        @Override
        public SeekableStream getStreamFor(String path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
            if (path.startsWith("http:") || path.startsWith("https:")) {
                URL url = new URL(path);
                return new SeekableHTTPStream(url);
            }
            if (path.startsWith("ftp:")) {
                return new SeekableFTPStream(new URL(path));
            }
            if (path.startsWith("file:")) {
                return new SeekableFileStream(new File(new URL(path).getPath()));
            }
            if (IOUtil.hasScheme(path)) {
                return new SeekablePathStream(IOUtil.getPath(path), wrapper);
            }
            return new SeekableFileStream(new File(path));
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream) {
            return this.getBufferedStream(stream, 512000);
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
            if (bufferSize == 0) {
                return stream;
            }
            return new SeekableBufferedStream(stream, bufferSize);
        }
    }
}

