/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.AbstractIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.seekablestream.ReadableSeekableStreamByteChannel;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class IndexedFastaSequenceFile
extends AbstractIndexedFastaSequenceFile {
    private final SeekableByteChannel channel;

    public IndexedFastaSequenceFile(File file, FastaSequenceIndex index) {
        this(IOUtil.toPath(file), index);
    }

    public IndexedFastaSequenceFile(File file) throws FileNotFoundException {
        this(file, new FastaSequenceIndex(IndexedFastaSequenceFile.findRequiredFastaIndexFile(IOUtil.toPath(file))));
    }

    public IndexedFastaSequenceFile(Path path, FastaSequenceIndex index) {
        super(path, index);
        try {
            if (IOUtil.isBlockCompressed(path, true)) {
                throw new SAMException("Indexed block-compressed FASTA file cannot be handled: " + path);
            }
            this.channel = Files.newByteChannel(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SAMException("FASTA file should be readable but is not: " + path, e);
        }
    }

    public IndexedFastaSequenceFile(Path path) throws FileNotFoundException {
        this(path, new FastaSequenceIndex(IndexedFastaSequenceFile.findRequiredFastaIndexFile(path)));
    }

    public IndexedFastaSequenceFile(String source, SeekableStream in, FastaSequenceIndex index, SAMSequenceDictionary dictionary) {
        super(source, index, dictionary);
        this.channel = new ReadableSeekableStreamByteChannel(in);
    }

    @Deprecated
    public static boolean canCreateIndexedFastaReader(File fastaFile) {
        return IndexedFastaSequenceFile.canCreateIndexedFastaReader(fastaFile.toPath());
    }

    @Deprecated
    public static boolean canCreateIndexedFastaReader(Path fastaFile) {
        block3: {
            try {
                if (!IOUtil.isBlockCompressed(fastaFile, true)) break block3;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return Files.exists(fastaFile, new LinkOption[0]) && IndexedFastaSequenceFile.findFastaIndex(fastaFile) != null;
    }

    @Override
    protected int readFromPosition(ByteBuffer buffer, long position) throws IOException {
        if (this.channel instanceof FileChannel) {
            return ((FileChannel)this.channel).read(buffer, position);
        }
        long oldPos = this.channel.position();
        try {
            this.channel.position(position);
            int n = this.channel.read(buffer);
            return n;
        }
        finally {
            this.channel.position(oldPos);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

