/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.FormatUtil;
import java.lang.reflect.Field;

public class MetricBase {
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        FormatUtil formatter = new FormatUtil();
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object rhs;
            Object lhs;
            block8: {
                Field f = fieldArray[n2];
                try {
                    lhs = f.get(this);
                    rhs = f.get(o);
                    if (lhs != null) break block8;
                    if (rhs != null) {
                        return false;
                    }
                }
                catch (IllegalAccessException iae) {
                    throw new SAMException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
                }
            }
            if (!formatter.format(lhs).equals(formatter.format(rhs))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        FormatUtil formatter = new FormatUtil();
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                Object value = f.get(this);
                value = formatter.format(value);
                int fieldHash = value != null ? value.hashCode() : 0;
                result = 31 * result + fieldHash;
            }
            catch (IllegalAccessException e) {
                throw new SAMException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        FormatUtil formatter = new FormatUtil();
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                buffer.append(f.getName());
                buffer.append('\t');
                buffer.append(formatter.format(f.get(this)));
                buffer.append('\n');
            }
            catch (IllegalAccessException iae) {
                throw new SAMException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
            }
            ++n2;
        }
        return buffer.toString();
    }
}

