/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataSeriesWriter;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CramRecordWriter {
    private final DataSeriesWriter<Integer> bitFlagsC;
    private final DataSeriesWriter<Byte> compBitFlagsC;
    private final DataSeriesWriter<Integer> readLengthC;
    private final DataSeriesWriter<Integer> alStartC;
    private final DataSeriesWriter<Integer> readGroupC;
    private final DataSeriesWriter<byte[]> readNameC;
    private final DataSeriesWriter<Integer> distanceC;
    private final Map<Integer, DataSeriesWriter<byte[]>> tagValueCodecs;
    private final DataSeriesWriter<Integer> numberOfReadFeaturesCodec;
    private final DataSeriesWriter<Integer> featurePositionCodec;
    private final DataSeriesWriter<Byte> featuresCodeCodec;
    private final DataSeriesWriter<Byte> baseCodec;
    private final DataSeriesWriter<Byte> qualityScoreCodec;
    private final DataSeriesWriter<byte[]> qualityScoreArrayCodec;
    private final DataSeriesWriter<Byte> baseSubstitutionCodeCodec;
    private final DataSeriesWriter<byte[]> insertionCodec;
    private final DataSeriesWriter<byte[]> softClipCodec;
    private final DataSeriesWriter<Integer> hardClipCodec;
    private final DataSeriesWriter<Integer> paddingCodec;
    private final DataSeriesWriter<Integer> deletionLengthCodec;
    private final DataSeriesWriter<Integer> mappingQualityScoreCodec;
    private final DataSeriesWriter<Byte> mateBitFlagsCodec;
    private final DataSeriesWriter<Integer> nextFragmentReferenceSequenceIDCodec;
    private final DataSeriesWriter<Integer> nextFragmentAlignmentStart;
    private final DataSeriesWriter<Integer> templateSize;
    private final DataSeriesWriter<Integer> tagIdListCodec;
    private final DataSeriesWriter<Integer> refIdCodec;
    private final DataSeriesWriter<Integer> refSkipCodec;
    private final Charset charset = Charset.forName("UTF8");
    private final boolean captureReadNames;
    private final ReferenceContext refContext;
    private final SubstitutionMatrix substitutionMatrix;
    private final boolean AP_delta;
    private final Map<DataSeries, EncodingParams> encodingMap;
    private final BitOutputStream coreBlockOutputStream;
    private final Map<Integer, ByteArrayOutputStream> externalBlockOutputMap;

    public CramRecordWriter(BitOutputStream coreOutputStream, Map<Integer, ByteArrayOutputStream> externalOutputMap, CompressionHeader header, ReferenceContext refContext) {
        this.captureReadNames = header.readNamesIncluded;
        this.refContext = refContext;
        this.substitutionMatrix = header.substitutionMatrix;
        this.AP_delta = header.APDelta;
        this.encodingMap = header.encodingMap;
        this.coreBlockOutputStream = coreOutputStream;
        this.externalBlockOutputMap = externalOutputMap;
        this.bitFlagsC = this.createDataWriter(DataSeries.BF_BitFlags);
        this.compBitFlagsC = this.createDataWriter(DataSeries.CF_CompressionBitFlags);
        this.readLengthC = this.createDataWriter(DataSeries.RL_ReadLength);
        this.alStartC = this.createDataWriter(DataSeries.AP_AlignmentPositionOffset);
        this.readGroupC = this.createDataWriter(DataSeries.RG_ReadGroup);
        this.readNameC = this.createDataWriter(DataSeries.RN_ReadName);
        this.distanceC = this.createDataWriter(DataSeries.NF_RecordsToNextFragment);
        this.numberOfReadFeaturesCodec = this.createDataWriter(DataSeries.FN_NumberOfReadFeatures);
        this.featurePositionCodec = this.createDataWriter(DataSeries.FP_FeaturePosition);
        this.featuresCodeCodec = this.createDataWriter(DataSeries.FC_FeatureCode);
        this.baseCodec = this.createDataWriter(DataSeries.BA_Base);
        this.qualityScoreCodec = this.createDataWriter(DataSeries.QS_QualityScore);
        this.baseSubstitutionCodeCodec = this.createDataWriter(DataSeries.BS_BaseSubstitutionCode);
        this.insertionCodec = this.createDataWriter(DataSeries.IN_Insertion);
        this.softClipCodec = this.createDataWriter(DataSeries.SC_SoftClip);
        this.hardClipCodec = this.createDataWriter(DataSeries.HC_HardClip);
        this.paddingCodec = this.createDataWriter(DataSeries.PD_padding);
        this.deletionLengthCodec = this.createDataWriter(DataSeries.DL_DeletionLength);
        this.mappingQualityScoreCodec = this.createDataWriter(DataSeries.MQ_MappingQualityScore);
        this.mateBitFlagsCodec = this.createDataWriter(DataSeries.MF_MateBitFlags);
        this.nextFragmentReferenceSequenceIDCodec = this.createDataWriter(DataSeries.NS_NextFragmentReferenceSequenceID);
        this.nextFragmentAlignmentStart = this.createDataWriter(DataSeries.NP_NextFragmentAlignmentStart);
        this.templateSize = this.createDataWriter(DataSeries.TS_InsertSize);
        this.tagIdListCodec = this.createDataWriter(DataSeries.TL_TagIdList);
        this.refIdCodec = this.createDataWriter(DataSeries.RI_RefId);
        this.refSkipCodec = this.createDataWriter(DataSeries.RS_RefSkip);
        this.qualityScoreArrayCodec = new DataSeriesWriter(DataSeriesType.BYTE_ARRAY, header.encodingMap.get((Object)DataSeries.QS_QualityScore), coreOutputStream, externalOutputMap);
        this.tagValueCodecs = header.tMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapEntry -> new DataSeriesWriter(DataSeriesType.BYTE_ARRAY, (EncodingParams)mapEntry.getValue(), coreOutputStream, externalOutputMap)));
    }

    private <T> DataSeriesWriter<T> createDataWriter(DataSeries dataSeries) {
        if (this.encodingMap.containsKey((Object)dataSeries)) {
            return new DataSeriesWriter(dataSeries.getType(), this.encodingMap.get((Object)dataSeries), this.coreBlockOutputStream, this.externalBlockOutputMap);
        }
        return null;
    }

    public void writeCramCompressionRecords(List<CramCompressionRecord> records, int initialAlignmentStart) {
        int prevAlignmentStart = initialAlignmentStart;
        for (CramCompressionRecord record : records) {
            this.writeRecord(record, prevAlignmentStart);
            prevAlignmentStart = record.alignmentStart;
        }
    }

    private void writeRecord(CramCompressionRecord r, int prevAlignmentStart) {
        this.bitFlagsC.writeData(r.flags);
        this.compBitFlagsC.writeData(r.getCompressionFlags());
        if (this.refContext.isMultiRef()) {
            this.refIdCodec.writeData(r.sequenceId);
        }
        this.readLengthC.writeData(r.readLength);
        if (this.AP_delta) {
            int alignmentDelta = r.alignmentStart - prevAlignmentStart;
            this.alStartC.writeData(alignmentDelta);
        } else {
            this.alStartC.writeData(r.alignmentStart);
        }
        this.readGroupC.writeData(r.readGroupID);
        if (this.captureReadNames) {
            this.readNameC.writeData(r.readName.getBytes(this.charset));
        }
        if (r.isDetached()) {
            this.mateBitFlagsCodec.writeData(r.getMateFlags());
            if (!this.captureReadNames) {
                this.readNameC.writeData(r.readName.getBytes(this.charset));
            }
            this.nextFragmentReferenceSequenceIDCodec.writeData(r.mateSequenceID);
            this.nextFragmentAlignmentStart.writeData(r.mateAlignmentStart);
            this.templateSize.writeData(r.templateSize);
        } else if (r.isHasMateDownStream()) {
            this.distanceC.writeData(r.recordsToNextFragment);
        }
        this.tagIdListCodec.writeData(r.tagIdsIndex.value);
        if (r.tags != null) {
            int i = 0;
            while (i < r.tags.length) {
                DataSeriesWriter<byte[]> writer = this.tagValueCodecs.get(r.tags[i].keyType3BytesAsInt);
                writer.writeData(r.tags[i].getValueAsByteArray());
                ++i;
            }
        }
        if (!r.isSegmentUnmapped()) {
            this.numberOfReadFeaturesCodec.writeData(r.readFeatures.size());
            int prevPos = 0;
            for (ReadFeature f : r.readFeatures) {
                this.featuresCodeCodec.writeData(f.getOperator());
                this.featurePositionCodec.writeData(f.getPosition() - prevPos);
                prevPos = f.getPosition();
                switch (f.getOperator()) {
                    case 66: {
                        ReadBase rb = (ReadBase)f;
                        this.baseCodec.writeData(rb.getBase());
                        this.qualityScoreCodec.writeData(rb.getQualityScore());
                        break;
                    }
                    case 88: {
                        Substitution sv = (Substitution)f;
                        if (sv.getCode() < 0) {
                            this.baseSubstitutionCodeCodec.writeData(this.substitutionMatrix.code(sv.getReferenceBase(), sv.getBase()));
                            break;
                        }
                        this.baseSubstitutionCodeCodec.writeData(sv.getCode());
                        break;
                    }
                    case 73: {
                        Insertion iv = (Insertion)f;
                        this.insertionCodec.writeData(iv.getSequence());
                        break;
                    }
                    case 83: {
                        SoftClip fv = (SoftClip)f;
                        this.softClipCodec.writeData(fv.getSequence());
                        break;
                    }
                    case 72: {
                        HardClip hv = (HardClip)f;
                        this.hardClipCodec.writeData(hv.getLength());
                        break;
                    }
                    case 80: {
                        Padding pv = (Padding)f;
                        this.paddingCodec.writeData(pv.getLength());
                        break;
                    }
                    case 68: {
                        Deletion dv = (Deletion)f;
                        this.deletionLengthCodec.writeData(dv.getLength());
                        break;
                    }
                    case 78: {
                        RefSkip rsv = (RefSkip)f;
                        this.refSkipCodec.writeData(rsv.getLength());
                        break;
                    }
                    case 105: {
                        InsertBase ib = (InsertBase)f;
                        this.baseCodec.writeData(ib.getBase());
                        break;
                    }
                    case 81: {
                        BaseQualityScore bqs = (BaseQualityScore)f;
                        this.qualityScoreCodec.writeData(bqs.getQualityScore());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown read feature operator: " + (char)f.getOperator());
                    }
                }
            }
            this.mappingQualityScoreCodec.writeData(r.mappingQuality);
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.qualityScores);
            }
        } else {
            if (!r.isUnknownBases()) {
                byte[] byArray = r.readBases;
                int n = r.readBases.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    this.baseCodec.writeData(b);
                    ++n2;
                }
            }
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.qualityScores);
            }
        }
    }
}

