/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.external.ByteArrayStopCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class ByteArrayStopEncoding
extends CRAMEncoding<byte[]> {
    private final byte stopByte;
    private final int externalId;
    private final ByteBuffer buf;

    public ByteArrayStopEncoding(byte stopByte, int externalId) {
        super(EncodingID.BYTE_ARRAY_STOP);
        this.stopByte = stopByte;
        this.externalId = externalId;
        this.buf = ByteBuffer.allocate(6);
    }

    public static ByteArrayStopEncoding fromParams(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        byte stopByte = buf.get();
        int externalId = ITF8.readUnsignedITF8(buf);
        return new ByteArrayStopEncoding(stopByte, externalId);
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        this.buf.put(this.stopByte);
        ITF8.writeUnsignedITF8(this.externalId, this.buf);
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<byte[]> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        ByteArrayInputStream is = externalBlockInputMap == null ? null : externalBlockInputMap.get(this.externalId);
        ByteArrayOutputStream os = externalBlockOutputMap == null ? null : externalBlockOutputMap.get(this.externalId);
        return new ByteArrayStopCodec(is, os, this.stopByte);
    }
}

