/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class CanonicalHuffmanIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int[] values;
    private final int[] bitLengths;
    private final ByteBuffer buf;

    public CanonicalHuffmanIntegerEncoding(int[] values, int[] bitLengths) {
        super(EncodingID.HUFFMAN);
        this.values = values;
        this.bitLengths = bitLengths;
        this.buf = ByteBuffer.allocate(5 * (values.length + bitLengths.length));
    }

    public static CanonicalHuffmanIntegerEncoding fromParams(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int valueSize = ITF8.readUnsignedITF8(buf);
        int[] values = new int[valueSize];
        int i = 0;
        while (i < valueSize) {
            values[i] = ITF8.readUnsignedITF8(buf);
            ++i;
        }
        int lengthSize = ITF8.readUnsignedITF8(buf);
        int[] bitLengths = new int[lengthSize];
        int i2 = 0;
        while (i2 < lengthSize) {
            bitLengths[i2] = ITF8.readUnsignedITF8(buf);
            ++i2;
        }
        return new CanonicalHuffmanIntegerEncoding(values, bitLengths);
    }

    @Override
    public byte[] toByteArray() {
        int value;
        this.buf.clear();
        ITF8.writeUnsignedITF8(this.values.length, this.buf);
        int[] nArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            value = nArray[n2];
            ITF8.writeUnsignedITF8(value, this.buf);
            ++n2;
        }
        ITF8.writeUnsignedITF8(this.bitLengths.length, this.buf);
        nArray = this.bitLengths;
        n = this.bitLengths.length;
        n2 = 0;
        while (n2 < n) {
            value = nArray[n2];
            ITF8.writeUnsignedITF8(value, this.buf);
            ++n2;
        }
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new CanonicalHuffmanIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.values, this.bitLengths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalHuffmanIntegerEncoding that = (CanonicalHuffmanIntegerEncoding)o;
        return Arrays.equals(this.bitLengths, that.bitLengths) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bitLengths);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

