/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.D04;
import htsjdk.samtools.cram.compression.rans.D14;
import htsjdk.samtools.cram.compression.rans.Decoding;
import htsjdk.samtools.cram.compression.rans.E04;
import htsjdk.samtools.cram.compression.rans.E14;
import htsjdk.samtools.cram.compression.rans.Encoding;
import htsjdk.samtools.cram.compression.rans.Frequencies;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RANS {
    private static final int ORDER_BYTE_LENGTH = 1;
    private static final int COMPRESSED_BYTE_LENGTH = 4;
    private static final int RAW_BYTE_LENGTH = 4;
    private static final int PREFIX_BYTE_LENGTH = 9;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static ByteBuffer uncompress(ByteBuffer in, ByteBuffer out) {
        if (in.remaining() == 0) {
            return ByteBuffer.allocate(0);
        }
        ORDER order = ORDER.fromInt(in.get());
        in.order(ByteOrder.LITTLE_ENDIAN);
        int in_sz = in.getInt();
        if (in_sz != in.remaining() - 4) {
            throw new RuntimeException("Incorrect input length.");
        }
        int out_sz = in.getInt();
        if (out == null) {
            out = ByteBuffer.allocate(out_sz);
        } else {
            out.limit(out_sz);
        }
        if (out.remaining() < out_sz) {
            throw new RuntimeException("Output buffer too small to fit " + out_sz + " bytes.");
        }
        switch (order) {
            case ZERO: {
                return RANS.uncompress_order0_way4(in, out);
            }
            case ONE: {
                return RANS.uncompress_order1_way4(in, out);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)order));
    }

    public static ByteBuffer compress(ByteBuffer in, ORDER order, ByteBuffer out) {
        if (in.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        if (in.remaining() < 4) {
            return RANS.encode_order0_way4(in, out);
        }
        switch (order) {
            case ZERO: {
                return RANS.encode_order0_way4(in, out);
            }
            case ONE: {
                return RANS.encode_order1_way4(in, out);
            }
        }
        throw new RuntimeException("Unknown rANS order: " + (Object)((Object)order));
    }

    private static ByteBuffer allocateIfNeeded(int in_size, ByteBuffer out_buf) {
        int compressedSize = (int)(1.05 * (double)in_size + 198147.0 + 4.0);
        if (out_buf == null) {
            return ByteBuffer.allocate(compressedSize);
        }
        if (out_buf.remaining() < compressedSize) {
            throw new RuntimeException("Insufficient buffer size.");
        }
        out_buf.order(ByteOrder.LITTLE_ENDIAN);
        return out_buf;
    }

    private static ByteBuffer encode_order0_way4(ByteBuffer in, ByteBuffer out_buf) {
        int in_size = in.remaining();
        out_buf = RANS.allocateIfNeeded(in_size, out_buf);
        int freqTableStart = 9;
        out_buf.position(9);
        int[] F = Frequencies.calcFrequencies_o0(in);
        Encoding.RansEncSymbol[] syms = Frequencies.buildSyms_o0(F);
        ByteBuffer cp = out_buf.slice();
        int frequencyTable_size = Frequencies.writeFrequencies_o0(cp, F);
        in.rewind();
        int compressedBlob_size = E04.compress(in, syms, cp);
        RANS.finalizeCompressed(0, out_buf, in_size, frequencyTable_size, compressedBlob_size);
        return out_buf;
    }

    private static ByteBuffer encode_order1_way4(ByteBuffer in, ByteBuffer out_buf) {
        int in_size = in.remaining();
        out_buf = RANS.allocateIfNeeded(in_size, out_buf);
        int freqTableStart = 9;
        out_buf.position(9);
        int[][] F = Frequencies.calcFrequencies_o1(in);
        Encoding.RansEncSymbol[][] syms = Frequencies.buildSyms_o1(F);
        ByteBuffer cp = out_buf.slice();
        int frequencyTable_size = Frequencies.writeFrequencies_o1(cp, F);
        in.rewind();
        int compressedBlob_size = E14.compress(in, syms, cp);
        RANS.finalizeCompressed(1, out_buf, in_size, frequencyTable_size, compressedBlob_size);
        return out_buf;
    }

    private static void finalizeCompressed(int order, ByteBuffer out_buf, int in_size, int frequencyTable_size, int compressedBlob_size) {
        out_buf.limit(9 + frequencyTable_size + compressedBlob_size);
        out_buf.put(0, (byte)order);
        out_buf.order(ByteOrder.LITTLE_ENDIAN);
        boolean compressedSizeOffset = true;
        out_buf.putInt(1, frequencyTable_size + compressedBlob_size);
        int rawSizeOffset = 5;
        out_buf.putInt(5, in_size);
        out_buf.rewind();
    }

    private static ByteBuffer uncompress_order0_way4(ByteBuffer in, ByteBuffer out) {
        in.order(ByteOrder.LITTLE_ENDIAN);
        Decoding.AriDecoder D = new Decoding.AriDecoder();
        Decoding.RansDecSymbol[] syms = new Decoding.RansDecSymbol[256];
        int i = 0;
        while (i < syms.length) {
            syms[i] = new Decoding.RansDecSymbol();
            ++i;
        }
        Frequencies.readStats_o0(in, D, syms);
        D04.uncompress(in, D, syms, out);
        return out;
    }

    private static ByteBuffer uncompress_order1_way4(ByteBuffer in, ByteBuffer out_buf) {
        Decoding.AriDecoder[] D = new Decoding.AriDecoder[256];
        Decoding.RansDecSymbol[][] syms = new Decoding.RansDecSymbol[256][256];
        int i = 0;
        while (i < syms.length) {
            int j = 0;
            while (j < syms[i].length) {
                syms[i][j] = new Decoding.RansDecSymbol();
                ++j;
            }
            ++i;
        }
        Frequencies.readStats_o1(in, D, syms);
        D14.uncompress(in, out_buf, D, syms);
        return out_buf;
    }

    public static enum ORDER {
        ZERO,
        ONE;


        public static ORDER fromInt(int value) {
            try {
                return ORDER.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Unknown rANS order: " + value);
            }
        }
    }
}

