/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.rans.RANS;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class ExternalCompression {
    private static final int GZIP_COMPRESSION_LEVEL = Integer.parseInt(System.getProperty("gzip.compression.level", "5"));

    public static byte[] gzip(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GZIPOutputStream gos = new GZIPOutputStream(byteArrayOutputStream){
                {
                    this.def.setLevel(GZIP_COMPRESSION_LEVEL);
                }
            };){
                IOUtil.copyStream(new ByteArrayInputStream(data), gos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzip(byte[] data) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(data));){
                return InputStreamUtils.readFully(gzipInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static byte[] bzip2(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BZip2CompressorOutputStream bos = new BZip2CompressorOutputStream(byteArrayOutputStream);){
                IOUtil.copyStream(new ByteArrayInputStream(data), bos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unbzip2(byte[] data) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);){
                return InputStreamUtils.readFully(new BZip2CompressorInputStream(byteArrayInputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static byte[] rans(byte[] data, RANS.ORDER order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), order, null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] rans(byte[] data, int order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), RANS.ORDER.fromInt(order), null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] unrans(byte[] data) {
        ByteBuffer buf = RANS.uncompress(ByteBuffer.wrap(data), null);
        return ExternalCompression.toByteArray(buf);
    }

    public static byte[] xz(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(data.length * 2);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XZCompressorOutputStream xzCompressorOutputStream = new XZCompressorOutputStream(byteArrayOutputStream);){
                xzCompressorOutputStream.write(data);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unxz(byte[] data) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XZCompressorInputStream xzCompressorInputStream = new XZCompressorInputStream(new ByteArrayInputStream(data));){
                return InputStreamUtils.readFully(xzCompressorInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] uncompress(BlockCompressionMethod method, byte[] compressedContent) {
        switch (method) {
            case RAW: {
                return compressedContent;
            }
            case GZIP: {
                return ExternalCompression.gunzip(compressedContent);
            }
            case BZIP2: {
                return ExternalCompression.unbzip2(compressedContent);
            }
            case LZMA: {
                return ExternalCompression.unxz(compressedContent);
            }
            case RANS: {
                return ExternalCompression.unrans(compressedContent);
            }
        }
        throw new RuntimeException("Unknown block compression method: " + method.name());
    }
}

