/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CramNormalizer {
    private final SAMFileHeader header;
    private int readCounter = 0;
    private static Log log = Log.getInstance(CramNormalizer.class);
    private CRAMReferenceSource referenceSource;

    private CramNormalizer(SAMFileHeader header) {
        this.header = header;
    }

    public CramNormalizer(SAMFileHeader header, CRAMReferenceSource referenceSource) {
        if (referenceSource == null) {
            throw new IllegalArgumentException("A reference is required.");
        }
        this.header = header;
        this.referenceSource = referenceSource;
    }

    public void normalize(ArrayList<CramCompressionRecord> records, byte[] ref, int refOffset_zeroBased, SubstitutionMatrix substitutionMatrix) {
        int startCounter = this.readCounter;
        for (CramCompressionRecord record : records) {
            record.index = ++this.readCounter;
            if (record.sequenceId == -1) {
                record.sequenceName = "*";
                record.alignmentStart = 0;
                continue;
            }
            record.sequenceName = this.header.getSequence(record.sequenceId).getSequenceName();
        }
        for (CramCompressionRecord record : records) {
            CramCompressionRecord downMate;
            if (!record.isMultiFragment() || record.isDetached()) {
                record.recordsToNextFragment = -1;
                record.next = null;
                record.previous = null;
                continue;
            }
            if (!record.isHasMateDownStream()) continue;
            record.next = downMate = records.get(record.index + record.recordsToNextFragment - startCounter);
            downMate.previous = record;
        }
        for (CramCompressionRecord record : records) {
            if (record.previous != null || record.next == null) continue;
            CramNormalizer.restoreMateInfo(record);
        }
        for (CramCompressionRecord record : records) {
            String name;
            if (record.readName != null) continue;
            String readNamePrefix = "";
            record.readName = name = "" + record.index;
            if (record.next != null) {
                record.next.readName = name;
            }
            if (record.previous == null) continue;
            record.previous.readName = name;
        }
        for (CramCompressionRecord record : records) {
            if (record.isSegmentUnmapped()) continue;
            byte[] refBases = ref;
            if ((ref == null || ref.length == 0) && this.referenceSource != null) {
                refBases = this.referenceSource.getReferenceBases(this.header.getSequence(record.sequenceId), true);
            }
            record.readBases = record.isUnknownBases() ? SAMRecord.NULL_SEQUENCE : CramNormalizer.restoreReadBases(record, refBases, refOffset_zeroBased, substitutionMatrix);
        }
        int defaultQualityScore = 30;
        CramNormalizer.restoreQualityScores((byte)30, records);
    }

    private static void restoreMateInfo(CramCompressionRecord record) {
        int templateLength;
        if (record.next == null) {
            return;
        }
        CramCompressionRecord cur = record;
        while (cur.next != null) {
            CramNormalizer.setNextMate(cur, cur.next);
            cur = cur.next;
        }
        CramCompressionRecord last = cur;
        CramNormalizer.setNextMate(last, record);
        record.templateSize = templateLength = CramNormalizer.computeInsertSize(record, last);
        last.templateSize = -templateLength;
    }

    private static void setNextMate(CramCompressionRecord record, CramCompressionRecord next) {
        record.mateAlignmentStart = next.alignmentStart;
        record.setMateUnmapped(next.isSegmentUnmapped());
        record.setMateNegativeStrand(next.isNegativeStrand());
        record.mateSequenceID = next.sequenceId;
        if (record.mateSequenceID == -1) {
            record.mateAlignmentStart = 0;
        }
    }

    public static void restoreQualityScores(byte defaultQualityScore, List<CramCompressionRecord> records) {
        for (CramCompressionRecord record : records) {
            CramNormalizer.restoreQualityScores(defaultQualityScore, record);
        }
    }

    private static byte[] restoreQualityScores(byte defaultQualityScore, CramCompressionRecord record) {
        if (!record.isForcePreserveQualityScores()) {
            boolean star = true;
            byte[] scores = new byte[record.readLength];
            Arrays.fill(scores, defaultQualityScore);
            if (record.readFeatures != null) {
                for (ReadFeature feature : record.readFeatures) {
                    switch (feature.getOperator()) {
                        case 81: {
                            int pos = feature.getPosition();
                            scores[pos - 1] = ((BaseQualityScore)feature).getQualityScore();
                            star = false;
                            break;
                        }
                        case 66: {
                            int pos = feature.getPosition();
                            scores[pos - 1] = ((ReadBase)feature).getQualityScore();
                            star = false;
                            break;
                        }
                    }
                }
            }
            record.qualityScores = star ? SAMRecord.NULL_QUALS : scores;
        } else {
            byte[] scores = record.qualityScores;
            int missingScores = 0;
            int i = 0;
            while (i < scores.length) {
                if (scores[i] == -1) {
                    scores[i] = defaultQualityScore;
                    ++missingScores;
                }
                ++i;
            }
            if (missingScores == scores.length) {
                record.qualityScores = SAMRecord.NULL_QUALS;
            }
        }
        return record.qualityScores;
    }

    private static byte[] restoreReadBases(CramCompressionRecord record, byte[] ref, int refOffsetZeroBased, SubstitutionMatrix substitutionMatrix) {
        if (record.isUnknownBases() || record.readLength == 0) {
            return SAMRecord.NULL_SEQUENCE;
        }
        int readLength = record.readLength;
        byte[] bases = new byte[readLength];
        int posInRead = 1;
        int alignmentStart = record.alignmentStart - 1;
        int posInSeq = 0;
        if (record.readFeatures == null || record.readFeatures.isEmpty()) {
            if (ref.length + refOffsetZeroBased < alignmentStart + bases.length) {
                Arrays.fill(bases, (byte)78);
                System.arraycopy(ref, alignmentStart - refOffsetZeroBased, bases, 0, Math.min(bases.length, ref.length + refOffsetZeroBased - alignmentStart));
            } else {
                System.arraycopy(ref, alignmentStart - refOffsetZeroBased, bases, 0, bases.length);
            }
            return SequenceUtil.toBamReadBasesInPlace(bases);
        }
        List<ReadFeature> variations = record.readFeatures;
        block11: for (ReadFeature variation : variations) {
            while (posInRead < variation.getPosition()) {
                int rp = alignmentStart + posInSeq++ - refOffsetZeroBased;
                bases[posInRead - 1] = CramNormalizer.getByteOrDefault(ref, rp, (byte)78);
                ++posInRead;
            }
            switch (variation.getOperator()) {
                case 88: {
                    Substitution substitution = (Substitution)variation;
                    byte refBase = CramNormalizer.getByteOrDefault(ref, alignmentStart + posInSeq - refOffsetZeroBased, (byte)78);
                    refBase = Utils.normalizeBase(refBase);
                    byte base = substitutionMatrix.base(refBase, substitution.getCode());
                    substitution.setBase(base);
                    substitution.setReferenceBase(refBase);
                    bases[posInRead++ - 1] = base;
                    ++posInSeq;
                    break;
                }
                case 73: {
                    Insertion insertion = (Insertion)variation;
                    int i = 0;
                    while (i < insertion.getSequence().length) {
                        bases[posInRead++ - 1] = insertion.getSequence()[i];
                        ++i;
                    }
                    continue block11;
                }
                case 83: {
                    SoftClip softClip = (SoftClip)variation;
                    int i = 0;
                    while (i < softClip.getSequence().length) {
                        bases[posInRead++ - 1] = softClip.getSequence()[i];
                        ++i;
                    }
                    continue block11;
                }
                case 68: {
                    Deletion deletion = (Deletion)variation;
                    posInSeq += deletion.getLength();
                    break;
                }
                case 105: {
                    InsertBase insert = (InsertBase)variation;
                    bases[posInRead++ - 1] = insert.getBase();
                    break;
                }
                case 78: {
                    posInSeq += ((RefSkip)variation).getLength();
                }
            }
        }
        while (posInRead <= readLength && alignmentStart + posInSeq - refOffsetZeroBased < ref.length) {
            bases[posInRead - 1] = ref[alignmentStart + posInSeq - refOffsetZeroBased];
            ++posInRead;
            ++posInSeq;
        }
        for (ReadFeature variation : variations) {
            switch (variation.getOperator()) {
                case 66: {
                    ReadBase readBase = (ReadBase)variation;
                    bases[variation.getPosition() - 1] = readBase.getBase();
                    break;
                }
            }
        }
        return SequenceUtil.toBamReadBasesInPlace(bases);
    }

    private static byte getByteOrDefault(byte[] array, int pos, byte outOfBoundsValue) {
        if (pos >= array.length) {
            return outOfBoundsValue;
        }
        return array[pos];
    }

    public static int computeInsertSize(CramCompressionRecord firstEnd, CramCompressionRecord secondEnd) {
        if (firstEnd.isSegmentUnmapped() || secondEnd.isSegmentUnmapped()) {
            return 0;
        }
        if (firstEnd.sequenceId != secondEnd.sequenceId) {
            return 0;
        }
        int firstEnd5PrimePosition = firstEnd.isNegativeStrand() ? firstEnd.getAlignmentEnd() : firstEnd.alignmentStart;
        int secondEnd5PrimePosition = secondEnd.isNegativeStrand() ? secondEnd.getAlignmentEnd() : secondEnd.alignmentStart;
        int adjustment = secondEnd5PrimePosition >= firstEnd5PrimePosition ? 1 : -1;
        return secondEnd5PrimePosition - firstEnd5PrimePosition + adjustment;
    }
}

