/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.rans.RANS;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    public static final int BYTE_SPACE_SIZE = 256;
    public static final int ALL_BYTES_USED = -1;
    private static final int[] singleZero = new int[1];
    private final Map<Integer, EncodingDetails> bestEncodings = new HashMap<Integer, EncodingDetails>();
    private final ByteArrayOutputStream baosForTagValues = new ByteArrayOutputStream(0x100000);

    public CompressionHeader build(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix, boolean coordinateSorted) {
        CompressionHeaderBuilder builder = new CompressionHeaderBuilder(coordinateSorted);
        builder.addExternalIntegerRansOrderZeroEncoding(DataSeries.AP_AlignmentPositionOffset);
        builder.addExternalByteRansOrderOneEncoding(DataSeries.BA_Base);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.BF_BitFlags);
        builder.addExternalByteGzipEncoding(DataSeries.BS_BaseSubstitutionCode);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.CF_CompressionBitFlags);
        builder.addExternalIntegerGzipEncoding(DataSeries.DL_DeletionLength);
        builder.addExternalByteGzipEncoding(DataSeries.FC_FeatureCode);
        builder.addExternalIntegerGzipEncoding(DataSeries.FN_NumberOfReadFeatures);
        builder.addExternalIntegerGzipEncoding(DataSeries.FP_FeaturePosition);
        builder.addExternalIntegerGzipEncoding(DataSeries.HC_HardClip);
        builder.addExternalByteArrayStopTabGzipEncoding(DataSeries.IN_Insertion);
        builder.addExternalIntegerGzipEncoding(DataSeries.MF_MateBitFlags);
        builder.addExternalIntegerGzipEncoding(DataSeries.MQ_MappingQualityScore);
        builder.addExternalIntegerGzipEncoding(DataSeries.NF_RecordsToNextFragment);
        builder.addExternalIntegerGzipEncoding(DataSeries.NP_NextFragmentAlignmentStart);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.NS_NextFragmentReferenceSequenceID);
        builder.addExternalIntegerGzipEncoding(DataSeries.PD_padding);
        builder.addExternalByteRansOrderOneEncoding(DataSeries.QS_QualityScore);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.RG_ReadGroup);
        builder.addExternalIntegerRansOrderZeroEncoding(DataSeries.RI_RefId);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.RL_ReadLength);
        builder.addExternalByteArrayStopTabGzipEncoding(DataSeries.RN_ReadName);
        builder.addExternalIntegerGzipEncoding(DataSeries.RS_RefSkip);
        builder.addExternalByteArrayStopTabGzipEncoding(DataSeries.SC_SoftClip);
        builder.addExternalIntegerGzipEncoding(DataSeries.TC_TagCount);
        builder.addExternalIntegerEncoding(DataSeries.TL_TagIdList, ExternalCompressor.createGZIP());
        builder.addExternalIntegerGzipEncoding(DataSeries.TN_TagNameAndType);
        builder.addExternalIntegerRansOrderOneEncoding(DataSeries.TS_InsertSize);
        builder.setTagIdDictionary(CompressionHeaderFactory.buildTagIdDictionary(records));
        this.buildTagEncodings(records, builder);
        if (substitutionMatrix == null) {
            substitutionMatrix = new SubstitutionMatrix(CompressionHeaderFactory.buildFrequencies(records));
            CompressionHeaderFactory.updateSubstitutionCodes(records, substitutionMatrix);
        }
        builder.setSubstitutionMatrix(substitutionMatrix);
        return builder.getHeader();
    }

    private void buildTagEncodings(List<CramCompressionRecord> records, CompressionHeaderBuilder builder) {
        HashSet<Integer> tagIdSet = new HashSet<Integer>();
        for (CramCompressionRecord record : records) {
            if (record.tags == null || record.tags.length == 0) continue;
            ReadTag[] readTagArray = record.tags;
            int n = record.tags.length;
            int n2 = 0;
            while (n2 < n) {
                ReadTag tag = readTagArray[n2];
                tagIdSet.add(tag.keyType3BytesAsInt);
                ++n2;
            }
        }
        Iterator<CramCompressionRecord> iterator = tagIdSet.iterator();
        while (iterator.hasNext()) {
            int tagId = (Integer)((Object)iterator.next());
            if (this.bestEncodings.containsKey(tagId)) {
                builder.addTagEncoding(tagId, this.bestEncodings.get(tagId));
                continue;
            }
            EncodingDetails e = this.buildEncodingForTag(records, tagId);
            builder.addTagEncoding(tagId, e);
            this.bestEncodings.put(tagId, e);
        }
    }

    static void updateSubstitutionCodes(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) {
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                Substitution substitution;
                if (recordFeature.getOperator() != 88 || (substitution = (Substitution)recordFeature).getCode() != -1) continue;
                byte refBase = substitution.getReferenceBase();
                byte base = substitution.getBase();
                substitution.setCode(substitutionMatrix.code(refBase, base));
            }
        }
    }

    static long[][] buildFrequencies(List<CramCompressionRecord> records) {
        long[][] frequencies = new long[256][256];
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature readFeature : record.readFeatures) {
                if (readFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)readFeature;
                byte refBase = substitution.getReferenceBase();
                byte base = substitution.getBase();
                long[] lArray = frequencies[refBase];
                byte by = base;
                lArray[by] = lArray[by] + 1L;
            }
        }
        return frequencies;
    }

    private static byte[][][] buildTagIdDictionary(List<CramCompressionRecord> records) {
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag o1, ReadTag o2) {
                return o1.keyType3BytesAsInt - o2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> baComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length - o2.length != 0) {
                    return o1.length - o2.length;
                }
                int i = 0;
                while (i < o1.length) {
                    if (o1[i] != o2[i]) {
                        return o1[i] - o2[i];
                    }
                    ++i;
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> map = new TreeMap<byte[], MutableInt>(baComparator);
        MutableInt noTagCounter = new MutableInt();
        map.put(new byte[0], noTagCounter);
        for (CramCompressionRecord record : records) {
            if (record.tags == null) {
                ++noTagCounter.value;
                record.tagIdsIndex = noTagCounter;
                continue;
            }
            Arrays.sort(record.tags, comparator);
            record.tagIds = new byte[record.tags.length * 3];
            int tagIndex = 0;
            int i = 0;
            while (i < record.tags.length) {
                record.tagIds[i * 3] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(0);
                record.tagIds[i * 3 + 1] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(1);
                record.tagIds[i * 3 + 2] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(2);
                ++tagIndex;
                ++i;
            }
            MutableInt count = (MutableInt)map.get(record.tagIds);
            if (count == null) {
                count = new MutableInt();
                map.put(record.tagIds, count);
            }
            ++count.value;
            record.tagIdsIndex = count;
        }
        byte[][][] dictionary = new byte[map.size()][][];
        int i = 0;
        for (byte[] idsAsBytes : map.keySet()) {
            int nofIds = idsAsBytes.length / 3;
            dictionary[i] = new byte[nofIds][];
            int j = 0;
            while (j < idsAsBytes.length) {
                int idIndex = j / 3;
                dictionary[i][idIndex] = new byte[3];
                dictionary[i][idIndex][0] = idsAsBytes[j++];
                dictionary[i][idIndex][1] = idsAsBytes[j++];
                dictionary[i][idIndex][2] = idsAsBytes[j++];
            }
            ((MutableInt)map.get((Object)idsAsBytes)).value = i++;
        }
        return dictionary;
    }

    static byte getTagType(int tagID) {
        return (byte)(tagID & 0xFF);
    }

    static ExternalCompressor getBestExternalCompressor(byte[] data) {
        ExternalCompressor rans1;
        int rans1Len;
        ExternalCompressor rans0;
        int rans0Len;
        ExternalCompressor gzip = ExternalCompressor.createGZIP();
        int gzipLen = gzip.compress(data).length;
        int minLen = Math.min(gzipLen, Math.min(rans0Len = (rans0 = ExternalCompressor.createRANS(RANS.ORDER.ZERO)).compress(data).length, rans1Len = (rans1 = ExternalCompressor.createRANS(RANS.ORDER.ONE)).compress(data).length));
        if (minLen == rans0Len) {
            return rans0;
        }
        if (minLen == rans1Len) {
            return rans1;
        }
        return gzip;
    }

    byte[] getDataForTag(List<CramCompressionRecord> records, int tagID) {
        this.baosForTagValues.reset();
        for (CramCompressionRecord record : records) {
            if (record.tags == null) continue;
            ReadTag[] readTagArray = record.tags;
            int n = record.tags.length;
            int n2 = 0;
            while (n2 < n) {
                ReadTag tag = readTagArray[n2];
                if (tag.keyType3BytesAsInt == tagID) {
                    byte[] valueBytes = tag.getValueAsByteArray();
                    try {
                        this.baosForTagValues.write(valueBytes);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
                ++n2;
            }
        }
        return this.baosForTagValues.toByteArray();
    }

    static ByteSizeRange getByteSizeRangeOfTagValues(List<CramCompressionRecord> records, int tagID) {
        byte type = CompressionHeaderFactory.getTagType(tagID);
        ByteSizeRange stats = new ByteSizeRange();
        for (CramCompressionRecord record : records) {
            if (record.tags == null) continue;
            ReadTag[] readTagArray = record.tags;
            int n = record.tags.length;
            int n2 = 0;
            while (n2 < n) {
                ReadTag tag = readTagArray[n2];
                if (tag.keyType3BytesAsInt == tagID) {
                    int size = CompressionHeaderFactory.getTagValueByteSize(type, tag.getValue());
                    if (stats.min > size) {
                        stats.min = size;
                    }
                    if (stats.max < size) {
                        stats.max = size;
                    }
                }
                ++n2;
            }
        }
        return stats;
    }

    static int getUnusedByte(byte[] array) {
        byte[] usage = new byte[256];
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            usage[0xFF & b] = 1;
            ++n2;
        }
        int i = 0;
        while (i < usage.length) {
            if (usage[i] == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private EncodingParams buildTagEncodingForSize(int tagValueSize, int tagID) {
        return new ByteArrayLenEncoding(new CanonicalHuffmanIntegerEncoding(new int[]{tagValueSize}, singleZero), new ExternalByteArrayEncoding(tagID)).toParam();
    }

    private EncodingDetails buildEncodingForTag(List<CramCompressionRecord> records, int tagID) {
        EncodingDetails details = new EncodingDetails();
        byte[] data = this.getDataForTag(records, tagID);
        details.compressor = CompressionHeaderFactory.getBestExternalCompressor(data);
        byte type = CompressionHeaderFactory.getTagType(tagID);
        switch (type) {
            case 65: 
            case 67: 
            case 99: {
                details.params = this.buildTagEncodingForSize(1, tagID);
                return details;
            }
            case 73: 
            case 102: 
            case 105: {
                details.params = this.buildTagEncodingForSize(4, tagID);
                return details;
            }
            case 83: 
            case 115: {
                details.params = this.buildTagEncodingForSize(2, tagID);
                return details;
            }
            case 66: 
            case 90: {
                int unusedByte;
                boolean singleSize;
                ByteSizeRange stats = CompressionHeaderFactory.getByteSizeRangeOfTagValues(records, tagID);
                boolean bl = singleSize = stats.min == stats.max;
                if (singleSize) {
                    details.params = this.buildTagEncodingForSize(stats.min, tagID);
                    return details;
                }
                if (type == 90) {
                    details.params = new ByteArrayStopEncoding(9, tagID).toParam();
                    return details;
                }
                int minSize_threshold_ForByteArrayStopEncoding = 100;
                if (stats.min > 100 && (unusedByte = CompressionHeaderFactory.getUnusedByte(data)) > -1) {
                    details.params = new ByteArrayStopEncoding((byte)unusedByte, tagID).toParam();
                    return details;
                }
                details.params = new ByteArrayLenEncoding(new ExternalIntegerEncoding(tagID), new ExternalByteArrayEncoding(tagID)).toParam();
                return details;
            }
        }
        throw new IllegalArgumentException("Unknown tag type: " + (char)type);
    }

    static int getTagValueByteSize(byte type, Object value) {
        switch (type) {
            case 65: {
                return 1;
            }
            case 73: {
                return 4;
            }
            case 105: {
                return 4;
            }
            case 115: {
                return 2;
            }
            case 83: {
                return 2;
            }
            case 99: {
                return 1;
            }
            case 67: {
                return 1;
            }
            case 102: {
                return 4;
            }
            case 90: {
                return ((String)value).length() + 1;
            }
            case 66: {
                if (value instanceof byte[]) {
                    return 5 + ((byte[])value).length;
                }
                if (value instanceof short[]) {
                    return 5 + ((short[])value).length * 2;
                }
                if (value instanceof int[]) {
                    return 5 + ((int[])value).length * 4;
                }
                if (value instanceof float[]) {
                    return 5 + ((float[])value).length * 4;
                }
                if (value instanceof long[]) {
                    return 5 + ((long[])value).length * 4;
                }
                throw new RuntimeException("Unknown tag array class: " + value.getClass());
            }
        }
        throw new RuntimeException("Unknown tag type: " + (char)type);
    }

    static class ByteSizeRange {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        ByteSizeRange() {
        }
    }

    private static class CompressionHeaderBuilder {
        private final CompressionHeader header = new CompressionHeader();

        CompressionHeaderBuilder(boolean coordinateSorted) {
            this.header.externalIds = new ArrayList<Integer>();
            this.header.tMap = new TreeMap<Integer, EncodingParams>();
            this.header.encodingMap = new TreeMap<DataSeries, EncodingParams>();
            this.header.APDelta = coordinateSorted;
        }

        CompressionHeader getHeader() {
            return this.header;
        }

        private void addExternalEncoding(DataSeries dataSeries, EncodingParams params, ExternalCompressor compressor) {
            this.header.externalIds.add(dataSeries.getExternalBlockContentId());
            this.header.externalCompressors.put(dataSeries.getExternalBlockContentId(), compressor);
            this.header.encodingMap.put(dataSeries, params);
        }

        private void addExternalByteArrayStopTabGzipEncoding(DataSeries dataSeries) {
            this.addExternalEncoding(dataSeries, new ByteArrayStopEncoding(9, dataSeries.getExternalBlockContentId()).toParam(), ExternalCompressor.createGZIP());
        }

        private void addExternalIntegerEncoding(DataSeries dataSeries, ExternalCompressor compressor) {
            this.addExternalEncoding(dataSeries, new ExternalIntegerEncoding(dataSeries.getExternalBlockContentId()).toParam(), compressor);
        }

        private void addExternalIntegerGzipEncoding(DataSeries dataSeries) {
            this.addExternalEncoding(dataSeries, new ExternalIntegerEncoding(dataSeries.getExternalBlockContentId()).toParam(), ExternalCompressor.createGZIP());
        }

        private void addExternalByteGzipEncoding(DataSeries dataSeries) {
            this.addExternalEncoding(dataSeries, new ExternalByteEncoding(dataSeries.getExternalBlockContentId()).toParam(), ExternalCompressor.createGZIP());
        }

        private void addExternalByteRansOrderOneEncoding(DataSeries dataSeries) {
            this.addExternalEncoding(dataSeries, new ExternalByteEncoding(dataSeries.getExternalBlockContentId()).toParam(), ExternalCompressor.createRANS(RANS.ORDER.ONE));
        }

        private void addExternalIntegerRansOrderOneEncoding(DataSeries dataSeries) {
            this.addExternalIntegerEncoding(dataSeries, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        }

        private void addExternalIntegerRansOrderZeroEncoding(DataSeries dataSeries) {
            this.addExternalIntegerEncoding(dataSeries, ExternalCompressor.createRANS(RANS.ORDER.ZERO));
        }

        void addTagEncoding(int tagId, EncodingDetails encodingDetails) {
            this.header.externalIds.add(tagId);
            this.header.externalCompressors.put(tagId, encodingDetails.compressor);
            this.header.tMap.put(tagId, encodingDetails.params);
        }

        void setTagIdDictionary(byte[][][] dictionary) {
            this.header.dictionary = dictionary;
        }

        void setSubstitutionMatrix(SubstitutionMatrix substitutionMatrix) {
            this.header.substitutionMatrix = substitutionMatrix;
        }
    }

    private static class EncodingDetails {
        ExternalCompressor compressor;
        EncodingParams params;

        private EncodingDetails() {
        }
    }
}

