/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class SBIIndexWriter {
    public static final long DEFAULT_GRANULARITY = 4096L;
    static final byte[] EMPTY_MD5 = new byte[16];
    static final byte[] EMPTY_UUID = new byte[16];
    private final OutputStream out;
    private final long granularity;
    private final Path tempOffsetsFile;
    private final BinaryCodec tempOffsetsCodec;
    private long prev = -1L;
    private long recordCount;
    private long virtualOffsetCount;

    public SBIIndexWriter(OutputStream out) {
        this(out, 4096L);
    }

    public SBIIndexWriter(OutputStream out, long granularity) {
        this.out = out;
        this.granularity = granularity;
        try {
            this.tempOffsetsFile = Files.createTempFile("offsets-", ".headerless.sbi", new FileAttribute[0]);
            this.tempOffsetsCodec = new BinaryCodec(new BufferedOutputStream(Files.newOutputStream(this.tempOffsetsFile, new OpenOption[0])));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void processRecord(long virtualOffset) {
        if (this.recordCount++ % this.granularity == 0L) {
            this.writeVirtualOffset(virtualOffset);
        }
    }

    void writeVirtualOffset(long virtualOffset) {
        if (this.prev > virtualOffset) {
            throw new IllegalArgumentException(String.format("Offsets not in order: %#x > %#x", this.prev, virtualOffset));
        }
        this.tempOffsetsCodec.writeLong(virtualOffset);
        ++this.virtualOffsetCount;
        this.prev = virtualOffset;
    }

    public void finish(long finalVirtualOffset, long dataFileLength) {
        this.finish(finalVirtualOffset, dataFileLength, null, null);
    }

    public void finish(long finalVirtualOffset, long dataFileLength, byte[] md5, byte[] uuid) {
        if (md5 != null && md5.length != 16) {
            throw new IllegalArgumentException("Invalid MD5 length: " + md5.length);
        }
        if (uuid != null && uuid.length != 16) {
            throw new IllegalArgumentException("Invalid UUID length: " + uuid.length);
        }
        SBIIndex.Header header = new SBIIndex.Header(dataFileLength, md5 == null ? EMPTY_MD5 : md5, uuid == null ? EMPTY_UUID : uuid, this.recordCount, this.granularity);
        this.finish(header, finalVirtualOffset);
    }

    void finish(SBIIndex.Header header, long finalVirtualOffset) {
        this.writeVirtualOffset(finalVirtualOffset);
        this.tempOffsetsCodec.close();
        try {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    BinaryCodec binaryCodec = new BinaryCodec(this.out);
                    try {
                        try (BufferedInputStream tempOffsets = new BufferedInputStream(Files.newInputStream(this.tempOffsetsFile, new OpenOption[0]));){
                            binaryCodec.writeBytes(SBIIndex.SBI_MAGIC);
                            binaryCodec.writeLong(header.getFileLength());
                            binaryCodec.writeBytes(header.getMd5());
                            binaryCodec.writeBytes(header.getUuid());
                            binaryCodec.writeLong(header.getTotalNumberOfRecords());
                            binaryCodec.writeLong(header.getGranularity());
                            binaryCodec.writeLong(this.virtualOffsetCount);
                            IOUtil.copyStream(tempOffsets, this.out);
                        }
                        if (binaryCodec != null) {
                            binaryCodec.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (binaryCodec != null) {
                            binaryCodec.close();
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        finally {
            try {
                Files.delete(this.tempOffsetsFile);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }
}

