/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;

public class SAMSortOrderChecker {
    private final SAMFileHeader.SortOrder sortOrder;
    private SAMRecord prev;
    private final SAMRecordComparator comparator;

    public SAMSortOrderChecker(SAMFileHeader.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this.comparator = sortOrder == null ? null : sortOrder.getComparatorInstance();
    }

    public boolean isSorted(SAMRecord rec) {
        if (this.comparator == null) {
            return true;
        }
        boolean ret = true;
        if (this.prev != null) {
            ret = this.comparator.fileOrderCompare(this.prev, rec) <= 0;
        }
        this.prev = rec;
        return ret;
    }

    public SAMRecord getPreviousRecord() {
        return this.prev;
    }

    public SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getSortKey(SAMRecord rec) {
        switch (this.sortOrder) {
            case coordinate: {
                return String.valueOf(rec.getReferenceName()) + ":" + rec.getAlignmentStart();
            }
            case queryname: {
                return rec.getReadName();
            }
        }
        return rec.getSAMString().trim();
    }
}

