/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SAMRecord
implements Cloneable,
Locatable,
Serializable {
    private static final Log LOG = Log.getInstance(SAMRecord.class);
    public static final long serialVersionUID = 1L;
    public static final int UNKNOWN_MAPPING_QUALITY = 255;
    public static final int NO_MAPPING_QUALITY = 0;
    public static final String NO_ALIGNMENT_REFERENCE_NAME = "*";
    public static final int NO_ALIGNMENT_REFERENCE_INDEX = -1;
    public static final String NO_ALIGNMENT_CIGAR = "*";
    public static final int NO_ALIGNMENT_START = 0;
    public static final byte[] NULL_SEQUENCE = new byte[0];
    public static final String NULL_SEQUENCE_STRING = "*";
    public static final byte[] NULL_QUALS = new byte[0];
    public static final String NULL_QUALS_STRING = "*";
    public static final int MAX_INSERT_SIZE = 0x20000000;
    public static final List<String> TAGS_TO_REVERSE_COMPLEMENT = Arrays.asList(SAMTag.E2.name(), SAMTag.SQ.name());
    public static final List<String> TAGS_TO_REVERSE = Arrays.asList(SAMTag.OQ.name(), SAMTag.U2.name());
    private String mReadName = null;
    private byte[] mReadBases = NULL_SEQUENCE;
    private byte[] mBaseQualities = NULL_QUALS;
    private String mReferenceName = "*";
    private int mAlignmentStart = 0;
    private transient int mAlignmentEnd = 0;
    private int mMappingQuality = 0;
    private String mCigarString = "*";
    private Cigar mCigar = null;
    private List<AlignmentBlock> mAlignmentBlocks = null;
    private int mFlags = 0;
    private String mMateReferenceName = "*";
    private int mMateAlignmentStart = 0;
    private int mInferredInsertSize = 0;
    private SAMBinaryTagAndValue mAttributes = null;
    protected Integer mReferenceIndex = null;
    protected Integer mMateReferenceIndex = null;
    private ValidationStringency mValidationStringency = ValidationStringency.SILENT;
    private transient SAMFileSource mFileSource;
    private SAMFileHeader mHeader = null;
    private transient Map<Object, Object> transientAttributes;

    public SAMRecord(SAMFileHeader header) {
        this.mHeader = header;
    }

    public String getReadName() {
        return this.mReadName;
    }

    public int getReadNameLength() {
        return this.mReadName.length();
    }

    public void setReadName(String value) {
        this.mReadName = value;
    }

    public String getReadString() {
        byte[] readBases = this.getReadBases();
        if (readBases.length == 0) {
            return "*";
        }
        return StringUtil.bytesToString(readBases);
    }

    public void setReadString(String value) {
        if ("*".equals(value)) {
            this.mReadBases = NULL_SEQUENCE;
        } else {
            byte[] bases = StringUtil.stringToBytes(value);
            if (bases != null) {
                SAMUtils.normalizeBases(bases);
            }
            this.setReadBases(bases);
        }
    }

    public byte[] getReadBases() {
        return this.mReadBases;
    }

    public void setReadBases(byte[] value) {
        this.mReadBases = value;
    }

    public int getReadLength() {
        byte[] readBases = this.getReadBases();
        return readBases == null ? 0 : readBases.length;
    }

    public String getBaseQualityString() {
        if (Arrays.equals(NULL_QUALS, this.getBaseQualities())) {
            return "*";
        }
        return SAMUtils.phredToFastq(this.getBaseQualities());
    }

    public void setBaseQualityString(String value) {
        if ("*".equals(value)) {
            this.setBaseQualities(NULL_QUALS);
        } else {
            this.setBaseQualities(SAMUtils.fastqToPhred(value));
        }
    }

    public byte[] getBaseQualities() {
        return this.mBaseQualities;
    }

    public void setBaseQualities(byte[] value) {
        this.mBaseQualities = value;
    }

    public byte[] getOriginalBaseQualities() {
        String oqString = (String)this.getAttribute("OQ");
        if (oqString != null && !oqString.isEmpty()) {
            return SAMUtils.fastqToPhred(oqString);
        }
        return null;
    }

    public void setOriginalBaseQualities(byte[] oq) {
        this.setAttribute("OQ", (Object)SAMUtils.phredToFastq(oq));
    }

    private static boolean hasReferenceName(Integer referenceIndex, String referenceName) {
        return referenceIndex != null && !referenceIndex.equals(-1) || !"*".equals(referenceName);
    }

    private boolean hasReferenceName() {
        return SAMRecord.hasReferenceName(this.mReferenceIndex, this.mReferenceName);
    }

    private boolean hasMateReferenceName() {
        return SAMRecord.hasReferenceName(this.mMateReferenceIndex, this.mMateReferenceName);
    }

    public String getReferenceName() {
        return this.mReferenceName;
    }

    public void setReferenceName(String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException("Reference name must not be null. Use SAMRecord.NO_ALIGNMENT_REFERENCE_NAME to reset the reference name.");
        }
        if (this.mHeader != null) {
            this.mReferenceIndex = SAMRecord.resolveIndexFromName(referenceName, this.mHeader, false);
            this.mReferenceName = this.mReferenceIndex == null ? referenceName.intern() : SAMRecord.resolveNameFromIndex(this.mReferenceIndex, this.mHeader);
        } else if ("*".equals(referenceName)) {
            this.mReferenceName = "*";
            this.mReferenceIndex = -1;
        } else {
            this.mReferenceName = referenceName.intern();
            this.mReferenceIndex = null;
        }
    }

    public Integer getReferenceIndex() {
        if (this.mReferenceIndex == null) {
            this.mReferenceIndex = SAMRecord.resolveIndexFromName(this.mReferenceName, this.mHeader, false);
            if (this.mReferenceIndex == null) {
                this.mReferenceIndex = -1;
            }
        }
        return this.mReferenceIndex;
    }

    public void setReferenceIndex(int referenceIndex) {
        this.setReferenceName(SAMRecord.resolveNameFromIndex(referenceIndex, this.mHeader));
        this.mReferenceIndex = referenceIndex;
    }

    public String getMateReferenceName() {
        return this.mMateReferenceName;
    }

    public void setMateReferenceName(String mateReferenceName) {
        if (mateReferenceName == null) {
            throw new IllegalArgumentException("Mate reference name must not be null. Use SAMRecord.NO_ALIGNMENT_REFERENCE_NAME to reset the mate reference name.");
        }
        if (this.mHeader != null) {
            this.mMateReferenceIndex = SAMRecord.resolveIndexFromName(mateReferenceName, this.mHeader, false);
            this.mMateReferenceName = this.mMateReferenceIndex == null ? mateReferenceName.intern() : SAMRecord.resolveNameFromIndex(this.mMateReferenceIndex, this.mHeader);
        } else if ("*".equals(mateReferenceName)) {
            this.mMateReferenceName = "*";
            this.mMateReferenceIndex = -1;
        } else {
            this.mMateReferenceName = mateReferenceName.intern();
            this.mMateReferenceIndex = null;
        }
    }

    public Integer getMateReferenceIndex() {
        if (this.mMateReferenceIndex == null) {
            this.mMateReferenceIndex = SAMRecord.resolveIndexFromName(this.mMateReferenceName, this.mHeader, false);
            if (this.mMateReferenceIndex == null) {
                this.mMateReferenceIndex = -1;
            }
        }
        return this.mMateReferenceIndex;
    }

    public void setMateReferenceIndex(int mateReferenceIndex) {
        this.setMateReferenceName(SAMRecord.resolveNameFromIndex(mateReferenceIndex, this.mHeader));
        this.mMateReferenceIndex = mateReferenceIndex;
    }

    protected static Integer resolveIndexFromName(String referenceName, SAMFileHeader header, boolean strict) {
        Integer referenceIndex = -1;
        if (!"*".equals(referenceName)) {
            if (header == null) {
                throw new IllegalStateException("A non-null SAMFileHeader is required to resolve the reference index or name");
            }
            referenceIndex = header.getSequenceIndex(referenceName);
            if (-1 == referenceIndex) {
                if (strict) {
                    throw new IllegalArgumentException("Reference index for '" + referenceName + "' not found in sequence dictionary.");
                }
                referenceIndex = null;
            }
        }
        return referenceIndex;
    }

    protected static String resolveNameFromIndex(int referenceIndex, SAMFileHeader header) {
        String referenceName = "*";
        if (-1 != referenceIndex) {
            if (header == null) {
                throw new IllegalStateException("A non-null SAMFileHeader is required to resolve the reference index or name");
            }
            SAMSequenceRecord samSeq = header.getSequence(referenceIndex);
            if (samSeq == null) {
                throw new IllegalArgumentException("Reference name for '" + referenceIndex + "' not found in sequence dictionary.");
            }
            referenceName = samSeq.getSequenceName();
        }
        return referenceName;
    }

    public int getAlignmentStart() {
        return this.mAlignmentStart;
    }

    public void setAlignmentStart(int value) {
        this.mAlignmentStart = value;
        this.mAlignmentEnd = 0;
    }

    public int getAlignmentEnd() {
        if (this.getReadUnmappedFlag()) {
            return 0;
        }
        if (this.mAlignmentEnd == 0) {
            this.mAlignmentEnd = this.mAlignmentStart + this.getCigar().getReferenceLength() - 1;
        }
        return this.mAlignmentEnd;
    }

    public int getUnclippedStart() {
        return SAMUtils.getUnclippedStart(this.getAlignmentStart(), this.getCigar());
    }

    public int getUnclippedEnd() {
        return SAMUtils.getUnclippedEnd(this.getAlignmentEnd(), this.getCigar());
    }

    public int getReferencePositionAtReadPosition(int position) {
        return SAMRecord.getReferencePositionAtReadPosition(this, position);
    }

    public static int getReferencePositionAtReadPosition(SAMRecord rec, int position) {
        if (position == 0) {
            return 0;
        }
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            if (CoordMath.getEnd(alignmentBlock.getReadStart(), alignmentBlock.getLength()) < position) continue;
            if (position < alignmentBlock.getReadStart()) {
                return 0;
            }
            return alignmentBlock.getReferenceStart() + position - alignmentBlock.getReadStart();
        }
        return 0;
    }

    public int getReadPositionAtReferencePosition(int pos) {
        return SAMRecord.getReadPositionAtReferencePosition(this, pos, false);
    }

    public int getReadPositionAtReferencePosition(int pos, boolean returnLastBaseIfDeleted) {
        return SAMRecord.getReadPositionAtReferencePosition(this, pos, returnLastBaseIfDeleted);
    }

    public static int getReadPositionAtReferencePosition(SAMRecord rec, int pos, boolean returnLastBaseIfDeleted) {
        if (pos <= 0) {
            return 0;
        }
        int lastAlignmentOffset = 0;
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            if (CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength()) >= pos) {
                if (pos < alignmentBlock.getReferenceStart()) {
                    return returnLastBaseIfDeleted ? lastAlignmentOffset : 0;
                }
                return pos - alignmentBlock.getReferenceStart() + alignmentBlock.getReadStart();
            }
            lastAlignmentOffset = alignmentBlock.getReadStart() + alignmentBlock.getLength() - 1;
        }
        return 0;
    }

    public int getMateAlignmentStart() {
        return this.mMateAlignmentStart;
    }

    public void setMateAlignmentStart(int mateAlignmentStart) {
        this.mMateAlignmentStart = mateAlignmentStart;
    }

    public int getInferredInsertSize() {
        return this.mInferredInsertSize;
    }

    public void setInferredInsertSize(int inferredInsertSize) {
        this.mInferredInsertSize = inferredInsertSize;
    }

    public int getMappingQuality() {
        return this.mMappingQuality;
    }

    public void setMappingQuality(int value) {
        this.mMappingQuality = value;
    }

    public String getCigarString() {
        if (this.mCigarString == null && this.getCigar() != null) {
            this.mCigarString = TextCigarCodec.encode(this.getCigar());
        }
        return this.mCigarString;
    }

    public void setCigarString(String value) {
        this.mCigarString = value;
        this.mCigar = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
    }

    public Cigar getCigar() {
        if (this.mCigar == null && this.mCigarString != null) {
            this.mCigar = TextCigarCodec.decode(this.mCigarString);
            if (this.getHeader() != null && this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return this.mCigar;
    }

    public int getCigarLength() {
        return this.getCigar().numCigarElements();
    }

    public void setCigar(Cigar cigar) {
        this.initializeCigar(cigar);
    }

    protected void initializeCigar(Cigar cigar) {
        this.mCigar = cigar;
        this.mCigarString = null;
        this.mAlignmentBlocks = null;
        this.mAlignmentEnd = 0;
    }

    public SAMReadGroupRecord getReadGroup() {
        String rgId = (String)this.getAttribute(SAMTag.RG.getBinaryTag());
        if (rgId == null || this.getHeader() == null) {
            return null;
        }
        return this.getHeader().getReadGroup(rgId);
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int value) {
        this.mFlags = value;
    }

    public boolean getReadPairedFlag() {
        return (this.mFlags & SAMFlag.READ_PAIRED.flag) != 0;
    }

    private void requireReadPaired() {
        if (!this.getReadPairedFlag()) {
            throw new IllegalStateException("Inappropriate call if not paired read");
        }
    }

    public boolean getProperPairFlag() {
        this.requireReadPaired();
        return this.getProperPairFlagUnchecked();
    }

    private boolean getProperPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.PROPER_PAIR.flag) != 0;
    }

    public boolean getReadUnmappedFlag() {
        return (this.mFlags & SAMFlag.READ_UNMAPPED.flag) != 0;
    }

    public boolean getMateUnmappedFlag() {
        this.requireReadPaired();
        return this.getMateUnmappedFlagUnchecked();
    }

    private boolean getMateUnmappedFlagUnchecked() {
        return (this.mFlags & SAMFlag.MATE_UNMAPPED.flag) != 0;
    }

    public boolean getReadNegativeStrandFlag() {
        return (this.mFlags & SAMFlag.READ_REVERSE_STRAND.flag) != 0;
    }

    public boolean getMateNegativeStrandFlag() {
        this.requireReadPaired();
        return this.getMateNegativeStrandFlagUnchecked();
    }

    private boolean getMateNegativeStrandFlagUnchecked() {
        return (this.mFlags & SAMFlag.MATE_REVERSE_STRAND.flag) != 0;
    }

    public boolean getFirstOfPairFlag() {
        this.requireReadPaired();
        return this.getFirstOfPairFlagUnchecked();
    }

    private boolean getFirstOfPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.FIRST_OF_PAIR.flag) != 0;
    }

    public boolean getSecondOfPairFlag() {
        this.requireReadPaired();
        return this.getSecondOfPairFlagUnchecked();
    }

    private boolean getSecondOfPairFlagUnchecked() {
        return (this.mFlags & SAMFlag.SECOND_OF_PAIR.flag) != 0;
    }

    @Deprecated
    public boolean getNotPrimaryAlignmentFlag() {
        return this.isSecondaryAlignment();
    }

    public boolean isSecondaryAlignment() {
        return (this.mFlags & SAMFlag.SECONDARY_ALIGNMENT.flag) != 0;
    }

    public boolean getSupplementaryAlignmentFlag() {
        return (this.mFlags & SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag) != 0;
    }

    public boolean getReadFailsVendorQualityCheckFlag() {
        return (this.mFlags & SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag) != 0;
    }

    public boolean getDuplicateReadFlag() {
        return (this.mFlags & SAMFlag.DUPLICATE_READ.flag) != 0;
    }

    public void setReadPairedFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.READ_PAIRED.flag);
    }

    public void setProperPairFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.PROPER_PAIR.flag);
    }

    @Deprecated
    public void setReadUmappedFlag(boolean flag) {
        this.setReadUnmappedFlag(flag);
    }

    public void setReadUnmappedFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.READ_UNMAPPED.flag);
    }

    public void setMateUnmappedFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.MATE_UNMAPPED.flag);
    }

    public void setReadNegativeStrandFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.READ_REVERSE_STRAND.flag);
    }

    public void setMateNegativeStrandFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.MATE_REVERSE_STRAND.flag);
    }

    public void setFirstOfPairFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.FIRST_OF_PAIR.flag);
    }

    public void setSecondOfPairFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.SECOND_OF_PAIR.flag);
    }

    @Deprecated
    public void setNotPrimaryAlignmentFlag(boolean flag) {
        this.setSecondaryAlignment(flag);
    }

    public void setSecondaryAlignment(boolean flag) {
        this.setFlag(flag, SAMFlag.SECONDARY_ALIGNMENT.flag);
    }

    public void setSupplementaryAlignmentFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag);
    }

    public void setReadFailsVendorQualityCheckFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag);
    }

    public void setDuplicateReadFlag(boolean flag) {
        this.setFlag(flag, SAMFlag.DUPLICATE_READ.flag);
    }

    public boolean isSecondaryOrSupplementary() {
        return this.isSecondaryAlignment() || this.getSupplementaryAlignmentFlag();
    }

    private void setFlag(boolean flag, int bit) {
        this.mFlags = flag ? (this.mFlags |= bit) : (this.mFlags &= ~bit);
    }

    public ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    public boolean hasAttribute(String tag) {
        return this.getAttribute(tag) != null;
    }

    public Object getAttribute(String tag) {
        return this.getAttribute(SAMTag.makeBinaryTag(tag));
    }

    public Integer getIntegerAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < Integer.MIN_VALUE || longVal > Integer.MAX_VALUE) {
            throw new RuntimeException("Value for tag " + tag + " is not in Integer range: " + longVal);
        }
        return (int)longVal;
    }

    public Long getUnsignedIntegerAttribute(String tag) throws SAMException {
        return this.getUnsignedIntegerAttribute(SAMTag.makeBinaryTag(tag));
    }

    public Long getUnsignedIntegerAttribute(short tag) throws SAMException {
        Object value = this.getAttribute(tag);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            long lValue = ((Number)value).longValue();
            if (SAMUtils.isValidUnsignedIntegerAttribute(lValue)) {
                return lValue;
            }
            throw new SAMException("Unsigned integer value of tag " + SAMTag.makeStringTag(tag) + " is out of bounds for a 32-bit unsigned integer: " + lValue);
        }
        throw new SAMException("Unexpected attribute value data type " + value.getClass() + " for tag " + SAMTag.makeStringTag(tag));
    }

    public Short getShortAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < -32768L || longVal > 32767L) {
            throw new RuntimeException("Value for tag " + tag + " is not in Short range: " + longVal);
        }
        return (short)longVal;
    }

    public Byte getByteAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (!(val instanceof Number)) {
            throw new RuntimeException("Value for tag " + tag + " is not Number: " + val.getClass());
        }
        long longVal = ((Number)val).longValue();
        if (longVal < -128L || longVal > 127L) {
            throw new RuntimeException("Value for tag " + tag + " is not in Short range: " + longVal);
        }
        return (byte)longVal;
    }

    public String getStringAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a String: " + val.getClass());
    }

    public Character getCharacterAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Character) {
            return (Character)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a Character: " + val.getClass());
    }

    public Float getFloatAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        throw new SAMException("Value for tag " + tag + " is not a Float: " + val.getClass());
    }

    public byte[] getByteArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a byte[]: " + val.getClass());
    }

    public byte[] getUnsignedByteArrayAttribute(String tag) {
        byte[] ret = this.getByteArrayAttribute(tag);
        if (ret != null) {
            this.requireUnsigned(tag);
        }
        return ret;
    }

    public byte[] getSignedByteArrayAttribute(String tag) {
        byte[] ret = this.getByteArrayAttribute(tag);
        if (ret != null) {
            this.requireSigned(tag);
        }
        return ret;
    }

    public short[] getUnsignedShortArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof short[]) {
            this.requireUnsigned(tag);
            return (short[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a short[]: " + val.getClass());
    }

    public short[] getSignedShortArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof short[]) {
            this.requireSigned(tag);
            return (short[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a short[]: " + val.getClass());
    }

    public int[] getUnsignedIntArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof int[]) {
            this.requireUnsigned(tag);
            return (int[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a int[]: " + val.getClass());
    }

    public int[] getSignedIntArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val == null) {
            return null;
        }
        if (val instanceof int[]) {
            this.requireSigned(tag);
            return (int[])val;
        }
        throw new SAMException("Value for tag " + tag + " is not a int[]: " + val.getClass());
    }

    public float[] getFloatArrayAttribute(String tag) {
        Object val = this.getAttribute(tag);
        if (val != null && !(val instanceof float[])) {
            throw new SAMException("Value for tag " + tag + " is not a float[]: " + val.getClass());
        }
        return (float[])val;
    }

    public boolean isUnsignedArrayAttribute(String tag) {
        SAMBinaryTagAndValue tmp = this.mAttributes.find(SAMTag.makeBinaryTag(tag));
        if (tmp != null) {
            return tmp.isUnsignedArray();
        }
        throw new SAMException("Tag " + tag + " is not present in this SAMRecord");
    }

    private void requireSigned(String tag) {
        if (this.isUnsignedArrayAttribute(tag)) {
            throw new SAMException("Value for tag " + tag + " is not signed");
        }
    }

    private void requireUnsigned(String tag) {
        if (!this.isUnsignedArrayAttribute(tag)) {
            throw new SAMException("Value for tag " + tag + " is not unsigned");
        }
    }

    public Object getAttribute(short tag) {
        if (this.mAttributes == null) {
            return null;
        }
        SAMBinaryTagAndValue tmp = this.mAttributes.find(tag);
        if (tmp != null) {
            return tmp.value;
        }
        return null;
    }

    public void setAttribute(String tag, Object value) {
        this.setAttribute(SAMTag.makeBinaryTag(tag), value);
    }

    public void setUnsignedArrayAttribute(String tag, Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        if (Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value, true);
    }

    protected void setAttribute(short tag, Object value) {
        this.setAttribute(tag, value, false);
    }

    @Deprecated
    protected static boolean isAllowedAttributeValue(Object value) {
        return SAMBinaryTagAndValue.isAllowedAttributeValue(value);
    }

    protected void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        if (value == null) {
            if (this.mAttributes != null) {
                this.mAttributes = this.mAttributes.remove(tag);
            }
        } else {
            SAMBinaryTagAndValue tmp = !isUnsignedArray ? new SAMBinaryTagAndValue(tag, value) : new SAMBinaryTagAndUnsignedArrayValue(tag, value);
            this.mAttributes = this.mAttributes == null ? tmp : this.mAttributes.insert(tmp);
        }
    }

    public void clearAttributes() {
        this.mAttributes = null;
    }

    protected void setAttributes(SAMBinaryTagAndValue attributes) {
        this.mAttributes = attributes;
    }

    protected SAMBinaryTagAndValue getBinaryAttributes() {
        return this.mAttributes;
    }

    @Override
    public String getContig() {
        if (this.getReadUnmappedFlag()) {
            return null;
        }
        return this.getReferenceName();
    }

    @Override
    public int getStart() {
        return this.getAlignmentStart();
    }

    @Override
    public int getEnd() {
        return this.getAlignmentEnd();
    }

    public List<SAMTagAndValue> getAttributes() {
        SAMBinaryTagAndValue binaryAttributes = this.getBinaryAttributes();
        ArrayList<SAMTagAndValue> ret = new ArrayList<SAMTagAndValue>();
        while (binaryAttributes != null) {
            ret.add(new SAMTagAndValue(SAMTag.makeStringTag(binaryAttributes.tag), binaryAttributes.value));
            binaryAttributes = binaryAttributes.getNext();
        }
        return ret;
    }

    @Deprecated
    public int computeIndexingBinIfAbsent(SAMRecord alignment) {
        return alignment.computeIndexingBin();
    }

    int computeIndexingBin() {
        int alignmentStart = this.getAlignmentStart() - 1;
        int alignmentEnd = this.getAlignmentEnd();
        if (alignmentEnd <= 0) {
            alignmentEnd = alignmentStart + 1;
        }
        if (alignmentStart > 0x20000000 || alignmentEnd > 0x20000000) {
            throw new IllegalStateException("Read position too high for BAI bin indexing.");
        }
        return GenomicIndexUtil.regionToBin(alignmentStart, alignmentEnd) & 0xFFFF;
    }

    public SAMFileHeader getHeader() {
        return this.mHeader;
    }

    public void setHeader(SAMFileHeader header) {
        this.mHeader = header;
        if (header == null) {
            this.mReferenceIndex = null;
            this.mMateReferenceIndex = null;
        } else {
            this.setReferenceName(this.mReferenceName);
            this.setMateReferenceName(this.mMateReferenceName);
        }
    }

    public void setHeaderStrict(SAMFileHeader header) {
        if (header == null) {
            this.mReferenceIndex = null;
            this.mMateReferenceIndex = null;
        } else {
            Integer referenceIndex = SAMRecord.resolveIndexFromName(this.mReferenceName, header, true);
            Integer mateReferenceIndex = SAMRecord.resolveIndexFromName(this.mMateReferenceName, header, true);
            this.mReferenceIndex = referenceIndex;
            this.mMateReferenceIndex = mateReferenceIndex;
        }
        this.mHeader = header;
    }

    public byte[] getVariableBinaryRepresentation() {
        return null;
    }

    public int getAttributesBinarySize() {
        return -1;
    }

    @Deprecated
    public String format() {
        StringBuilder buffer = new StringBuilder();
        this.addField(buffer, this.getReadName(), null, null);
        this.addField(buffer, this.getFlags(), null, null);
        this.addField(buffer, this.getReferenceName(), null, "*");
        this.addField(buffer, this.getAlignmentStart(), 0, "*");
        this.addField(buffer, this.getMappingQuality(), 0, "0");
        this.addField(buffer, this.getCigarString(), null, "*");
        this.addField(buffer, this.getMateReferenceName(), null, "*");
        this.addField(buffer, this.getMateAlignmentStart(), 0, "*");
        this.addField(buffer, this.getInferredInsertSize(), 0, "*");
        this.addField(buffer, this.getReadString(), null, "*");
        this.addField(buffer, this.getBaseQualityString(), null, "*");
        if (this.mAttributes != null) {
            SAMBinaryTagAndValue entry = this.getBinaryAttributes();
            while (entry != null) {
                this.addField(buffer, SAMRecord.formatTagValue(entry.tag, entry.value));
                entry = entry.getNext();
            }
        }
        return buffer.toString();
    }

    private void addField(StringBuilder buffer, Object value, Object defaultValue, String defaultString) {
        if (this.safeEquals(value, defaultValue)) {
            this.addField(buffer, defaultString);
        } else if (value == null) {
            this.addField(buffer, "");
        } else {
            this.addField(buffer, value.toString());
        }
    }

    private void addField(StringBuilder buffer, String field) {
        if (buffer.length() > 0) {
            buffer.append('\t');
        }
        buffer.append(field);
    }

    private static String formatTagValue(short tag, Object value) {
        String tagString = SAMTag.makeStringTag(tag);
        if (value == null || value instanceof String) {
            return String.valueOf(tagString) + ":Z:" + value;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            return String.valueOf(tagString) + ":i:" + value;
        }
        if (value instanceof Character) {
            return String.valueOf(tagString) + ":A:" + value;
        }
        if (value instanceof Float) {
            return String.valueOf(tagString) + ":f:" + value;
        }
        if (value instanceof byte[]) {
            return String.valueOf(tagString) + ":H:" + StringUtil.bytesToHexString((byte[])value);
        }
        throw new RuntimeException("Unexpected value type for tag " + tagString + ": " + value + " of class " + value.getClass().getName());
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected void eagerDecode() {
        this.getCigar();
        this.getCigarString();
    }

    public List<AlignmentBlock> getAlignmentBlocks() {
        if (this.mAlignmentBlocks == null) {
            this.mAlignmentBlocks = SAMUtils.getAlignmentBlocks(this.getCigar(), this.getAlignmentStart(), "read cigar");
        }
        return this.mAlignmentBlocks;
    }

    public List<SAMValidationError> validateCigar(long recordNumber) {
        List<SAMValidationError> ret = null;
        if (this.getHeader() != null && this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
            try {
                return SAMUtils.validateCigar(this, this.getCigar(), this.getReferenceIndex(), this.getAlignmentBlocks(), recordNumber, "Read CIGAR");
            }
            catch (IllegalArgumentException e) {
                return Collections.singletonList(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, e.getMessage(), this.getReadName(), recordNumber));
            }
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMRecord)) {
            return false;
        }
        SAMRecord samRecord = (SAMRecord)o;
        if (this.mAlignmentStart != samRecord.mAlignmentStart) {
            return false;
        }
        if (this.mFlags != samRecord.mFlags) {
            return false;
        }
        if (this.mInferredInsertSize != samRecord.mInferredInsertSize) {
            return false;
        }
        if (this.mMappingQuality != samRecord.mMappingQuality) {
            return false;
        }
        if (this.mMateAlignmentStart != samRecord.mMateAlignmentStart) {
            return false;
        }
        if (this.mMateReferenceIndex != null ? !this.mMateReferenceIndex.equals(samRecord.mMateReferenceIndex) : samRecord.mMateReferenceIndex != null) {
            return false;
        }
        if (this.mReferenceIndex != null ? !this.mReferenceIndex.equals(samRecord.mReferenceIndex) : samRecord.mReferenceIndex != null) {
            return false;
        }
        this.eagerDecode();
        samRecord.eagerDecode();
        if (this.mReadName != null ? !this.mReadName.equals(samRecord.mReadName) : samRecord.mReadName != null) {
            return false;
        }
        if (this.mAttributes != null ? !this.mAttributes.equals(samRecord.mAttributes) : samRecord.mAttributes != null) {
            return false;
        }
        if (!Arrays.equals(this.mBaseQualities, samRecord.mBaseQualities)) {
            return false;
        }
        if (this.mCigar != null ? !this.mCigar.equals(samRecord.mCigar) : samRecord.mCigar != null) {
            return false;
        }
        if (this.mMateReferenceName != null ? !this.mMateReferenceName.equals(samRecord.mMateReferenceName) : samRecord.mMateReferenceName != null) {
            return false;
        }
        if (!Arrays.equals(this.mReadBases, samRecord.mReadBases)) {
            return false;
        }
        return !(this.mReferenceName != null ? !this.mReferenceName.equals(samRecord.mReferenceName) : samRecord.mReferenceName != null);
    }

    public int hashCode() {
        this.eagerDecode();
        int result = this.mReadName != null ? this.mReadName.hashCode() : 0;
        result = 31 * result + (this.mReadBases != null ? Arrays.hashCode(this.mReadBases) : 0);
        result = 31 * result + (this.mBaseQualities != null ? Arrays.hashCode(this.mBaseQualities) : 0);
        result = 31 * result + (this.mReferenceName != null ? this.mReferenceName.hashCode() : 0);
        result = 31 * result + this.mAlignmentStart;
        result = 31 * result + this.mMappingQuality;
        result = 31 * result + (this.mCigarString != null ? this.mCigarString.hashCode() : 0);
        result = 31 * result + this.mFlags;
        result = 31 * result + (this.mMateReferenceName != null ? this.mMateReferenceName.hashCode() : 0);
        result = 31 * result + this.mMateAlignmentStart;
        result = 31 * result + this.mInferredInsertSize;
        result = 31 * result + (this.mAttributes != null ? this.mAttributes.hashCode() : 0);
        result = 31 * result + (this.mReferenceIndex != null ? this.mReferenceIndex.hashCode() : 0);
        result = 31 * result + (this.mMateReferenceIndex != null ? this.mMateReferenceIndex.hashCode() : 0);
        return result;
    }

    public List<SAMValidationError> isValid() {
        return this.isValid(false);
    }

    public List<SAMValidationError> isValid(boolean firstOnly) {
        Object fz;
        List<SAMValidationError> errors;
        String rgId;
        ArrayList<SAMValidationError> ret = null;
        if (!this.getReadPairedFlag()) {
            if (this.getProperPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_PROPER_PAIR, "Proper pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMateUnmappedFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mate unmapped flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMateNegativeStrandFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_NEG_STRAND, "Mate negative strand flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getFirstOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_FIRST_OF_PAIR, "First of pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getSecondOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SECOND_OF_PAIR, "Second of pair flag should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getHeader() != null && this.getMateReferenceIndex() != -1) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MATE_REF_INDEX, "MRNM should not be set for unpaired read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (!this.getMateReferenceName().equals("*")) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_UNPAIRED_MATE_REFERENCE, "Unpaired read mate reference is " + this.getMateReferenceName() + " not " + "*" + " for unpaired read", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            List<SAMValidationError> errors2 = this.isValidReferenceIndexAndPosition(this.mMateReferenceIndex, this.mMateReferenceName, this.getMateAlignmentStart(), true, firstOnly);
            if (errors2 != null) {
                if (firstOnly) {
                    return errors2;
                }
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.addAll(errors2);
            }
            if (!this.hasMateReferenceName() && !this.getMateUnmappedFlag()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_MATE_UNMAPPED, "Mapped mate should have mate reference name", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (!this.getFirstOfPairFlagUnchecked() && !this.getSecondOfPairFlagUnchecked()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.PAIRED_READ_NOT_MARKED_AS_FIRST_OR_SECOND, "Paired read should be marked as first of pair or second of pair.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        }
        if (this.getInferredInsertSize() > 0x20000000 || this.getInferredInsertSize() < -536870912) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_INSERT_SIZE, "Insert size out of range", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getReadUnmappedFlag()) {
            if (this.isSecondaryAlignment()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_NOT_PRIM_ALIGNMENT, "Secondary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getSupplementaryAlignmentFlag()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_SUPPLEMENTARY_ALIGNMENT, "Supplementary alignment flag should not be set for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getMappingQuality() != 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be 0 for unmapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            if (this.getMappingQuality() >= 256) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_MAPPING_QUALITY, "MAPQ should be < 256.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getCigarLength() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR should have > zero elements for mapped read.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getHeader() != null && this.getHeader().getSequenceDictionary().isEmpty()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.MISSING_SEQUENCE_DICTIONARY, "Empty sequence dictionary.", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (!this.hasReferenceName()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_FLAG_READ_UNMAPPED, "Mapped read should have valid reference name", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        }
        if ((rgId = (String)this.getAttribute(SAMTag.RG.getBinaryTag())) != null && this.getHeader() != null && this.getHeader().getReadGroup(rgId) == null) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.READ_GROUP_NOT_FOUND, "RG ID on SAMRecord not found in header: " + rgId, this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if ((errors = this.isValidReferenceIndexAndPosition(this.mReferenceIndex, this.mReferenceName, this.getAlignmentStart(), false)) != null) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.addAll(errors);
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getReadLength() == 0 && !this.isSecondaryAlignment() && (fz = this.getAttribute(SAMTag.FZ.getBinaryTag())) == null) {
            String cq = (String)this.getAttribute(SAMTag.CQ.getBinaryTag());
            String cs = (String)this.getAttribute(SAMTag.CS.getBinaryTag());
            if (cq == null || cq.isEmpty() || cs == null || cs.isEmpty()) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Zero-length read without FZ, CS or CQ tag", this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            } else if (!this.getReadUnmappedFlag()) {
                boolean hasIndel = false;
                for (CigarElement cigarElement : this.getCigar().getCigarElements()) {
                    if (cigarElement.getOperator() != CigarOperator.DELETION && cigarElement.getOperator() != CigarOperator.INSERTION) continue;
                    hasIndel = true;
                    break;
                }
                if (!hasIndel) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.EMPTY_READ, "Colorspace read with zero-length bases but no indel", this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                }
            }
        }
        if (this.getReadLength() != this.getBaseQualities().length && !Arrays.equals(this.getBaseQualities(), NULL_QUALS)) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_READ_LENGTH_AND_QUALS_LENGTH, "Read length does not match quals length", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getMateReferenceName().equals("*") && this.getMateAlignmentStart() != 0) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_UNALIGNED_MATE_START, "The unaligned mate start position is " + this.getAlignmentStart() + ", should be " + 0, this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getReadLength() != 0 && this.getCigar().getReadLength() != 0 && this.getCigar().getReadLength() != this.getReadLength()) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_CIGAR_SEQ_LENGTH, "CIGAR covers " + this.getCigar().getReadLength() + " bases but the sequence is " + this.getReadLength() + " read bases ", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (this.getBaseQualities().length != 0 && this.getReadLength() != this.getBaseQualities().length) {
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_SEQ_QUAL_LENGTH, "Read length is  " + this.getReadLength() + " bases but have " + this.mBaseQualities.length + " qualities ", this.getReadName()));
            if (firstOnly) {
                return ret;
            }
        }
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public SAMFileSource getFileSource() {
        return this.mFileSource;
    }

    protected void setFileSource(SAMFileSource fileSource) {
        this.mFileSource = fileSource;
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer referenceIndex, String referenceName, int alignmentStart, boolean isMate) {
        return this.isValidReferenceIndexAndPosition(referenceIndex, referenceName, alignmentStart, isMate, false);
    }

    private List<SAMValidationError> isValidReferenceIndexAndPosition(Integer referenceIndex, String referenceName, int alignmentStart, boolean isMate, boolean firstOnly) {
        boolean hasReference = SAMRecord.hasReferenceName(referenceIndex, referenceName);
        ArrayList<SAMValidationError> ret = null;
        if (!hasReference) {
            if (alignmentStart != 0) {
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should be 0 because reference name = *.", isMate), this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
        } else {
            if (alignmentStart == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start should != 0 because reference name != *.", isMate), this.getReadName()));
                if (firstOnly) {
                    return ret;
                }
            }
            if (this.getHeader() != null && !this.getHeader().getSequenceDictionary().isEmpty()) {
                SAMSequenceRecord sequence;
                SAMSequenceRecord sAMSequenceRecord = sequence = referenceIndex != null ? this.getHeader().getSequence(referenceIndex) : this.getHeader().getSequence(referenceName);
                if (sequence == null) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_REFERENCE_INDEX, this.buildMessage("Reference sequence not found in sequence dictionary.", isMate), this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                } else if (alignmentStart > sequence.getSequenceLength()) {
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_ALIGNMENT_START, this.buildMessage("Alignment start (" + alignmentStart + ") must be <= reference sequence length (" + sequence.getSequenceLength() + ") on reference " + sequence.getSequenceName(), isMate), this.getReadName()));
                    if (firstOnly) {
                        return ret;
                    }
                }
            }
        }
        return ret;
    }

    private String buildMessage(String baseMessage, boolean isMate) {
        return isMate ? "Mate " + baseMessage : baseMessage;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMRecord newRecord = (SAMRecord)super.clone();
        if (this.mAttributes != null) {
            newRecord.mAttributes = this.mAttributes.copy();
        }
        return newRecord;
    }

    public SAMRecord deepCopy() {
        SAMRecord newSAM = new SAMRecord(this.getHeader());
        newSAM.setReadName(this.getReadName());
        newSAM.setReadBases(Arrays.copyOf(this.getReadBases(), this.getReadLength()));
        byte[] baseQualities = this.getBaseQualities();
        newSAM.setBaseQualities(Arrays.copyOf(baseQualities, baseQualities.length));
        newSAM.setReferenceName(this.getReferenceName());
        newSAM.setAlignmentStart(this.getAlignmentStart());
        newSAM.setMappingQuality(this.getMappingQuality());
        newSAM.setCigarString(this.getCigarString());
        newSAM.setFileSource(null);
        newSAM.setFlags(this.getFlags());
        newSAM.setMateReferenceName(this.getMateReferenceName());
        newSAM.setMateAlignmentStart(this.getMateAlignmentStart());
        newSAM.setInferredInsertSize(this.getInferredInsertSize());
        newSAM.mReferenceIndex = this.mReferenceIndex;
        newSAM.mMateReferenceIndex = this.mMateReferenceIndex;
        newSAM.setValidationStringency(this.getValidationStringency());
        SAMBinaryTagAndValue attributes = this.getBinaryAttributes();
        if (attributes != null) {
            newSAM.setAttributes(attributes.deepCopy());
        }
        return newSAM;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getReadName());
        if (this.getReadPairedFlag()) {
            if (this.getFirstOfPairFlag()) {
                builder.append(" 1/2");
            } else {
                builder.append(" 2/2");
            }
        }
        builder.append(' ').append(String.valueOf(this.getReadLength())).append('b');
        if (this.getReadUnmappedFlag()) {
            builder.append(" unmapped read.");
        } else {
            builder.append(String.format(" aligned to %s:%d-%d.", this.getContig(), this.getAlignmentStart(), this.getAlignmentEnd()));
        }
        return builder.toString();
    }

    public String getSAMString() {
        return SAMTextWriter.getSAMString(this);
    }

    public String getPairedReadName() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getReadName());
        if (this.getReadPairedFlag()) {
            if (this.getFirstOfPairFlag()) {
                builder.append(" 1/2");
            } else {
                builder.append(" 2/2");
            }
        }
        return builder.toString();
    }

    public final Set<SAMFlag> getSAMFlags() {
        return SAMFlag.getFlags(this.getFlags());
    }

    public final Object getTransientAttribute(Object key) {
        return this.transientAttributes == null ? null : this.transientAttributes.get(key);
    }

    public final Object setTransientAttribute(Object key, Object value) {
        if (this.transientAttributes == null) {
            this.transientAttributes = new HashMap<Object, Object>();
        }
        return this.transientAttributes.put(key, value);
    }

    public final Object removeTransientAttribute(Object key) {
        if (this.transientAttributes != null) {
            return this.transientAttributes.remove(key);
        }
        return null;
    }

    public void reverseComplement() {
        this.reverseComplement(false);
    }

    public void reverseComplement(boolean inplace) {
        this.reverseComplement(TAGS_TO_REVERSE_COMPLEMENT, TAGS_TO_REVERSE, inplace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reverseComplement(Collection<String> tagsToRevcomp, Collection<String> tagsToReverse, boolean inplace) {
        Object value;
        byte[] readBases = inplace ? this.getReadBases() : (byte[])this.getReadBases().clone();
        SequenceUtil.reverseComplement(readBases);
        this.setReadBases(readBases);
        byte[] qualities = inplace ? this.getBaseQualities() : (byte[])this.getBaseQualities().clone();
        SAMRecord.reverseArray(qualities);
        this.setBaseQualities(qualities);
        if (tagsToRevcomp != null) {
            for (String tag : tagsToRevcomp) {
                value = this.getAttribute(tag);
                if (value == null) continue;
                if (value instanceof byte[]) {
                    value = inplace ? value : ((byte[])value).clone();
                    SequenceUtil.reverseComplement((byte[])value);
                } else {
                    if (!(value instanceof String)) throw new UnsupportedOperationException("Don't know how to reverse complement: " + value);
                    value = SequenceUtil.reverseComplement((String)value);
                }
                this.setAttribute(tag, value);
            }
        }
        if (tagsToReverse == null) return;
        for (String tag : tagsToReverse) {
            value = this.getAttribute(tag);
            if (value == null) continue;
            if (value instanceof String) {
                value = StringUtil.reverseString((String)value);
            } else {
                if (!value.getClass().isArray()) throw new UnsupportedOperationException("Don't know how to reverse: " + value);
                if (value instanceof byte[]) {
                    value = inplace ? value : ((byte[])value).clone();
                    SAMRecord.reverseArray((byte[])value);
                } else if (value instanceof short[]) {
                    value = inplace ? value : ((short[])value).clone();
                    SAMRecord.reverseArray((short[])value);
                } else if (value instanceof int[]) {
                    value = inplace ? value : ((int[])value).clone();
                    SAMRecord.reverseArray((int[])value);
                } else {
                    if (!(value instanceof float[])) throw new UnsupportedOperationException("Reversing array attribute of type " + value.getClass().getComponentType() + " not supported.");
                    value = inplace ? value : ((float[])value).clone();
                    SAMRecord.reverseArray((float[])value);
                }
            }
            this.setAttribute(tag, value);
        }
    }

    private static void reverseArray(byte[] array) {
        int i = 0;
        int j = array.length - 1;
        while (i < j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    private static void reverseArray(short[] array) {
        int i = 0;
        int j = array.length - 1;
        while (i < j) {
            short tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    private static void reverseArray(int[] array) {
        int i = 0;
        int j = array.length - 1;
        while (i < j) {
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    private static void reverseArray(float[] array) {
        int i = 0;
        int j = array.length - 1;
        while (i < j) {
            float tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    public static class SAMTagAndValue {
        public final String tag;
        public final Object value;

        public SAMTagAndValue(String tag, Object value) {
            this.tag = tag;
            this.value = value;
        }
    }
}

