/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.util.HashSet;
import java.util.Set;

public enum SAMFlag {
    READ_PAIRED(1, "Template having multiple segments in sequencing"),
    PROPER_PAIR(2, "Each segment properly aligned according to the aligner"),
    READ_UNMAPPED(4, "Segment unmapped"),
    MATE_UNMAPPED(8, "Next segment in the template unmapped"),
    READ_REVERSE_STRAND(16, "SEQ being reverse complemented"),
    MATE_REVERSE_STRAND(32, "SEQ of the next segment in the template being reverse complemented"),
    FIRST_OF_PAIR(64, "The first segment in the template"),
    SECOND_OF_PAIR(128, "The last segment in the template"),
    SECONDARY_ALIGNMENT(256, "Secondary alignment"),
    NOT_PRIMARY_ALIGNMENT(256, "Secondary alignment"),
    READ_FAILS_VENDOR_QUALITY_CHECK(512, "Not passing quality controls"),
    DUPLICATE_READ(1024, "PCR or optical duplicate"),
    SUPPLEMENTARY_ALIGNMENT(2048, "Supplementary alignment");

    final int flag;
    private final String description;

    private SAMFlag(int flag, String description) {
        this.flag = flag;
        this.description = description;
    }

    public int intValue() {
        return this.flag;
    }

    public String getLabel() {
        return this.name().toLowerCase().replace('_', ' ');
    }

    public String getDescription() {
        return this.description;
    }

    public static SAMFlag findByName(String flag) {
        SAMFlag[] sAMFlagArray = SAMFlag.values();
        int n = sAMFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            SAMFlag f = sAMFlagArray[n2];
            if (f.name().equals(flag)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public boolean isSet(int flag) {
        return (this.flag & flag) != 0;
    }

    public boolean isUnset(int flag) {
        return !this.isSet(flag);
    }

    public static Set<SAMFlag> getFlags(int flag) {
        HashSet<SAMFlag> set = new HashSet<SAMFlag>();
        SAMFlag[] sAMFlagArray = SAMFlag.values();
        int n = sAMFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            SAMFlag f = sAMFlagArray[n2];
            if (f.isSet(flag)) {
                set.add(f);
            }
            ++n2;
        }
        return set;
    }

    public static SAMFlag valueOf(String string) {
        return Enum.valueOf(SAMFlag.class, string);
    }
}

