/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class IndexStreamBuffer
implements IndexFileBuffer {
    private final SeekableStream in;
    private final ByteBuffer tmpBuf;

    private static void readFully(SeekableStream in, byte[] buffer, int length) {
        int read = 0;
        while (read < length) {
            int readThisLoop;
            try {
                readThisLoop = in.read(buffer, read, length - read);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (readThisLoop == -1) break;
            read += readThisLoop;
        }
        if (read != length) {
            throw new RuntimeIOException("Expected to read " + length + " bytes, but expired stream after " + read + ".");
        }
    }

    public IndexStreamBuffer(SeekableStream s) {
        this.in = s;
        this.tmpBuf = ByteBuffer.allocate(8);
        this.tmpBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void readBytes(byte[] bytes) {
        IndexStreamBuffer.readFully(this.in, bytes, bytes.length);
    }

    @Override
    public void seek(long position) {
        try {
            this.in.seek(position);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int readInteger() {
        IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 4);
        return this.tmpBuf.getInt(0);
    }

    @Override
    public long readLong() {
        IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 8);
        return this.tmpBuf.getLong(0);
    }

    @Override
    public void skipBytes(int count) {
        try {
            int s = count;
            while (s > 0) {
                int skipped = (int)this.in.skip(s);
                if (skipped <= 0) {
                    throw new RuntimeIOException("Failed to skip " + s);
                }
                s -= skipped;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long position() {
        try {
            return (int)this.in.position();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

