/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerParser;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class CRAMBAIIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public CRAMBAIIndexer(File output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public CRAMBAIIndexer(OutputStream output, SAMFileHeader fileHeader) {
        this.numReferences = fileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(fileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, output);
    }

    public void processContainer(Container container, ValidationStringency validationStringency) {
        if (container == null || container.isEOF()) {
            return;
        }
        int sliceIndex = 0;
        Slice[] sliceArray = container.slices;
        int n = container.slices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice slice = sliceArray[n2];
            slice.containerOffset = container.offset;
            slice.index = sliceIndex++;
            if (slice.getReferenceContext().isMultiRef()) {
                ContainerParser parser = new ContainerParser(this.indexBuilder.bamHeader);
                Map<ReferenceContext, AlignmentSpan> spanMap = parser.getReferences(container, validationStringency);
                slice.containerOffset = container.offset;
                slice.index = sliceIndex++;
                AlignmentSpan unmappedSpan = spanMap.remove(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT);
                for (ReferenceContext refContext : new TreeSet<ReferenceContext>(spanMap.keySet())) {
                    AlignmentSpan span = spanMap.get(refContext);
                    Slice fakeSlice = new Slice(refContext);
                    fakeSlice.containerOffset = slice.containerOffset;
                    fakeSlice.offset = slice.offset;
                    fakeSlice.index = slice.index;
                    fakeSlice.alignmentStart = span.getStart();
                    fakeSlice.alignmentSpan = span.getSpan();
                    fakeSlice.nofRecords = span.getCount();
                    this.processSingleReferenceSlice(fakeSlice);
                }
                if (unmappedSpan != null) {
                    Slice fakeSlice = new Slice(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT);
                    fakeSlice.containerOffset = slice.containerOffset;
                    fakeSlice.offset = slice.offset;
                    fakeSlice.index = slice.index;
                    fakeSlice.alignmentStart = 0;
                    fakeSlice.alignmentSpan = 0;
                    fakeSlice.nofRecords = unmappedSpan.getCount();
                    this.processSingleReferenceSlice(fakeSlice);
                }
            } else {
                this.processSingleReferenceSlice(slice);
            }
            ++n2;
        }
    }

    public void processSingleReferenceSlice(Slice slice) {
        try {
            ReferenceContext sliceContext = slice.getReferenceContext();
            if (sliceContext.isUnmappedUnplaced()) {
                return;
            }
            if (sliceContext.isMultiRef()) {
                throw new SAMException("Expecting a single reference slice.");
            }
            int reference = sliceContext.getSequenceId();
            if (reference != this.currentReference) {
                this.advanceToReference(reference);
            }
            this.indexBuilder.processSingleReferenceSlice(slice);
        }
        catch (Exception e) {
            throw new SAMException("Exception creating BAM index for slice " + slice, e);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int nextReference) {
        while (this.currentReference < nextReference) {
            BAMIndexContent content = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(content);
            ++this.currentReference;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createIndex(SeekableStream stream, File output, Log log, ValidationStringency validationStringency) throws IOException {
        CramHeader cramHeader = CramIO.readCramHeader(stream);
        if (cramHeader.getSamFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("Expecting a coordinate sorted file.");
        }
        CRAMBAIIndexer indexer = new CRAMBAIIndexer(output, cramHeader.getSamFileHeader());
        boolean totalRecords = false;
        Container container = null;
        ProgressLogger progressLogger = new ProgressLogger(log, 1, "indexed", "slices");
        do {
            try {
                String sequenceName;
                long offset = stream.position();
                container = ContainerIO.readContainer(cramHeader.getVersion(), (InputStream)stream);
                if (container == null || container.isEOF()) break;
                container.offset = offset;
                indexer.processContainer(container, validationStringency);
                if (log == null) continue;
                ReferenceContext containerContext = container.getReferenceContext();
                switch (containerContext.getType()) {
                    case UNMAPPED_UNPLACED_TYPE: {
                        sequenceName = "?";
                        break;
                    }
                    case MULTIPLE_REFERENCE_TYPE: {
                        sequenceName = "???";
                        break;
                    }
                    default: {
                        sequenceName = cramHeader.getSamFileHeader().getSequence(containerContext.getSequenceId()).getSequenceName();
                    }
                }
                progressLogger.record(sequenceName, container.alignmentStart);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read cram container", e);
            }
        } while (!container.isEOF());
        indexer.finish();
    }

    private class BAMIndexBuilder {
        private final SAMFileHeader bamHeader;
        private Bin[] bins;
        private int binsSeen = 0;
        private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
        private int largestIndexSeen = -1;
        private final BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMFileHeader header) {
            this.bamHeader = header;
        }

        private int computeIndexingBin(Slice slice) {
            int alignmentEnd = slice.alignmentStart + slice.alignmentSpan - 1;
            int alignmentStart = slice.alignmentStart - 1;
            if (alignmentEnd <= alignmentStart) {
                alignmentEnd = alignmentStart + 1;
            }
            return GenomicIndexUtil.regionToBin(alignmentStart, alignmentEnd);
        }

        private void processSingleReferenceSlice(Slice slice) {
            Bin bin;
            this.indexStats.recordMetaData(slice);
            ReferenceContext sliceContext = slice.getReferenceContext();
            if (!sliceContext.isMappedSingleRef()) {
                return;
            }
            int reference = sliceContext.getSequenceId();
            if (reference != CRAMBAIIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + CRAMBAIIndexer.this.currentReference + " for record " + slice);
            }
            int binNum = this.computeIndexingBin(slice);
            if (this.bins == null) {
                SAMSequenceRecord seq = this.bamHeader.getSequence(reference);
                this.bins = seq == null ? new Bin[37451] : new Bin[AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(seq.getSequenceLength()) + 1];
            }
            if (this.bins[binNum] != null) {
                bin = this.bins[binNum];
            } else {
                this.bins[binNum] = bin = new Bin(reference, binNum);
                ++this.binsSeen;
            }
            long chunkStart = slice.containerOffset << 16 | (long)slice.index;
            long chunkEnd = (slice.containerOffset << 16 | (long)slice.index) + 1L;
            Chunk newChunk = new Chunk(chunkStart, chunkEnd);
            List<Chunk> oldChunks = bin.getChunkList();
            if (!bin.containsChunks()) {
                bin.addInitialChunk(newChunk);
            } else {
                Chunk lastChunk = bin.getLastChunk();
                if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(lastChunk.getChunkEnd(), chunkStart)) {
                    lastChunk.setChunkEnd(chunkEnd);
                } else {
                    oldChunks.add(newChunk);
                    bin.setLastChunk(newChunk);
                }
            }
            int alignmentStart = slice.alignmentStart;
            int alignmentEnd = slice.alignmentStart + slice.alignmentSpan;
            int startWindow = LinearIndex.convertToLinearIndexOffset(alignmentStart);
            int endWindow = alignmentEnd == 0 ? (startWindow = LinearIndex.convertToLinearIndexOffset(alignmentStart - 1)) : LinearIndex.convertToLinearIndexOffset(alignmentEnd);
            if (endWindow > this.largestIndexSeen) {
                this.largestIndexSeen = endWindow;
            }
            int win = startWindow;
            while (win <= endWindow) {
                if (this.index[win] == 0L || chunkStart < this.index[win]) {
                    this.index[win] = chunkStart;
                }
                ++win;
            }
        }

        public BAMIndexContent processReference(int reference) {
            if (reference != CRAMBAIIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + reference + " when constructing index for " + CRAMBAIIndexer.this.currentReference);
            }
            if (this.binsSeen == 0) {
                return null;
            }
            long[] newIndex = new long[this.largestIndexSeen + 1];
            long lastNonZeroOffset = 0L;
            int i = 0;
            while (i <= this.largestIndexSeen) {
                if (this.index[i] == 0L) {
                    this.index[i] = lastNonZeroOffset;
                } else {
                    lastNonZeroOffset = this.index[i];
                }
                newIndex[i] = this.index[i];
                ++i;
            }
            LinearIndex linearIndex = new LinearIndex(reference, 0, newIndex);
            return new BAMIndexContent(reference, this.bins, this.binsSeen, this.indexStats, linearIndex);
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            this.bins = null;
            if (this.binsSeen > 0) {
                Arrays.fill(this.index, 0L);
            }
            this.binsSeen = 0;
            this.largestIndexSeen = -1;
            this.indexStats.newReference();
        }
    }
}

