/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.util.Arrays;
import java.util.List;

public class BinningIndexBuilder {
    private static final int UNINITIALIZED_WINDOW = -1;
    private final int referenceSequence;
    private final Bin[] bins;
    private int binsSeen = 0;
    private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
    private int largestIndexSeen = -1;

    public BinningIndexBuilder(int referenceSequence, int sequenceLength) {
        this.referenceSequence = referenceSequence;
        Arrays.fill(this.index, -1L);
        int numBins = sequenceLength <= 0 ? 37451 : AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(sequenceLength) + 1;
        this.bins = new Bin[numBins];
    }

    public BinningIndexBuilder(int referenceSequence) {
        this(referenceSequence, 0);
    }

    public void processFeature(FeatureToBeIndexed feature) {
        Bin bin;
        int binNum;
        Integer binNumber = feature.getIndexingBin();
        int n = binNum = binNumber == null ? this.computeIndexingBin(feature) : binNumber.intValue();
        if (this.bins[binNum] != null) {
            bin = this.bins[binNum];
        } else {
            this.bins[binNum] = bin = new Bin(this.referenceSequence, binNum);
            ++this.binsSeen;
        }
        Chunk newChunk = feature.getChunk();
        long chunkStart = newChunk.getChunkStart();
        long chunkEnd = newChunk.getChunkEnd();
        List<Chunk> oldChunks = bin.getChunkList();
        if (!bin.containsChunks()) {
            bin.addInitialChunk(newChunk);
        } else {
            Chunk lastChunk = bin.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(lastChunk.getChunkEnd(), chunkStart)) {
                lastChunk.setChunkEnd(chunkEnd);
            } else {
                oldChunks.add(newChunk);
                bin.setLastChunk(newChunk);
            }
        }
        int featureEnd = feature.getEnd();
        int startWindow = LinearIndex.convertToLinearIndexOffset(feature.getStart());
        int endWindow = featureEnd == 0 ? (startWindow = LinearIndex.convertToLinearIndexOffset(feature.getStart() - 1)) : LinearIndex.convertToLinearIndexOffset(featureEnd);
        if (endWindow > this.largestIndexSeen) {
            this.largestIndexSeen = endWindow;
        }
        int win = startWindow;
        while (win <= endWindow) {
            if (this.index[win] == -1L || chunkStart < this.index[win]) {
                this.index[win] = chunkStart;
            }
            ++win;
        }
    }

    public BinningIndexContent generateIndexContent() {
        if (this.binsSeen == 0) {
            return null;
        }
        long[] newIndex = new long[this.largestIndexSeen + 1];
        long lastNonZeroOffset = 0L;
        int i = 0;
        while (i <= this.largestIndexSeen) {
            if (this.index[i] == -1L) {
                this.index[i] = lastNonZeroOffset;
            } else {
                lastNonZeroOffset = this.index[i];
            }
            newIndex[i] = this.index[i];
            ++i;
        }
        LinearIndex linearIndex = new LinearIndex(this.referenceSequence, 0, newIndex);
        return new BinningIndexContent(this.referenceSequence, new BinningIndexContent.BinList(this.bins, this.binsSeen), linearIndex);
    }

    private int computeIndexingBin(FeatureToBeIndexed feature) {
        int start = feature.getStart() - 1;
        int end = feature.getEnd();
        if (end <= 0) {
            end = start + 1;
        }
        return GenomicIndexUtil.regionToBin(start, end);
    }

    public static interface FeatureToBeIndexed {
        public int getStart();

        public int getEnd();

        public Integer getIndexingBin();

        public Chunk getChunk();
    }
}

