/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CSIIndex;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamIndexes;
import htsjdk.samtools.SamReader;
import java.util.Arrays;
import java.util.List;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            if (SamIndexes.BAI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int indexCount = 0;
                int i = 0;
                while (i < numRefs) {
                    BAMIndexContent content = existingIndex.getQueryResults(i);
                    for (Chunk c : content.getAllChunks()) {
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        ++chunkCount;
                        SAMRecord sam = null;
                        try {
                            sam = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Last good record " + sam + " in chunk " + c + " chunkCount=" + chunkCount, e);
                        }
                    }
                    LinearIndex linearIndex = content.getLinearIndex();
                    long[] lArray = linearIndex.getIndexEntries();
                    int n = lArray.length;
                    int sam = 0;
                    while (sam < n) {
                        long l = lArray[sam];
                        try {
                            if (l != 0L) {
                                SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                                SAMRecord sam2 = (SAMRecord)iter.next();
                                ++indexCount;
                                iter.close();
                            }
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                        }
                        ++sam;
                    }
                    ++i;
                }
                return chunkCount;
            }
            if (SamIndexes.CSI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CSIIndex existingIndex = (CSIIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int i = 0;
                while (i < numRefs) {
                    BAMIndexContent content = existingIndex.getQueryResults(i);
                    for (Chunk c : content.getAllChunks()) {
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        ++chunkCount;
                        SAMRecord sam = null;
                        try {
                            sam = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Last good record " + sam + " in chunk " + c + " chunkCount=" + chunkCount, e);
                        }
                    }
                    ++i;
                }
                return chunkCount;
            }
        }
        return 0;
    }

    public static int lessExhaustivelyTestIndex(SamReader reader) {
        if (reader.indexing().hasBrowseableIndex()) {
            if (SamIndexes.BAI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int indexCount = 0;
                int i = 0;
                while (i < numRefs) {
                    Object c;
                    BAMIndexContent content = existingIndex.getQueryResults(i);
                    List<Chunk> chunks = content.getAllChunks();
                    int numChunks = chunks.size();
                    for (int chunkNo : Arrays.asList(0, numChunks - 1)) {
                        ++chunkCount;
                        c = chunks.get(chunkNo);
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan((Chunk)c));
                        try {
                            SAMRecord sam = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception querying chunk " + chunkNo + " from reference index " + i, e);
                        }
                    }
                    long[] linearIndexEntries = content.getLinearIndex().getIndexEntries();
                    c = Arrays.asList(0, linearIndexEntries.length - 1).iterator();
                    while (c.hasNext()) {
                        int binNo = (Integer)c.next();
                        ++indexCount;
                        long l = linearIndexEntries[binNo];
                        try {
                            if (l == 0L) continue;
                            SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                            SAMRecord sam = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                        }
                    }
                    ++i;
                }
                return chunkCount;
            }
            if (SamIndexes.CSI.fileNameSuffix.endsWith(reader.type().indexExtension())) {
                CSIIndex existingIndex = (CSIIndex)reader.indexing().getBrowseableIndex();
                int numRefs = existingIndex.getNumberOfReferences();
                int chunkCount = 0;
                int i = 0;
                while (i < numRefs) {
                    BAMIndexContent content = existingIndex.getQueryResults(i);
                    List<Chunk> chunks = content.getAllChunks();
                    int numChunks = chunks.size();
                    for (int chunkNo : Arrays.asList(0, numChunks - 1)) {
                        ++chunkCount;
                        Chunk c = chunks.get(chunkNo);
                        SAMRecordIterator iter = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader).iterator(new BAMFileSpan(c));
                        try {
                            SAMRecord sam = (SAMRecord)iter.next();
                            iter.close();
                        }
                        catch (Exception e) {
                            throw new SAMException("Exception querying chunk " + chunkNo + " from reference index " + i, e);
                        }
                    }
                    ++i;
                }
                return chunkCount;
            }
        }
        return 0;
    }

    public static enum IndexValidationStringency {
        EXHAUSTIVE,
        LESS_EXHAUSTIVE,
        NONE;

    }
}

