/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ErrorLog;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Sample;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StatsTable
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    BufferedImage bufImage;
    ListSorter sorter = new ListSorter();
    int rowHeight = 15;
    int geneheaderlength = 0;
    int variants = 0;
    Graphics2D buf;
    StringBuffer mutcountbuffer = new StringBuffer("");
    int width;
    int height;
    ArrayList<Object[]> sampleArray = new ArrayList();
    ArrayList<Sample> samples = new ArrayList();
    int mouseY = 0;
    int mouseX = 0;
    int pressX = 0;
    int pressY = 0;
    final JScrollPane tablescroll;
    Object[] hoverNode;
    Object[] selectedNode;
    String[] posSplit;
    String[] hoverString;
    int samplecount = 0;
    Enumeration<String> e;
    String base;
    ArrayList<String> geneheader = new ArrayList();
    String[] header = new String[]{"Sample", "Variants", "SNVs", "DELs", "INSs", "Coding", "Hetero/homo-rate", "TS/TV-rate", "T>A", "T>C", "T>G", "C>A", "C>G", "C>T", "Avg.call/cov"};
    int[][] headerlengths = new int[this.header.length][2];
    private int genemutcount;
    VarNode hoverVar;
    int headerHover;
    boolean dot = false;
    Polygon sortTriangle = new Polygon();
    ArrayList<SampleNode> vararray = new ArrayList();
    ArrayList<SampleNode> controlarray;
    VarNode varAdd;
    Map.Entry<String, ArrayList<SampleNode>> entry;
    MethodLibrary.controlsorter ctrlsort = new MethodLibrary.controlsorter();
    private Color linecolor;
    private Sample sample;

    StatsTable(int width, int height, JScrollPane tablescroll) {
        this.width = width;
        this.height = height;
        this.tablescroll = tablescroll;
        this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(1, 1, 2));
        this.buf = (Graphics2D)this.bufImage.getGraphics();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.controlarray = new ArrayList();
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = tablescroll.getViewport().getWidth() / this.header.length;
        int i = 1;
        while (i < this.headerlengths.length) {
            this.headerlengths[i][0] = this.headerlengths[0][1] * i;
            this.headerlengths[i][1] = this.headerlengths[0][1];
            ++i;
        }
    }

    void resizeTable() {
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = this.tablescroll.getViewport().getWidth() / this.header.length;
        int i = 1;
        while (i < this.headerlengths.length) {
            this.headerlengths[i][0] = this.headerlengths[0][1] * i;
            this.headerlengths[i][1] = this.headerlengths[0][1];
            ++i;
        }
    }

    void drawScreen(Graphics g) {
        int i;
        this.buf.setColor(Color.black);
        this.buf.fillRect(0, 0, this.tablescroll.getViewport().getWidth(), this.tablescroll.getViewport().getHeight());
        if (this.width != this.tablescroll.getViewport().getWidth()) {
            this.width = this.tablescroll.getViewport().getWidth();
            this.createPolygon();
            this.resizeTable();
        }
        this.genemutcount = 0;
        if (this.sampleArray.size() > 0) {
            this.hoverVar = null;
            i = 0;
            while (i < this.sampleArray.size()) {
                this.dot = false;
                if ((i + 1 + this.samplecount + this.sampleArray.size()) * this.rowHeight >= this.tablescroll.getVerticalScrollBar().getValue()) {
                    if (i * this.rowHeight > this.tablescroll.getVerticalScrollBar().getValue() + this.tablescroll.getViewport().getHeight()) break;
                    if (this.mouseY >= this.rowHeight * (i + this.genemutcount + 1) && this.mouseY < this.rowHeight * (i + this.genemutcount + 2)) {
                        this.hoverNode = this.sampleArray.get(i);
                    }
                    try {
                        this.buf.setColor(Color.darkGray);
                        this.buf.drawLine(4, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.tablescroll.getViewport().getWidth(), this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                        this.linecolor = this.sampleArray.get(i).equals(this.hoverNode) || this.sampleArray.get(i).equals(this.selectedNode) ? Color.yellow : Color.white;
                        this.buf.setColor(this.linecolor);
                        int c = 0;
                        while (c < this.headerlengths.length) {
                            if (c == 0) {
                                this.sample = (Sample)this.sampleArray.get(i)[c];
                                this.buf.drawString(String.valueOf(i + 1) + ".  " + this.sample.getName(), this.headerlengths[c][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            } else {
                                this.buf.drawString("" + this.sampleArray.get(i)[c], this.headerlengths[c][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            }
                            if (c < this.headerlengths.length - 1) {
                                this.buf.setColor(Color.black);
                                this.buf.fillRect(this.headerlengths[c + 1][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.headerlengths[c][1], this.rowHeight - 1);
                                this.buf.setColor(this.linecolor);
                            }
                            ++c;
                        }
                    }
                    catch (Exception e) {
                        ErrorLog.addError(e.getStackTrace());
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.buf.setColor(Color.darkGray);
            this.buf.drawLine(4, this.rowHeight * (this.sampleArray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.tablescroll.getViewport().getWidth(), this.rowHeight * (this.sampleArray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
        }
        this.headerHover = -1;
        i = 0;
        while (i < this.header.length) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect(i * this.tablescroll.getViewport().getWidth() / this.header.length, 0, this.tablescroll.getViewport().getWidth() / this.header.length + 1, this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() < this.rowHeight && this.mouseX > i * this.tablescroll.getViewport().getWidth() / this.header.length && this.mouseX < (i + 1) * this.tablescroll.getViewport().getWidth() / this.header.length) {
                this.headerHover = i;
                this.buf.setColor(Color.yellow);
            } else {
                this.buf.setColor(Color.white);
            }
            this.buf.drawString(this.header[i], i * this.tablescroll.getViewport().getWidth() / this.header.length + 4, this.rowHeight - 2);
            this.buf.setColor(Color.black);
            this.buf.drawLine(i * this.tablescroll.getViewport().getWidth() / this.header.length, 0, i * this.tablescroll.getViewport().getWidth() / this.header.length, this.rowHeight);
            if (this.sorter.index > -1) {
                if (this.sorter.ascending) {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                } else {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                }
            }
            ++i;
        }
        if (this.headerHover == -1) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
    }

    void drawGeneheader(int y) {
        int i = 0;
        while (i < this.geneheader.size()) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect((int)((double)i * ((double)(this.tablescroll.getViewport().getWidth() - 10) / (double)this.geneheader.size())) + 10, y, (int)((double)(this.tablescroll.getViewport().getWidth() - 10) / (double)this.geneheader.size() + 1.0), this.rowHeight);
            this.buf.setColor(Color.white);
            this.buf.drawString(this.geneheader.get(i), (int)((double)(i * (this.tablescroll.getViewport().getWidth() - 10)) / (double)this.geneheader.size() + 14.0), y + this.rowHeight - 3);
            this.buf.setColor(Color.black);
            this.buf.drawLine((int)((double)(i * (this.tablescroll.getViewport().getWidth() - 10)) / (double)this.geneheader.size()) + 10, y, (int)((double)(i * (this.tablescroll.getViewport().getWidth() - 10)) / (double)this.geneheader.size()) + 10, y + this.rowHeight);
            ++i;
        }
    }

    void addEntry(String[] entry) {
        this.sampleArray.add(entry);
    }

    void clear() {
        this.samples.clear();
        this.sampleArray.clear();
        this.controlarray.clear();
        this.varAdd = null;
        this.hoverNode = null;
        this.selectedNode = null;
        this.entry = null;
        this.vararray.clear();
        this.hoverVar = null;
    }

    int getTableSize() {
        return this.sampleArray.size();
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.drawScreen(g);
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getModifiers()) {
            case 4: 
            case 16: {
                this.selectedNode = null;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    void createPolygon() {
        if (this.sorter.ascending) {
            int[] x = new int[]{(this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 15, (this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 10, (this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 5};
            int[] y = new int[]{12, 4, 12};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        } else {
            int[] x = new int[]{(this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 15, (this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 10, (this.sorter.index + 1) * this.tablescroll.getViewport().getWidth() / this.header.length - 5};
            int[] y = new int[]{4, 12, 4};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled()) break;
                if (this.headerHover > -1) {
                    this.sorter.ascending = !this.sorter.ascending;
                    this.sorter.index = this.headerHover;
                    Collections.sort(this.sampleArray, this.sorter);
                    this.createPolygon();
                    this.repaint();
                }
                if (this.hoverNode == null && this.hoverVar == null) break;
                Main.chromDraw.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.mouseY = event.getY();
        this.mouseX = event.getX();
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() - 16);
        } else {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() + 16);
        }
        this.repaint();
    }

    public static class ListSorter
    implements Comparator<Object[]> {
        public int index;
        boolean ascending = true;

        @Override
        public int compare(Object[] o1, Object[] o2) {
            double f2;
            if (this.index == 0) {
                String f22;
                Sample s1 = (Sample)o1[0];
                Sample s2 = (Sample)o2[0];
                String f1 = s1.getName();
                if (f1.compareTo(f22 = s2.getName()) < 0) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1.compareTo(f22) > 0) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (o1[this.index] instanceof Integer) {
                int f23;
                int f1 = (Integer)o1[this.index];
                if (f1 < (f23 = ((Integer)o2[this.index]).intValue())) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f23) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            double f1 = (Double)o1[this.index];
            if (f1 < (f2 = ((Double)o2[this.index]).doubleValue())) {
                if (this.ascending) {
                    return -1;
                }
                return 1;
            }
            if (f1 > f2) {
                if (this.ascending) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

