/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BBfile.BigWigIterator;
import base.BBfile.WigItem;
import base.BasePlayer.BedTrack;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Reads;
import base.BasePlayer.Sample;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class PeakCaller
extends JPanel
implements ActionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    static Boolean loading = false;
    static JFrame frame = new JFrame("Peak Caller");
    JLabel testing = new JLabel("Read Peak Caller test");
    static JTextField minreads = new JTextField("10");
    JLabel minreadlabel = new JLabel("Minimum coverage for calling:");
    static JTextField minwidth = new JTextField("10");
    JLabel minwidthlabel = new JLabel("Minimum width of region:");
    static String savepath = "";
    static JLabel info = new JLabel("");
    static JCheckBox allchroms = new JCheckBox("All chromosomes");
    JButton execute = new JButton("Execute");

    public PeakCaller(boolean caller) {
    }

    public PeakCaller() {
        super(new GridLayout(8, 1));
        try {
            frame.addComponentListener(this);
            boolean bams = false;
            int i = 0;
            while (i < Main.bedCanvas.bedTrack.size()) {
                if (Main.bedCanvas.bedTrack.get((int)i).file.getName().toLowerCase().endsWith(".bw") || Main.bedCanvas.bedTrack.get((int)i).file.getName().toLowerCase().endsWith(".bigwig")) {
                    bams = true;
                    break;
                }
                ++i;
            }
            if (!bams) {
                info.setText("Open BigWig files to call the read peaks.");
                this.execute.setEnabled(false);
            }
            savepath = String.valueOf(savepath) + "/";
            this.testing.setForeground(Color.red);
            this.execute.addActionListener(this);
            allchroms.addActionListener(this);
            this.add(this.testing);
            this.add(info);
            this.add(this.minreadlabel);
            this.add(minreads);
            this.add(this.minwidthlabel);
            this.add(minwidth);
            this.add(allchroms);
            this.add(this.execute);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createAndShowGUI() {
        if (Main.frame != null) {
            frame.setDefaultCloseOperation(2);
            frame.setVisible(false);
        } else {
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        frame.setAlwaysOnTop(true);
        PeakCaller newContentPane = new PeakCaller();
        newContentPane.setOpaque(false);
        frame.setContentPane(newContentPane);
        PeakCaller.setFonts(Main.menuFont);
        frame.pack();
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setMinimumSize(frame.getContentPane().getComponent(i).getPreferredSize());
            ++i;
        }
        minreads.setMinimumSize(new Dimension(minreads.getWidth(), minreads.getHeight()));
        minwidth.setMinimumSize(new Dimension(minwidth.getWidth(), minwidth.getHeight()));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PeakCaller.createAndShowGUI();
            }
        });
    }

    static void setFonts(Font menuFont) {
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setFont(menuFont);
            ++i;
        }
        frame.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.execute) {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(2);
                chooser.setDialogTitle("Save peak results in...");
                int returnVal = chooser.showSaveDialog(this.getParent());
                if (returnVal == 0) {
                    PeakRunner caller = new PeakRunner(chooser.getSelectedFile().getCanonicalPath());
                    caller.execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        boolean bams = false;
        int i = 0;
        while (i < Main.bedCanvas.bedTrack.size()) {
            if (Main.bedCanvas.bedTrack.get((int)i).file.getName().toLowerCase().endsWith(".bw") || Main.bedCanvas.bedTrack.get((int)i).file.getName().toLowerCase().endsWith(".bigwig")) {
                bams = true;
                break;
            }
            ++i;
        }
        if (!bams) {
            info.setText("Open BigWig files to call the read peaks.");
            this.execute.setEnabled(false);
        } else {
            info.setText("");
            this.execute.setEnabled(true);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public class PeakRunner
    extends SwingWorker<String, Object> {
        int minwidth;
        int minquality;
        int minreadquality;
        int mincoverage;
        double readlevel;
        boolean onlysel;
        String savepath = "";

        public PeakRunner(int readlevel, int minquality, int minreadquality, int mincoverage, boolean onlysel) {
            this.readlevel = readlevel;
            this.minquality = minquality;
            this.minreadquality = minreadquality;
            this.mincoverage = mincoverage;
            this.onlysel = onlysel;
        }

        public PeakRunner(String savepath) {
            int minwidth;
            double readlevel;
            this.savepath = String.valueOf(savepath) + "/";
            try {
                readlevel = Double.parseDouble(minreads.getText());
                minwidth = Integer.parseInt(PeakCaller.minwidth.getText());
            }
            catch (Exception e) {
                minreads.setForeground(Color.red);
                return;
            }
            this.readlevel = readlevel;
            this.minwidth = minwidth;
        }

        void callWigPeaks() {
            loading = true;
            if (!Main.drawCanvas.loading) {
                Main.drawCanvas.loading("Calling peaks");
            } else {
                Main.drawCanvas.loadingtext = "Calling peaks";
            }
            int chromindex = 0;
            ArrayList<BedTrack> samples = new ArrayList<BedTrack>();
            ArrayList<BufferedWriter> samplewriter = new ArrayList<BufferedWriter>();
            try {
                int i = 0;
                while (i < Main.bedCanvas.bedTrack.size()) {
                    if (Main.bedCanvas.bedTrack.get((int)i).file != null) {
                        samples.add(Main.bedCanvas.bedTrack.get(i));
                        String samplename = String.valueOf(Main.bedCanvas.bedTrack.get((int)i).file.getName().toLowerCase().replace(".bw", "").replace(".bigwig", "")) + "_peaks.bed";
                        BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(this.savepath) + samplename));
                        samplewriter.add(writer);
                        writer.write("#chrom\tstart\tend\tOverlappingGenes\tHighestPeak\tRegionWidth\n");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (allchroms.isSelected()) {
                Main.nothread = true;
                Main.chromosomeDropdown.setSelectedIndex(0);
            }
            BigWigIterator wigiter = null;
            WigItem features = null;
            int loadbarsamplevalue = 0;
            while (chromindex < 25) {
                if (!Main.drawCanvas.loading) break;
                int s = 0;
                while (s < samples.size()) {
                    try {
                        if (!Main.drawCanvas.loading) break;
                        Main.drawCanvas.loadBarSample = loadbarsamplevalue = (int)((double)s / (double)samples.size() * 100.0);
                        BedTrack track = (BedTrack)samples.get(s);
                        int startpos = (int)Main.drawCanvas.splits.get((int)0).start;
                        int endpos = (int)Main.drawCanvas.splits.get((int)0).end;
                        boolean start = false;
                        wigiter = track.getBBfileReader().getBigWigIterator(String.valueOf(track.chr) + Main.chromosomeDropdown.getSelectedItem().toString(), startpos, String.valueOf(track.chr) + Main.chromosomeDropdown.getSelectedItem().toString(), endpos, false);
                        track.setZoomlevel(1);
                        int regionstart = 0;
                        int regionend = 0;
                        Float maxvalue = Float.valueOf(0.0f);
                        while (wigiter.hasNext()) {
                            if (!Main.drawCanvas.loading) break;
                            try {
                                features = wigiter.next();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                ErrorLog.addError(ex.getStackTrace());
                                Main.showError(ex.getMessage(), "Error");
                                break;
                            }
                            if ((double)features.getWigValue() >= this.readlevel && !start) {
                                start = true;
                                regionstart = features.getStartBase();
                                maxvalue = Float.valueOf(features.getWigValue());
                                continue;
                            }
                            if ((double)features.getWigValue() < this.readlevel && start) {
                                regionend = features.getEndBase();
                                String genes = MethodLibrary.getOverlappingGenes(regionstart, regionend, Main.drawCanvas.splits.get(0));
                                Main.drawCanvas.loadbarAll = (int)((double)regionstart / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
                                Main.drawCanvas.loadBarSample = loadbarsamplevalue + (int)((double)regionstart / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0) / samples.size();
                                if (regionend - regionstart >= this.minwidth) {
                                    try {
                                        ((BufferedWriter)samplewriter.get(s)).write(Main.chromosomeDropdown.getSelectedItem() + "\t" + (regionstart + 1) + "\t" + regionend + "\t" + genes + "\t" + maxvalue + "\t" + (regionend - regionstart) + "\n");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        ErrorLog.addError(e.getStackTrace());
                                        Main.showError(e.getMessage(), "Error");
                                        break;
                                    }
                                }
                                start = false;
                                continue;
                            }
                            if (!(maxvalue.floatValue() < features.getWigValue())) continue;
                            maxvalue = Float.valueOf(features.getWigValue());
                        }
                    }
                    catch (Exception e) {
                        ErrorLog.addError(e.getStackTrace());
                        Main.showError(e.getMessage(), "Error");
                        e.printStackTrace();
                        break;
                    }
                    ++s;
                }
                if (!allchroms.isSelected() || ++chromindex == 25) break;
                if (!allchroms.isSelected()) continue;
                Main.nothread = true;
                Main.chromosomeDropdown.setSelectedIndex(chromindex);
            }
            try {
                int i = 0;
                while (i < samplewriter.size()) {
                    ((BufferedWriter)samplewriter.get(i)).close();
                    ++i;
                }
            }
            catch (Exception e) {
                ErrorLog.addError(e.getStackTrace());
                e.printStackTrace();
                Main.showError(e.getMessage(), "Error");
            }
            Main.drawCanvas.ready("Calling peaks");
            Main.drawCanvas.repaint();
            loading = false;
        }

        void callPeaks() {
            if (this.onlysel && (Main.drawCanvas.selectedSample == null || Main.drawCanvas.selectedSample.getTabixFile() != null || Main.drawCanvas.selectedSample.samFile == null)) {
                loading = false;
                return;
            }
            FileRead reader = new FileRead();
            loading = true;
            if (!Main.drawCanvas.loading) {
                Main.drawCanvas.loading("Calling peaks");
            } else {
                Main.drawCanvas.loadingtext = "Calling peaks";
            }
            int chromindex = 0;
            ArrayList<Sample> samples = new ArrayList<Sample>();
            ArrayList<BufferedWriter> samplewriter = new ArrayList<BufferedWriter>();
            try {
                int i = 0;
                while (i < Main.samples) {
                    if (Main.drawCanvas.sampleList.get((int)i).samFile != null) {
                        samples.add(Main.drawCanvas.sampleList.get(i));
                        String samplename = String.valueOf(Main.drawCanvas.sampleList.get(i).getName().replace(".bam", "")) + "_peaks.bed";
                        BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(this.savepath) + samplename));
                        samplewriter.add(writer);
                        writer.write("#chrom\tstart\tend\tOverlappingGenes\tHighestPeak\n");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (allchroms.isSelected()) {
                Main.nothread = true;
                Main.chromosomeDropdown.setSelectedIndex(0);
            }
            int loadbarsamplevalue = 0;
            while (chromindex < 25) {
                if (!Main.drawCanvas.loading) break;
                int s = 0;
                while (s < samples.size()) {
                    block33: {
                        try {
                            if (!Main.drawCanvas.loading) break;
                            Main.drawCanvas.loadBarSample = loadbarsamplevalue = (int)((double)s / (double)Main.samples * 100.0);
                            Sample sample = (Sample)samples.get(s);
                            sample.basequalsum = 0;
                            sample.basequals = 0;
                            if (this.onlysel && !sample.equals(Main.drawCanvas.selectedSample)) break block33;
                            Reads reads = null;
                            try {
                                reads = (Reads)sample.getreadHash().get(Main.drawCanvas.splits.get(0)).clone();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (!Main.drawCanvas.loading) {
                                Main.drawCanvas.ready("all");
                                break;
                            }
                            int startpos = (int)Main.drawCanvas.splits.get((int)0).start;
                            int endpos = (int)Main.drawCanvas.splits.get((int)0).end;
                            Iterator<SAMRecord> bamIterator = reader.getBamIterator(reads, String.valueOf(reads.sample.chr) + Main.drawCanvas.splits.get((int)0).chrom, startpos, endpos);
                            SAMRecord samRecord = null;
                            int coveragestart = 0;
                            int coverageend = 0;
                            int prevend = 0;
                            ArrayList<Integer> coverages = new ArrayList<Integer>();
                            int i = 0;
                            while (i < 2000) {
                                coverages.add(0);
                                ++i;
                            }
                            boolean start = false;
                            boolean printed = false;
                            int regionstart = 0;
                            int regionend = 0;
                            int maxvalue = 0;
                            while (bamIterator != null && bamIterator.hasNext()) {
                                if (!Main.drawCanvas.loading) {
                                    Main.drawCanvas.ready("all");
                                    break;
                                }
                                try {
                                    samRecord = bamIterator.next();
                                }
                                catch (SAMFormatException ex) {
                                    ex.printStackTrace();
                                    continue;
                                }
                                if (samRecord.getReadUnmappedFlag() || samRecord.getUnclippedEnd() < startpos) continue;
                                if (samRecord.getUnclippedStart() >= endpos) break;
                                if (coveragestart != 0) {
                                    printed = false;
                                    maxvalue = 0;
                                    if (prevend < samRecord.getAlignmentStart()) {
                                        int i2 = 0;
                                        while (i2 < coverages.size()) {
                                            if ((Integer)coverages.get(i2) == 0) break;
                                            if (start && (double)((Integer)coverages.get(i2)).intValue() < this.readlevel) {
                                                start = false;
                                                regionend = coveragestart + i2;
                                                String genes = MethodLibrary.getOverlappingGenes(regionstart, regionend, Main.drawCanvas.splits.get(0));
                                                Main.drawCanvas.loadbarAll = (int)((double)regionstart / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0);
                                                Main.drawCanvas.loadBarSample = loadbarsamplevalue + (int)((double)regionstart / (double)Main.drawCanvas.splits.get((int)0).chromEnd * 100.0) / samples.size();
                                                ((BufferedWriter)samplewriter.get(s)).write(String.valueOf(Main.drawCanvas.splits.get((int)0).chrom) + "\t" + regionstart + "\t" + regionend + "\t" + genes + "\t" + maxvalue + "\n");
                                            }
                                            if (!start && (double)((Integer)coverages.get(i2)).intValue() >= this.readlevel) {
                                                start = true;
                                                regionstart = coveragestart + i2;
                                            }
                                            if (start && maxvalue < (Integer)coverages.get(i2)) {
                                                maxvalue = (Integer)coverages.get(i2);
                                            }
                                            coverages.set(i2, 0);
                                            ++i2;
                                        }
                                        coverageend = 0;
                                    }
                                }
                                if (coverageend == 0) {
                                    coveragestart = samRecord.getAlignmentStart();
                                }
                                prevend = coverageend = samRecord.getAlignmentEnd();
                                int i3 = 0;
                                while (i3 < samRecord.getReadLength()) {
                                    if (samRecord.getAlignmentStart() - coveragestart + i3 > coverages.size() - 1) {
                                        int j = 0;
                                        while (j < 2000) {
                                            coverages.add(0);
                                            ++j;
                                        }
                                    }
                                    coverages.set(samRecord.getAlignmentStart() - coveragestart + i3, (Integer)coverages.get(samRecord.getAlignmentStart() - coveragestart + i3) + 1);
                                    ++i3;
                                }
                            }
                            reads = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    ++s;
                }
                if (!allchroms.isSelected() || ++chromindex == 25) break;
                if (!allchroms.isSelected()) continue;
                Main.nothread = true;
                Main.chromosomeDropdown.setSelectedIndex(chromindex);
            }
            try {
                int i = 0;
                while (i < samplewriter.size()) {
                    ((BufferedWriter)samplewriter.get(i)).close();
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Main.drawCanvas.ready("Calling peaks");
            Main.drawCanvas.repaint();
            loading = false;
        }

        @Override
        protected String doInBackground() throws Exception {
            this.callWigPeaks();
            return null;
        }
    }
}

