/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.AbstractVCFCodec;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OwnVCFCodec
extends AbstractVCFCodec {
    public static final String VCF4_MAGIC_HEADER = "##fileformat=VCFv4";
    private static final VCFHeaderVersion VCFHeaderVersion = null;

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        boolean foundHeaderVersion = false;
        while (lineIterator.hasNext()) {
            String line = lineIterator.peek();
            ++this.lineNo;
            if (line.startsWith("##")) {
                String[] lineFields = line.substring(2).split("=");
                if (lineFields.length == 2 && htsjdk.variant.vcf.VCFHeaderVersion.isFormatString(lineFields[0])) {
                    if (!htsjdk.variant.vcf.VCFHeaderVersion.isVersionString(lineFields[1])) {
                        throw new TribbleException.InvalidHeader(String.valueOf(lineFields[1]) + " is not a supported version");
                    }
                    foundHeaderVersion = true;
                    this.version = htsjdk.variant.vcf.VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                    if (!this.version.isAtLeastAsRecentAs(htsjdk.variant.vcf.VCFHeaderVersion.VCF4_0)) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + lineFields[1]);
                    }
                    if (this.version != htsjdk.variant.vcf.VCFHeaderVersion.VCF4_0 && this.version != htsjdk.variant.vcf.VCFHeaderVersion.VCF4_1 && this.version != htsjdk.variant.vcf.VCFHeaderVersion.VCF4_2) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + lineFields[1]);
                    }
                }
                headerStrings.add((String)lineIterator.next());
                continue;
            }
            if (line.startsWith("#")) {
                if (!foundHeaderVersion) {
                    throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                }
                headerStrings.add((String)lineIterator.next());
                super.parseHeaderFromLines(headerStrings, this.version);
                return this.header;
            }
            throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    private VariantContext decodeLine(String line, boolean includeGenotypes) {
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new TribbleException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int nParts = ParsingUtils.split(line, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
            throw new TribbleException("Line " + this.lineNo + ": there aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )");
        }
        return this.parseVCFLine(this.parts, includeGenotypes);
    }

    private VariantContext parseVCFLine(String[] parts, boolean includeGenotypes) {
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.source(this.getName());
        ++this.lineNo;
        String chr = this.getCachedString(parts[0]);
        builder.chr(chr);
        int pos = -1;
        try {
            pos = Integer.valueOf(parts[1]);
        }
        catch (NumberFormatException e) {
            this.generateException(String.valueOf(parts[1]) + " is not a valid start position in the VCF format");
        }
        builder.start(pos);
        if (parts[2].isEmpty()) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (parts[2].equals(".")) {
            builder.noID();
        } else {
            builder.id(parts[2]);
        }
        String ref = this.getCachedString(parts[3].toUpperCase());
        String alts = this.getCachedString(parts[4]);
        if (parts.length > 5 && parts[5] != null) {
            builder.log10PError(OwnVCFCodec.parseQual(parts[5]));
            List<String> filters = this.parseFilters(this.getCachedString(parts[6]));
            if (filters != null) {
                builder.filters(new HashSet<String>(filters));
            }
            Map<String, Object> attrs = this.parseInfo(parts[7]);
            builder.attributes(attrs);
            if (attrs.containsKey("END")) {
                try {
                    builder.stop(Integer.valueOf(attrs.get("END").toString()).intValue());
                }
                catch (Exception e) {
                    this.generateException("the END value in the INFO field is not valid");
                }
            } else {
                builder.stop(pos + ref.length() - 1);
            }
            List<Allele> alleles = null;
            try {
                alleles = OwnVCFCodec.parseAlleles(ref, alts, this.lineNo);
            }
            catch (Exception e) {
                alleles = OwnVCFCodec.parseAlleles(ref.replace("\"", ""), alts.replace("\"", ""), this.lineNo);
            }
            builder.alleles((Collection<Allele>)alleles);
            if (parts.length > 8 && includeGenotypes) {
                LazyVCFGenotypesParser lazyParser = new LazyVCFGenotypesParser(alleles, chr, pos);
                int nGenotypes = this.header.getNGenotypeSamples();
                LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, parts[8], nGenotypes);
                if (!this.header.samplesWereAlreadySorted()) {
                    lazy.decode();
                }
                builder.genotypesNoValidation(lazy);
            }
        } else {
            List<Allele> alleles = OwnVCFCodec.parseAlleles(ref, alts, this.lineNo);
            builder.alleles((Collection<Allele>)alleles);
            builder.log10PError(OwnVCFCodec.parseQual("20"));
            builder.stop(pos + ref.length() - 1);
        }
        VariantContext vc = null;
        try {
            vc = builder.make();
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        return vc;
    }

    @Override
    protected List<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        if (filterString.equals("PASS")) {
            return Collections.emptyList();
        }
        if (filterString.equals("0")) {
            OwnVCFCodec.generateException("0 is an invalid filter name in vcf4", this.lineNo);
        }
        if (filterString.isEmpty()) {
            OwnVCFCodec.generateException("The VCF specification requires a valid filter status: filter was " + filterString, this.lineNo);
        }
        if (this.filterHash.containsKey(filterString)) {
            return (List)this.filterHash.get(filterString);
        }
        LinkedList<String> fFields = new LinkedList<String>();
        if (!filterString.contains(";")) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, Collections.unmodifiableList(fFields));
        return fFields;
    }

    private Map<String, Object> parseInfo(String infoField) {
        HashMap<String, Object> attributes;
        block4: {
            attributes = new HashMap<String, Object>();
            if (infoField.isEmpty()) {
                this.generateException("The VCF specification requires a valid (non-zero length) info field");
            }
            if (infoField.equals(".")) break block4;
            if (infoField.indexOf(9) != -1 || infoField.indexOf(32) != -1) {
                infoField = infoField.split("\\s+")[0];
            }
            List<String> infoFields = ParsingUtils.split(infoField, ';');
            int i = 0;
            while (i < infoFields.size()) {
                block8: {
                    Object value;
                    String key;
                    block7: {
                        block5: {
                            List<String> infoValueSplit;
                            block6: {
                                int eqI = infoFields.get(i).indexOf("=");
                                if (eqI == -1) break block5;
                                key = infoFields.get(i).substring(0, eqI);
                                String valueString = infoFields.get(i).substring(eqI + 1);
                                infoValueSplit = ParsingUtils.split(valueString, ',');
                                if (infoValueSplit.size() != 1) break block6;
                                value = infoValueSplit.get(0);
                                VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                                if (headerLine == null || headerLine.getType() != VCFHeaderLineType.Flag || !value.equals("0")) break block7;
                                break block8;
                            }
                            value = infoValueSplit;
                            break block7;
                        }
                        key = infoFields.get(i);
                        VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                        value = headerLine != null && headerLine.getType() != VCFHeaderLineType.Flag ? "." : Boolean.valueOf(true);
                    }
                    if ("".equals(value)) {
                        value = ".";
                    }
                    attributes.put(key, value);
                }
                ++i;
            }
        }
        return attributes;
    }

    @Override
    public VariantContext decode(String line) {
        return this.decodeLine(line, true);
    }

    @Override
    public boolean canDecode(String potentialInput) {
        return OwnVCFCodec.canDecodeFile(potentialInput, VCF4_MAGIC_HEADER);
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> alleles, String contig, int start) {
            this.alleles = alleles;
            this.contig = contig;
            this.start = start;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            return OwnVCFCodec.this.createGenotypeMap((String)data, this.alleles, this.contig, this.start);
        }
    }
}

