/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.bed.FullBEDFeature;
import htsjdk.tribble.readers.LineIterator;
import java.util.regex.Pattern;

public class OWNCodec
extends AsciiFeatureCodec<BEDFeature> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\t|( +)");
    private final int startOffsetValue;

    public OWNCodec() {
        this(StartOffset.ONE);
    }

    public OWNCodec(StartOffset startOffset) {
        super(BEDFeature.class);
        this.startOffsetValue = startOffset.value();
    }

    public BEDFeature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public BEDFeature decode(String line) {
        if (line.trim().isEmpty()) {
            return null;
        }
        if (line.startsWith("#") || line.startsWith("track") || line.startsWith("browser")) {
            this.readHeaderLine(line);
            return null;
        }
        String[] tokens = SPLIT_PATTERN.split(line, -1);
        return this.decode(tokens);
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        return null;
    }

    @Override
    public BEDFeature decode(String[] tokens) {
        int tokenCount = tokens.length;
        if (tokenCount < 2) {
            return null;
        }
        String chr = tokens[0];
        int start = 0;
        try {
            start = Integer.parseInt(tokens[1]) + this.startOffsetValue;
        }
        catch (Exception e) {
            return null;
        }
        int end = start;
        if (tokenCount > 2) {
            try {
                end = Integer.parseInt(tokens[2]);
            }
            catch (Exception e) {
                end = Integer.parseInt(tokens[2].trim());
            }
        }
        FullBEDFeature feature = new FullBEDFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[3].replaceAll("\"", "");
            feature.setName(name);
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.isEmpty() ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        return feature;
    }

    protected boolean readHeaderLine(String line) {
        return false;
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".bed");
    }

    public int getStartOffset() {
        return this.startOffsetValue;
    }

    public static enum StartOffset {
        ZERO(0),
        ONE(1);

        private int start;

        private StartOffset(int start) {
            this.start = start;
        }

        public int value() {
            return this.start;
        }
    }
}

