/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.MethodLibrary;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InsertFetcher {
    byte[] seqresult;
    private StringBuffer seqBuffer;
    private RandomAccessFile chromo;
    private String resString;
    int seqStart = 0;
    String seq;
    private String readlen;
    static Hashtable<String, Long[]> chromIndex = new Hashtable();
    int[][] consensus5;
    char[] result5 = new char[0];
    int[][] consensus3;
    char[] result3 = new char[0];

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Give bam-file and reference.fa");
            System.exit(0);
        }
        try {
            String line;
            File refFile = new File(args[1]);
            RandomAccessFile referenceFile = new RandomAccessFile(refFile, "r");
            File chromindex = null;
            chromindex = new File(String.valueOf(refFile.getAbsolutePath()) + ".fai");
            BufferedReader reader = new BufferedReader(new FileReader(chromindex));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                Long[] add = new Long[]{Long.parseLong(split[2]), Long.parseLong(split[1]), Long.parseLong(split[3])};
                chromIndex.put(split[0], add);
            }
            reader.close();
            SamReader samFileReader = SamReaderFactory.make().open(new File(args[0]));
            InsertFetcher fetcher = new InsertFetcher();
            fetcher.searchInsSites2(samFileReader, referenceFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void searchInsSites(SamReader samFileReader, RandomAccessFile reference) {
        Hashtable<Integer, Character> bases = new Hashtable<Integer, Character>();
        bases.put(0, Character.valueOf('A'));
        bases.put(1, Character.valueOf('C'));
        bases.put(2, Character.valueOf('G'));
        bases.put(3, Character.valueOf('T'));
        bases.put(4, Character.valueOf('N'));
        Hashtable<Character, Integer> bases2 = new Hashtable<Character, Integer>();
        bases2.put(Character.valueOf('A'), 0);
        bases2.put(Character.valueOf('C'), 1);
        bases2.put(Character.valueOf('G'), 2);
        bases2.put(Character.valueOf('T'), 3);
        List<Integer> refReadQualities = Collections.synchronizedList(new ArrayList());
        int readLengths = 0;
        int clipLengths = 0;
        int consensusStart = 0;
        String sequence = "";
        String repeat = "";
        int maxbase = 0;
        int allbases = 0;
        int disbases = 0;
        int disbasetemp = 0;
        ArrayList<Integer> maxindex = new ArrayList<Integer>();
        int del = 0;
        String readString = "";
        Hashtable<Integer, Integer> startVote = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> endVote = new Hashtable<Integer, Integer>();
        int readPos = 0;
        int miscounter = 0;
        int clusterStart = 0;
        int startReadMisSum = 0;
        int endReadMisSum = 0;
        int clusterEnd = 0;
        int max = 0;
        int sum = 0;
        int refReads = 0;
        int altReads5 = 0;
        int altReads3 = 0;
        int breakPointStart = 0;
        int breakPointEnd = 0;
        int support5 = 0;
        int support3 = 0;
        List<Integer> positionList = Collections.synchronizedList(new ArrayList());
        List<Object[]> startReadList = Collections.synchronizedList(new ArrayList());
        List<Object[]> endReadList = Collections.synchronizedList(new ArrayList());
        String rate3 = "";
        String rate5 = "";
        SAMRecordIterator iter = samFileReader.iterator();
        while (iter.hasNext()) {
            SAMRecord cur = (SAMRecord)iter.next();
            if (cur.getReadUnmappedFlag() || cur.getMappingQuality() < 10) continue;
            try {
                int s;
                int h;
                int c;
                Object[] read;
                miscounter = 0;
                clusterStart = 0;
                clusterEnd = 0;
                startVote.clear();
                endVote.clear();
                refReads = 0;
                refReadQualities.clear();
                startReadList.clear();
                endReadList.clear();
                Cigar cigar = cur.getCigar();
                List<CigarElement> elements = cigar.getCigarElements();
                readString = cur.getReadString();
                if (!cigar.toString().contains("S")) continue;
                breakPointEnd = 0;
                breakPointStart = 0;
                clusterStart = cur.getUnclippedStart();
                clusterEnd = cur.getUnclippedStart() + 150;
                if (cigar.toString().endsWith("S")) {
                    clipLengths = elements.get(elements.size() - 1).getLength();
                    readLengths = cur.getReadLength();
                    read = new Object[]{cur.getUnclippedStart() + cur.getReadLength() - elements.get(elements.size() - 1).getLength() - 1, readString.substring(readString.length() - elements.get(elements.size() - 1).getLength(), readString.length())};
                    endReadList.add(read);
                } else {
                    clipLengths = elements.get(0).getLength();
                    readLengths = cur.getReadLength();
                    read = new Object[]{cur.getUnclippedStart(), readString.substring(0, elements.get(0).getLength())};
                    startReadList.add(read);
                }
                if (!iter.hasNext()) break;
                cur = (SAMRecord)iter.next();
                cigar = cur.getCigar();
                elements = cigar.getCigarElements();
                readString = cur.getReadString();
                while ((double)clipLengths / (double)readLengths > 0.1 && cur.getUnclippedStart() < clusterEnd) {
                    try {
                        if (cur.getCigarLength() > 0 && cur.getReadNegativeStrandFlag() && elements.get(0).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                            if (cur.getMappingQuality() >= 10) {
                                clipLengths += elements.get(0).getLength();
                                readLengths += cur.getReadLength();
                                read = new Object[]{cur.getUnclippedStart(), readString.substring(0, elements.get(0).getLength())};
                                startReadList.add(read);
                                if (startReadList.size() > 500) {
                                    startReadList.clear();
                                    endReadList.clear();
                                    break;
                                }
                            }
                        } else if (!cur.getReadNegativeStrandFlag() && cigar.toString().endsWith("S")) {
                            if (cur.getMappingQuality() >= 10) {
                                clipLengths += elements.get(elements.size() - 1).getLength();
                                readLengths += cur.getReadLength();
                                read = new Object[]{cur.getUnclippedStart() + cur.getReadLength() - elements.get(elements.size() - 1).getLength() - 1, readString.substring(readString.length() - elements.get(elements.size() - 1).getLength(), readString.length())};
                                endReadList.add(read);
                                if (endReadList.size() > 500) {
                                    startReadList.clear();
                                    endReadList.clear();
                                    break;
                                }
                            }
                        } else {
                            readLengths += cur.getReadLength();
                            refReadQualities.add(cur.getMappingQuality());
                            ++refReads;
                        }
                        if (!iter.hasNext()) break;
                        cur = (SAMRecord)iter.next();
                        cigar = cur.getCigar();
                        elements = cigar.getCigarElements();
                        readString = cur.getReadString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (startReadList.size() < 3 && endReadList.size() < 3) continue;
                clusterEnd = cur.getUnclippedStart() + cur.getReadLength();
                Collections.sort(refReadQualities);
                if (refReadQualities.size() > 0 && (Integer)refReadQualities.get(refReadQualities.size() / 2) < 10) continue;
                startReadMisSum = 0;
                this.seqStart = clusterStart - 100;
                sequence = this.getSeq(cur.getReferenceName(), clusterStart - 100, clusterEnd + 100, reference);
                int r = 0;
                while (r < startReadList.size()) {
                    miscounter = 0;
                    readPos = (Integer)((Object[])startReadList.get(r))[0];
                    readString = (String)((Object[])startReadList.get(r))[1];
                    c = 0;
                    while (c < readString.length()) {
                        if (readPos + c > this.seqStart && readPos + c - this.seqStart < sequence.length() && sequence.charAt(readPos + c - this.seqStart) != readString.charAt(c)) {
                            ++miscounter;
                        }
                        ++c;
                    }
                    if (readString.length() < 10 || (double)miscounter / (double)readString.length() > 0.05) {
                        ++startReadMisSum;
                        if (startVote.containsKey(readPos + readString.length())) {
                            startVote.put(readPos + readString.length(), (Integer)startVote.get(readPos + readString.length()) + 1);
                        } else {
                            startVote.put(readPos + readString.length(), 1);
                        }
                    } else {
                        startReadList.remove(r);
                        --r;
                    }
                    ++r;
                }
                endReadMisSum = 0;
                r = 0;
                while (r < endReadList.size()) {
                    miscounter = 0;
                    readPos = (Integer)((Object[])endReadList.get(r))[0];
                    readString = (String)((Object[])endReadList.get(r))[1];
                    c = 0;
                    while (c < readString.length()) {
                        if (readPos + c > this.seqStart && readPos + c - this.seqStart < sequence.length() && sequence.charAt(readPos + c - this.seqStart + 1) != readString.charAt(c)) {
                            ++miscounter;
                        }
                        ++c;
                    }
                    if (readString.length() < 10 || (double)miscounter / (double)readString.length() > 0.05) {
                        ++endReadMisSum;
                        if (endVote.containsKey(readPos + 1)) {
                            endVote.put(readPos + 1, (Integer)endVote.get(readPos + 1) + 1);
                        } else {
                            endVote.put(readPos + 1, 1);
                        }
                    } else {
                        endReadList.remove(r);
                        --r;
                    }
                    ++r;
                }
                if (endVote.size() < 3 && startVote.size() < 3) continue;
                Iterator iterator = startVote.entrySet().iterator();
                positionList.clear();
                support3 = 0;
                support5 = 0;
                altReads3 = 0;
                altReads5 = 0;
                max = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    altReads5 += ((Integer)entry.getValue()).intValue();
                    if ((Integer)entry.getValue() > max) {
                        max = (Integer)entry.getValue();
                        positionList.clear();
                        positionList.add((Integer)entry.getKey());
                        continue;
                    }
                    if ((Integer)entry.getValue() != max) continue;
                    positionList.add((Integer)entry.getKey());
                }
                support5 = max;
                sum = 0;
                int j = 0;
                while (j < positionList.size()) {
                    sum += ((Integer)positionList.get(j)).intValue();
                    ++j;
                }
                breakPointStart = (int)((double)sum / (double)positionList.size() + 0.5);
                positionList.clear();
                max = 0;
                for (Map.Entry entry : endVote.entrySet()) {
                    altReads3 += ((Integer)entry.getValue()).intValue();
                    if ((Integer)entry.getValue() > max) {
                        max = (Integer)entry.getValue();
                        positionList.clear();
                        positionList.add((Integer)entry.getKey());
                        continue;
                    }
                    if ((Integer)entry.getValue() != max) continue;
                    positionList.add((Integer)entry.getKey());
                }
                support3 = max;
                sum = 0;
                j = 0;
                while (j < positionList.size()) {
                    sum += ((Integer)positionList.get(j)).intValue();
                    ++j;
                }
                breakPointEnd = (int)((double)sum / (double)positionList.size() + 0.5);
                int r2 = 0;
                while (r2 < endReadList.size()) {
                    this.seq = (String)((Object[])endReadList.get(r2))[1];
                    readPos = (Integer)((Object[])endReadList.get(r2))[0];
                    if (readPos + this.seq.length() < breakPointEnd || readPos > breakPointEnd + 50) {
                        endReadList.remove(r2);
                        --r2;
                    }
                    ++r2;
                }
                if (support5 < 3 && support3 < 3 || startReadMisSum < 3 && endReadMisSum < 3) continue;
                if (support5 < 3 && (double)startReadMisSum / (double)endReadMisSum < 0.3) {
                    breakPointStart = -1;
                }
                if (support3 < 3 && (double)endReadMisSum / (double)startReadMisSum < 0.3) {
                    breakPointEnd = -1;
                }
                if (support5 == 1) {
                    breakPointStart = -1;
                }
                if (support3 == 1) {
                    breakPointEnd = -1;
                }
                if (breakPointStart <= 0) {
                    breakPointStart = -1;
                }
                if (breakPointEnd <= 0) {
                    breakPointEnd = -1;
                }
                if (breakPointStart > -1 && startReadList.size() > 0) {
                    Collections.sort(startReadList, new MethodLibrary.ReadListSorter());
                    consensusStart = (Integer)((Object[])startReadList.get(0))[0];
                    this.consensus5 = new int[4][breakPointStart - consensusStart + 1];
                    this.result5 = new char[this.consensus5[0].length];
                    disbases = 0;
                    c = 0;
                    while (c < this.consensus5.length) {
                        h = 0;
                        while (h < this.consensus5[c].length) {
                            this.consensus5[c][h] = 0;
                            ++h;
                        }
                        ++c;
                    }
                    r2 = 0;
                    while (r2 < startReadList.size()) {
                        readPos = (Integer)((Object[])startReadList.get(r2))[0];
                        this.seq = (String)((Object[])startReadList.get(r2))[1];
                        del = 0;
                        s = 0;
                        while (s < this.seq.length()) {
                            if (bases2.containsKey(Character.valueOf(this.seq.charAt(s)))) {
                                if (readPos + s - del - consensusStart >= this.consensus5[0].length || readPos + s - del - consensusStart <= -1) break;
                                int[] nArray = this.consensus5[(Integer)bases2.get(Character.valueOf(this.seq.charAt(s)))];
                                int n = readPos + s - del - consensusStart;
                                nArray[n] = nArray[n] + 1;
                            } else if (this.seq.charAt(s) == 'D') {
                                ++del;
                            }
                            ++s;
                        }
                        ++r2;
                    }
                    c = 0;
                    while (c < this.consensus5[0].length) {
                        disbasetemp = 0;
                        maxbase = 0;
                        maxindex.clear();
                        h = 0;
                        while (h < this.consensus5.length) {
                            allbases += this.consensus5[h][c];
                            disbasetemp += this.consensus5[h][c];
                            if (this.consensus5[h][c] > maxbase) {
                                maxbase = this.consensus5[h][c];
                                maxindex.clear();
                                maxindex.add(h);
                            } else if (this.consensus5[h][c] == maxbase) {
                                maxindex.add(h);
                            }
                            ++h;
                        }
                        disbases += disbasetemp - maxbase;
                        this.result5[c] = maxbase == 0 ? 78 : ((Character)bases.get(maxindex.get((int)(Math.random() * (double)maxindex.size())))).charValue();
                        ++c;
                    }
                    rate5 = allbases > 0 ? "" + MethodLibrary.round((double)disbases / (double)allbases, 2) : "0";
                }
                if (breakPointEnd > -1 && endReadList.size() > 0) {
                    Collections.sort(endReadList, new MethodLibrary.ReadListSorter());
                    this.readlen = (String)((Object[])endReadList.get(endReadList.size() - 1))[1];
                    this.consensus3 = new int[4][(Integer)((Object[])endReadList.get(endReadList.size() - 1))[0] + this.readlen.length() - breakPointEnd + 1];
                    this.result3 = new char[this.consensus3[0].length];
                    disbasetemp = 0;
                    disbases = 0;
                    allbases = 0;
                    maxbase = 0;
                    r2 = 0;
                    while (r2 < endReadList.size()) {
                        readPos = (Integer)((Object[])endReadList.get(r2))[0];
                        this.seq = (String)((Object[])endReadList.get(r2))[1];
                        del = 0;
                        s = 0;
                        while (s < this.seq.length()) {
                            if (readPos + s >= breakPointEnd - 1) {
                                if (bases2.containsKey(Character.valueOf(this.seq.charAt(s)))) {
                                    if (readPos + s - del - (breakPointEnd - 1) >= this.consensus3[0].length) break;
                                    try {
                                        int[] nArray = this.consensus3[(Integer)bases2.get(Character.valueOf(this.seq.charAt(s)))];
                                        int n = readPos + s - del - (breakPointEnd - 1);
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else if (this.seq.charAt(s) == 'D') {
                                    ++del;
                                }
                            }
                            ++s;
                        }
                        ++r2;
                    }
                    c = 0;
                    while (c < this.consensus3[0].length) {
                        disbasetemp = 0;
                        maxbase = 0;
                        maxindex.clear();
                        h = 0;
                        while (h < this.consensus3.length) {
                            allbases += this.consensus3[h][c];
                            disbasetemp += this.consensus3[h][c];
                            if (this.consensus3[h][c] > maxbase) {
                                maxbase = this.consensus3[h][c];
                                maxindex.clear();
                                maxindex.add(h);
                            } else if (this.consensus3[h][c] == maxbase) {
                                maxindex.add(h);
                            }
                            ++h;
                        }
                        disbases += disbasetemp - maxbase;
                        this.result3[c] = maxbase == 0 ? 78 : ((Character)bases.get(maxindex.get((int)(Math.random() * (double)maxindex.size())))).charValue();
                        ++c;
                    }
                    rate3 = allbases > 0 ? "" + MethodLibrary.round((double)disbases / (double)allbases, 2) : "0";
                }
                if (breakPointStart > -1 && breakPointEnd > -1) {
                    if (breakPointStart <= breakPointEnd) {
                        repeat = sequence.substring(breakPointStart - clusterStart, breakPointEnd - clusterStart);
                        System.out.println(String.valueOf(cur.getReferenceName()) + "\t" + breakPointStart + "\t" + breakPointEnd + "\t" + (breakPointEnd - breakPointStart) + "\t-\t+\t" + repeat + "\t" + new String(this.result5) + "\t" + rate5 + "\t" + new String(this.result3) + "\t" + rate3 + "\t" + (altReads5 + altReads3) + "\t" + refReads + "\t" + support5 + "\t" + support3);
                        continue;
                    }
                    repeat = sequence.substring(breakPointEnd - clusterStart, breakPointStart - clusterStart);
                    System.out.println(String.valueOf(cur.getReferenceName()) + "\t" + breakPointEnd + "\t" + breakPointStart + "\t" + (breakPointStart - breakPointEnd) + "\t+\t-\t" + repeat + "\t" + new String(this.result5) + "\t" + rate5 + "\t" + new String(this.result3) + "\t" + rate3 + "\t" + (altReads5 + altReads3) + "\t" + refReads + "\t" + support3 + "\t" + support5);
                    continue;
                }
                if (breakPointEnd == -1) {
                    repeat = sequence.length() < breakPointStart - clusterStart + 20 ? sequence.substring(breakPointStart - clusterStart) : sequence.substring(breakPointStart - clusterStart, breakPointStart - clusterStart + 20);
                    System.out.println(String.valueOf(cur.getReferenceName()) + "\t" + breakPointStart + "\t" + (breakPointStart + 1) + "\t0\t-\t-\t" + repeat + "\t" + new String(this.result5) + "\t" + rate5 + "\t-\t-\t" + (altReads5 + altReads3) + "\t" + refReads + "\t" + support5 + "\t" + support3);
                    continue;
                }
                repeat = breakPointStart - clusterStart - 20 < 0 ? sequence.substring(0, breakPointEnd - clusterStart) : sequence.substring(breakPointStart - clusterStart, breakPointStart - clusterStart + 20);
                System.out.println(String.valueOf(cur.getReferenceName()) + "\t" + breakPointEnd + "\t" + (breakPointEnd + 1) + "\t0\t+\t+\t" + repeat + "\t-\t-\t" + new String(this.result3) + "\t" + rate3 + "\t" + (altReads5 + altReads3) + "\t" + refReads + "\t" + support5 + "\t" + support3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void searchInsSites2(SamReader samFileReader, RandomAccessFile reference) {
        String sequence = "";
        String readString = "";
        int interval = 1000;
        int seqStart = 0;
        int seqEnd = interval;
        SAMRecordIterator iter = samFileReader.iterator();
        int count = 0;
        int miscount = 0;
        int readpointer = 0;
        int seqpointer = 0;
        while (iter.hasNext()) {
            SAMRecord cur = (SAMRecord)iter.next();
            if (cur.getReadUnmappedFlag() || cur.getMappingQuality() < 10) continue;
            if (++count == 50) break;
            if (cur.getUnclippedEnd() > seqEnd) {
                seqStart = cur.getUnclippedStart() - 100;
                seqEnd = seqStart + interval;
                sequence = this.getSeq(cur.getReferenceName(), seqStart, seqEnd, reference);
            }
            try {
                miscount = 0;
                seqpointer = cur.getUnclippedStart() - seqStart;
                int i = 0;
                while (i < cur.getUnclippedStart() - seqStart) {
                    System.out.print(" ");
                    ++i;
                }
                if (cur.getCigarLength() == 1) {
                    readString = cur.getReadString();
                    i = 0;
                    while (i < cur.getReadString().length()) {
                        if (readString.charAt(i) != sequence.charAt(seqpointer + i)) {
                            ++miscount;
                        }
                        System.out.print(readString.charAt(i));
                        ++i;
                    }
                } else {
                    readpointer = 0;
                    List<CigarElement> elements = cur.getCigar().getCigarElements();
                    readString = cur.getReadString();
                    i = 0;
                    while (i < elements.size()) {
                        int j;
                        if (elements.get(i).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                            j = 0;
                            while (j < elements.get(i).getLength()) {
                                if (readString.charAt(readpointer) != sequence.charAt(seqpointer + j)) {
                                    ++miscount;
                                }
                                System.out.print(readString.charAt(readpointer));
                                ++readpointer;
                                ++j;
                            }
                            seqpointer += elements.get(i).getLength();
                        } else if (elements.get(i).getOperator().compareTo(CigarOperator.MATCH_OR_MISMATCH) == 0) {
                            j = 0;
                            while (j < elements.get(i).getLength()) {
                                if (readString.charAt(readpointer) != sequence.charAt(seqpointer + j)) {
                                    ++miscount;
                                }
                                System.out.print(readString.charAt(readpointer));
                                ++readpointer;
                                ++j;
                            }
                            seqpointer += elements.get(i).getLength();
                        } else if (elements.get(i).getOperator().compareTo(CigarOperator.INSERTION) == 0) {
                            readpointer += elements.get(i).getLength();
                        } else if (elements.get(i).getOperator().compareTo(CigarOperator.DELETION) == 0) {
                            j = 0;
                            while (j < elements.get(i).getLength()) {
                                System.out.print(" ");
                                ++j;
                            }
                            seqpointer += elements.get(i).getLength();
                        }
                        ++i;
                    }
                }
                System.out.println(" " + miscount + " " + cur.getCigarString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getSeq(String chrom, int start, int end, RandomAccessFile seqchrom) {
        try {
            this.seqresult = new byte[end - start + (end - start) / 60 + 1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        this.seqBuffer = new StringBuffer();
        this.chromo = seqchrom;
        try {
            try {
                this.chromo.seek(chromIndex.get(chrom)[0] + (long)start + (long)(start / 60) - 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.chromo.readFully(this.seqresult);
            if (this.seqresult[0] == 10) {
                this.chromo.seek(chromIndex.get(chrom)[0] + (long)(start - 1) + (long)(start / 60) - 1L);
                seqchrom.readFully(this.seqresult);
            }
            int i = 0;
            while (i < this.seqresult.length) {
                if (this.seqresult[i] != 10) {
                    this.seqBuffer.append((char)this.seqresult[i]);
                }
                this.resString = this.seqBuffer.toString().toUpperCase();
                if (this.resString.length() < end - start) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resString;
    }
}

