/*
 * Decompiled with CFR 0.152.
 */
package base.BBfile;

import base.BBfile.RPChromosomeRegion;
import base.BBfile.RPTreeLeafNodeItem;
import base.BBfile.RPTreeNode;
import base.BBfile.RPTreeNodeItem;
import java.util.ArrayList;

public class RPTreeLeafNode
implements RPTreeNode {
    private RPChromosomeRegion chromosomeBounds;
    private ArrayList<RPTreeLeafNodeItem> leafItems = new ArrayList();

    public RPTreeLeafNode() {
        this.chromosomeBounds = new RPChromosomeRegion();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int index) {
        if (index < 0 || index >= this.leafItems.size()) {
            return null;
        }
        return this.leafItems.get(index);
    }

    @Override
    public boolean insertItem(RPTreeNodeItem item) {
        RPTreeLeafNodeItem newItem = (RPTreeLeafNodeItem)item;
        this.leafItems.add(newItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(newItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(newItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        int itemCount = this.getItemCount();
        if (index < 0 || index >= itemCount) {
            return false;
        }
        this.leafItems.remove(index);
        return true;
    }

    @Override
    public void printItems() {
        int item = 0;
        while (item < this.leafItems.size()) {
            this.leafItems.get(item).print();
            ++item;
        }
    }
}

