/*
 * Decompiled with CFR 0.152.
 */
package base.BBfile;

import base.BBfile.BBCompressionUtils;
import base.BBfile.BigWigSection;
import base.BBfile.RPChromosomeRegion;
import base.BBfile.RPTreeLeafNodeItem;
import base.BBfile.WigItem;
import base.BasePlayer.Main;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class BigWigDataBlock {
    final int FIXED_STEP_ITEM_SIZE = 4;
    final int VAR_STEP_ITEM_SIZE = 8;
    final int BED_GRAPH_ITEM_SIZE = 12;
    private long fileOffset;
    private long leafDataSize;
    private boolean isLowToHigh;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] wigBuffer;
    private int remDataSize;
    private ArrayList<WigItem> wigItemList;

    public BigWigDataBlock(SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.leafDataSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.leafDataSize];
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.wigBuffer = uncompressBufSize > 0 ? BBCompressionUtils.decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(Main.chromDraw, String.valueOf(ex.getMessage()) + "\nPlease restart program to recover the connection.", "Error", 0);
            ex.printStackTrace();
        }
        this.remDataSize = this.wigBuffer.length;
    }

    public ArrayList<WigItem> getWigData(RPChromosomeRegion selectionRegion, boolean contained) {
        this.wigItemList = new ArrayList();
        int index = 0;
        while (this.remDataSize > 0) {
            BigWigSection wigSection = new BigWigSection(this.wigBuffer, this.chromosomeMap, this.isLowToHigh, this.leafHitItem);
            int sectionBytes = wigSection.getSectionData(selectionRegion, contained, this.wigItemList);
            this.remDataSize -= sectionBytes;
            ++index;
        }
        return this.wigItemList;
    }

    public void print() {
        int index = 0;
        while (index <= this.wigItemList.size()) {
            this.wigItemList.get(index).print();
            ++index;
        }
    }
}

