/*
 * Decompiled with CFR 0.152.
 */
package base.BBfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class BPTreeHeader {
    public static final int BPTREE_HEADER_SIZE = 32;
    public static final int BPTREE_MAGIC_LTH = 2026540177;
    public static final int BPTREE_MAGIC_HTL = -1853044104;
    private long headerOffset;
    private boolean headerOK;
    private int magic;
    private int blockSize;
    private int keySize;
    private int valSize;
    private long itemCount;
    private long reserved;

    public BPTreeHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        this.headerOffset = fileOffset;
        this.headerOK = this.readHeader(fis, this.headerOffset, isLowToHigh);
    }

    public static int getHeaderSize() {
        return 32;
    }

    public long getHeaderOffset() {
        return this.headerOffset;
    }

    public boolean isHeaderOK() {
        return this.headerOK;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValSize() {
        return this.valSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void print() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readHeader(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        byte[] buffer = new byte[32];
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                LittleEndianInputStream lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
                this.magic = lbdis.readInt();
                if (this.magic != 2026540177) {
                    return false;
                }
                this.blockSize = lbdis.readInt();
                this.keySize = lbdis.readInt();
                this.valSize = lbdis.readInt();
                this.itemCount = lbdis.readLong();
                this.reserved = lbdis.readLong();
                return true;
            }
            DataInputStream bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            this.magic = bdis.readInt();
            if (this.magic != -1853044104) {
                return false;
            }
            this.blockSize = bdis.readInt();
            this.keySize = bdis.readInt();
            this.valSize = bdis.readInt();
            this.itemCount = bdis.readLong();
            this.reserved = bdis.readLong();
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading B+ tree header \n", ex);
        }
    }
}

