/*
 * Decompiled with CFR 0.152.
 */
package base.BBfile;

import base.BBfile.BBZoomLevelFormat;
import base.BBfile.BBZoomLevelHeader;
import base.BBfile.RPTree;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;

public class BBZoomLevels {
    private long zoomHeadersOffset;
    private int zoomLevelsCount;
    private ArrayList<BBZoomLevelHeader> zoomLevelHeaders;
    private ArrayList<BBZoomLevelFormat> zoomLevelFormatList;
    private ArrayList<RPTree> zoomLevelRPTree;

    public BBZoomLevels(SeekableStream fis, long fileOffset, int zoomLevels, boolean isLowToHigh, int uncompressBufSize) {
        this.zoomHeadersOffset = fileOffset;
        this.zoomLevelsCount = zoomLevels;
        int zoomHeadersRead = this.readZoomHeaders(fis, this.zoomHeadersOffset, zoomLevels, isLowToHigh);
        if (zoomHeadersRead > 0) {
            this.zoomLevelFormatList = new ArrayList();
            int index = 0;
            while (index < zoomHeadersRead) {
                int zoomLevel = index + 1;
                long zoomDataOffset = this.zoomLevelHeaders.get(index).getDataOffset();
                long dataSize = this.zoomLevelHeaders.get(index).getIndexOffset() - zoomDataOffset - 4L;
                BBZoomLevelFormat zoomLevelData = new BBZoomLevelFormat(zoomLevel, fis, zoomDataOffset, dataSize, isLowToHigh, uncompressBufSize);
                this.zoomLevelFormatList.add(zoomLevelData);
                ++index;
            }
            this.zoomLevelRPTree = new ArrayList();
            index = 0;
            while (index < zoomHeadersRead) {
                long zoomIndexOffset = this.zoomLevelHeaders.get(index).getIndexOffset();
                RPTree zoomRPTree = new RPTree(fis, zoomIndexOffset, isLowToHigh, uncompressBufSize, true);
                this.zoomLevelRPTree.add(zoomRPTree);
                ++index;
            }
        }
    }

    public long getZoomHeadersOffset() {
        return this.zoomHeadersOffset;
    }

    public int getZoomHeaderCount() {
        return this.zoomLevelHeaders.size();
    }

    public ArrayList<BBZoomLevelHeader> getZoomLevelHeaders() {
        return this.zoomLevelHeaders;
    }

    public BBZoomLevelHeader getZoomLevelHeader(int level) {
        if (level < 1 || level > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelHeaders.get(level - 1);
    }

    public ArrayList<BBZoomLevelFormat> getZoomLevelFormats() {
        return this.zoomLevelFormatList;
    }

    public RPTree getZoomLevelRPTree(int level) {
        if (level < 1 || level > this.zoomLevelsCount) {
            return null;
        }
        return this.zoomLevelRPTree.get(level - 1);
    }

    public void printZoomHeaders() {
        int index = 0;
        while (index < this.zoomLevelHeaders.size()) {
            this.zoomLevelHeaders.get(index).print();
            ++index;
        }
    }

    private int readZoomHeaders(SeekableStream fis, long fileOffset, int zoomLevels, boolean isLowToHigh) {
        int level = 0;
        if (zoomLevels < 1) {
            return 0;
        }
        this.zoomLevelHeaders = new ArrayList();
        int index = 0;
        while (index < zoomLevels) {
            level = index + 1;
            BBZoomLevelHeader zoomLevelHeader = new BBZoomLevelHeader(fis, fileOffset, level, isLowToHigh);
            this.zoomLevelHeaders.add(zoomLevelHeader);
            fileOffset += 24L;
            ++index;
        }
        return level;
    }
}

