/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.BedCanvas;
import base.BasePlayer.Control;
import base.BasePlayer.Draw;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Reads;
import base.BasePlayer.ReferenceSeq;
import base.BasePlayer.Sample;
import base.BasePlayer.Settings;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantCall;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class VariantCaller
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static Boolean loading = false;
    static JFrame frame = new JFrame("Variant Caller");
    JLabel testing = new JLabel("Test version");
    static JTextField minreads = new JTextField("4");
    JLabel minreadlabel = new JLabel("Min. alt-read count");
    static JTextField mincoverage = new JTextField("10");
    JLabel mincoveragelabel = new JLabel("Min. coverage");
    static JTextField minbaseq = new JTextField("5");
    JLabel minbaseqlabel = new JLabel("Min. base quality");
    static JTextField minmappingq = new JTextField("10");
    JLabel minmappingqlabel = new JLabel("Min. mapping quality");
    static JCheckBox bothstrand = new JCheckBox("Require both strands");
    static JCheckBox bothruns = new JCheckBox("Require multiple runs");
    JCheckBox onlySel = new JCheckBox("Calc only for selected");
    static JCheckBox inanno = new JCheckBox("Before annotation");
    JButton execute = new JButton("Execute");

    public VariantCaller(boolean caller) {
    }

    public VariantCaller() {
        super(new GridLayout(8, 2));
        try {
            this.testing.setForeground(Color.red);
            this.execute.addActionListener(this);
            inanno.addActionListener(this);
            this.add(this.testing);
            this.add(new JLabel());
            this.add(minreads);
            this.add(this.minreadlabel);
            this.add(mincoverage);
            this.add(this.mincoveragelabel);
            this.add(minmappingq);
            this.add(this.minmappingqlabel);
            this.add(minbaseq);
            this.add(this.minbaseqlabel);
            this.add(bothstrand);
            this.add(bothruns);
            this.add(this.onlySel);
            this.add(inanno);
            this.add(this.execute);
            bothstrand.setToolTipText("Variant call is discared if mismatches are present only in the other strand.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createAndShowGUI() {
        if (Main.frame != null) {
            frame.setDefaultCloseOperation(2);
            frame.setVisible(false);
        } else {
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        frame.setAlwaysOnTop(true);
        VariantCaller newContentPane = new VariantCaller();
        newContentPane.setOpaque(false);
        frame.setContentPane(newContentPane);
        VariantCaller.setFonts(Main.menuFont);
        frame.pack();
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setMinimumSize(frame.getContentPane().getComponent(i).getPreferredSize());
            ++i;
        }
        minreads.setMinimumSize(new Dimension(minreads.getWidth(), minreads.getHeight()));
        mincoverage.setMinimumSize(new Dimension(mincoverage.getWidth(), mincoverage.getHeight()));
        minbaseq.setMinimumSize(new Dimension(minbaseq.getWidth(), minbaseq.getHeight()));
        minmappingq.setMinimumSize(new Dimension(minmappingq.getWidth(), minmappingq.getHeight()));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariantCaller.createAndShowGUI();
            }
        });
    }

    static void setFonts(Font menuFont) {
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setFont(menuFont);
            ++i;
        }
        frame.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.execute) {
            try {
                VarCaller caller = new VarCaller();
                caller.execute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (event.getSource() == inanno) {
            if (inanno.isSelected()) {
                FileRead.caller = true;
                FileRead.checkSamples();
            } else {
                FileRead.caller = false;
                FileRead.checkSamples();
            }
        }
    }

    public class VarCaller
    extends SwingWorker<String, Object> {
        int readlevel;
        int minquality;
        int minreadquality;
        int mincoverage;
        boolean onlysel;

        public VarCaller(int readlevel, int minquality, int minreadquality, int mincoverage, boolean onlysel) {
            this.readlevel = readlevel;
            this.minquality = minquality;
            this.minreadquality = minreadquality;
            this.mincoverage = mincoverage;
            this.onlysel = onlysel;
        }

        public VarCaller() {
            int mincoverage;
            int minreadquality;
            int minquality;
            int readlevel;
            try {
                readlevel = Integer.parseInt(minreads.getText());
            }
            catch (Exception e) {
                minreads.setForeground(Color.red);
                return;
            }
            try {
                minquality = Integer.parseInt(minbaseq.getText());
            }
            catch (Exception e) {
                minbaseq.setForeground(Color.red);
                return;
            }
            try {
                minreadquality = Integer.parseInt(minmappingq.getText());
            }
            catch (Exception e) {
                minmappingq.setForeground(Color.red);
                return;
            }
            try {
                mincoverage = Integer.parseInt(VariantCaller.mincoverage.getText());
            }
            catch (Exception e) {
                VariantCaller.mincoverage.setForeground(Color.red);
                return;
            }
            this.readlevel = readlevel;
            this.minquality = minquality;
            this.minreadquality = minreadquality;
            this.mincoverage = mincoverage;
            this.onlysel = VariantCaller.this.onlySel.isSelected();
        }

        void callVariants() {
            if (this.onlysel && (Main.drawCanvas.selectedSample == null || Main.drawCanvas.selectedSample.getTabixFile() != null || Main.drawCanvas.selectedSample.samFile == null)) {
                loading = false;
                return;
            }
            int startpos = (int)Main.drawCanvas.splits.get((int)0).start;
            int endpos = (int)Main.drawCanvas.splits.get((int)0).end;
            FileRead reader = new FileRead();
            FileRead.head.putNext(null);
            loading = true;
            if (!Main.drawCanvas.loading) {
                Main.drawCanvas.loading("Calling variants");
            } else {
                Main.drawCanvas.loadingtext = "Calling variants";
            }
            Main.bedCanvas.bedOn = false;
            int s = 0;
            while (s < Main.samples) {
                block38: {
                    try {
                        if (!Main.drawCanvas.loading) break;
                        Main.drawCanvas.loadBarSample = 0;
                        Main.drawCanvas.loadbarAll = s / Main.samples * 100;
                        Sample sample = Main.drawCanvas.sampleList.get(s);
                        Reads readClass = sample.getreadHash().get(Main.drawCanvas.splits.get(0));
                        sample.basequalsum = 0;
                        sample.basequals = 0;
                        if (this.onlysel && !sample.equals(Main.drawCanvas.selectedSample) || sample.getTabixFile() != null || sample.samFile == null) break block38;
                        VarNode node = FileRead.head.getNext();
                        while (node != null) {
                            node.removeSample(sample);
                            node = node.getNext();
                        }
                        node = null;
                        Reads reads = null;
                        try {
                            reads = (Reads)readClass.clone();
                        }
                        catch (Exception e) {
                            sample.resetreadHash();
                            reads = (Reads)readClass.clone();
                            e.printStackTrace();
                        }
                        if (!sample.calledvariants) {
                            VariantHandler.commonSlider.setMaximum(++Main.varsamples);
                            VariantHandler.commonSlider.setUpperValue(Main.varsamples);
                            VariantHandler.geneSlider.setMaximum(Main.varsamples);
                        }
                        sample.maxCoveragecaller = 0;
                        sample.calledvariants = true;
                        String[] coveragebases = new String[]{"", "A", "C", "G", "T", "N"};
                        double homlevel = 0.95;
                        boolean foundscan = false;
                        StringBuffer genotypes = new StringBuffer("");
                        int calls = 0;
                        int refs = 0;
                        String refbase = "";
                        reader.current = FileRead.head;
                        int interval = endpos - startpos < Settings.windowSize ? endpos - startpos : Settings.windowSize;
                        Draw.updatevars = true;
                        Main.drawCanvas.repaint();
                        String[] line = new String[10];
                        line[2] = ".";
                        line[6] = "PASS";
                        line[7] = "INFO";
                        line[8] = "GT:AD:DP";
                        int start = startpos;
                        int end = startpos + interval;
                        Main.drawCanvas.variantsStart = start;
                        int scanpointer = 0;
                        while (start < endpos) {
                            if (!Main.drawCanvas.loading) {
                                Main.drawCanvas.ready("all");
                                break;
                            }
                            if (end > endpos) {
                                end = endpos;
                            }
                            Main.drawCanvas.variantsEnd = end;
                            ReferenceSeq reference = new ReferenceSeq(Main.drawCanvas.splits.get((int)0).chrom, start - 300, end + 300, Main.referenceFile);
                            VariantCall[][] coverages = reader.variantCaller(Main.drawCanvas.splits.get((int)0).chrom, start, end, reads, this.minquality, this.minreadquality, reference);
                            int i = 0;
                            while (i < coverages.length) {
                                if (!Main.drawCanvas.loading) break;
                                if (coverages[i][0] != null) {
                                    if (coverages[i][0].calls > sample.maxCoveragecaller) {
                                        sample.maxCoveragecaller = coverages[i][0].calls;
                                    }
                                    int j = 1;
                                    while (j < coverages[i].length - 2) {
                                        if (!(coverages[i][j] == null || coverages[i][j].calls < this.readlevel || coverages[i][0].calls < this.mincoverage || bothstrand.isSelected() && coverages[i][j].strands.size() < 2 || bothruns.isSelected() && readClass.getRuns() > 1 && coverages[i][j].runs.size() < 2)) {
                                            foundscan = false;
                                            scanpointer = i - 1;
                                            while (scanpointer >= 0 && i - scanpointer < 10) {
                                                if (coverages[scanpointer][j] != null) {
                                                    foundscan = true;
                                                    break;
                                                }
                                                --scanpointer;
                                            }
                                            if (!foundscan) {
                                                scanpointer = i + 1;
                                                while (scanpointer < coverages.length && scanpointer - i < 10) {
                                                    if (coverages[scanpointer][j] != null) {
                                                        foundscan = true;
                                                        break;
                                                    }
                                                    ++scanpointer;
                                                }
                                                if (!foundscan) {
                                                    genotypes = new StringBuffer("");
                                                    calls = coverages[i][j].calls;
                                                    refs = coverages[i][0].calls;
                                                    if ((double)calls / (double)refs >= homlevel) {
                                                        genotypes.append("1/1:");
                                                    } else {
                                                        genotypes.append("0/1:");
                                                    }
                                                    genotypes.append(String.valueOf(refs - calls) + "," + calls + ":" + refs);
                                                    refbase = Main.getBase.get(reference.getSeq()[reads.getCoverageStart() + i - 1 - reference.getStartPos()]);
                                                    line[0] = Main.drawCanvas.splits.get((int)0).chrom;
                                                    line[1] = "" + (reads.getCoverageStart() + i);
                                                    line[3] = refbase;
                                                    line[4] = coveragebases[j];
                                                    line[5] = "" + MethodLibrary.round((double)coverages[i][j].qualities / (double)coverages[i][j].calls, 2);
                                                    line[9] = genotypes.toString();
                                                    reader.readLine(line, sample);
                                                }
                                            }
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                            start = end;
                            end += interval;
                            Draw.updatevars = true;
                            Draw.calculateVars = true;
                            Main.drawCanvas.repaint();
                        }
                        node = null;
                        reads = null;
                        readClass = null;
                        System.out.println(String.valueOf(sample.getName()) + ": " + (double)sample.basequalsum / (double)sample.basequals);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                ++s;
            }
            Main.drawCanvas.variantsEnd = endpos;
            reader.current = FileRead.head;
            reader = null;
            FileRead.annotate();
            if (Control.controlData.controlsOn) {
                Control.applyControl();
            }
            Main.drawCanvas.calcClusters(FileRead.head, 1);
            Main.bedCanvas.bedOn = true;
            boolean ison = false;
            int i = 0;
            while (i < Main.bedCanvas.bedTrack.size()) {
                if (Main.bedCanvas.bedTrack.get((int)i).intersect) {
                    ison = true;
                    break;
                }
                ++i;
            }
            if (!ison) {
                Main.bedCanvas.bedOn = false;
            }
            if (Main.bedCanvas.bedOn) {
                Main.drawCanvas.loadingtext = "Annotating variants";
                i = 0;
                while (i < Main.bedCanvas.bedTrack.size()) {
                    if (Main.bedCanvas.bedTrack.get((int)i).small && Main.bedCanvas.bedTrack.get(i).getBBfileReader() == null) {
                        if (Main.bedCanvas.bedTrack.get((int)i).intersect && !Main.bedCanvas.bedTrack.get((int)i).loading) {
                            Main.bedCanvas.annotate(Main.bedCanvas.bedTrack.get(i).getHead(), FileRead.head.getNext());
                            Main.bedCanvas.intersected = true;
                        } else if (Main.bedCanvas.bedTrack.get((int)i).intersect && Main.bedCanvas.bedTrack.get((int)i).loading) {
                            Main.bedCanvas.bedTrack.get((int)i).waiting = true;
                        }
                    } else if (Main.bedCanvas.bedTrack.get((int)i).intersect) {
                        BedCanvas bedCanvas = Main.bedCanvas;
                        bedCanvas.getClass();
                        BedCanvas.Annotator annotator = bedCanvas.new BedCanvas.Annotator(Main.bedCanvas.bedTrack.get(i));
                        annotator.annotateVars();
                        Main.bedCanvas.intersected = true;
                    }
                    ++i;
                }
            }
            Main.drawCanvas.ready("Calling variants");
            Draw.updatevars = true;
            Main.drawCanvas.repaint();
            loading = false;
        }

        @Override
        protected String doInBackground() throws Exception {
            this.callVariants();
            return null;
        }
    }
}

