/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.FileRead;
import base.BasePlayer.Gene;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;

public class Transcript {
    private boolean canonical = true;
    private final String biotype;
    private final String uniprot;
    private final String ID;
    private int start;
    private int end;
    private int codingStart;
    private int codingEnd;
    private int exonstart;
    private int exonend;
    private int length;
    private Exon[] exons;
    ArrayList<Exon> exonArray;
    private String[] exonstarts;
    private String[] exonends;
    private String[] exonphases;
    private Gene gene;
    short startphase;
    short endphase;
    short endphasetemp;
    int firstamino = 0;
    int ypos = 0;

    public Transcript(String[] line) {
        this.biotype = line[10];
        this.uniprot = line[8];
        if (line[9].equals("-")) {
            this.canonical = false;
        }
        this.ID = line[7].contains(":") ? line[7].split(":")[1] : line[7];
        this.start = Integer.parseInt(line[1]);
        this.end = Integer.parseInt(line[2]);
        this.length = this.end - this.start;
        this.codingStart = Integer.parseInt(line[11]);
        this.codingEnd = Integer.parseInt(line[12]);
        Boolean strand = false;
        if (line[5].equals("+")) {
            strand = true;
        }
        this.exons = new Exon[Integer.parseInt(line[4])];
        this.exonstarts = line[13].split(",");
        this.exonends = line[14].split(",");
        this.exonphases = line[15].split(",");
        if (strand.booleanValue()) {
            this.firstamino = 0;
            int i = 0;
            while (i < this.exons.length) {
                this.exonstart = Integer.parseInt(this.exonstarts[i]);
                this.exonend = Integer.parseInt(this.exonends[i]);
                this.startphase = Short.parseShort(this.exonphases[i]);
                if (this.startphase > 0) {
                    this.startphase = (short)(3 - this.startphase);
                }
                if (this.startphase > -1) {
                    this.endphasetemp = 0;
                    if (this.codingStart >= this.exonstart && this.codingStart < this.exonend) {
                        this.firstamino = 1;
                        this.endphase = (short)((this.exonend - this.codingStart) % 3);
                        if (this.endphase > 0) {
                            this.endphasetemp = (short)(3 - this.endphase);
                        }
                        if (this.codingEnd > this.exonstart && this.codingEnd < this.exonend) {
                            this.endphase = 0;
                        }
                        this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, this.endphase, (short)(i + 1), this.firstamino, this);
                        this.firstamino += (this.exonend - this.codingStart + this.endphasetemp) / 3;
                    } else {
                        if (this.codingEnd > this.exonstart && this.codingEnd < this.exonend) {
                            this.endphase = 0;
                        } else {
                            this.endphase = (short)((this.exonend - (this.exonstart + this.startphase)) % 3);
                            if (this.endphase > 0) {
                                this.endphasetemp = (short)(3 - this.endphase);
                            }
                        }
                        this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, this.endphase, (short)(i + 1), this.firstamino, this);
                        this.firstamino += (this.exonend - this.exonstart - this.startphase + this.endphasetemp) / 3;
                    }
                } else {
                    this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, -1, (short)(i + 1), 0, this);
                }
                i = (short)(i + 1);
            }
        } else {
            this.firstamino = 0;
            int i = this.exons.length - 1;
            while (i >= 0) {
                this.exonstart = Integer.parseInt(this.exonstarts[i]);
                this.exonend = Integer.parseInt(this.exonends[i]);
                this.startphase = Short.parseShort(this.exonphases[i]);
                if (this.startphase > 0) {
                    this.startphase = (short)(3 - this.startphase);
                }
                if (this.startphase > -1) {
                    this.endphasetemp = 0;
                    if (this.codingEnd > this.exonstart && this.codingEnd <= this.exonend) {
                        this.firstamino = 1;
                        this.endphase = (short)((this.codingEnd - this.exonstart) % 3);
                        if (this.endphase > 0) {
                            this.endphasetemp = (short)(3 - this.endphase);
                        }
                        if (this.codingStart > this.exonstart && this.codingStart < this.exonend) {
                            this.endphase = 0;
                        }
                        this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, this.endphase, (short)(this.exons.length - i), this.firstamino, this);
                        this.firstamino += (this.codingEnd - this.exonstart + this.endphasetemp) / 3;
                    } else {
                        if (this.codingStart > this.exonstart && this.codingStart < this.exonend) {
                            this.endphase = 0;
                        } else {
                            this.endphase = (short)((this.exonend - this.startphase - this.exonstart) % 3);
                            if (this.endphase > 0) {
                                this.endphasetemp = (short)(3 - this.endphase);
                            }
                        }
                        this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, this.endphase, (short)(this.exons.length - i), this.firstamino, this);
                        this.firstamino += (this.exonend - this.exonstart - this.startphase + this.endphasetemp) / 3;
                    }
                } else {
                    this.exons[i] = new Exon(this.exonstart, this.exonend, this.startphase, -1, (short)(this.exons.length - i), 0, this);
                }
                --i;
            }
        }
        this.exonstarts = null;
        this.exonends = null;
        this.exonphases = null;
    }

    public Transcript(HashMap<String, String> gffLine, Gene gene) {
        this.exonArray = new ArrayList();
        this.uniprot = FileRead.getInfoValue(gffLine, "uniprot");
        this.biotype = FileRead.getInfoValue(gffLine, "biotype");
        this.ID = gffLine.containsKey("transcript_id") ? "TranscriptID:" + gffLine.get("transcript_id") : FileRead.getInfoValue(gffLine, "id");
        this.start = Integer.parseInt(FileRead.getInfoValue(gffLine, "start"));
        this.end = Integer.parseInt(FileRead.getInfoValue(gffLine, "end"));
        this.length = this.end - this.start;
        this.gene = gene;
        this.gene.addTranscript(this);
        this.codingStart = Integer.MAX_VALUE;
        this.codingEnd = -1;
    }

    public void addExon(HashMap<String, String> gffHash, Transcript trans) {
        if (trans.start > Integer.parseInt(gffHash.get("start"))) {
            trans.start = Integer.parseInt(gffHash.get("start"));
        }
        if (trans.end < Integer.parseInt(gffHash.get("end"))) {
            trans.end = Integer.parseInt(gffHash.get("end"));
        }
        if (this.exonArray.size() == 0) {
            Exon addExon = new Exon(Integer.parseInt(gffHash.get("start")), Integer.parseInt(gffHash.get("end")), (short)(this.exonArray.size() + 1), trans);
            this.exonArray.add(addExon);
            if (!gffHash.get("phase").equals(".")) {
                if (trans.getStrand()) {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                } else {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                }
                addExon.startPhase = Short.parseShort(gffHash.get("phase"));
            }
        } else if (this.exonArray.get(0).getStart() > Integer.parseInt(gffHash.get("end"))) {
            Exon addExon = new Exon(Integer.parseInt(gffHash.get("start")), Integer.parseInt(gffHash.get("end")), (short)(this.exonArray.size() + 1), trans);
            this.exonArray.add(0, addExon);
            if (!gffHash.get("phase").equals(".")) {
                if (trans.getStrand()) {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                } else {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                }
                addExon.startPhase = Short.parseShort(gffHash.get("phase"));
            }
        } else if (this.exonArray.get(this.exonArray.size() - 1).getEnd() < Integer.parseInt(gffHash.get("start"))) {
            Exon addExon = new Exon(Integer.parseInt(gffHash.get("start")), Integer.parseInt(gffHash.get("end")), (short)(this.exonArray.size() + 1), trans);
            this.exonArray.add(addExon);
            if (!gffHash.get("phase").equals(".")) {
                if (trans.getStrand()) {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                } else {
                    if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                        trans.codingStart = Integer.parseInt(gffHash.get("start"));
                    }
                    if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                        trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                    }
                }
                addExon.startPhase = Short.parseShort(gffHash.get("phase"));
            }
        } else {
            int start = Integer.parseInt(gffHash.get("start"));
            int i = 0;
            while (i < this.exonArray.size()) {
                if (start >= this.exonArray.get(i).getStart() && start < this.exonArray.get(i).getEnd()) {
                    if (!gffHash.get("phase").equals(".")) {
                        if (trans.getStrand()) {
                            if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                                trans.codingStart = Integer.parseInt(gffHash.get("start"));
                            }
                            if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                                trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                            }
                        } else {
                            if (trans.codingStart > Integer.parseInt(gffHash.get("start"))) {
                                trans.codingStart = Integer.parseInt(gffHash.get("start"));
                            }
                            if (trans.codingEnd < Integer.parseInt(gffHash.get("end"))) {
                                trans.codingEnd = Integer.parseInt(gffHash.get("end"));
                            }
                        }
                        if (!gffHash.get("type").contains("codon")) {
                            this.exonArray.get((int)i).startPhase = Short.parseShort(gffHash.get("phase"));
                        }
                    }
                    if (Integer.parseInt(gffHash.get("end")) <= this.exonArray.get(i).getEnd()) break;
                    this.exonArray.get(i).end = Integer.parseInt(gffHash.get("end"));
                    break;
                }
                ++i;
            }
        }
    }

    public Gene getGene() {
        return this.gene;
    }

    public void setGene(Gene gene) {
        this.gene = gene;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public Integer getCodingStart() {
        return this.codingStart;
    }

    public Integer getCodingEnd() {
        return this.codingEnd;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public boolean getStrand() {
        return this.gene.getStrand();
    }

    public String getChrom() {
        return this.gene.getChrom();
    }

    public String getBiotype() {
        return this.biotype;
    }

    public String getUniprot() {
        return this.uniprot;
    }

    public String getGenename() {
        return this.gene.getName();
    }

    public String getDescription() {
        return this.gene.getDescription();
    }

    public String getENSG() {
        return this.gene.getID();
    }

    public String getENST() {
        return this.ID;
    }

    public Exon[] getExons() {
        return this.exons;
    }

    class Exon {
        private int start;
        private int end;
        short startPhase = (short)-1;
        short endPhase = (short)-1;
        short nro;
        private int firstamino;
        private Rectangle rectangle;
        Transcript transcript;

        public Exon(int start, int end, short startphase, short endphase, short nro, int firstAmino, Transcript transcript2) {
            this.start = start;
            this.end = end;
            this.startPhase = startphase;
            this.endPhase = endphase;
            this.rectangle = new Rectangle();
            this.nro = nro;
            this.transcript = transcript2;
            this.firstamino = firstAmino;
        }

        public Exon(int start, int end, short nro, Transcript transcript2) {
            this.start = start;
            this.end = end;
            this.nro = nro;
            this.transcript = transcript2;
        }

        public int getFirstAmino() {
            return this.firstamino;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public short getStartPhase() {
            return this.startPhase;
        }

        public short getEndPhase() {
            return this.endPhase;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public short getNro() {
            return this.nro;
        }

        public Transcript getTranscript() {
            return this.transcript;
        }
    }
}

