/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;

public class TableColumnResizer2
extends MouseInputAdapter {
    public static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private int mouseXOffset;
    private Cursor otherCursor = resizeCursor;
    private JTable table;
    private JTable table2;

    public TableColumnResizer2(JTable table, JTable table2) {
        this.table = table;
        this.table2 = table2;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.table.getTableHeader().getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(JTable tablez, Point p) {
        return this.getResizingColumn(this.table, p, this.table.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(JTable tablez, Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        int row = this.table.rowAtPoint(p);
        if (row == -1) {
            return null;
        }
        Rectangle r = this.table.getCellRect(row, column, true);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.table.getTableHeader().getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return tablez.getTableHeader().getColumnModel().getColumn(columnIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.table.getTableHeader().setDraggedColumn(null);
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedDistance(0);
        Point p = e.getPoint();
        int index = this.table.columnAtPoint(p);
        if (index == -1) {
            return;
        }
        TableColumn resizingColumn = this.getResizingColumn(this.table, p, index);
        TableColumn resizingColumn2 = this.getResizingColumn(this.table2, p, index);
        if (!this.canResize(resizingColumn)) {
            return;
        }
        this.table.getTableHeader().setResizingColumn(resizingColumn);
        this.table2.getTableHeader().setResizingColumn(resizingColumn2);
        this.mouseXOffset = this.table.getTableHeader().getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
    }

    private void swapCursor() {
        Cursor tmp = this.table.getCursor();
        this.table.setCursor(this.otherCursor);
        this.otherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.canResize(this.getResizingColumn(this.table, e.getPoint())) != (this.table.getCursor() == resizeCursor)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        TableColumn resizingColumn = this.table.getTableHeader().getResizingColumn();
        TableColumn resizingColumn2 = this.table2.getTableHeader().getResizingColumn();
        boolean headerLeftToRight = this.table.getTableHeader().getComponentOrientation().isLeftToRight();
        if (resizingColumn != null) {
            Container container;
            int oldWidth = resizingColumn.getWidth();
            int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
            resizingColumn.setWidth(newWidth);
            resizingColumn2.setWidth(newWidth);
            if (this.table.getTableHeader().getParent() == null || (container = this.table.getTableHeader().getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && this.table != null) {
                JViewport viewport = ((JScrollPane)container).getViewport();
                int viewportWidth = viewport.getWidth();
                int diff = newWidth - oldWidth;
                int newHeaderWidth = this.table.getWidth() + diff;
                Dimension tableSize = this.table.getSize();
                tableSize.width += diff;
                this.table.setSize(tableSize);
                this.table2.setSize(tableSize);
                if (newHeaderWidth >= viewportWidth && this.table.getAutoResizeMode() == 0) {
                    Point p = viewport.getViewPosition();
                    p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                    viewport.setViewPosition(p);
                    this.mouseXOffset += diff;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedColumn(null);
    }
}

