/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.BrowserColorColumnRenderer;
import base.BasePlayer.ComboRenderer;
import base.BasePlayer.Draw;
import base.BasePlayer.EditableHeader;
import base.BasePlayer.EditableHeaderTableColumn;
import base.BasePlayer.Main;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TableBrowser
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    JFrame frame = new JFrame("Table Browser");
    JPanel panel = new JPanel(new GridBagLayout());
    static JTable table;
    JLabel info = new JLabel("Open TSV files.");
    Object[][] data = new Object[0][];
    static HashMap<Integer, Boolean> editables;
    static HashMap<String, Integer> columnValues;
    static JScrollPane tableScroll;
    static TableColumnModel columnModel;
    static DefaultTableModel tablemodel;
    String[][] selectdata = new String[0][];
    static String[] items;
    Object[] headers = new Object[0];
    ArrayList<String> header = new ArrayList();
    boolean changing = false;
    ArrayList<JComboBox> comboboxes = new ArrayList();
    JTableHeader tableHeader;
    JButton open = new JButton("Open");
    JButton write = new JButton("Write");
    boolean found = false;
    boolean tableSet = false;
    MouseAdapter tableMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent evt) {
            EditableHeader header = (EditableHeader)table.getTableHeader();
            header.removeEditor();
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                int row = table.rowAtPoint(evt.getPoint());
                int col = table.columnAtPoint(evt.getPoint());
                EditableHeaderTableColumn column = (EditableHeaderTableColumn)table.getColumnModel().getColumn(col);
                if (column.getHeaderValue() != null && !column.getHeaderValue().toString().equals("Select") && !column.getHeaderValue().toString().equals("Editable")) {
                    if (row >= 0 && col >= 0) {
                        if (column.getHeaderValue().toString().equals("Position")) {
                            String pos = (String)table.getValueAt(row, col);
                            if (!pos.contains(":") && columnValues.get("Chromosome") < 0) {
                                Main.showError("Please, select chromosome column.", "Note", tableScroll);
                                return;
                            }
                            Main.searchField.setText(pos);
                            Main.search(pos);
                        } else if (column.getHeaderValue().toString().equals("Chromosome")) {
                            String pos = (String)table.getValueAt(row, col);
                            Main.chromosomeDropdown.setSelectedItem(pos.replace("chr", ""));
                        } else if (column.getHeaderValue().toString().equals("Start")) {
                            if (columnValues.get("Chromosome") < 0) {
                                Main.showError("Please, select chromosome column.", "Note", tableScroll);
                                return;
                            }
                            if (columnValues.get("End") < 0) {
                                int chrom = columnValues.get("Chromosome");
                                String start = (String)table.getValueAt(row, col);
                                String search = String.valueOf((String)table.getValueAt(row, chrom)) + ":" + start;
                                Main.searchField.setText(search);
                                Main.search(search);
                            } else if (columnValues.get("End") > -1) {
                                int chrom = columnValues.get("Chromosome");
                                String start = (String)table.getValueAt(row, col);
                                int end = columnValues.get("End");
                                String search = String.valueOf((String)table.getValueAt(row, chrom)) + ":" + start + "-" + (String)table.getValueAt(row, end);
                                Main.searchField.setText(search);
                                Main.search(search);
                            }
                        } else if (column.getHeaderValue().toString().equals("Gene")) {
                            String gene = (String)table.getValueAt(row, col);
                            Main.searchField.setText(gene);
                            Main.search(gene);
                        }
                        if (columnValues.get("Sample") > -1) {
                            int sample = columnValues.get("Sample");
                            Main.search("s " + (String)table.getValueAt(row, sample));
                        }
                    }
                } else if (column.getHeaderValue() != null && column.getHeaderValue().toString().equals("Select")) {
                    Main.showError("Please, select column type.", "Note", tableScroll);
                    return;
                }
            }
        }
    };
    ActionListener comboActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getActionCommand() == "comboBoxChanged") {
                    if (columnValues.size() == 0) {
                        return;
                    }
                    if (TableBrowser.this.changing) {
                        return;
                    }
                    JComboBox comboBox = (JComboBox)actionEvent.getSource();
                    int i = 0;
                    while (i < TableBrowser.this.comboboxes.size()) {
                        if (!TableBrowser.this.comboboxes.get(i).equals(comboBox) && !TableBrowser.this.comboboxes.get(i).getSelectedItem().toString().equals("Editable") && TableBrowser.this.comboboxes.get(i).getSelectedItem().toString().equals(comboBox.getSelectedItem().toString())) {
                            TableBrowser.this.changing = true;
                            TableBrowser.this.comboboxes.get(i).setSelectedIndex(0);
                            EditableHeaderTableColumn col = (EditableHeaderTableColumn)table.getColumnModel().getColumn(i);
                            col.setHeaderValue("Select");
                            TableBrowser.this.comboboxes.get(i).revalidate();
                            TableBrowser.this.comboboxes.get(i).repaint();
                            table.revalidate();
                            table.repaint();
                            TableBrowser.this.changing = false;
                            break;
                        }
                        ++i;
                    }
                    TableBrowser.this.checkHeaders();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    static int addedItems;

    static {
        editables = new HashMap();
        columnValues = new HashMap();
        tableScroll = new JScrollPane();
        items = new String[]{"Select", "Position", "Chromosome", "Start", "End", "Sample", "Gene", "Editable"};
        addedItems = 0;
    }

    void checkHeaders() {
        columnValues.put("Select", -1);
        columnValues.put("Position", -1);
        columnValues.put("Chromosome", -1);
        columnValues.put("Start", -1);
        columnValues.put("End", -1);
        columnValues.put("Sample", -1);
        columnValues.put("Gene", -1);
        columnValues.put("Editable", -1);
        editables.clear();
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            EditableHeaderTableColumn col = (EditableHeaderTableColumn)table.getColumnModel().getColumn(i);
            if (col.getHeaderRenderer() == null) {
                editables.put(i, true);
            } else if (col.getHeaderValue().toString().equals("Editable")) {
                editables.put(i, true);
            } else {
                columnValues.put(col.getHeaderValue().toString(), i);
            }
            ++i;
        }
        table.repaint();
    }

    void setWindow() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(false);
            if (VariantHandler.aminoCount == null) {
                this.frame.setVisible(true);
                this.frame.setDefaultCloseOperation(3);
            } else {
                this.frame.setVisible(false);
            }
            this.frame.setContentPane(this);
            this.frame.setResizable(true);
            this.frame.setMinimumSize(new Dimension(600, 300));
            this.createTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TableBrowser() {
        super(new GridBagLayout());
        this.setWindow();
    }

    void createTable(File file) {
        try {
            String line;
            addedItems = 0;
            int headercount = 4;
            int rows = 0;
            BufferedReader reader = null;
            GZIPInputStream gzip = null;
            this.data = new Object[0][];
            tablemodel = new DefaultTableModel(this.data, new Object[]{"", "", "", ""});
            table = new JTable(tablemodel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return editables.containsKey(columnIndex);
                }
            };
            table.addMouseListener(this.tableMouseListener);
            columnModel = table.getColumnModel();
            int i = columnModel.getColumnCount() - 1;
            while (i >= 0) {
                columnModel.removeColumn(columnModel.getColumn(i));
                --i;
            }
            table.setTableHeader(new EditableHeader(columnModel));
            if (file.getName().endsWith(".gz")) {
                try {
                    gzip = new GZIPInputStream(new FileInputStream(file));
                    reader = new BufferedReader(new InputStreamReader(gzip));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                reader = new BufferedReader(new FileReader(file));
            }
            this.comboboxes.clear();
            tablemodel.setRowCount(0);
            this.header.clear();
            int rowlimit = 100000;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                int i2;
                Object[] row;
                if (line.startsWith("#")) {
                    this.header.add(line);
                    continue;
                }
                if (first) {
                    if (this.header.size() > 0) {
                        row = this.header.get(this.header.size() - 1).split("\t");
                        if (row.length > headercount) {
                            i2 = 0;
                            while (i2 < row.length - headercount) {
                                tablemodel.addColumn("new");
                                ++i2;
                            }
                            headercount = row.length;
                        }
                        tablemodel.addRow(row);
                    }
                    first = false;
                }
                if (rows > rowlimit) {
                    Main.showError("Showing " + rowlimit + " rows.", "Note", tableScroll);
                    break;
                }
                row = line.split("\t");
                ++rows;
                if (row.length > headercount) {
                    i2 = 0;
                    while (i2 < row.length - headercount) {
                        tablemodel.addColumn("new");
                        ++i2;
                    }
                    headercount = row.length;
                }
                tablemodel.addRow(row);
            }
            editables.clear();
            reader.close();
            tablemodel.addColumn("Editable");
            ++headercount;
            columnModel = table.getColumnModel();
            table.setTableHeader(new EditableHeader(columnModel));
            String[] items = new String[]{"Select", "Position", "Chromosome", "Start", "End", "Sample", "Gene", "Editable"};
            ComboRenderer renderer = new ComboRenderer(items);
            BrowserColorColumnRenderer columnRenderer = new BrowserColorColumnRenderer(new Color(150, 255, 150), Color.black);
            int i3 = 0;
            while (i3 < columnModel.getColumnCount() - 1) {
                JComboBox<String> combo = new JComboBox<String>();
                int c = 0;
                while (c < items.length) {
                    combo.addItem(items[c]);
                    ++c;
                }
                combo.addActionListener(this.comboActionListener);
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(i3);
                col.setCellRenderer(columnRenderer);
                col.setHeaderValue(combo.getItemAt(0));
                col.setHeaderRenderer(renderer);
                col.setHeaderEditor(new DefaultCellEditor(combo));
                this.comboboxes.add(combo);
                ++i3;
            }
            int columnIndex = columnModel.getColumn(columnModel.getColumnCount() - 1).getModelIndex();
            EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(columnIndex);
            col.setHeaderValue("Editable");
            col.setCellRenderer(columnRenderer);
            this.checkTable(table);
            this.checkHeaders();
            tableScroll.getViewport().removeAll();
            tableScroll.getViewport().add(table);
            table.revalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void checkTable(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        if (table.getRowCount() < 2) {
            return;
        }
        this.changing = true;
        if (table.getValueAt(0, 0).toString().equals("#Sample")) {
            int i = 0;
            while (i < columnModel.getColumnCount() - 1) {
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(i);
                if (table.getValueAt(0, i).toString().contains("#Sample")) {
                    this.comboboxes.get(i).setSelectedItem("Sample");
                    col.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                } else if (table.getValueAt(0, i).toString().contains("Gene")) {
                    this.comboboxes.get(i).setSelectedItem("Gene");
                    col.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                } else if (table.getValueAt(0, i).toString().contains("Position")) {
                    this.comboboxes.get(i).setSelectedItem("Position");
                    col.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                }
                ++i;
            }
        }
        this.changing = false;
    }

    void createTable() {
        try {
            tablemodel = new DefaultTableModel(this.data, new Object[]{"", "", "", "", "Editable"});
            table = new JTable(tablemodel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return editables.containsKey(columnIndex);
                }
            };
            int i = 0;
            while (i < 40) {
                tablemodel.addRow(new String[]{"", "", "", ""});
                ++i;
            }
            table.addMouseListener(this);
            columnModel = table.getColumnModel();
            table.setTableHeader(new EditableHeader(columnModel));
            this.frame.addMouseListener(this);
            BrowserColorColumnRenderer columnRenderer = new BrowserColorColumnRenderer(new Color(150, 255, 150), Color.black);
            ComboRenderer renderer = new ComboRenderer(items);
            int i2 = 0;
            while (i2 < columnModel.getColumnCount() - 1) {
                JComboBox<String> combo = new JComboBox<String>();
                int c = 0;
                while (c < items.length) {
                    combo.addItem(items[c]);
                    ++c;
                }
                combo.addActionListener(this.comboActionListener);
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(i2);
                col.setCellRenderer(columnRenderer);
                col.setHeaderValue(combo.getItemAt(0));
                col.setHeaderRenderer(renderer);
                col.setHeaderEditor(new DefaultCellEditor(combo));
                this.comboboxes.add(combo);
                ++i2;
            }
            this.checkHeaders();
            this.panel.setBackground(Draw.sidecolor);
            table.addMouseListener(this.tableMouseListener);
            columnValues.put("Select", -1);
            columnValues.put("Position", -1);
            columnValues.put("Chromosome", -1);
            columnValues.put("Start", -1);
            columnValues.put("End", -1);
            columnValues.put("Sample", -1);
            columnValues.put("Gene", -1);
            columnValues.put("Editable", -1);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            this.panel.add((Component)this.open, c);
            ++c.gridx;
            this.panel.add((Component)this.write, c);
            ++c.gridx;
            this.panel.add((Component)this.info, c);
            c.gridx = 0;
            this.open.addActionListener(this);
            this.write.addActionListener(this);
            this.write.setPreferredSize(Main.buttonDimension);
            this.write.setMinimumSize(Main.buttonDimension);
            this.open.setPreferredSize(Main.buttonDimension);
            this.open.setMinimumSize(Main.buttonDimension);
            ++c.gridy;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            table.setAutoResizeMode(4);
            table.setVisible(true);
            c.weighty = 1.0;
            c.fill = 1;
            tableScroll.getViewport().add(table);
            this.panel.add((Component)tableScroll, c);
            this.add((Component)this.panel, c);
            this.frame.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setFonts(Font menuFont) {
        int i = 0;
        while (i < this.panel.getComponentCount()) {
            this.panel.getComponent(i).setFont(menuFont);
            ++i;
        }
        if (table != null) {
            table.getTableHeader().setFont(menuFont);
            table.setFont(menuFont);
        }
        this.frame.pack();
    }

    public static void main(String[] args) {
        TableBrowser bro = new TableBrowser();
        bro.frame.setVisible(true);
        bro.frame.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.write) {
            try {
                String filename;
                File savefile = null;
                FileDialog fs = new FileDialog((Frame)this.frame, "Save table as...", 1);
                fs.setFile("*.tsv");
                fs.setVisible(true);
                while ((filename = fs.getFile()) != null) {
                    savefile = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                    if (!Files.isWritable(Paths.get(savefile.getParent(), new String[0]))) {
                        Main.showError("No permission to write.", "Error");
                        continue;
                    }
                    if (!savefile.getName().contains(".")) {
                        savefile = new File(String.valueOf(savefile.getAbsolutePath()) + ".tsv");
                    }
                    Main.savedir = fs.getDirectory();
                    Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(savefile));
                    int i = 0;
                    while (i < this.header.size() - 1) {
                        writer.write(this.header + "\n");
                        ++i;
                    }
                    int columns = table.getColumnCount();
                    int i2 = 0;
                    while (i2 < table.getRowCount()) {
                        int j = 0;
                        while (j < columns) {
                            if (j > 0) {
                                writer.write("\t");
                            }
                            if (table.getValueAt(i2, j) == null) {
                                writer.write("\t");
                            } else {
                                writer.write("" + table.getValueAt(i2, j));
                            }
                            ++j;
                        }
                        writer.write("\n");
                        ++i2;
                    }
                    writer.close();
                    break;
                }
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (event.getSource() == this.open) {
            FileDialog fs = new FileDialog((Frame)this.frame, "Choose a tab separated file", 0);
            fs.setDirectory(Main.savedir);
            fs.setVisible(true);
            String filename = fs.getFile();
            if (filename != null) {
                File addfile = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                Main.savedir = fs.getDirectory();
                Main.writeToConfig("DefaultSaveDir=" + Main.savedir);
                if (addfile.exists()) {
                    this.createTable(addfile);
                    this.info.setText("Select correct header values for BED columns. File: " + addfile.getName());
                } else {
                    Main.showError("File does not exists.", "Error", this.frame);
                }
            }
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        EditableHeader header = (EditableHeader)table.getTableHeader();
        header.removeEditor();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        EditableHeader header = (EditableHeader)table.getTableHeader();
        header.removeEditor();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

